USE [master]
GO
/****** Object:  Database [WWWings66_vieleDaten]    Script Date: 23/02/2020 21:58:18 ******/
CREATE DATABASE [WWWings66_vieleDaten]

GO
ALTER DATABASE [WWWings66_vieleDaten] SET COMPATIBILITY_LEVEL = 100
GO
IF (1 = FULLTEXTSERVICEPROPERTY('IsFullTextInstalled'))
begin
EXEC [WWWings66_vieleDaten].[dbo].[sp_fulltext_database] @action = 'enable'
end
GO
ALTER DATABASE [WWWings66_vieleDaten] SET ANSI_NULL_DEFAULT OFF 
GO
ALTER DATABASE [WWWings66_vieleDaten] SET ANSI_NULLS OFF 
GO
ALTER DATABASE [WWWings66_vieleDaten] SET ANSI_PADDING OFF 
GO
ALTER DATABASE [WWWings66_vieleDaten] SET ANSI_WARNINGS OFF 
GO
ALTER DATABASE [WWWings66_vieleDaten] SET ARITHABORT OFF 
GO
ALTER DATABASE [WWWings66_vieleDaten] SET AUTO_CLOSE OFF 
GO
ALTER DATABASE [WWWings66_vieleDaten] SET AUTO_SHRINK OFF 
GO
ALTER DATABASE [WWWings66_vieleDaten] SET AUTO_UPDATE_STATISTICS ON 
GO
ALTER DATABASE [WWWings66_vieleDaten] SET CURSOR_CLOSE_ON_COMMIT OFF 
GO
ALTER DATABASE [WWWings66_vieleDaten] SET CURSOR_DEFAULT  GLOBAL 
GO
ALTER DATABASE [WWWings66_vieleDaten] SET CONCAT_NULL_YIELDS_NULL OFF 
GO
ALTER DATABASE [WWWings66_vieleDaten] SET NUMERIC_ROUNDABORT OFF 
GO
ALTER DATABASE [WWWings66_vieleDaten] SET QUOTED_IDENTIFIER OFF 
GO
ALTER DATABASE [WWWings66_vieleDaten] SET RECURSIVE_TRIGGERS OFF 
GO
ALTER DATABASE [WWWings66_vieleDaten] SET  DISABLE_BROKER 
GO
ALTER DATABASE [WWWings66_vieleDaten] SET AUTO_UPDATE_STATISTICS_ASYNC OFF 
GO
ALTER DATABASE [WWWings66_vieleDaten] SET DATE_CORRELATION_OPTIMIZATION OFF 
GO
ALTER DATABASE [WWWings66_vieleDaten] SET TRUSTWORTHY OFF 
GO
ALTER DATABASE [WWWings66_vieleDaten] SET ALLOW_SNAPSHOT_ISOLATION OFF 
GO
ALTER DATABASE [WWWings66_vieleDaten] SET PARAMETERIZATION SIMPLE 
GO
ALTER DATABASE [WWWings66_vieleDaten] SET READ_COMMITTED_SNAPSHOT OFF 
GO
ALTER DATABASE [WWWings66_vieleDaten] SET HONOR_BROKER_PRIORITY OFF 
GO
ALTER DATABASE [WWWings66_vieleDaten] SET RECOVERY FULL 
GO
ALTER DATABASE [WWWings66_vieleDaten] SET  MULTI_USER 
GO
ALTER DATABASE [WWWings66_vieleDaten] SET PAGE_VERIFY CHECKSUM  
GO
ALTER DATABASE [WWWings66_vieleDaten] SET DB_CHAINING OFF 
GO
ALTER DATABASE [WWWings66_vieleDaten] SET FILESTREAM( NON_TRANSACTED_ACCESS = OFF ) 
GO
ALTER DATABASE [WWWings66_vieleDaten] SET TARGET_RECOVERY_TIME = 0 SECONDS 
GO
ALTER DATABASE [WWWings66_vieleDaten] SET DELAYED_DURABILITY = DISABLED 
GO
EXEC sys.sp_db_vardecimal_storage_format N'WWWings66_vieleDaten', N'ON'
GO
ALTER DATABASE [WWWings66_vieleDaten] SET QUERY_STORE = OFF
GO
USE [WWWings66_vieleDaten]
GO
/****** Object:  Schema [Admin]    Script Date: 23/02/2020 21:58:18 ******/
CREATE SCHEMA [Admin]
GO
/****** Object:  Schema [Betrieb]    Script Date: 23/02/2020 21:58:18 ******/
CREATE SCHEMA [Betrieb]
GO
/****** Object:  Schema [Immobilien]    Script Date: 23/02/2020 21:58:18 ******/
CREATE SCHEMA [Immobilien]
GO
/****** Object:  Table [Betrieb].[Flug]    Script Date: 23/02/2020 21:58:18 ******/
SET ANSI_NULLS OFF
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [Betrieb].[Flug](
	[FlugNr] [int] NOT NULL,
	[Abflugort] [nvarchar](30) NOT NULL,
	[Zielort] [nvarchar](30) NOT NULL,
	[Datum] [datetime] NOT NULL,
	[NichtRaucherFlug] [bit] NOT NULL,
	[Plaetze] [smallint] NOT NULL,
	[FreiePlaetze] [smallint] NULL,
	[Pilot_PersonID] [int] NULL,
	[Ankunft] [datetime] NULL,
	[Memo] [varchar](max) NULL,
	[Bestreikt] [bit] NULL,
	[Auslastung] [int] NULL,
	[Timestamp] [timestamp] NULL,
	[aliensErlaubt] [bit] NULL,
 CONSTRAINT [PK_Flug] PRIMARY KEY CLUSTERED 
(
	[FlugNr] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON, OPTIMIZE_FOR_SEQUENTIAL_KEY = OFF) ON [PRIMARY]
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
GO
/****** Object:  UserDefinedFunction [Betrieb].[GetFluegeVonTVF]    Script Date: 23/02/2020 21:58:18 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE FUNCTION [Betrieb].[GetFluegeVonTVF]
(
	@Abflugort nvarchar(30)
)
RETURNS TABLE
AS
RETURN

Select * from Flug where Abflugort = @Abflugort

GO
/****** Object:  Table [Betrieb].[Flug_Passagier]    Script Date: 23/02/2020 21:58:18 ******/
SET ANSI_NULLS OFF
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [Betrieb].[Flug_Passagier](
	[Flug_FlugNr] [int] NOT NULL,
	[Passagier_PersonID] [int] NOT NULL
) ON [PRIMARY]
GO
/****** Object:  Table [Betrieb].[Passagier]    Script Date: 23/02/2020 21:58:18 ******/
SET ANSI_NULLS OFF
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [Betrieb].[Passagier](
	[PersonID] [int] NOT NULL,
	[KundeSeit] [datetime] NULL,
	[KundenStatus] [nchar](1) NULL,
 CONSTRAINT [PK_Passagier] PRIMARY KEY CLUSTERED 
(
	[PersonID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON, OPTIMIZE_FOR_SEQUENTIAL_KEY = OFF) ON [PRIMARY]
) ON [PRIMARY]
GO
/****** Object:  View [Betrieb].[AlleBuchungen]    Script Date: 23/02/2020 21:58:18 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE VIEW [Betrieb].[AlleBuchungen]
AS
SELECT     Betrieb.Flug.FlugNr, Betrieb.Flug.Abflugort, Betrieb.Flug.Zielort, Betrieb.Flug.Datum, Betrieb.Passagier.PersonID
FROM         Betrieb.Flug INNER JOIN
                      Betrieb.Flug_Passagier ON Betrieb.Flug.FlugNr = Betrieb.Flug_Passagier.Flug_FlugNr INNER JOIN
                      Betrieb.Passagier ON Betrieb.Flug_Passagier.Passagier_PersonID = Betrieb.Passagier.PersonID

GO
/****** Object:  Table [Betrieb].[Mitarbeiter]    Script Date: 23/02/2020 21:58:18 ******/
SET ANSI_NULLS OFF
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [Betrieb].[Mitarbeiter](
	[PersonID] [int] NOT NULL,
	[MitarbeiterNr] [int] NULL,
	[Einstellungsdatum] [datetime] NULL,
	[VorgesetzterPersonID] [int] NULL,
 CONSTRAINT [PK_Mitarbeiter] PRIMARY KEY CLUSTERED 
(
	[PersonID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON, OPTIMIZE_FOR_SEQUENTIAL_KEY = OFF) ON [PRIMARY]
) ON [PRIMARY]
GO
/****** Object:  Table [Betrieb].[Person]    Script Date: 23/02/2020 21:58:18 ******/
SET ANSI_NULLS OFF
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [Betrieb].[Person](
	[PersonID] [int] NOT NULL,
	[Name] [nvarchar](50) NOT NULL,
	[Vorname] [nvarchar](50) NOT NULL,
	[Land] [nvarchar](2) NULL,
	[Geburtstag] [datetime] NULL,
	[Foto] [varbinary](max) NULL,
	[EMail] [nvarchar](50) NULL,
	[Stadt] [nvarchar](30) NULL,
	[Memo] [varchar](max) NULL,
	[Geburtsort] [nvarchar](30) NULL,
 CONSTRAINT [PK_Person] PRIMARY KEY CLUSTERED 
(
	[PersonID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON, OPTIMIZE_FOR_SEQUENTIAL_KEY = OFF) ON [PRIMARY]
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
GO
/****** Object:  View [Betrieb].[AlleMitarbeiter]    Script Date: 23/02/2020 21:58:18 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE VIEW [Betrieb].[AlleMitarbeiter]
AS
SELECT        Betrieb.Mitarbeiter.PersonID, Betrieb.Mitarbeiter.Einstellungsdatum, Betrieb.Mitarbeiter.MitarbeiterNr, Betrieb.Mitarbeiter.VorgesetzterPersonID, Betrieb.Person.Name, 
                         Betrieb.Person.Vorname, Betrieb.Person.Land, Betrieb.Person.Geburtstag, Betrieb.Person.Foto, Betrieb.Person.EMail
FROM            Betrieb.Mitarbeiter INNER JOIN
                         Betrieb.Person ON Betrieb.Mitarbeiter.PersonID = Betrieb.Person.PersonID

GO
/****** Object:  View [Betrieb].[AllePassagiere]    Script Date: 23/02/2020 21:58:18 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE VIEW [Betrieb].[AllePassagiere]
AS
SELECT        Betrieb.Passagier.PersonID, Betrieb.Passagier.KundeSeit, Betrieb.Passagier.KundenStatus, Betrieb.Person.Name, Betrieb.Person.Vorname, Betrieb.Person.Land, 
                         Betrieb.Person.Geburtstag, Betrieb.Person.Foto, Betrieb.Person.EMail, Betrieb.Person.Geburtsort
FROM            Betrieb.Passagier INNER JOIN
                         Betrieb.Person ON Betrieb.Passagier.PersonID = Betrieb.Person.PersonID

GO
/****** Object:  View [Betrieb].[FluegeVonRom]    Script Date: 23/02/2020 21:58:18 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE VIEW [Betrieb].[FluegeVonRom]
AS
SELECT        FlugNr, Abflugort, Datum, Zielort, NichtRaucherFlug, Plaetze, Memo, FreiePlaetze, Pilot_PersonID, Ankunft
FROM            Betrieb.Flug AS Extent1
WHERE        (N'Rom' = Abflugort)

GO
/****** Object:  Table [Admin].[Metadaten]    Script Date: 23/02/2020 21:58:18 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [Admin].[Metadaten](
	[Name] [nvarchar](20) NOT NULL,
	[Value] [varchar](max) NULL,
	[Timestamp] [binary](8) NOT NULL,
	[Memo] [nvarchar](100) NULL,
 CONSTRAINT [PK_Metadaten] PRIMARY KEY CLUSTERED 
(
	[Name] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON, OPTIMIZE_FOR_SEQUENTIAL_KEY = OFF) ON [PRIMARY]
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
GO
/****** Object:  Table [Admin].[Protokoll]    Script Date: 23/02/2020 21:58:18 ******/
SET ANSI_NULLS OFF
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [Admin].[Protokoll](
	[ID] [int] IDENTITY(1,1) NOT NULL,
	[Zeit] [datetime] NOT NULL,
	[Computer] [varchar](max) NULL,
	[Benutzer] [varchar](max) NULL,
	[Text] [varchar](max) NULL,
	[Entity] [nvarchar](50) NULL,
	[Attribut] [nvarchar](50) NULL,
	[Aktion] [nvarchar](50) NULL,
	[EntityID] [int] NULL,
	[AlterWert] [varchar](max) NULL,
	[NeuerWert] [varchar](max) NULL,
 CONSTRAINT [PK_Protokoll] PRIMARY KEY CLUSTERED 
(
	[ID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON, OPTIMIZE_FOR_SEQUENTIAL_KEY = OFF) ON [PRIMARY]
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
GO
/****** Object:  Table [Admin].[Test]    Script Date: 23/02/2020 21:58:18 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [Admin].[Test](
	[Test] [nchar](10) NOT NULL,
	[Event] [nchar](10) NULL,
 CONSTRAINT [PK_Test] PRIMARY KEY CLUSTERED 
(
	[Test] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON, OPTIMIZE_FOR_SEQUENTIAL_KEY = OFF) ON [PRIMARY]
) ON [PRIMARY]
GO
/****** Object:  Table [Betrieb].[Pilot]    Script Date: 23/02/2020 21:58:18 ******/
SET ANSI_NULLS OFF
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [Betrieb].[Pilot](
	[PersonID] [int] NOT NULL,
	[FlugscheinSeit] [datetime] NULL,
	[Flugscheintyp] [nchar](1) NULL,
	[Flugstunden] [int] NULL,
	[Flugschule] [nvarchar](50) NULL,
 CONSTRAINT [PK_Pilot] PRIMARY KEY CLUSTERED 
(
	[PersonID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON, OPTIMIZE_FOR_SEQUENTIAL_KEY = OFF) ON [PRIMARY]
) ON [PRIMARY]
GO
/****** Object:  Table [dbo].[__MigrationHistory]    Script Date: 23/02/2020 21:58:18 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[__MigrationHistory](
	[MigrationId] [nvarchar](150) NOT NULL,
	[ContextKey] [nvarchar](300) NOT NULL,
	[Model] [varbinary](max) NOT NULL,
	[ProductVersion] [nvarchar](32) NOT NULL,
 CONSTRAINT [PK_dbo.__MigrationHistory] PRIMARY KEY CLUSTERED 
(
	[MigrationId] ASC,
	[ContextKey] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON, OPTIMIZE_FOR_SEQUENTIAL_KEY = OFF) ON [PRIMARY]
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
GO
/****** Object:  Table [Immobilien].[Flughafen]    Script Date: 23/02/2020 21:58:18 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [Immobilien].[Flughafen](
	[Name] [nchar](30) NOT NULL,
	[Position] [geography] NULL,
	[Typ] [int] NULL,
	[Planet] [nchar](10) NULL,
 CONSTRAINT [PK_Flughafen] PRIMARY KEY CLUSTERED 
(
	[Name] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON, OPTIMIZE_FOR_SEQUENTIAL_KEY = OFF) ON [PRIMARY]
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
GO
INSERT [Admin].[Metadaten] ([Name], [Value], [Timestamp], [Memo]) VALUES (N'LetzteAktion', N'19.02.2011 22:58:43', 0x00000000000AED3B, NULL)
GO
INSERT [Admin].[Metadaten] ([Name], [Value], [Timestamp], [Memo]) VALUES (N'LetzteÄnderung', N'23.2.2011', 0x00000000000007D1, NULL)
GO
INSERT [Admin].[Metadaten] ([Name], [Value], [Timestamp], [Memo]) VALUES (N'Schemaversion', N'6.4', 0x00000000000007D3, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (100, N'Oslo', N'Berlin', CAST(N'2018-12-10T15:14:24.360' AS DateTime), 0, 250, 242, 2085, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (101, N'Berlin', N'Essen/Mülheim', CAST(N'2018-08-11T05:14:24.403' AS DateTime), 0, 200, 183, NULL, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (102, N'Oslo', N'Moskau', CAST(N'2018-04-14T11:21:24.417' AS DateTime), 0, 250, 2, 2181, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (103, N'Kapstadt', N'Moskau', CAST(N'2018-08-24T02:38:24.427' AS DateTime), 0, 250, 134, 2056, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (104, N'Berlin', N'Dallas', CAST(N'2018-04-25T12:38:24.437' AS DateTime), 0, 250, 12, 2061, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (105, N'München', N'Paris', CAST(N'2018-09-04T03:55:24.450' AS DateTime), 0, 250, 145, 2071, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (106, N'Mailand', N'Kapstadt', CAST(N'2018-05-06T13:55:24.460' AS DateTime), 0, -1, 22, 2189, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (107, N'London', N'Dallas', CAST(N'2018-09-15T05:12:24.470' AS DateTime), 0, 250, 156, 2188, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (108, N'Berlin', N'London', CAST(N'2018-05-18T15:19:24.480' AS DateTime), 0, 280, 37, 2056, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (109, N'Rom', N'New York', CAST(N'2018-09-26T06:29:24.490' AS DateTime), 0, -1, 83, 2089, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (110, N'Mailand', N'London', CAST(N'2018-05-29T16:36:24.500' AS DateTime), 0, 250, 48, 2009, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (111, N'Oslo', N'Mailand', CAST(N'2018-10-07T07:46:24.510' AS DateTime), 0, 250, 178, 2167, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (112, N'Köln/Bonn', N'Seattle', CAST(N'2018-06-09T17:53:24.523' AS DateTime), 0, 250, 59, 2139, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (113, N'Seattle', N'Essen/Mülheim', CAST(N'2018-10-19T09:10:24.543' AS DateTime), 0, 250, 190, 2115, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (114, N'Prag', N'Paris', CAST(N'2018-06-20T19:10:24.553' AS DateTime), 0, 250, 70, 2113, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (115, N'Hamburg', N'München', CAST(N'2018-10-30T10:27:24.563' AS DateTime), 0, 250, 201, 2124, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (116, N'Rom', N'Mailand', CAST(N'2018-07-01T20:27:24.573' AS DateTime), 0, 250, 72, 2145, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (117, N'Dallas', N'Prag', CAST(N'2018-11-10T11:44:24.587' AS DateTime), 0, 250, 212, 2046, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (118, N'Dallas', N'Moskau', CAST(N'2018-07-13T21:51:24.593' AS DateTime), 0, 250, 93, 2006, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (119, N'Mailand', N'Berlin', CAST(N'2018-11-21T13:01:24.603' AS DateTime), 0, 250, 223, 2080, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (120, N'London', N'Moskau', CAST(N'2018-07-24T23:08:24.613' AS DateTime), 0, 250, 104, 2185, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (121, N'Mailand', N'Rom', CAST(N'2018-12-02T14:18:24.627' AS DateTime), 0, 250, 234, 2047, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (122, N'Köln/Bonn', N'Frankfurt', CAST(N'2018-08-05T00:25:24.647' AS DateTime), 0, 250, 115, 2108, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (123, N'Mailand', N'Oslo', CAST(N'2018-12-14T15:42:24.657' AS DateTime), 0, 250, 246, 2136, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (124, N'New York', N'Essen/Mülheim', CAST(N'2018-08-16T01:42:24.667' AS DateTime), 0, 250, 126, 2010, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (125, N'London', N'Madrid', CAST(N'2018-04-18T11:49:24.677' AS DateTime), 0, 250, 7, 2113, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (126, N'London', N'Kapstadt', CAST(N'2018-08-27T02:59:24.687' AS DateTime), 0, 250, 137, 2045, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (127, N'New York', N'Berlin', CAST(N'2018-04-29T13:06:24.697' AS DateTime), 0, 250, 18, 2042, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (128, N'Seattle', N'Mailand', CAST(N'2018-09-08T04:23:24.707' AS DateTime), 0, 250, 149, 2172, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (129, N'Kapstadt', N'Dallas', CAST(N'2018-05-10T14:23:24.717' AS DateTime), 0, 250, 29, 2174, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (130, N'Kapstadt', N'Essen/Mülheim', CAST(N'2018-09-19T05:40:24.727' AS DateTime), 0, 250, 160, 2134, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (131, N'Rom', N'London', CAST(N'2018-05-21T15:40:24.747' AS DateTime), 0, 250, 32, 2028, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (132, N'New York', N'Berlin', CAST(N'2018-09-30T06:57:24.757' AS DateTime), 0, 250, 171, 2025, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (133, N'London', N'Dallas', CAST(N'2018-06-02T17:04:24.767' AS DateTime), 0, 250, 52, 2009, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (134, N'Frankfurt', N'Kapstadt', CAST(N'2018-10-11T08:14:24.777' AS DateTime), 0, 250, 182, 2109, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (135, N'Berlin', N'London', CAST(N'2018-06-13T18:21:24.787' AS DateTime), 0, 250, 63, 2146, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (136, N'Hamburg', N'Moskau', CAST(N'2018-10-23T09:38:24.797' AS DateTime), 0, 250, 194, 2147, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (137, N'Mailand', N'Frankfurt', CAST(N'2018-06-24T19:38:24.807' AS DateTime), 0, 250, 74, 2047, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (138, N'Hamburg', N'Seattle', CAST(N'2018-11-03T10:55:24.817' AS DateTime), 0, 250, 205, 2119, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (139, N'Seattle', N'Essen/Mülheim', CAST(N'2018-07-05T20:55:24.827' AS DateTime), 0, 250, 85, 2162, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (140, N'London', N'Paris', CAST(N'2018-11-14T12:12:24.850' AS DateTime), 0, 250, 216, 2027, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (141, N'Seattle', N'New York', CAST(N'2018-07-17T22:19:24.860' AS DateTime), 0, 250, 97, 2033, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (142, N'Berlin', N'London', CAST(N'2018-11-25T13:29:24.867' AS DateTime), 0, 250, 227, 2084, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (143, N'Oslo', N'Essen/Mülheim', CAST(N'2018-07-28T23:36:24.883' AS DateTime), 0, 250, 108, 2158, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (144, N'Paris', N'Berlin', CAST(N'2018-12-06T14:46:24.907' AS DateTime), 0, 250, 238, 2170, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (145, N'Hamburg', N'Moskau', CAST(N'2018-08-09T00:53:24.927' AS DateTime), 0, 250, 119, 2037, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (146, N'New York', N'Seattle', CAST(N'2018-04-11T11:00:24.947' AS DateTime), 0, 250, 0, 2030, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (147, N'München', N'New York', CAST(N'2018-08-20T02:10:24.970' AS DateTime), 0, 250, 130, 2072, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (148, N'München', N'London', CAST(N'2018-04-22T12:17:25.017' AS DateTime), 0, 250, 11, 2127, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (149, N'Paris', N'München', CAST(N'2018-08-31T03:27:25.040' AS DateTime), 0, 250, 141, 2131, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (150, N'Prag', N'Oslo', CAST(N'2018-05-03T13:34:25.063' AS DateTime), 0, 250, 22, 2062, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (151, N'Rom', N'Dallas', CAST(N'2018-09-12T04:51:25.087' AS DateTime), 0, 250, 145, 2107, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (152, N'Oslo', N'Paris', CAST(N'2018-05-14T14:51:25.110' AS DateTime), 0, 250, 33, 2035, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (153, N'London', N'Berlin', CAST(N'2018-09-23T06:08:25.133' AS DateTime), 0, 250, 164, 2195, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (154, N'Rom', N'Köln/Bonn', CAST(N'2018-05-25T16:08:25.157' AS DateTime), 0, 250, 36, 2175, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (155, N'Dallas', N'Berlin', CAST(N'2018-10-04T07:25:25.180' AS DateTime), 0, 250, 175, 2014, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (156, N'London', N'Berlin', CAST(N'2018-06-06T17:32:25.207' AS DateTime), 0, 250, 56, 2023, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (157, N'Paris', N'Frankfurt', CAST(N'2018-10-15T08:42:25.257' AS DateTime), 0, 250, 186, 2015, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (158, N'New York', N'Köln/Bonn', CAST(N'2018-06-17T18:49:25.297' AS DateTime), 0, 250, 67, 2159, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (159, N'Essen/Mülheim', N'Prag', CAST(N'2018-10-26T09:59:25.313' AS DateTime), 0, 250, 197, 2061, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (160, N'Prag', N'Moskau', CAST(N'2018-06-28T20:06:25.330' AS DateTime), 0, 250, 78, 2048, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (161, N'Essen/Mülheim', N'London', CAST(N'2018-11-07T11:23:25.357' AS DateTime), 0, 250, 209, 2158, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (162, N'Mailand', N'München', CAST(N'2018-07-09T21:23:25.380' AS DateTime), 0, 250, 89, 2016, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (163, N'Rom', N'Köln/Bonn', CAST(N'2018-11-18T12:40:25.403' AS DateTime), 0, 250, 212, 2034, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (164, N'Berlin', N'Rom', CAST(N'2018-07-20T20:40:25.430' AS DateTime), 0, 250, 100, NULL, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (165, N'Hamburg', N'Kapstadt', CAST(N'2018-11-29T13:57:25.453' AS DateTime), 0, 250, 231, 2071, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (166, N'Mailand', N'Hamburg', CAST(N'2018-08-02T00:04:25.507' AS DateTime), 0, 250, 112, 2066, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (167, N'Moskau', N'Frankfurt', CAST(N'2018-12-10T15:14:25.530' AS DateTime), 0, 250, 242, 2024, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (168, N'Prag', N'München', CAST(N'2018-08-13T01:21:25.557' AS DateTime), 0, 250, 123, 2175, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (169, N'Köln/Bonn', N'New York', CAST(N'2018-04-15T11:28:25.580' AS DateTime), 0, 250, 4, 2145, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (170, N'Essen/Mülheim', N'München', CAST(N'2018-08-24T02:38:25.603' AS DateTime), 0, 250, 134, 2174, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (171, N'Mailand', N'Essen/Mülheim', CAST(N'2018-04-26T12:45:25.627' AS DateTime), 0, 250, 15, 2110, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (172, N'Oslo', N'Frankfurt', CAST(N'2018-09-04T03:55:25.650' AS DateTime), 0, 250, 145, 2093, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (173, N'Madrid', N'Dallas', CAST(N'2018-05-07T14:02:25.677' AS DateTime), 0, 250, 26, 2014, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (174, N'Essen/Mülheim', N'Dallas', CAST(N'2018-09-16T05:19:25.730' AS DateTime), 0, 250, 157, 2080, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (175, N'Kapstadt', N'Paris', CAST(N'2018-05-18T15:19:25.757' AS DateTime), 0, 250, 37, 2098, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (176, N'Rom', N'London', CAST(N'2018-09-27T06:36:25.780' AS DateTime), 0, 250, 160, 2194, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (177, N'Dallas', N'Prag', CAST(N'2018-05-29T16:36:25.803' AS DateTime), 0, 250, 48, 2024, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (178, N'Oslo', N'Köln/Bonn', CAST(N'2018-10-08T07:53:25.830' AS DateTime), 0, 250, 179, 2097, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (179, N'London', N'Moskau', CAST(N'2018-06-10T18:00:25.853' AS DateTime), 0, 250, 60, 2027, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (180, N'Rom', N'München', CAST(N'2018-10-19T09:10:25.877' AS DateTime), 0, 250, 182, 2085, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (181, N'Hamburg', N'Paris', CAST(N'2018-06-21T19:17:25.900' AS DateTime), 0, 250, 71, 2054, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (182, N'Essen/Mülheim', N'Mailand', CAST(N'2018-10-30T10:27:25.923' AS DateTime), 0, 250, 201, 2114, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (183, N'Dallas', N'London', CAST(N'2018-07-02T20:34:25.977' AS DateTime), 0, 250, 82, 2119, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (184, N'Essen/Mülheim', N'Frankfurt', CAST(N'2018-11-11T11:51:26.000' AS DateTime), 0, 250, 213, 2161, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (185, N'München', N'Rom', CAST(N'2018-07-13T21:51:26.023' AS DateTime), 0, 250, 93, 2060, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (186, N'Madrid', N'Prag', CAST(N'2018-11-22T13:08:26.047' AS DateTime), 0, 250, 224, 2178, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (187, N'Oslo', N'Dallas', CAST(N'2018-07-24T23:08:26.073' AS DateTime), 0, 250, 104, 2123, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (188, N'Rom', N'Seattle', CAST(N'2018-12-03T14:25:26.097' AS DateTime), 0, 250, 227, 2034, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (189, N'Hamburg', N'Paris', CAST(N'2018-08-06T00:32:26.120' AS DateTime), 0, 250, 116, 2128, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (190, N'Mailand', N'Moskau', CAST(N'2018-12-14T15:42:26.143' AS DateTime), 0, 250, 246, 2129, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (191, N'Köln/Bonn', N'London', CAST(N'2018-08-17T01:49:26.167' AS DateTime), 0, 250, 127, 2050, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (192, N'Frankfurt', N'München', CAST(N'2018-04-18T11:49:26.220' AS DateTime), 0, 250, 7, 2002, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (193, N'Oslo', N'New York', CAST(N'2018-08-28T03:06:26.243' AS DateTime), 0, 250, 138, 2105, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (194, N'Paris', N'Prag', CAST(N'2018-04-30T13:13:26.267' AS DateTime), 0, 250, 19, 2147, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (195, N'New York', N'Mailand', CAST(N'2018-09-08T04:23:26.293' AS DateTime), 0, 250, 149, 2164, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (196, N'Paris', N'Rom', CAST(N'2018-05-11T14:30:26.313' AS DateTime), 0, 250, 30, 2011, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (197, N'Köln/Bonn', N'Rom', CAST(N'2018-09-20T05:47:26.337' AS DateTime), 0, 250, 161, 2156, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (198, N'Köln/Bonn', N'Prag', CAST(N'2018-05-22T15:47:26.360' AS DateTime), 0, 250, 41, 2047, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (199, N'Kapstadt', N'Oslo', CAST(N'2018-10-01T07:04:26.383' AS DateTime), 0, 250, 172, 2149, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (200, N'Köln/Bonn', N'Prag', CAST(N'2018-06-02T17:04:26.407' AS DateTime), 0, 250, 52, 2010, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (201, N'Oslo', N'Mailand', CAST(N'2018-10-12T08:21:26.460' AS DateTime), 0, 250, 183, 2156, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (202, N'Dallas', N'Mailand', CAST(N'2018-06-14T18:28:26.487' AS DateTime), 0, 250, 64, 2148, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (203, N'Moskau', N'Frankfurt', CAST(N'2018-10-23T09:38:26.510' AS DateTime), 0, 250, 194, 2029, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (204, N'Rom', N'Dallas', CAST(N'2018-06-25T19:45:26.533' AS DateTime), 0, 250, 67, 2178, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (205, N'London', N'Prag', CAST(N'2018-11-03T10:55:26.557' AS DateTime), 0, 250, 205, 2085, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (206, N'Madrid', N'Seattle', CAST(N'2018-07-06T21:02:26.580' AS DateTime), 0, 250, 86, 2041, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (207, N'London', N'Essen/Mülheim', CAST(N'2018-11-15T12:19:26.603' AS DateTime), 0, 250, 217, 2015, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (208, N'Moskau', N'Hamburg', CAST(N'2018-07-17T22:19:26.627' AS DateTime), 0, 250, 97, 2063, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (209, N'Madrid', N'Dallas', CAST(N'2018-11-26T13:36:26.677' AS DateTime), 0, 250, 228, 2165, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (210, N'Berlin', N'Köln/Bonn', CAST(N'2018-07-28T23:36:26.697' AS DateTime), 0, 250, 108, 2043, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (211, N'Köln/Bonn', N'New York', CAST(N'2018-12-07T14:53:26.720' AS DateTime), 0, 250, 239, 2025, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (212, N'Berlin', N'Dallas', CAST(N'2018-08-10T01:00:26.747' AS DateTime), 0, 250, 120, 2135, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (213, N'Berlin', N'Frankfurt', CAST(N'2018-04-11T09:00:26.770' AS DateTime), 0, 250, 0, NULL, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (214, N'Köln/Bonn', N'Oslo', CAST(N'2018-08-21T02:17:26.793' AS DateTime), 0, 250, 131, 2197, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (215, N'London', N'Oslo', CAST(N'2018-04-22T12:17:26.817' AS DateTime), 0, 250, 11, 2177, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (216, N'Berlin', N'Kapstadt', CAST(N'2018-09-01T03:34:26.843' AS DateTime), 0, 250, 142, 2186, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (217, N'Köln/Bonn', N'Prag', CAST(N'2018-05-04T13:41:26.867' AS DateTime), 0, 250, 23, 2177, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (218, N'Essen/Mülheim', N'Dallas', CAST(N'2018-09-12T04:51:26.917' AS DateTime), 0, 250, 153, 2069, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (219, N'Rom', N'Mailand', CAST(N'2018-05-15T14:58:26.933' AS DateTime), 0, 250, 30, 2018, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (220, N'Mailand', N'Oslo', CAST(N'2018-09-23T06:08:26.947' AS DateTime), 0, 250, 164, 2108, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (221, N'Madrid', N'Oslo', CAST(N'2018-05-26T16:15:26.963' AS DateTime), 0, 250, 45, 2006, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (222, N'Rom', N'Essen/Mülheim', CAST(N'2018-10-05T07:32:26.980' AS DateTime), 0, 250, 172, 2177, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (223, N'Berlin', N'Paris', CAST(N'2018-06-06T17:32:26.997' AS DateTime), 0, 250, 53, 2186, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (224, N'Berlin', N'Hamburg', CAST(N'2018-10-16T08:49:27.010' AS DateTime), 0, 250, 187, 2054, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (225, N'Oslo', N'Madrid', CAST(N'2018-06-17T18:49:27.027' AS DateTime), 0, 250, 67, 2135, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (226, N'Köln/Bonn', N'Dallas', CAST(N'2018-10-27T10:06:27.043' AS DateTime), 0, 250, 198, 2193, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (227, N'München', N'Kapstadt', CAST(N'2018-06-29T20:13:27.077' AS DateTime), 0, 250, 79, 2042, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (228, N'Rom', N'Dallas', CAST(N'2018-11-07T11:23:27.090' AS DateTime), 0, 250, 205, 2144, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (229, N'Essen/Mülheim', N'Paris', CAST(N'2018-07-10T21:30:27.103' AS DateTime), 0, 250, 90, 2102, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (230, N'München', N'Essen/Mülheim', CAST(N'2018-11-19T12:47:27.117' AS DateTime), 0, 250, 221, 2096, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (231, N'Moskau', N'Prag', CAST(N'2018-07-21T22:47:27.127' AS DateTime), 0, 250, 101, 2033, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (232, N'Berlin', N'München', CAST(N'2018-11-30T14:04:27.137' AS DateTime), 0, 250, 232, 2001, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (233, N'Dallas', N'Paris', CAST(N'2018-08-02T00:04:27.147' AS DateTime), 0, 250, 112, 2199, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (234, N'Köln/Bonn', N'London', CAST(N'2018-12-11T15:21:27.157' AS DateTime), 0, 250, 243, 2123, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (235, N'Madrid', N'München', CAST(N'2018-08-14T01:28:27.177' AS DateTime), 0, 250, 124, 2134, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (236, N'Berlin', N'Mailand', CAST(N'2018-04-15T11:28:27.193' AS DateTime), 0, 250, 4, 2024, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (237, N'London', N'München', CAST(N'2018-08-25T02:45:27.203' AS DateTime), 0, 250, 135, 2067, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (238, N'Prag', N'Dallas', CAST(N'2018-04-26T12:45:27.213' AS DateTime), 0, 250, 15, 2061, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (239, N'Prag', N'London', CAST(N'2018-09-05T04:02:27.223' AS DateTime), 0, 250, 146, 2075, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (240, N'Oslo', N'New York', CAST(N'2018-05-08T14:09:27.233' AS DateTime), 0, 250, 27, 2091, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (241, N'Paris', N'Seattle', CAST(N'2018-09-16T05:19:27.243' AS DateTime), 0, 250, 157, 2022, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (242, N'Prag', N'Mailand', CAST(N'2018-05-19T15:26:27.263' AS DateTime), 0, 250, 38, 2137, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (243, N'Köln/Bonn', N'Oslo', CAST(N'2018-09-27T06:36:27.273' AS DateTime), 0, 250, 168, 2169, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (244, N'München', N'Kapstadt', CAST(N'2018-05-30T16:43:27.283' AS DateTime), 0, 250, 49, 2159, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (245, N'Rom', N'Essen/Mülheim', CAST(N'2018-10-09T08:00:27.293' AS DateTime), 0, 250, 176, 2077, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (246, N'München', N'Moskau', CAST(N'2018-06-10T18:00:27.303' AS DateTime), 0, 250, 60, 2077, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (247, N'Paris', N'Seattle', CAST(N'2018-10-20T09:17:27.313' AS DateTime), 0, 250, 191, 2196, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (248, N'Mailand', N'München', CAST(N'2018-06-21T19:17:27.323' AS DateTime), 0, 250, 71, 2009, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (249, N'Berlin', N'Madrid', CAST(N'2018-10-31T10:34:27.333' AS DateTime), 0, 250, 202, 2007, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (250, N'New York', N'Prag', CAST(N'2018-07-03T20:41:27.343' AS DateTime), 0, 250, 83, 2150, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (251, N'New York', N'Frankfurt', CAST(N'2018-11-11T11:51:27.363' AS DateTime), 0, 250, 213, 2150, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (252, N'Prag', N'Kapstadt', CAST(N'2018-07-14T21:58:27.373' AS DateTime), 0, 250, 94, 2130, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (253, N'Prag', N'Rom', CAST(N'2018-11-22T13:08:27.383' AS DateTime), 0, 250, 224, 2131, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (254, N'Dallas', N'Kapstadt', CAST(N'2018-07-25T23:15:27.393' AS DateTime), 0, 250, 105, 2115, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (255, N'Rom', N'Prag', CAST(N'2018-12-04T14:32:27.403' AS DateTime), 0, 250, 232, 2045, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (256, N'Hamburg', N'Oslo', CAST(N'2018-08-06T00:32:27.413' AS DateTime), 0, 250, 116, 2073, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (257, N'Kapstadt', N'Dallas', CAST(N'2018-12-15T15:49:27.423' AS DateTime), 0, 250, 247, 2097, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (258, N'Dallas', N'Mailand', CAST(N'2018-08-17T01:49:27.433' AS DateTime), 0, 250, 127, 2193, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (259, N'Prag', N'Frankfurt', CAST(N'2018-04-19T11:56:27.453' AS DateTime), 0, 250, 8, 2109, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (260, N'New York', N'London', CAST(N'2018-08-29T03:13:27.463' AS DateTime), 0, 250, 139, 2020, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (261, N'Mailand', N'Essen/Mülheim', CAST(N'2018-04-30T13:13:27.477' AS DateTime), 0, 250, 19, 2010, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (262, N'Essen/Mülheim', N'Dallas', CAST(N'2018-09-09T04:30:27.487' AS DateTime), 0, 250, 150, 2146, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (263, N'New York', N'Köln/Bonn', CAST(N'2018-05-12T14:37:27.497' AS DateTime), 0, 250, 31, 2145, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (264, N'Mailand', N'Oslo', CAST(N'2018-09-20T05:47:27.507' AS DateTime), 0, 250, 161, 2081, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (265, N'Hamburg', N'Madrid', CAST(N'2018-05-23T15:54:27.517' AS DateTime), 0, 250, 42, 2144, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (266, N'Mailand', N'Moskau', CAST(N'2018-10-01T07:04:27.527' AS DateTime), 0, 250, 172, 2164, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (267, N'Essen/Mülheim', N'Hamburg', CAST(N'2018-06-03T17:11:27.537' AS DateTime), 0, 250, 53, 2186, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (268, N'New York', N'Moskau', CAST(N'2018-10-13T08:28:27.557' AS DateTime), 0, 250, 184, 2156, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (269, N'Frankfurt', N'Kapstadt', CAST(N'2018-06-14T18:28:27.573' AS DateTime), 0, 250, 64, 2021, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (270, N'Paris', N'Essen/Mülheim', CAST(N'2018-10-24T09:45:27.583' AS DateTime), 0, 250, 195, 2006, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (271, N'Rom', N'München', CAST(N'2018-06-25T19:45:27.593' AS DateTime), 0, 250, 71, 2038, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (272, N'Hamburg', N'Essen/Mülheim', CAST(N'2018-11-04T11:02:27.603' AS DateTime), 0, 250, 206, 2115, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (273, N'Köln/Bonn', N'Hamburg', CAST(N'2018-07-07T21:09:27.613' AS DateTime), 0, 250, 87, 2144, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (274, N'Prag', N'Köln/Bonn', CAST(N'2018-11-15T12:19:27.623' AS DateTime), 0, 250, 217, 2006, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (275, N'Essen/Mülheim', N'New York', CAST(N'2018-07-18T22:26:27.640' AS DateTime), 0, 250, 98, 2069, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (276, N'Frankfurt', N'Berlin', CAST(N'2018-11-26T13:36:27.653' AS DateTime), 0, 250, 228, 2166, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (277, N'Oslo', N'Hamburg', CAST(N'2018-07-29T23:43:27.663' AS DateTime), 0, 250, 109, 2033, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (278, N'Madrid', N'München', CAST(N'2018-12-08T15:00:27.673' AS DateTime), 0, 250, 240, 2053, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (279, N'Seattle', N'München', CAST(N'2018-08-10T01:00:27.683' AS DateTime), 0, 250, 120, 2126, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (280, N'Hamburg', N'Prag', CAST(N'2018-04-12T11:07:27.693' AS DateTime), 0, 250, 1, 2140, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (281, N'München', N'Essen/Mülheim', CAST(N'2018-08-21T02:17:27.707' AS DateTime), 0, 250, 131, 2044, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (282, N'Berlin', N'München', CAST(N'2018-04-23T12:24:27.717' AS DateTime), 0, 250, 12, 2030, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (283, N'Dallas', N'München', CAST(N'2018-09-02T03:41:27.737' AS DateTime), 0, 250, 143, 2114, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (284, N'Prag', N'Mailand', CAST(N'2018-05-04T13:41:27.747' AS DateTime), 0, 250, 23, 2079, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (285, N'London', N'Prag', CAST(N'2018-09-13T04:58:27.757' AS DateTime), 0, 250, 154, 2143, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (286, N'Paris', N'Frankfurt', CAST(N'2018-05-15T14:58:27.767' AS DateTime), 0, 250, 34, 2132, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (287, N'Berlin', N'Mailand', CAST(N'2018-09-24T06:15:27.777' AS DateTime), 0, 250, 165, 2053, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (288, N'Dallas', N'Berlin', CAST(N'2018-05-27T16:22:27.787' AS DateTime), 0, 250, 46, 2183, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (289, N'Paris', N'Köln/Bonn', CAST(N'2018-10-05T07:32:27.797' AS DateTime), 0, 250, 176, 2153, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (290, N'München', N'Moskau', CAST(N'2018-06-07T17:39:27.807' AS DateTime), 0, 250, 57, 2104, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (291, N'Dallas', N'Moskau', CAST(N'2018-10-17T08:56:27.817' AS DateTime), 0, 250, 188, 2178, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (292, N'Rom', N'Madrid', CAST(N'2018-06-18T18:56:27.840' AS DateTime), 0, 250, 64, 2153, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (293, N'Prag', N'Hamburg', CAST(N'2018-10-28T10:13:27.850' AS DateTime), 0, 250, 199, 2019, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (294, N'Madrid', N'Köln/Bonn', CAST(N'2018-06-29T20:13:27.857' AS DateTime), 0, 250, 79, 2071, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (295, N'Mailand', N'New York', CAST(N'2018-11-08T11:30:27.870' AS DateTime), 0, 250, 210, 2109, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (296, N'Seattle', N'Frankfurt', CAST(N'2018-07-11T21:37:27.880' AS DateTime), 0, 250, 91, 2037, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (297, N'Frankfurt', N'Madrid', CAST(N'2018-11-19T12:47:27.890' AS DateTime), 0, 250, 221, 2139, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (298, N'New York', N'Mailand', CAST(N'2018-07-22T22:54:27.900' AS DateTime), 0, 250, 102, 2050, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (299, N'Dallas', N'Hamburg', CAST(N'2018-11-30T14:04:27.910' AS DateTime), 0, 250, 232, 2148, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (300, N'Essen/Mülheim', N'London', CAST(N'2018-08-03T00:11:27.920' AS DateTime), 0, 250, 113, 2091, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (301, N'Dallas', N'Oslo', CAST(N'2018-12-12T15:28:27.940' AS DateTime), 0, 250, 244, 2080, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (302, N'Kapstadt', N'New York', CAST(N'2018-08-14T01:28:27.950' AS DateTime), 0, 250, 124, 2081, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (303, N'Hamburg', N'Rom', CAST(N'2018-04-16T11:35:27.960' AS DateTime), 0, 250, 5, 2178, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (304, N'Oslo', N'Moskau', CAST(N'2018-08-25T02:45:27.970' AS DateTime), 0, 250, 135, 2027, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (305, N'Köln/Bonn', N'Oslo', CAST(N'2018-04-27T12:52:27.983' AS DateTime), 0, 250, 16, 2041, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (306, N'Köln/Bonn', N'Paris', CAST(N'2018-09-06T04:09:27.993' AS DateTime), 0, 250, 147, 2159, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (307, N'Seattle', N'Frankfurt', CAST(N'2018-05-08T14:09:28.003' AS DateTime), 0, 250, 27, 2006, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (308, N'London', N'Paris', CAST(N'2018-09-17T05:26:28.010' AS DateTime), 0, 250, 158, 2023, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (309, N'Madrid', N'Köln/Bonn', CAST(N'2018-05-19T15:26:28.020' AS DateTime), 0, 250, 38, 2166, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (310, N'Moskau', N'Essen/Mülheim', CAST(N'2018-09-28T06:43:28.040' AS DateTime), 0, 250, 169, 2071, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (311, N'Mailand', N'London', CAST(N'2018-05-31T16:50:28.053' AS DateTime), 0, 250, 50, 2096, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (312, N'Kapstadt', N'London', CAST(N'2018-10-09T08:00:28.063' AS DateTime), 0, 250, 180, 2167, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (313, N'London', N'Seattle', CAST(N'2018-06-11T18:07:28.073' AS DateTime), 0, 250, 61, 2191, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (314, N'München', N'Prag', CAST(N'2018-10-20T09:17:28.083' AS DateTime), 0, 250, 191, 2161, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (315, N'Rom', N'Hamburg', CAST(N'2018-06-22T19:24:28.093' AS DateTime), 0, 250, 68, 2064, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (316, N'Moskau', N'Paris', CAST(N'2018-11-01T10:41:28.113' AS DateTime), 0, 250, 203, 2114, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (317, N'Berlin', N'Essen/Mülheim', CAST(N'2018-07-03T20:41:28.123' AS DateTime), 0, 250, 83, 2154, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (318, N'Oslo', N'Frankfurt', CAST(N'2018-11-12T11:58:28.133' AS DateTime), 0, 250, 214, 2061, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (319, N'Paris', N'Moskau', CAST(N'2018-07-14T21:58:28.143' AS DateTime), 0, 250, 94, 2101, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (320, N'Rom', N'Oslo', CAST(N'2018-11-23T13:15:28.153' AS DateTime), 0, 250, 221, 2081, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (321, N'Mailand', N'Köln/Bonn', CAST(N'2018-07-26T23:22:28.163' AS DateTime), 0, 250, 106, 2130, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (322, N'Paris', N'Prag', CAST(N'2018-12-04T14:32:28.173' AS DateTime), 0, 250, 236, 2074, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (323, N'Madrid', N'Essen/Mülheim', CAST(N'2018-08-07T00:39:28.183' AS DateTime), 0, 250, 117, 2167, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (324, N'Prag', N'Moskau', CAST(N'2018-12-16T15:56:28.193' AS DateTime), 0, 250, 248, 2045, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (325, N'Frankfurt', N'Köln/Bonn', CAST(N'2018-08-18T01:56:28.210' AS DateTime), 0, 250, 128, 2158, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (326, N'Rom', N'Madrid', CAST(N'2018-04-20T12:03:28.220' AS DateTime), 0, 250, 5, 2052, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (327, N'Prag', N'Berlin', CAST(N'2018-08-29T03:13:28.230' AS DateTime), 0, 250, 139, 2117, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (328, N'Prag', N'Köln/Bonn', CAST(N'2018-05-01T13:20:28.240' AS DateTime), 0, 250, 20, 2036, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (329, N'London', N'Essen/Mülheim', CAST(N'2018-09-10T04:37:28.250' AS DateTime), 0, 250, 151, 2066, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (330, N'Frankfurt', N'Essen/Mülheim', CAST(N'2018-05-12T14:37:28.260' AS DateTime), 0, 250, 31, 2110, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (331, N'Moskau', N'Oslo', CAST(N'2018-09-21T05:54:28.270' AS DateTime), 0, 250, 162, 2058, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (332, N'Frankfurt', N'Oslo', CAST(N'2018-05-23T15:54:28.280' AS DateTime), 0, 250, 42, 2196, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (333, N'Berlin', N'Seattle', CAST(N'2018-10-02T07:11:28.290' AS DateTime), 0, 250, 173, 2174, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (334, N'Berlin', N'Frankfurt', CAST(N'2018-06-04T17:18:28.310' AS DateTime), 0, 250, 54, 2109, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (335, N'Essen/Mülheim', N'Hamburg', CAST(N'2018-10-13T08:28:28.320' AS DateTime), 0, 250, 184, 2105, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (336, N'Köln/Bonn', N'Mailand', CAST(N'2018-06-15T18:35:28.330' AS DateTime), 0, 250, 65, 2124, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (337, N'Moskau', N'Rom', CAST(N'2018-10-24T09:45:28.343' AS DateTime), 0, 250, 195, 2004, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (338, N'Mailand', N'Dallas', CAST(N'2018-06-26T19:52:28.353' AS DateTime), 0, 250, 76, 2188, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (339, N'Dallas', N'Mailand', CAST(N'2018-11-05T11:09:28.363' AS DateTime), 0, 250, 207, 2009, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (340, N'Essen/Mülheim', N'Berlin', CAST(N'2018-07-07T21:09:28.373' AS DateTime), 0, 250, 87, 2158, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (341, N'Dallas', N'Rom', CAST(N'2018-11-16T12:26:28.383' AS DateTime), 0, 250, 218, 2191, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (342, N'New York', N'Oslo', CAST(N'2018-07-18T22:26:28.393' AS DateTime), 0, 250, 98, 2064, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (343, N'Mailand', N'Seattle', CAST(N'2018-11-27T13:43:28.417' AS DateTime), 0, 250, 229, 2080, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (344, N'Madrid', N'Köln/Bonn', CAST(N'2018-07-30T23:50:28.427' AS DateTime), 0, 250, 110, 2175, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (345, N'München', N'Prag', CAST(N'2018-12-08T15:00:28.437' AS DateTime), 0, 250, 240, 2081, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (346, N'Seattle', N'Mailand', CAST(N'2018-08-11T01:07:28.447' AS DateTime), 0, 250, 121, 2037, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (347, N'Köln/Bonn', N'Frankfurt', CAST(N'2018-04-12T11:07:28.457' AS DateTime), 0, 250, 1, 2118, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (348, N'München', N'Dallas', CAST(N'2018-08-22T02:24:28.467' AS DateTime), 0, 250, 132, 2053, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (349, N'Oslo', N'Kapstadt', CAST(N'2018-04-24T12:31:28.477' AS DateTime), 0, 250, 13, 2161, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (350, N'Kapstadt', N'München', CAST(N'2018-09-02T03:41:28.490' AS DateTime), 0, 250, 143, 2087, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (351, N'Oslo', N'Köln/Bonn', CAST(N'2018-05-05T13:48:28.507' AS DateTime), 0, 250, 24, 2128, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (352, N'Kapstadt', N'Moskau', CAST(N'2018-09-13T04:58:28.523' AS DateTime), 0, 250, 154, 2019, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (353, N'Köln/Bonn', N'Hamburg', CAST(N'2018-05-16T15:05:28.533' AS DateTime), 0, 250, 35, 2156, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (354, N'Kapstadt', N'Köln/Bonn', CAST(N'2018-09-25T06:22:28.547' AS DateTime), 0, 250, 166, 2139, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (355, N'Frankfurt', N'München', CAST(N'2018-05-27T16:22:28.557' AS DateTime), 0, 250, 46, 2068, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (356, N'Paris', N'Prag', CAST(N'2018-10-06T07:39:28.567' AS DateTime), 0, 250, 177, 2048, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (357, N'Berlin', N'Madrid', CAST(N'2018-06-08T17:46:28.577' AS DateTime), 0, 250, 58, 2105, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (358, N'Dallas', N'Hamburg', CAST(N'2018-10-17T08:56:28.597' AS DateTime), 0, 250, 188, 2164, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (359, N'Rom', N'Seattle', CAST(N'2018-06-19T19:03:28.607' AS DateTime), 0, 250, 65, 2143, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (360, N'München', N'Prag', CAST(N'2018-10-28T10:13:28.620' AS DateTime), 0, 250, 199, 2138, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (361, N'Moskau', N'Dallas', CAST(N'2018-06-30T20:20:28.630' AS DateTime), 0, 250, 80, 2184, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (362, N'Dallas', N'Köln/Bonn', CAST(N'2018-11-09T11:37:28.640' AS DateTime), 0, 250, 211, 2015, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (363, N'Mailand', N'Moskau', CAST(N'2018-07-11T21:37:28.653' AS DateTime), 0, 250, 91, 2027, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (364, N'London', N'Oslo', CAST(N'2018-11-20T12:54:28.663' AS DateTime), 0, 250, 222, 2008, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (365, N'Köln/Bonn', N'Kapstadt', CAST(N'2018-07-22T22:54:28.673' AS DateTime), 0, 250, 102, 2184, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (366, N'Rom', N'Hamburg', CAST(N'2018-12-01T14:11:28.683' AS DateTime), 0, 250, 229, 2155, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (367, N'Mailand', N'Paris', CAST(N'2018-08-04T00:18:28.703' AS DateTime), 0, 250, 114, 2053, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (368, N'Oslo', N'Paris', CAST(N'2018-12-12T15:28:28.717' AS DateTime), 0, 250, 244, 2016, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (369, N'Essen/Mülheim', N'New York', CAST(N'2018-08-15T01:35:28.727' AS DateTime), 0, 250, 125, 2174, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (370, N'Köln/Bonn', N'Prag', CAST(N'2018-04-16T11:35:28.737' AS DateTime), 0, 250, 5, 2178, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (371, N'London', N'München', CAST(N'2018-08-26T02:52:28.747' AS DateTime), 0, 250, 136, 2139, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (372, N'Frankfurt', N'Köln/Bonn', CAST(N'2018-04-28T12:59:28.757' AS DateTime), 0, 250, 17, 2053, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (373, N'Essen/Mülheim', N'München', CAST(N'2018-09-06T04:09:28.767' AS DateTime), 0, 250, 147, 2181, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (374, N'Köln/Bonn', N'Oslo', CAST(N'2018-05-09T14:16:28.780' AS DateTime), 0, 250, 28, 2189, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (375, N'Frankfurt', N'Seattle', CAST(N'2018-09-17T05:26:28.800' AS DateTime), 0, 250, 158, 2189, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (376, N'Mailand', N'Seattle', CAST(N'2018-05-20T15:33:28.810' AS DateTime), 0, 250, 39, 2083, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (377, N'Oslo', N'Dallas', CAST(N'2018-09-29T06:50:28.820' AS DateTime), 0, 250, 170, 2103, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (378, N'Oslo', N'Seattle', CAST(N'2018-05-31T16:50:28.830' AS DateTime), 0, 250, 50, 2023, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (379, N'Paris', N'New York', CAST(N'2018-10-10T08:07:28.843' AS DateTime), 0, 250, 181, 2110, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (380, N'Madrid', N'Hamburg', CAST(N'2018-06-11T18:07:28.850' AS DateTime), 0, 250, 61, 2115, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (381, N'Frankfurt', N'Köln/Bonn', CAST(N'2018-10-21T09:24:28.863' AS DateTime), 0, 250, 192, 2195, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (382, N'Kapstadt', N'London', CAST(N'2018-06-23T19:31:28.873' AS DateTime), 0, 250, 73, 2038, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (383, N'Prag', N'New York', CAST(N'2018-11-01T10:41:28.883' AS DateTime), 0, 250, 203, 2104, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (384, N'Berlin', N'Madrid', CAST(N'2018-07-04T20:48:28.903' AS DateTime), 0, 250, 84, 2038, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (385, N'Mailand', N'Rom', CAST(N'2018-11-12T11:58:28.917' AS DateTime), 0, 250, 214, 2158, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (386, N'Essen/Mülheim', N'München', CAST(N'2018-07-15T22:05:28.927' AS DateTime), 0, 250, 95, 2051, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (387, N'Dallas', N'Mailand', CAST(N'2018-11-24T13:22:28.937' AS DateTime), 0, 250, 226, 2069, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (388, N'Prag', N'London', CAST(N'2018-07-26T23:22:28.947' AS DateTime), 0, 250, 106, 2089, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (389, N'Mailand', N'Moskau', CAST(N'2018-12-05T14:39:28.957' AS DateTime), 0, 250, 237, 2132, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (390, N'Moskau', N'Seattle', CAST(N'2018-08-08T00:46:28.963' AS DateTime), 0, 250, 118, 2186, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (391, N'Oslo', N'Rom', CAST(N'2018-12-16T15:56:28.983' AS DateTime), 0, 250, 248, 2014, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (392, N'Seattle', N'Madrid', CAST(N'2018-08-19T02:03:28.993' AS DateTime), 0, 250, 129, 2172, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (393, N'Seattle', N'München', CAST(N'2018-04-20T12:03:29.003' AS DateTime), 0, 250, 9, 2030, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (394, N'Prag', N'Madrid', CAST(N'2018-08-30T03:20:29.017' AS DateTime), 0, 250, 140, 2049, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (395, N'Frankfurt', N'Mailand', CAST(N'2018-05-02T13:27:29.027' AS DateTime), 0, 250, 21, 2130, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (396, N'Frankfurt', N'Madrid', CAST(N'2018-09-10T04:37:29.037' AS DateTime), 0, 250, 151, 2161, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (397, N'Seattle', N'Dallas', CAST(N'2018-05-13T14:44:29.047' AS DateTime), 0, 250, 32, 2124, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (398, N'Essen/Mülheim', N'Madrid', CAST(N'2018-09-21T05:54:29.057' AS DateTime), 0, 250, 162, 2107, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (399, N'Madrid', N'Prag', CAST(N'2018-05-24T16:01:29.077' AS DateTime), 0, 250, 43, 2067, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (400, N'Essen/Mülheim', N'Prag', CAST(N'2018-10-03T07:18:29.090' AS DateTime), 0, 250, 174, 2193, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (401, N'Dallas', N'Moskau', CAST(N'2018-06-04T17:18:29.100' AS DateTime), 0, 250, 54, 2027, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (402, N'Prag', N'München', CAST(N'2018-10-14T08:35:29.113' AS DateTime), 0, 250, 185, 2148, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (403, N'Paris', N'Oslo', CAST(N'2018-06-15T18:35:29.123' AS DateTime), 0, 250, 65, 2011, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (404, N'Dallas', N'Frankfurt', CAST(N'2018-10-25T09:52:29.133' AS DateTime), 0, 250, 196, 2087, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (405, N'Moskau', N'Frankfurt', CAST(N'2018-06-27T19:59:29.143' AS DateTime), 0, 250, 77, 2010, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (406, N'Oslo', N'London', CAST(N'2018-11-05T11:09:29.153' AS DateTime), 0, 250, 207, 2192, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (407, N'Oslo', N'Prag', CAST(N'2018-07-08T21:16:29.163' AS DateTime), 0, 250, 88, 2141, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (408, N'Oslo', N'Hamburg', CAST(N'2018-11-16T12:26:29.187' AS DateTime), 0, 250, 218, 2190, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (409, N'Seattle', N'Rom', CAST(N'2018-07-19T22:33:29.197' AS DateTime), 0, 250, 99, 2168, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (410, N'London', N'Dallas', CAST(N'2018-11-28T13:50:29.207' AS DateTime), 0, 250, 230, 2031, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (411, N'Kapstadt', N'Paris', CAST(N'2018-07-30T23:50:29.217' AS DateTime), 0, 250, 110, 2198, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (412, N'Oslo', N'Rom', CAST(N'2018-12-09T15:07:29.227' AS DateTime), 0, 250, 241, 2178, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (413, N'London', N'Prag', CAST(N'2018-08-11T01:07:29.240' AS DateTime), 0, 250, 121, 2074, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (414, N'Oslo', N'Seattle', CAST(N'2018-04-13T11:14:29.250' AS DateTime), 0, 250, 2, 2188, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (415, N'Madrid', N'Hamburg', CAST(N'2018-08-23T02:31:29.260' AS DateTime), 0, 250, 133, 2032, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (416, N'Essen/Mülheim', N'Mailand', CAST(N'2018-04-24T12:31:29.273' AS DateTime), 0, 250, 13, 2193, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (417, N'München', N'London', CAST(N'2018-09-03T03:48:29.293' AS DateTime), 0, 250, 144, 2164, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (418, N'Dallas', N'Köln/Bonn', CAST(N'2018-05-06T13:55:29.307' AS DateTime), 0, 250, 25, 2009, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (419, N'London', N'Hamburg', CAST(N'2018-09-14T05:05:29.317' AS DateTime), 0, 250, 155, 2166, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (420, N'Kapstadt', N'Oslo', CAST(N'2018-05-17T15:12:29.327' AS DateTime), 0, 250, 36, 2017, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (421, N'München', N'Seattle', CAST(N'2018-09-25T06:22:29.340' AS DateTime), 0, 250, 166, 2089, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (422, N'Seattle', N'Kapstadt', CAST(N'2018-05-28T16:29:29.350' AS DateTime), 0, 250, 47, 2032, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (423, N'Moskau', N'Madrid', CAST(N'2018-10-07T07:46:29.360' AS DateTime), 0, 250, 178, 2119, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (424, N'Berlin', N'Madrid', CAST(N'2018-06-08T17:46:29.383' AS DateTime), 0, 250, 58, 2153, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (425, N'München', N'Mailand', CAST(N'2018-10-18T09:03:29.403' AS DateTime), 0, 250, 189, 2019, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (426, N'Prag', N'Hamburg', CAST(N'2018-06-19T19:03:29.427' AS DateTime), 0, 250, 69, 2014, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (427, N'Madrid', N'Berlin', CAST(N'2018-10-29T10:20:29.450' AS DateTime), 0, 250, 200, 2199, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (428, N'Mailand', N'Moskau', CAST(N'2018-07-01T20:27:29.473' AS DateTime), 0, 250, 81, 2004, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (429, N'New York', N'Köln/Bonn', CAST(N'2018-11-09T11:37:29.493' AS DateTime), 0, 250, 211, 2105, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (430, N'München', N'Seattle', CAST(N'2018-07-12T21:44:29.517' AS DateTime), 0, 250, 92, 2114, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (431, N'Berlin', N'Moskau', CAST(N'2018-11-20T12:54:29.537' AS DateTime), 0, 250, 222, 2001, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (432, N'Madrid', N'Moskau', CAST(N'2018-07-23T23:01:29.583' AS DateTime), 0, 250, 103, 2031, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (433, N'Essen/Mülheim', N'Mailand', CAST(N'2018-12-02T14:18:29.600' AS DateTime), 0, 250, 234, 2192, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (434, N'Rom', N'Paris', CAST(N'2018-08-02T10:18:29.617' AS DateTime), 0, 250, 72, NULL, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (435, N'Essen/Mülheim', N'Kapstadt', CAST(N'2018-12-13T15:35:29.630' AS DateTime), 0, 250, 245, 2020, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (436, N'Mailand', N'Oslo', CAST(N'2018-08-15T01:35:29.647' AS DateTime), 0, 250, 125, 2177, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (437, N'Frankfurt', N'Rom', CAST(N'2018-04-17T11:42:29.660' AS DateTime), 0, 250, 6, 2126, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (438, N'Kapstadt', N'Hamburg', CAST(N'2018-08-27T02:59:29.677' AS DateTime), 0, 250, 137, 2183, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (439, N'Oslo', N'Seattle', CAST(N'2018-04-28T12:59:29.687' AS DateTime), 0, 250, 17, 2027, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (440, N'Paris', N'Berlin', CAST(N'2018-09-07T04:16:29.697' AS DateTime), 0, 250, 148, 2111, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (441, N'New York', N'Paris', CAST(N'2018-05-09T14:16:29.720' AS DateTime), 0, 250, 28, 2032, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (442, N'Rom', N'Essen/Mülheim', CAST(N'2018-09-18T05:33:29.730' AS DateTime), 0, 250, 155, 2060, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (443, N'Madrid', N'Oslo', CAST(N'2018-05-21T15:40:29.740' AS DateTime), 0, 250, 40, 2156, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (444, N'Seattle', N'Frankfurt', CAST(N'2018-09-29T06:50:29.750' AS DateTime), 0, 250, 170, 2107, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (445, N'New York', N'Seattle', CAST(N'2018-06-01T16:57:29.763' AS DateTime), 0, 250, 51, 2136, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (446, N'Essen/Mülheim', N'Oslo', CAST(N'2018-10-10T08:07:29.773' AS DateTime), 0, 250, 181, 2031, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (447, N'London', N'New York', CAST(N'2018-06-12T18:14:29.787' AS DateTime), 0, 250, 62, 2014, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (448, N'London', N'Oslo', CAST(N'2018-10-22T09:31:29.797' AS DateTime), 0, 250, 193, 2036, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (449, N'London', N'Frankfurt', CAST(N'2018-06-23T19:31:29.807' AS DateTime), 0, 250, 73, 2191, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (450, N'Oslo', N'Berlin', CAST(N'2018-11-02T10:48:29.827' AS DateTime), 0, 250, 204, 2063, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (451, N'Seattle', N'Dallas', CAST(N'2018-07-05T20:55:29.840' AS DateTime), 0, 250, 85, 2030, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (452, N'Essen/Mülheim', N'Kapstadt', CAST(N'2018-11-13T12:05:29.850' AS DateTime), 0, 250, 215, 2163, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (453, N'Essen/Mülheim', N'Moskau', CAST(N'2018-07-16T22:12:29.863' AS DateTime), 0, 250, 96, 2001, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (454, N'München', N'Prag', CAST(N'2018-11-24T13:22:29.873' AS DateTime), 0, 250, 226, 2187, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (455, N'Essen/Mülheim', N'Seattle', CAST(N'2018-07-27T23:29:29.883' AS DateTime), 0, 250, 107, 2059, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (456, N'Hamburg', N'Berlin', CAST(N'2018-12-06T14:46:29.903' AS DateTime), 0, 250, 238, 2072, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (457, N'Prag', N'Madrid', CAST(N'2018-08-08T00:46:29.913' AS DateTime), 0, 250, 118, 2039, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (458, N'Dallas', N'London', CAST(N'2018-12-17T16:03:29.927' AS DateTime), 0, 250, 249, 2154, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (459, N'Frankfurt', N'Madrid', CAST(N'2018-08-19T02:03:29.937' AS DateTime), 0, 250, 129, 2180, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (460, N'Seattle', N'London', CAST(N'2018-04-21T12:10:29.947' AS DateTime), 0, 250, 10, 2194, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (461, N'Oslo', N'Mailand', CAST(N'2018-08-31T03:27:29.957' AS DateTime), 0, 250, 141, 2051, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (462, N'Seattle', N'Madrid', CAST(N'2018-05-02T13:27:29.967' AS DateTime), 0, 250, 21, 2128, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (463, N'Prag', N'Oslo', CAST(N'2018-09-11T04:44:29.977' AS DateTime), 0, 250, 152, 2198, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (464, N'Frankfurt', N'Paris', CAST(N'2018-05-13T14:44:29.987' AS DateTime), 0, 250, 32, 2154, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (465, N'New York', N'Oslo', CAST(N'2018-09-22T06:01:30.010' AS DateTime), 0, 250, 163, 2172, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (466, N'Berlin', N'Mailand', CAST(N'2018-05-25T16:08:30.020' AS DateTime), 0, 250, 44, 2138, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (467, N'Kapstadt', N'Essen/Mülheim', CAST(N'2018-10-03T07:18:30.030' AS DateTime), 0, 250, 174, 2181, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (468, N'New York', N'Kapstadt', CAST(N'2018-06-05T17:25:30.040' AS DateTime), 0, 250, 55, 2111, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (469, N'Hamburg', N'Seattle', CAST(N'2018-10-14T08:35:30.053' AS DateTime), 0, 250, 185, 2127, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (470, N'London', N'New York', CAST(N'2018-06-16T18:42:30.063' AS DateTime), 0, 250, 66, 2188, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (471, N'Oslo', N'Berlin', CAST(N'2018-10-26T09:59:30.073' AS DateTime), 0, 250, 197, 2050, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (472, N'Berlin', N'Hamburg', CAST(N'2018-06-27T19:59:30.083' AS DateTime), 0, 250, 77, 2011, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (473, N'Seattle', N'Berlin', CAST(N'2018-11-06T11:16:30.097' AS DateTime), 0, 250, 208, 2169, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (474, N'Frankfurt', N'London', CAST(N'2018-07-08T21:16:30.117' AS DateTime), 0, 250, 88, 2082, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (475, N'Mailand', N'Paris', CAST(N'2018-11-17T12:33:30.127' AS DateTime), 0, 250, 219, 2072, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (476, N'Paris', N'Oslo', CAST(N'2018-07-20T22:40:30.137' AS DateTime), 0, 250, 100, 2017, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (477, N'London', N'Hamburg', CAST(N'2018-11-28T13:50:30.147' AS DateTime), 0, 250, 230, 2177, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (478, N'Moskau', N'Frankfurt', CAST(N'2018-07-31T23:57:30.157' AS DateTime), 0, 250, 111, 2052, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (479, N'Mailand', N'München', CAST(N'2018-12-09T15:07:30.170' AS DateTime), 0, 250, 241, 2001, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (480, N'Hamburg', N'Köln/Bonn', CAST(N'2018-08-12T01:14:30.180' AS DateTime), 0, 250, 122, 2010, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (481, N'Hamburg', N'London', CAST(N'2018-04-14T11:21:30.190' AS DateTime), 0, 250, 3, 2104, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (482, N'Moskau', N'Seattle', CAST(N'2018-08-23T02:31:30.203' AS DateTime), 0, 250, 133, 2161, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (483, N'Rom', N'Paris', CAST(N'2018-04-25T12:38:30.223' AS DateTime), 0, 250, 10, 2169, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (484, N'München', N'Frankfurt', CAST(N'2018-09-04T03:55:30.237' AS DateTime), 0, 250, 145, 2168, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (485, N'Rom', N'Paris', CAST(N'2018-05-06T13:55:30.247' AS DateTime), 0, 250, 21, 2019, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (486, N'Kapstadt', N'London', CAST(N'2018-09-15T05:12:30.257' AS DateTime), 0, 250, 156, 2044, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (487, N'Mailand', N'Moskau', CAST(N'2018-05-17T15:12:30.267' AS DateTime), 0, 250, 36, 2111, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (488, N'Seattle', N'Hamburg', CAST(N'2018-09-26T06:29:30.277' AS DateTime), 0, 250, 167, 2131, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (489, N'London', N'Dallas', CAST(N'2018-05-29T16:36:30.297' AS DateTime), 0, 250, 48, 2106, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (490, N'Seattle', N'New York', CAST(N'2018-10-07T07:46:30.310' AS DateTime), 0, 250, 178, 2098, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (491, N'Kapstadt', N'Rom', CAST(N'2018-06-09T17:53:30.320' AS DateTime), 0, 250, 59, 2045, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (492, N'Frankfurt', N'Oslo', CAST(N'2018-10-18T09:03:30.330' AS DateTime), 0, 250, 189, 2151, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (493, N'Seattle', N'Frankfurt', CAST(N'2018-06-20T19:10:30.340' AS DateTime), 0, 250, 70, 2152, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (494, N'Dallas', N'London', CAST(N'2018-10-30T10:27:30.350' AS DateTime), 0, 250, 201, 2149, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (495, N'Prag', N'Köln/Bonn', CAST(N'2018-07-01T20:27:30.360' AS DateTime), 0, 250, 81, 2191, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (496, N'Köln/Bonn', N'Moskau', CAST(N'2018-11-10T11:44:30.373' AS DateTime), 0, 250, 212, 2141, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (497, N'Hamburg', N'Madrid', CAST(N'2018-07-12T21:44:30.383' AS DateTime), 0, 250, 92, 2127, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (498, N'Essen/Mülheim', N'Paris', CAST(N'2018-11-21T13:01:30.417' AS DateTime), 0, 250, 223, 2068, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (499, N'Oslo', N'München', CAST(N'2018-07-24T23:08:30.437' AS DateTime), 0, 250, 104, 2098, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (500, N'Moskau', N'Berlin', CAST(N'2018-12-02T14:18:30.457' AS DateTime), 0, 250, 234, 2196, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (501, N'München', N'Berlin', CAST(N'2018-08-05T00:25:30.483' AS DateTime), 0, 250, 115, 2175, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (502, N'Moskau', N'Prag', CAST(N'2018-12-13T15:35:30.507' AS DateTime), 0, 250, 245, 2071, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (503, N'Kapstadt', N'Moskau', CAST(N'2018-08-16T01:42:30.530' AS DateTime), 0, 250, 126, 2068, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (504, N'Paris', N'München', CAST(N'2018-04-18T11:49:30.553' AS DateTime), 0, 250, 7, 2148, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (505, N'Berlin', N'München', CAST(N'2018-08-27T02:59:30.577' AS DateTime), 0, 250, 137, 2075, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (506, N'Kapstadt', N'Oslo', CAST(N'2018-04-29T13:06:30.603' AS DateTime), 0, 250, 18, 2172, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (507, N'Kapstadt', N'Frankfurt', CAST(N'2018-09-07T04:16:30.650' AS DateTime), 0, 250, 148, 2165, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (508, N'Essen/Mülheim', N'Oslo', CAST(N'2018-05-10T14:23:30.667' AS DateTime), 0, 250, 29, 2010, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (509, N'München', N'Dallas', CAST(N'2018-09-19T05:40:30.683' AS DateTime), 0, 250, 160, 2137, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (510, N'Paris', N'Berlin', CAST(N'2018-05-21T15:40:30.700' AS DateTime), 0, 250, 40, 2047, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (511, N'Köln/Bonn', N'Oslo', CAST(N'2018-09-30T06:57:30.717' AS DateTime), 0, 250, 171, 2037, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (512, N'Dallas', N'Frankfurt', CAST(N'2018-06-02T17:04:30.733' AS DateTime), 0, 250, 52, 2121, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (513, N'Kapstadt', N'Hamburg', CAST(N'2018-10-11T08:14:30.750' AS DateTime), 0, 250, 182, 2055, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (514, N'London', N'Madrid', CAST(N'2018-06-13T18:21:30.767' AS DateTime), 0, 250, 63, 2177, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (515, N'München', N'Essen/Mülheim', CAST(N'2018-10-22T09:31:30.783' AS DateTime), 0, 250, 193, 2143, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (516, N'Oslo', N'Essen/Mülheim', CAST(N'2018-06-24T19:38:30.827' AS DateTime), 0, 250, 74, 2061, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (517, N'Dallas', N'Frankfurt', CAST(N'2018-11-03T10:55:30.843' AS DateTime), 0, 250, 205, 2040, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (518, N'New York', N'Kapstadt', CAST(N'2018-07-05T20:55:30.857' AS DateTime), 0, 250, 85, 2185, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (519, N'München', N'Paris', CAST(N'2018-11-14T12:12:30.870' AS DateTime), 0, 250, 216, 2021, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (520, N'Kapstadt', N'Mailand', CAST(N'2018-07-16T22:12:30.887' AS DateTime), 0, 250, 96, 2108, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (521, N'Seattle', N'Paris', CAST(N'2018-11-25T13:29:30.900' AS DateTime), 0, 250, 227, 2109, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (522, N'Frankfurt', N'München', CAST(N'2018-07-28T23:36:30.920' AS DateTime), 0, 250, 108, 2047, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (523, N'Moskau', N'Berlin', CAST(N'2018-12-06T14:46:30.930' AS DateTime), 0, 250, 238, 2001, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (524, N'Essen/Mülheim', N'Dallas', CAST(N'2018-08-09T00:53:30.940' AS DateTime), 0, 250, 119, 2146, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (525, N'Moskau', N'Paris', CAST(N'2018-12-17T16:03:30.953' AS DateTime), 0, 250, 249, 2048, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (526, N'Oslo', N'Moskau', CAST(N'2018-08-20T02:10:30.963' AS DateTime), 0, 250, 130, 2024, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (527, N'Rom', N'Hamburg', CAST(N'2018-04-22T12:17:30.973' AS DateTime), 0, 250, 7, 2046, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (528, N'London', N'Mailand', CAST(N'2018-08-31T03:27:30.983' AS DateTime), 0, 250, 141, 2196, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (529, N'Berlin', N'New York', CAST(N'2018-05-03T13:34:30.997' AS DateTime), 0, 250, 22, 2019, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (530, N'Köln/Bonn', N'Kapstadt', CAST(N'2018-09-11T04:44:31.007' AS DateTime), 0, 250, 152, 2137, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (531, N'Prag', N'Dallas', CAST(N'2018-05-14T14:51:31.027' AS DateTime), 0, 250, 33, 2145, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (532, N'Essen/Mülheim', N'Seattle', CAST(N'2018-09-23T06:08:31.037' AS DateTime), 0, 250, 164, 2096, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (533, N'London', N'Berlin', CAST(N'2018-05-25T16:08:31.047' AS DateTime), 0, 250, 44, 2122, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (534, N'Mailand', N'London', CAST(N'2018-10-04T07:25:31.057' AS DateTime), 0, 250, 175, 2143, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (535, N'Rom', N'Hamburg', CAST(N'2018-06-05T17:25:31.067' AS DateTime), 0, 250, 51, 2015, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (536, N'Mailand', N'Berlin', CAST(N'2018-10-15T08:42:31.080' AS DateTime), 0, 250, 186, 2078, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (537, N'Seattle', N'Hamburg', CAST(N'2018-06-17T18:49:31.090' AS DateTime), 0, 250, 67, 2164, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (538, N'Dallas', N'Prag', CAST(N'2018-10-26T09:59:31.100' AS DateTime), 0, 250, 197, 2050, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (539, N'Oslo', N'Moskau', CAST(N'2018-06-28T20:06:31.110' AS DateTime), 0, 250, 78, 2013, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (540, N'Prag', N'München', CAST(N'2018-11-06T11:16:31.133' AS DateTime), 0, 250, 208, 2060, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (541, N'Hamburg', N'Rom', CAST(N'2018-07-09T21:23:31.143' AS DateTime), 0, 250, 89, 2054, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (542, N'Madrid', N'Essen/Mülheim', CAST(N'2018-11-18T12:40:31.153' AS DateTime), 0, 250, 220, 2152, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (543, N'Prag', N'Madrid', CAST(N'2018-07-20T22:40:31.163' AS DateTime), 0, 250, 100, 2176, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (544, N'Prag', N'Frankfurt', CAST(N'2018-11-29T13:57:31.177' AS DateTime), 0, 250, 231, 2055, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (545, N'Oslo', N'Moskau', CAST(N'2018-08-02T00:04:31.187' AS DateTime), 0, 250, 112, 2118, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (546, N'Seattle', N'Moskau', CAST(N'2018-12-10T15:14:31.197' AS DateTime), 0, 250, 242, 2121, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (547, N'Madrid', N'Prag', CAST(N'2018-08-13T01:21:31.207' AS DateTime), 0, 250, 123, 2098, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (548, N'Mailand', N'Paris', CAST(N'2018-04-14T11:21:31.227' AS DateTime), 0, 250, 3, 2080, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (549, N'Prag', N'Essen/Mülheim', CAST(N'2018-08-24T02:38:31.240' AS DateTime), 0, 250, 134, 2195, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (550, N'Frankfurt', N'London', CAST(N'2018-04-26T12:45:31.250' AS DateTime), 0, 250, 15, 2009, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (551, N'Prag', N'Dallas', CAST(N'2018-09-04T03:55:31.263' AS DateTime), 0, 250, 145, 2184, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (552, N'Frankfurt', N'Mailand', CAST(N'2018-05-07T14:02:31.273' AS DateTime), 0, 250, 26, 2037, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (553, N'New York', N'Oslo', CAST(N'2018-09-15T05:12:31.283' AS DateTime), 0, 250, 156, 2124, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (554, N'Köln/Bonn', N'Mailand', CAST(N'2018-05-18T15:19:31.297' AS DateTime), 0, 250, 37, 2130, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (555, N'London', N'Kapstadt', CAST(N'2018-09-27T06:36:31.313' AS DateTime), 0, 250, 168, 2041, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (556, N'Mailand', N'Dallas', CAST(N'2018-05-29T16:36:31.327' AS DateTime), 0, 250, 48, 2087, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (557, N'Essen/Mülheim', N'Moskau', CAST(N'2018-10-08T07:53:31.337' AS DateTime), 0, 250, 179, 2091, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (558, N'Essen/Mülheim', N'Prag', CAST(N'2018-06-09T17:53:31.350' AS DateTime), 0, 250, 59, 2106, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (559, N'Paris', N'London', CAST(N'2018-10-19T09:10:31.360' AS DateTime), 0, 250, 190, 2042, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (560, N'Kapstadt', N'Moskau', CAST(N'2018-06-21T19:17:31.370' AS DateTime), 0, 250, 71, 2086, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (561, N'Prag', N'Madrid', CAST(N'2018-10-30T10:27:31.380' AS DateTime), 0, 250, 201, 2001, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (562, N'Frankfurt', N'London', CAST(N'2018-07-02T20:34:31.390' AS DateTime), 0, 250, 82, 2167, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (563, N'München', N'Paris', CAST(N'2018-11-10T11:44:31.403' AS DateTime), 0, 250, 212, 2011, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (564, N'New York', N'Dallas', CAST(N'2018-07-13T21:51:31.423' AS DateTime), 0, 250, 93, 2119, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (565, N'Berlin', N'Madrid', CAST(N'2018-11-22T13:08:31.437' AS DateTime), 0, 250, 224, 2022, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (566, N'New York', N'Hamburg', CAST(N'2018-07-24T23:08:31.447' AS DateTime), 0, 250, 104, 2179, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (567, N'Frankfurt', N'Mailand', CAST(N'2018-12-03T14:25:31.457' AS DateTime), 0, 250, 235, 2026, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (568, N'Oslo', N'Rom', CAST(N'2018-08-05T00:25:31.467' AS DateTime), 0, 250, 115, 2183, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (569, N'Prag', N'München', CAST(N'2018-12-14T15:42:31.477' AS DateTime), 0, 250, 246, 2111, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (570, N'Oslo', N'Essen/Mülheim', CAST(N'2018-08-17T01:49:31.487' AS DateTime), 0, 250, 127, 2062, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (571, N'Essen/Mülheim', N'Kapstadt', CAST(N'2018-04-18T11:49:31.500' AS DateTime), 0, 250, 7, 2137, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (572, N'Berlin', N'München', CAST(N'2018-08-28T03:06:31.520' AS DateTime), 0, 250, 138, 2106, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (573, N'Kapstadt', N'Frankfurt', CAST(N'2018-04-29T13:06:31.533' AS DateTime), 0, 250, 18, 2060, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (574, N'Kapstadt', N'London', CAST(N'2018-09-08T04:23:31.543' AS DateTime), 0, 250, 149, 2108, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (575, N'London', N'Frankfurt', CAST(N'2018-05-11T14:30:31.553' AS DateTime), 0, 250, 30, 2122, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (576, N'Madrid', N'Seattle', CAST(N'2018-09-19T05:40:31.560' AS DateTime), 0, 250, 160, 2135, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (577, N'Paris', N'Kapstadt', CAST(N'2018-05-22T15:47:31.573' AS DateTime), 0, 250, 41, 2029, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (578, N'Rom', N'Seattle', CAST(N'2018-10-01T07:04:31.583' AS DateTime), 0, 250, 168, 2020, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (579, N'Rom', N'Moskau', CAST(N'2018-06-02T17:04:31.593' AS DateTime), 0, 250, 48, 2106, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (580, N'Frankfurt', N'Moskau', CAST(N'2018-10-12T08:21:31.603' AS DateTime), 0, 250, 183, 2038, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (581, N'Rom', N'Hamburg', CAST(N'2018-06-13T18:21:31.623' AS DateTime), 0, 250, 59, 2130, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (582, N'Essen/Mülheim', N'Oslo', CAST(N'2018-10-23T09:38:31.640' AS DateTime), 0, 250, 194, 2038, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (583, N'Oslo', N'Dallas', CAST(N'2018-06-25T19:45:31.653' AS DateTime), 0, 250, 75, 2139, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (584, N'Moskau', N'Madrid', CAST(N'2018-11-03T10:55:31.663' AS DateTime), 0, 250, 205, 2020, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (585, N'Moskau', N'Rom', CAST(N'2018-07-06T21:02:31.673' AS DateTime), 0, 250, 86, 2021, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (586, N'Moskau', N'Prag', CAST(N'2018-11-14T12:12:31.683' AS DateTime), 0, 250, 216, 2044, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (587, N'Rom', N'Seattle', CAST(N'2018-07-17T22:19:31.693' AS DateTime), 0, 250, 93, 2089, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (588, N'Madrid', N'Prag', CAST(N'2018-11-26T13:36:31.713' AS DateTime), 0, 250, 228, 2190, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (589, N'München', N'Paris', CAST(N'2018-07-28T23:36:31.723' AS DateTime), 0, 250, 108, 2017, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (590, N'Moskau', N'Essen/Mülheim', CAST(N'2018-12-07T14:53:31.737' AS DateTime), 0, 250, 239, 2107, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (591, N'Dallas', N'Seattle', CAST(N'2018-08-09T00:53:31.747' AS DateTime), 0, 250, 119, 2104, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (592, N'Frankfurt', N'Prag', CAST(N'2018-04-11T11:00:31.757' AS DateTime), 0, 250, 0, 2039, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (593, N'Oslo', N'New York', CAST(N'2018-08-21T02:17:31.767' AS DateTime), 0, 250, 131, 2036, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (594, N'Paris', N'Dallas', CAST(N'2018-04-22T12:17:31.777' AS DateTime), 0, 250, 11, 2146, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (595, N'Dallas', N'Madrid', CAST(N'2018-09-01T03:34:31.790' AS DateTime), 0, 250, 142, 2193, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (596, N'Berlin', N'Seattle', CAST(N'2018-05-03T13:34:31.807' AS DateTime), 0, 250, 22, 2086, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (597, N'Dallas', N'Seattle', CAST(N'2018-09-12T04:51:31.820' AS DateTime), 0, 250, 153, 2017, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (598, N'Rom', N'Essen/Mülheim', CAST(N'2018-05-15T14:58:31.830' AS DateTime), 0, 250, 30, 2182, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (599, N'Essen/Mülheim', N'Paris', CAST(N'2018-09-23T06:08:31.843' AS DateTime), 0, 250, 164, 2137, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (600, N'Seattle', N'Moskau', CAST(N'2018-05-26T16:15:31.853' AS DateTime), 0, 250, 45, 2100, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (601, N'Frankfurt', N'Rom', CAST(N'2018-10-04T07:25:31.863' AS DateTime), 0, 250, 175, 2048, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (602, N'München', N'Moskau', CAST(N'2018-06-06T17:32:31.877' AS DateTime), 0, 250, 56, 2025, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (603, N'Moskau', N'Mailand', CAST(N'2018-10-16T08:49:31.887' AS DateTime), 0, 250, 187, 2148, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (604, N'Oslo', N'Seattle', CAST(N'2018-06-17T18:49:31.897' AS DateTime), 0, 250, 67, 2177, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (605, N'Berlin', N'Madrid', CAST(N'2018-10-27T10:06:31.917' AS DateTime), 0, 250, 198, 2144, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (606, N'Seattle', N'Oslo', CAST(N'2018-06-28T20:06:31.930' AS DateTime), 0, 250, 78, 2130, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (607, N'Dallas', N'München', CAST(N'2018-11-07T11:23:31.940' AS DateTime), 0, 250, 209, 2140, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (608, N'New York', N'Moskau', CAST(N'2018-07-10T21:30:31.950' AS DateTime), 0, 250, 90, 2007, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (609, N'Mailand', N'Seattle', CAST(N'2018-11-18T12:40:31.960' AS DateTime), 0, 250, 220, 2187, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (610, N'New York', N'London', CAST(N'2018-07-21T22:47:31.970' AS DateTime), 0, 250, 101, 2028, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (611, N'Prag', N'Hamburg', CAST(N'2018-11-30T14:04:31.980' AS DateTime), 0, 250, 232, 2012, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (612, N'Seattle', N'Rom', CAST(N'2018-08-02T00:04:31.990' AS DateTime), 0, 250, 112, 2125, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (613, N'Mailand', N'Kapstadt', CAST(N'2018-12-11T15:21:32.000' AS DateTime), 0, 250, 243, 2054, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (614, N'Madrid', N'Mailand', CAST(N'2018-08-13T01:21:32.017' AS DateTime), 0, 250, 123, 2045, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (615, N'Seattle', N'Frankfurt', CAST(N'2018-04-15T11:28:32.030' AS DateTime), 0, 250, 4, 2005, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (616, N'Hamburg', N'Köln/Bonn', CAST(N'2018-08-25T02:45:32.040' AS DateTime), 0, 250, 135, 2177, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (617, N'Hamburg', N'Berlin', CAST(N'2018-04-26T12:45:32.053' AS DateTime), 0, 250, 15, 2102, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (618, N'Berlin', N'Seattle', CAST(N'2018-09-05T04:02:32.063' AS DateTime), 0, 250, 146, 2091, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (619, N'Kapstadt', N'Mailand', CAST(N'2018-05-07T14:02:32.073' AS DateTime), 0, 250, 26, 2144, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (620, N'Hamburg', N'Seattle', CAST(N'2018-09-16T05:19:32.083' AS DateTime), 0, 250, 157, 2178, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (621, N'Hamburg', N'Dallas', CAST(N'2018-05-19T15:26:32.100' AS DateTime), 0, 250, 38, 2025, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (622, N'Moskau', N'Paris', CAST(N'2018-09-27T06:36:32.113' AS DateTime), 0, 250, 168, 2100, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (623, N'Madrid', N'London', CAST(N'2018-05-30T16:43:32.123' AS DateTime), 0, 250, 49, 2114, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (624, N'Frankfurt', N'Hamburg', CAST(N'2018-10-08T07:53:32.133' AS DateTime), 0, 250, 179, 2016, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (625, N'London', N'München', CAST(N'2018-06-10T18:00:32.143' AS DateTime), 0, 250, 60, 2132, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (626, N'Mailand', N'Dallas', CAST(N'2018-10-20T09:17:32.153' AS DateTime), 0, 250, 191, 2103, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (627, N'Berlin', N'Köln/Bonn', CAST(N'2018-06-21T19:17:32.163' AS DateTime), 0, 250, 71, 2082, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (628, N'Berlin', N'Paris', CAST(N'2018-10-31T10:34:32.177' AS DateTime), 0, 250, 202, 2067, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (629, N'New York', N'Mailand', CAST(N'2018-07-02T20:34:32.197' AS DateTime), 0, 250, 82, 2098, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (630, N'Moskau', N'Madrid', CAST(N'2018-11-11T11:51:32.207' AS DateTime), 0, 250, 213, 2173, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (631, N'Oslo', N'Rom', CAST(N'2018-07-14T21:58:32.217' AS DateTime), 0, 250, 94, 2023, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (632, N'London', N'New York', CAST(N'2018-11-22T13:08:32.227' AS DateTime), 0, 250, 224, 2100, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (633, N'Seattle', N'Prag', CAST(N'2018-07-25T23:15:32.237' AS DateTime), 0, 250, 105, 2072, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (634, N'Oslo', N'Rom', CAST(N'2018-12-03T14:25:32.247' AS DateTime), 0, 250, 235, 2020, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (635, N'Kapstadt', N'Paris', CAST(N'2018-08-06T00:32:32.257' AS DateTime), 0, 250, 116, 2131, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (636, N'Moskau', N'Kapstadt', CAST(N'2018-12-15T15:49:32.267' AS DateTime), 0, 250, 247, 2064, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (637, N'Mailand', N'Hamburg', CAST(N'2018-08-17T01:49:32.277' AS DateTime), 0, 250, 127, 2040, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (638, N'München', N'Prag', CAST(N'2018-04-19T11:56:32.297' AS DateTime), 0, 250, 8, 2158, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (639, N'Dallas', N'Oslo', CAST(N'2018-08-29T03:13:32.310' AS DateTime), 0, 250, 139, 2002, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (640, N'Köln/Bonn', N'Mailand', CAST(N'2018-04-30T13:13:32.320' AS DateTime), 0, 250, 19, 2140, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (641, N'Hamburg', N'Oslo', CAST(N'2018-09-09T04:30:32.330' AS DateTime), 0, 250, 150, 2193, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (642, N'Berlin', N'Mailand', CAST(N'2018-05-11T14:30:32.340' AS DateTime), 0, 250, 30, 2032, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (643, N'London', N'Madrid', CAST(N'2018-09-20T05:47:32.350' AS DateTime), 0, 250, 161, 2168, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (644, N'Mailand', N'Oslo', CAST(N'2018-05-23T15:54:32.363' AS DateTime), 0, 250, 42, 2099, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (645, N'Essen/Mülheim', N'Rom', CAST(N'2018-10-01T07:04:32.370' AS DateTime), 0, 250, 172, 2104, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (646, N'Hamburg', N'Kapstadt', CAST(N'2018-06-03T17:11:32.383' AS DateTime), 0, 250, 53, 2184, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (647, N'Kapstadt', N'Moskau', CAST(N'2018-10-12T08:21:32.400' AS DateTime), 0, 250, 183, 2078, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (648, N'Seattle', N'Frankfurt', CAST(N'2018-06-14T18:28:32.417' AS DateTime), 0, 250, 64, 2133, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (649, N'Oslo', N'Prag', CAST(N'2018-10-24T09:45:32.427' AS DateTime), 0, 250, 195, 2191, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (650, N'Rom', N'München', CAST(N'2018-06-25T19:45:32.437' AS DateTime), 0, 250, 71, 2148, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (651, N'Prag', N'München', CAST(N'2018-11-04T11:02:32.447' AS DateTime), 0, 250, 206, 2087, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (652, N'New York', N'Oslo', CAST(N'2018-07-06T21:02:32.457' AS DateTime), 0, 250, 86, 2174, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (653, N'Mailand', N'New York', CAST(N'2018-11-15T12:19:32.467' AS DateTime), 0, 250, 217, 2017, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (654, N'New York', N'Oslo', CAST(N'2018-07-18T22:26:32.487' AS DateTime), 0, 250, 98, 2120, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (655, N'London', N'Seattle', CAST(N'2018-11-26T13:36:32.497' AS DateTime), 0, 250, 228, 2108, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (656, N'Dallas', N'Paris', CAST(N'2018-07-29T23:43:32.507' AS DateTime), 0, 250, 109, 2044, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (657, N'Köln/Bonn', N'Essen/Mülheim', CAST(N'2018-12-07T14:53:32.517' AS DateTime), 0, 250, 239, 2024, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (658, N'Frankfurt', N'Paris', CAST(N'2018-08-10T01:00:32.527' AS DateTime), 0, 250, 120, 2185, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (659, N'Rom', N'Mailand', CAST(N'2018-04-12T11:07:32.537' AS DateTime), 0, 250, -3, 2171, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (660, N'Rom', N'Frankfurt', CAST(N'2018-08-21T02:17:32.547' AS DateTime), 0, 250, 127, 2191, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (661, N'Hamburg', N'Frankfurt', CAST(N'2018-04-23T12:24:32.557' AS DateTime), 0, 250, 12, 2154, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (662, N'Frankfurt', N'Dallas', CAST(N'2018-09-01T03:34:32.577' AS DateTime), 0, 250, 142, 2155, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (663, N'Frankfurt', N'München', CAST(N'2018-05-04T13:41:32.587' AS DateTime), 0, 250, 23, 2084, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (664, N'New York', N'Essen/Mülheim', CAST(N'2018-09-13T04:58:32.597' AS DateTime), 0, 250, 154, 2033, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (665, N'Madrid', N'München', CAST(N'2018-05-15T14:58:32.607' AS DateTime), 0, 250, 34, 2123, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (666, N'Kapstadt', N'Rom', CAST(N'2018-09-24T06:15:32.617' AS DateTime), 0, 250, 165, 2075, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (667, N'München', N'Oslo', CAST(N'2018-05-26T16:15:32.627' AS DateTime), 0, 250, 45, 2026, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (668, N'Essen/Mülheim', N'Berlin', CAST(N'2018-10-05T07:32:32.640' AS DateTime), 0, 250, 176, 2067, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (669, N'New York', N'Paris', CAST(N'2018-06-07T17:39:32.650' AS DateTime), 0, 250, 57, 2139, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (670, N'Prag', N'Rom', CAST(N'2018-10-16T08:49:32.660' AS DateTime), 0, 250, 187, 2082, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (671, N'Berlin', N'München', CAST(N'2018-06-18T18:56:32.680' AS DateTime), 0, 250, 68, 2110, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (672, N'München', N'Paris', CAST(N'2018-10-28T10:13:32.690' AS DateTime), 0, 250, 199, 2173, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (673, N'Kapstadt', N'Köln/Bonn', CAST(N'2018-06-29T20:13:32.700' AS DateTime), 0, 250, 79, 2146, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (674, N'Essen/Mülheim', N'Oslo', CAST(N'2018-11-08T11:30:32.710' AS DateTime), 0, 250, 210, 2054, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (675, N'Kapstadt', N'New York', CAST(N'2018-07-10T21:30:32.723' AS DateTime), 0, 250, 90, 2008, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (676, N'Dallas', N'Köln/Bonn', CAST(N'2018-11-19T12:47:32.730' AS DateTime), 0, 250, 221, 2053, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (677, N'Rom', N'Prag', CAST(N'2018-07-22T22:54:32.743' AS DateTime), 0, 250, 98, 2034, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (678, N'Mailand', N'Hamburg', CAST(N'2018-11-30T14:04:32.750' AS DateTime), 0, 250, 232, 2036, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (679, N'Kapstadt', N'Mailand', CAST(N'2018-08-03T00:11:32.763' AS DateTime), 0, 250, 113, 2008, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (680, N'Paris', N'Mailand', CAST(N'2018-12-11T15:21:32.780' AS DateTime), 0, 250, 243, 2110, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (681, N'Frankfurt', N'Moskau', CAST(N'2018-08-14T01:28:32.793' AS DateTime), 0, 250, 124, 2166, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (682, N'Berlin', N'New York', CAST(N'2018-04-16T11:35:32.803' AS DateTime), 0, 250, 5, 2115, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (683, N'New York', N'Seattle', CAST(N'2018-08-25T02:45:32.813' AS DateTime), 0, 250, 135, 2145, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (684, N'Essen/Mülheim', N'Dallas', CAST(N'2018-04-27T12:52:32.823' AS DateTime), 0, 250, 16, 2012, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (685, N'New York', N'London', CAST(N'2018-09-05T04:02:32.833' AS DateTime), 0, 250, 146, 2001, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (686, N'Madrid', N'Dallas', CAST(N'2018-05-08T14:09:32.853' AS DateTime), 0, 250, 27, 2082, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (687, N'Rom', N'Seattle', CAST(N'2018-09-17T05:26:32.863' AS DateTime), 0, 250, 154, 2035, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (688, N'Paris', N'Hamburg', CAST(N'2018-05-19T15:26:32.873' AS DateTime), 0, 250, 38, 2154, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (689, N'Köln/Bonn', N'Prag', CAST(N'2018-09-28T06:43:32.883' AS DateTime), 0, 250, 169, 2196, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (690, N'London', N'Rom', CAST(N'2018-05-30T16:43:32.893' AS DateTime), 0, 250, 49, 2195, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (691, N'Kapstadt', N'Paris', CAST(N'2018-10-09T08:00:32.903' AS DateTime), 0, 250, 180, 2158, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (692, N'Hamburg', N'Seattle', CAST(N'2018-06-11T18:07:32.917' AS DateTime), 0, 250, 61, 2072, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (693, N'Paris', N'Kapstadt', CAST(N'2018-10-20T09:17:32.927' AS DateTime), 0, 250, 191, 2199, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (694, N'Mailand', N'London', CAST(N'2018-06-22T19:24:32.937' AS DateTime), 0, 250, 72, 2107, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (695, N'Prag', N'Moskau', CAST(N'2018-10-31T10:34:32.957' AS DateTime), 0, 250, 202, 2112, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (696, N'München', N'Madrid', CAST(N'2018-07-03T20:41:32.967' AS DateTime), 0, 250, 83, 2163, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (697, N'Hamburg', N'Dallas', CAST(N'2018-11-12T11:58:32.977' AS DateTime), 0, 250, 214, 2103, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (698, N'New York', N'München', CAST(N'2018-07-14T21:58:32.987' AS DateTime), 0, 250, 94, 2162, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (699, N'London', N'New York', CAST(N'2018-11-23T13:15:32.997' AS DateTime), 0, 250, 225, 2074, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (700, N'Frankfurt', N'Essen/Mülheim', CAST(N'2018-07-25T23:15:33.007' AS DateTime), 0, 250, 105, 2018, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (701, N'Moskau', N'Köln/Bonn', CAST(N'2018-12-04T14:32:33.020' AS DateTime), 0, 250, 236, 2084, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (702, N'Essen/Mülheim', N'Oslo', CAST(N'2018-08-07T00:39:33.030' AS DateTime), 0, 250, 117, 2114, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (703, N'Köln/Bonn', N'Mailand', CAST(N'2018-12-15T15:49:33.040' AS DateTime), 0, 250, 247, 2135, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (704, N'New York', N'Paris', CAST(N'2018-08-18T01:56:33.063' AS DateTime), 0, 250, 128, 2032, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (705, N'Paris', N'Madrid', CAST(N'2018-04-20T12:03:33.073' AS DateTime), 0, 250, 9, 2065, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (706, N'New York', N'Oslo', CAST(N'2018-08-29T03:13:33.083' AS DateTime), 0, 250, 139, 2125, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (707, N'Hamburg', N'München', CAST(N'2018-05-01T13:20:33.093' AS DateTime), 0, 250, 20, 2139, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (708, N'Rom', N'Mailand', CAST(N'2018-09-09T04:30:33.103' AS DateTime), 0, 250, 146, 2040, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (709, N'Köln/Bonn', N'Dallas', CAST(N'2018-05-12T14:37:33.113' AS DateTime), 0, 250, 31, 2161, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (710, N'Berlin', N'Dallas', CAST(N'2018-09-21T05:54:33.123' AS DateTime), 0, 250, 162, 2077, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (711, N'Berlin', N'Oslo', CAST(N'2018-05-23T15:54:33.133' AS DateTime), 0, 250, 42, 2174, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (712, N'Frankfurt', N'München', CAST(N'2018-10-02T07:11:33.143' AS DateTime), 0, 250, 173, 2156, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (713, N'New York', N'Dallas', CAST(N'2018-06-03T17:11:33.163' AS DateTime), 0, 250, 53, 2169, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (714, N'London', N'München', CAST(N'2018-10-13T08:28:33.177' AS DateTime), 0, 250, 184, 2107, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (715, N'Moskau', N'London', CAST(N'2018-06-15T18:35:33.187' AS DateTime), 0, 250, 65, 2044, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (716, N'Rom', N'Mailand', CAST(N'2018-10-24T09:45:33.197' AS DateTime), 0, 250, 191, 2147, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (717, N'Madrid', N'New York', CAST(N'2018-06-26T19:52:33.207' AS DateTime), 0, 250, 76, 2079, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (718, N'Paris', N'Berlin', CAST(N'2018-11-04T11:02:33.217' AS DateTime), 0, 250, 206, 2021, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (719, N'Rom', N'Seattle', CAST(N'2018-07-07T21:09:33.237' AS DateTime), 0, 250, 83, 2063, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (720, N'Rom', N'New York', CAST(N'2018-11-16T12:26:33.247' AS DateTime), 0, 250, 214, 2129, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (721, N'New York', N'Berlin', CAST(N'2018-07-18T22:26:33.260' AS DateTime), 0, 250, 98, 2030, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (722, N'Prag', N'Dallas', CAST(N'2018-11-27T13:43:33.270' AS DateTime), 0, 250, 229, 2044, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (723, N'Prag', N'München', CAST(N'2018-07-29T23:43:33.280' AS DateTime), 0, 250, 109, 2194, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (724, N'Hamburg', N'Rom', CAST(N'2018-12-08T15:00:33.290' AS DateTime), 0, 250, 240, 2064, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (725, N'Berlin', N'New York', CAST(N'2018-08-11T01:07:33.300' AS DateTime), 0, 250, 121, 2151, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (726, N'Frankfurt', N'Dallas', CAST(N'2018-04-12T11:07:33.310' AS DateTime), 0, 250, 1, 2190, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (727, N'Mailand', N'Frankfurt', CAST(N'2018-08-22T02:24:33.320' AS DateTime), 0, 250, 132, 2055, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (728, N'Köln/Bonn', N'Prag', CAST(N'2018-04-23T12:24:33.340' AS DateTime), 0, 250, 12, 2074, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (729, N'Prag', N'Mailand', CAST(N'2018-09-02T03:41:33.350' AS DateTime), 0, 250, 143, 2012, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (730, N'Berlin', N'Mailand', CAST(N'2018-05-05T13:48:33.360' AS DateTime), 0, 250, 24, 2187, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (731, N'Seattle', N'Moskau', CAST(N'2018-09-13T04:58:33.370' AS DateTime), 0, 250, 154, 2145, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (732, N'Mailand', N'Madrid', CAST(N'2018-05-16T15:05:33.380' AS DateTime), 0, 250, 35, 2106, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (733, N'Hamburg', N'Seattle', CAST(N'2018-09-24T06:15:33.390' AS DateTime), 0, 250, 165, 2068, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (734, N'Köln/Bonn', N'Hamburg', CAST(N'2018-05-27T16:22:33.403' AS DateTime), 0, 250, 46, 2129, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (735, N'Essen/Mülheim', N'New York', CAST(N'2018-10-06T07:39:33.410' AS DateTime), 0, 250, 177, 2073, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (736, N'Frankfurt', N'Paris', CAST(N'2018-06-07T17:39:33.420' AS DateTime), 0, 250, 57, 2078, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (737, N'London', N'Hamburg', CAST(N'2018-10-17T08:56:33.440' AS DateTime), 0, 250, 188, 2147, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (738, N'London', N'Kapstadt', CAST(N'2018-06-19T19:03:33.450' AS DateTime), 0, 250, 69, 2117, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (739, N'London', N'Paris', CAST(N'2018-10-28T10:13:33.460' AS DateTime), 0, 250, 199, 2098, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (740, N'Essen/Mülheim', N'Dallas', CAST(N'2018-06-30T20:20:33.470' AS DateTime), 0, 250, 80, 2104, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (741, N'München', N'Prag', CAST(N'2018-11-08T11:30:33.477' AS DateTime), 0, 250, 210, 2124, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (742, N'Berlin', N'Prag', CAST(N'2018-07-11T21:37:33.487' AS DateTime), 0, 250, 91, 2142, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (743, N'Moskau', N'Prag', CAST(N'2018-11-20T12:54:33.497' AS DateTime), 0, 250, 222, 2154, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (744, N'Köln/Bonn', N'Oslo', CAST(N'2018-07-22T22:54:33.507' AS DateTime), 0, 250, 102, 2053, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (745, N'New York', N'Köln/Bonn', CAST(N'2018-12-01T14:11:33.517' AS DateTime), 0, 250, 233, 2172, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (746, N'New York', N'Mailand', CAST(N'2018-08-03T00:11:33.537' AS DateTime), 0, 250, 113, 2181, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (747, N'Berlin', N'Paris', CAST(N'2018-12-12T15:28:33.547' AS DateTime), 0, 250, 244, 2010, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (748, N'Seattle', N'New York', CAST(N'2018-08-15T01:35:33.570' AS DateTime), 0, 250, 125, 2062, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (749, N'Hamburg', N'Rom', CAST(N'2018-04-16T11:35:33.597' AS DateTime), 0, 250, 5, 2157, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (750, N'Mailand', N'Berlin', CAST(N'2018-08-26T02:52:33.620' AS DateTime), 0, 250, 136, 2087, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (751, N'Essen/Mülheim', N'Kapstadt', CAST(N'2018-04-27T12:52:33.643' AS DateTime), 0, 250, 16, 2021, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (752, N'Seattle', N'Berlin', CAST(N'2018-09-06T04:09:33.690' AS DateTime), 0, 250, 147, 2147, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (753, N'Frankfurt', N'New York', CAST(N'2018-05-09T14:16:33.713' AS DateTime), 0, 250, 28, 2096, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (754, N'Madrid', N'New York', CAST(N'2018-09-17T05:26:33.737' AS DateTime), 0, 250, 158, 2025, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (755, N'Rom', N'Mailand', CAST(N'2018-05-20T15:33:33.763' AS DateTime), 0, 250, 35, 2149, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (756, N'Prag', N'Essen/Mülheim', CAST(N'2018-09-28T06:43:33.787' AS DateTime), 0, 250, 169, 2147, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (757, N'Oslo', N'Moskau', CAST(N'2018-05-31T16:50:33.810' AS DateTime), 0, 250, 50, 2153, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (758, N'Prag', N'Mailand', CAST(N'2018-10-10T08:07:33.830' AS DateTime), 0, 250, 181, 2099, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (759, N'Madrid', N'Rom', CAST(N'2018-06-11T18:07:33.857' AS DateTime), 0, 250, 61, 2167, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (760, N'Hamburg', N'Oslo', CAST(N'2018-10-21T09:24:33.880' AS DateTime), 0, 250, 192, 2091, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (761, N'Paris', N'Rom', CAST(N'2018-06-22T19:24:33.933' AS DateTime), 0, 250, 72, 2037, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (762, N'Mailand', N'Prag', CAST(N'2018-11-01T10:41:33.960' AS DateTime), 0, 250, 203, 2158, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (763, N'München', N'Hamburg', CAST(N'2018-07-04T20:48:33.983' AS DateTime), 0, 250, 84, 2121, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (764, N'Essen/Mülheim', N'Kapstadt', CAST(N'2018-11-12T11:58:34.010' AS DateTime), 0, 250, 214, 2071, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (765, N'Dallas', N'Hamburg', CAST(N'2018-07-15T22:05:34.040' AS DateTime), 0, 250, 95, 2010, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (766, N'Prag', N'Berlin', CAST(N'2018-11-24T13:22:34.067' AS DateTime), 0, 250, 226, 2145, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (767, N'Moskau', N'Köln/Bonn', CAST(N'2018-07-26T23:22:34.090' AS DateTime), 0, 250, 106, 2083, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (768, N'London', N'Moskau', CAST(N'2018-12-05T14:39:34.113' AS DateTime), 0, 250, 237, 2091, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (769, N'New York', N'Hamburg', CAST(N'2018-08-07T00:39:34.137' AS DateTime), 0, 250, 117, 2071, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (770, N'New York', N'Kapstadt', CAST(N'2018-12-16T15:56:34.187' AS DateTime), 0, 250, 248, 2142, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (771, N'Oslo', N'Madrid', CAST(N'2018-08-19T02:03:34.217' AS DateTime), 0, 250, 129, 2145, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (772, N'Berlin', N'Mailand', CAST(N'2018-04-20T12:03:34.240' AS DateTime), 0, 250, 9, 2068, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (773, N'Oslo', N'Kapstadt', CAST(N'2018-08-30T03:20:34.267' AS DateTime), 0, 250, 140, 2188, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (774, N'Dallas', N'Paris', CAST(N'2018-05-01T13:20:34.290' AS DateTime), 0, 250, 20, 2110, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (775, N'München', N'Hamburg', CAST(N'2018-09-10T04:37:34.313' AS DateTime), 0, 250, 151, 2155, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (776, N'Paris', N'Moskau', CAST(N'2018-05-13T14:44:34.367' AS DateTime), 0, 250, 32, 2058, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (777, N'Mailand', N'Rom', CAST(N'2018-09-21T05:54:34.390' AS DateTime), 0, 250, 162, 2059, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (778, N'Frankfurt', N'New York', CAST(N'2018-05-24T16:01:34.407' AS DateTime), 0, 250, 43, 2139, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (779, N'Seattle', N'Essen/Mülheim', CAST(N'2018-10-02T07:11:34.423' AS DateTime), 0, 250, 173, 2160, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (780, N'London', N'Paris', CAST(N'2018-06-04T17:18:34.437' AS DateTime), 0, 250, 54, 2103, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (781, N'London', N'Oslo', CAST(N'2018-10-14T08:35:34.453' AS DateTime), 0, 250, 185, 2169, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (782, N'Oslo', N'New York', CAST(N'2018-06-15T18:35:34.467' AS DateTime), 0, 250, 65, 2187, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (783, N'Essen/Mülheim', N'Seattle', CAST(N'2018-10-25T09:52:34.480' AS DateTime), 0, 250, 196, 2120, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (784, N'Hamburg', N'Kapstadt', CAST(N'2018-06-26T19:52:34.493' AS DateTime), 0, 250, 76, 2123, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (785, N'Kapstadt', N'Madrid', CAST(N'2018-11-05T11:09:34.517' AS DateTime), 0, 250, 207, 2052, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (786, N'Paris', N'Seattle', CAST(N'2018-07-08T21:16:34.527' AS DateTime), 0, 250, 88, 2051, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (787, N'Moskau', N'Frankfurt', CAST(N'2018-11-16T12:26:34.543' AS DateTime), 0, 250, 218, 2033, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (788, N'Prag', N'Paris', CAST(N'2018-07-19T22:33:34.560' AS DateTime), 0, 250, 99, 2157, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (789, N'Köln/Bonn', N'Berlin', CAST(N'2018-11-27T13:43:34.580' AS DateTime), 0, 250, 229, 2196, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (790, N'Paris', N'New York', CAST(N'2018-07-30T23:50:34.597' AS DateTime), 0, 250, 110, 2042, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (791, N'Berlin', N'Moskau', CAST(N'2018-12-09T15:07:34.617' AS DateTime), 0, 250, 241, 2104, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (792, N'Oslo', N'Hamburg', CAST(N'2018-08-11T01:07:34.637' AS DateTime), 0, 250, 121, 2047, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (793, N'Rom', N'Madrid', CAST(N'2018-04-13T11:14:34.657' AS DateTime), 0, 250, -2, 2156, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (794, N'New York', N'Moskau', CAST(N'2018-08-22T02:24:34.693' AS DateTime), 0, 250, 132, 2148, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (795, N'Seattle', N'Frankfurt', CAST(N'2018-04-24T12:31:34.703' AS DateTime), 0, 250, 13, 2066, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (796, N'Berlin', N'Oslo', CAST(N'2018-09-03T03:48:34.717' AS DateTime), 0, 250, 144, 2036, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (797, N'Essen/Mülheim', N'Rom', CAST(N'2018-05-05T13:48:34.740' AS DateTime), 0, 250, 24, 2011, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (798, N'Prag', N'Essen/Mülheim', CAST(N'2018-09-14T05:05:34.760' AS DateTime), 0, 250, 155, 2075, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (799, N'London', N'Kapstadt', CAST(N'2018-05-17T15:12:34.783' AS DateTime), 0, 250, 36, 2095, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (800, N'Frankfurt', N'Seattle', CAST(N'2018-09-25T06:22:35.570' AS DateTime), 0, 250, 166, 2119, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (801, N'Dallas', N'Rom', CAST(N'2018-05-28T16:29:35.593' AS DateTime), 0, 250, 47, 2017, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (802, N'Paris', N'Hamburg', CAST(N'2018-10-06T07:39:35.617' AS DateTime), 0, 250, 177, 2037, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (803, N'Frankfurt', N'Oslo', CAST(N'2018-06-08T17:46:35.667' AS DateTime), 0, 250, 58, 2130, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (804, N'Berlin', N'Frankfurt', CAST(N'2018-10-18T09:03:35.687' AS DateTime), 0, 250, 189, 2166, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (805, N'Mailand', N'Dallas', CAST(N'2018-06-19T19:03:35.700' AS DateTime), 0, 250, 69, 2102, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (806, N'Paris', N'Kapstadt', CAST(N'2018-10-29T10:20:35.720' AS DateTime), 0, 250, 200, 2065, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (807, N'Mailand', N'Hamburg', CAST(N'2018-06-30T20:20:35.740' AS DateTime), 0, 250, 80, 2029, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (808, N'Kapstadt', N'New York', CAST(N'2018-11-09T11:37:35.763' AS DateTime), 0, 250, 211, 2060, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (809, N'München', N'Mailand', CAST(N'2018-07-12T21:44:35.803' AS DateTime), 0, 250, 92, 2172, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (810, N'München', N'Moskau', CAST(N'2018-11-20T12:54:35.817' AS DateTime), 0, 250, 222, 2077, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (811, N'Essen/Mülheim', N'Köln/Bonn', CAST(N'2018-07-23T23:01:35.830' AS DateTime), 0, 250, 103, 2034, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (812, N'Hamburg', N'Seattle', CAST(N'2018-12-01T14:11:35.847' AS DateTime), 0, 250, 233, 2052, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (813, N'New York', N'Rom', CAST(N'2018-08-04T00:18:35.860' AS DateTime), 0, 250, 114, 2183, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (814, N'München', N'Oslo', CAST(N'2018-12-13T15:35:35.877' AS DateTime), 0, 250, 245, 2199, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (815, N'Prag', N'Essen/Mülheim', CAST(N'2018-08-15T01:35:35.893' AS DateTime), 0, 250, 125, 2053, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (816, N'Hamburg', N'Frankfurt', CAST(N'2018-04-17T11:42:35.907' AS DateTime), 0, 250, 6, 2155, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (817, N'Madrid', N'Oslo', CAST(N'2018-08-26T02:52:35.923' AS DateTime), 0, 250, 136, 2008, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (818, N'München', N'Moskau', CAST(N'2018-04-28T12:59:35.957' AS DateTime), 0, 250, 17, 2092, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (819, N'Mailand', N'München', CAST(N'2018-09-07T04:16:35.970' AS DateTime), 0, 250, 148, 2127, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (820, N'Kapstadt', N'Köln/Bonn', CAST(N'2018-05-09T14:16:35.987' AS DateTime), 0, 250, 28, 2139, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (821, N'Rom', N'Dallas', CAST(N'2018-09-18T05:33:36.000' AS DateTime), 0, 250, 155, 2065, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (822, N'Kapstadt', N'New York', CAST(N'2018-05-20T15:33:36.017' AS DateTime), 0, 250, 39, 2057, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (823, N'Essen/Mülheim', N'Mailand', CAST(N'2018-09-29T06:50:36.030' AS DateTime), 0, 250, 170, 2081, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (824, N'München', N'Köln/Bonn', CAST(N'2018-06-01T16:57:36.047' AS DateTime), 0, 250, 51, 2183, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (825, N'Berlin', N'Oslo', CAST(N'2018-10-10T08:07:36.063' AS DateTime), 0, 250, 181, 2081, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (826, N'Frankfurt', N'Rom', CAST(N'2018-06-12T18:14:36.080' AS DateTime), 0, 250, 62, 2128, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (827, N'London', N'Moskau', CAST(N'2018-10-21T09:24:36.127' AS DateTime), 0, 250, 192, 2133, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (828, N'Seattle', N'Essen/Mülheim', CAST(N'2018-06-23T19:31:36.157' AS DateTime), 0, 250, 73, 2109, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (829, N'New York', N'Madrid', CAST(N'2018-11-02T10:48:36.180' AS DateTime), 0, 250, 204, 2021, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (830, N'Hamburg', N'Kapstadt', CAST(N'2018-07-04T20:48:36.203' AS DateTime), 0, 250, 84, 2194, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (831, N'Seattle', N'Köln/Bonn', CAST(N'2018-11-13T12:05:36.230' AS DateTime), 0, 250, 215, 2097, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (832, N'Mailand', N'Moskau', CAST(N'2018-07-16T22:12:36.257' AS DateTime), 0, 250, 96, 2158, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (833, N'Prag', N'New York', CAST(N'2018-11-24T13:22:36.297' AS DateTime), 0, 250, 226, 2032, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (834, N'Moskau', N'Essen/Mülheim', CAST(N'2018-07-27T23:29:36.320' AS DateTime), 0, 250, 107, 2058, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (835, N'München', N'Rom', CAST(N'2018-12-05T14:39:36.347' AS DateTime), 0, 250, 237, 2174, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (836, N'Seattle', N'Essen/Mülheim', CAST(N'2018-08-08T00:46:36.370' AS DateTime), 0, 250, 118, 2059, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (837, N'Rom', N'Köln/Bonn', CAST(N'2018-12-17T16:03:36.393' AS DateTime), 0, 250, 236, 2134, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (838, N'Seattle', N'Oslo', CAST(N'2018-08-19T02:03:36.420' AS DateTime), 0, 250, 129, 2130, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (839, N'München', N'Dallas', CAST(N'2018-04-21T12:10:36.443' AS DateTime), 0, 250, 10, 2111, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (840, N'Essen/Mülheim', N'New York', CAST(N'2018-08-30T03:20:36.467' AS DateTime), 0, 250, 140, 2179, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (841, N'London', N'Hamburg', CAST(N'2018-05-02T13:27:36.490' AS DateTime), 0, 250, 21, 2099, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (842, N'Rom', N'Mailand', CAST(N'2018-09-11T04:44:36.540' AS DateTime), 0, 250, 148, 2003, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (843, N'Paris', N'Moskau', CAST(N'2018-05-13T14:44:36.563' AS DateTime), 0, 250, 32, 2075, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (844, N'New York', N'Moskau', CAST(N'2018-09-22T06:01:36.587' AS DateTime), 0, 250, 163, 2133, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (845, N'Mailand', N'Essen/Mülheim', CAST(N'2018-05-24T16:01:36.613' AS DateTime), 0, 250, 43, 2173, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (846, N'London', N'Prag', CAST(N'2018-10-03T07:18:36.640' AS DateTime), 0, 250, 174, 2084, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (847, N'Seattle', N'Oslo', CAST(N'2018-06-05T17:25:36.667' AS DateTime), 0, 250, 55, 2026, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (848, N'Kapstadt', N'Oslo', CAST(N'2018-10-14T08:35:36.690' AS DateTime), 0, 250, 185, 2115, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (849, N'Rom', N'Dallas', CAST(N'2018-06-16T18:42:36.710' AS DateTime), 0, 250, 62, 2068, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (850, N'Kapstadt', N'London', CAST(N'2018-10-25T09:52:36.737' AS DateTime), 0, 250, 196, 2121, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (851, N'Köln/Bonn', N'Kapstadt', CAST(N'2018-06-27T19:59:36.783' AS DateTime), 0, 250, 77, 2197, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (852, N'Moskau', N'Kapstadt', CAST(N'2018-11-06T11:16:36.803' AS DateTime), 0, 250, 208, 2167, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (853, N'Rom', N'Hamburg', CAST(N'2018-07-08T21:16:36.827' AS DateTime), 0, 250, 84, 2183, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (854, N'Berlin', N'Hamburg', CAST(N'2018-11-17T12:33:36.847' AS DateTime), 0, 250, 219, 2032, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (855, N'Kapstadt', N'Essen/Mülheim', CAST(N'2018-07-19T22:33:36.867' AS DateTime), 0, 250, 99, 2082, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (856, N'München', N'Berlin', CAST(N'2018-11-28T13:50:36.890' AS DateTime), 0, 250, 230, 2144, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (857, N'Essen/Mülheim', N'Prag', CAST(N'2018-07-31T23:57:36.913' AS DateTime), 0, 250, 111, 2052, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (858, N'Oslo', N'Berlin', CAST(N'2018-12-09T15:07:36.937' AS DateTime), 0, 250, 241, 2096, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (859, N'Seattle', N'Moskau', CAST(N'2018-08-12T01:14:36.957' AS DateTime), 0, 250, 122, 2048, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (860, N'Essen/Mülheim', N'London', CAST(N'2018-04-14T11:21:37.000' AS DateTime), 0, 250, 3, 2159, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (861, N'Seattle', N'Hamburg', CAST(N'2018-08-23T02:31:37.020' AS DateTime), 0, 250, 133, 2106, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (862, N'Rom', N'Moskau', CAST(N'2018-04-25T12:38:37.040' AS DateTime), 0, 250, 10, 2141, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (863, N'Moskau', N'Kapstadt', CAST(N'2018-09-03T03:48:37.060' AS DateTime), 0, 250, 144, 2125, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (864, N'Dallas', N'Oslo', CAST(N'2018-05-06T13:55:37.080' AS DateTime), 0, 250, 25, 2049, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (865, N'Oslo', N'Rom', CAST(N'2018-09-15T05:12:37.103' AS DateTime), 0, 250, 156, 2156, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (866, N'Hamburg', N'Berlin', CAST(N'2018-05-17T15:12:37.143' AS DateTime), 0, 250, 36, 2115, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (867, N'Hamburg', N'Frankfurt', CAST(N'2018-09-26T06:29:37.163' AS DateTime), 0, 250, 167, 2145, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (868, N'Köln/Bonn', N'Mailand', CAST(N'2018-05-28T16:29:37.187' AS DateTime), 0, 250, 47, 2137, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (869, N'Rom', N'Madrid', CAST(N'2018-10-07T07:46:37.203' AS DateTime), 0, 250, 174, 2162, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (870, N'London', N'Hamburg', CAST(N'2018-06-09T17:53:37.223' AS DateTime), 0, 250, 59, 2135, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (871, N'Oslo', N'München', CAST(N'2018-10-18T09:03:37.243' AS DateTime), 0, 250, 189, 2061, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (872, N'Madrid', N'Rom', CAST(N'2018-06-20T19:10:37.263' AS DateTime), 0, 250, 70, 2196, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (873, N'New York', N'Mailand', CAST(N'2018-10-29T10:20:37.283' AS DateTime), 0, 250, 200, 2035, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (874, N'Seattle', N'Prag', CAST(N'2018-07-01T20:27:37.300' AS DateTime), 0, 250, 81, 2047, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (875, N'Frankfurt', N'Kapstadt', CAST(N'2018-11-10T11:44:37.343' AS DateTime), 0, 250, 212, 2131, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (876, N'Essen/Mülheim', N'Seattle', CAST(N'2018-07-12T21:44:37.363' AS DateTime), 0, 250, 92, 2098, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (877, N'Moskau', N'New York', CAST(N'2018-11-21T13:01:37.383' AS DateTime), 0, 250, 223, 2115, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (878, N'Köln/Bonn', N'Frankfurt', CAST(N'2018-07-23T23:01:37.400' AS DateTime), 0, 250, 103, 2082, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (879, N'Essen/Mülheim', N'Madrid', CAST(N'2018-12-02T14:18:37.417' AS DateTime), 0, 250, 234, 2003, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (880, N'Seattle', N'Oslo', CAST(N'2018-08-05T00:25:37.427' AS DateTime), 0, 250, 115, 2043, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (881, N'New York', N'Dallas', CAST(N'2018-12-13T15:35:37.440' AS DateTime), 0, 250, 245, 2004, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (882, N'Essen/Mülheim', N'Oslo', CAST(N'2018-08-16T01:42:37.453' AS DateTime), 0, 250, 126, 2008, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (883, N'Dallas', N'Kapstadt', CAST(N'2018-04-17T11:42:37.467' AS DateTime), 0, 250, 6, 2111, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (884, N'Moskau', N'Paris', CAST(N'2018-08-27T02:59:37.487' AS DateTime), 0, 250, 137, 2099, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (885, N'Prag', N'Mailand', CAST(N'2018-04-29T13:06:37.500' AS DateTime), 0, 250, 18, 2034, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (886, N'Seattle', N'Berlin', CAST(N'2018-09-07T04:16:37.513' AS DateTime), 0, 250, 148, 2057, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (887, N'Madrid', N'Frankfurt', CAST(N'2018-05-10T14:23:37.533' AS DateTime), 0, 250, 29, 2133, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (888, N'Seattle', N'München', CAST(N'2018-09-18T05:33:37.550' AS DateTime), 0, 250, 159, 2055, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (889, N'Moskau', N'Berlin', CAST(N'2018-05-21T15:40:37.570' AS DateTime), 0, 250, 40, 2160, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (890, N'Oslo', N'Köln/Bonn', CAST(N'2018-09-30T06:57:37.590' AS DateTime), 0, 250, 171, 2156, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (891, N'Kapstadt', N'London', CAST(N'2018-06-01T16:57:37.607' AS DateTime), 0, 250, 51, 2120, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (892, N'München', N'Kapstadt', CAST(N'2018-10-11T08:14:37.647' AS DateTime), 0, 250, 182, 2181, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (893, N'Frankfurt', N'Dallas', CAST(N'2018-06-13T18:21:37.673' AS DateTime), 0, 250, 63, 2152, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (894, N'Dallas', N'Köln/Bonn', CAST(N'2018-10-22T09:31:37.693' AS DateTime), 0, 250, 193, 2017, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (895, N'Seattle', N'Moskau', CAST(N'2018-06-24T19:38:37.713' AS DateTime), 0, 250, 74, 2048, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (896, N'Frankfurt', N'Kapstadt', CAST(N'2018-11-02T10:48:37.733' AS DateTime), 0, 250, 204, 2146, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (897, N'Madrid', N'Kapstadt', CAST(N'2018-07-05T20:55:37.757' AS DateTime), 0, 250, 85, 2110, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (898, N'Oslo', N'Kapstadt', CAST(N'2018-11-14T12:12:37.777' AS DateTime), 0, 250, 216, 2148, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (899, N'Hamburg', N'Oslo', CAST(N'2018-07-16T22:12:37.817' AS DateTime), 0, 250, 96, 2048, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (900, N'Berlin', N'Prag', CAST(N'2018-11-25T13:29:37.837' AS DateTime), 0, 250, 227, 2154, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (901, N'München', N'Oslo', CAST(N'2018-07-27T23:29:37.867' AS DateTime), 0, 250, 107, 2137, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (902, N'Hamburg', N'Oslo', CAST(N'2018-12-06T14:46:37.880' AS DateTime), 0, 250, 238, 2005, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (903, N'Madrid', N'München', CAST(N'2018-08-09T00:53:37.893' AS DateTime), 0, 250, 119, 2042, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (904, N'Oslo', N'Rom', CAST(N'2018-12-17T16:03:37.907' AS DateTime), 0, 250, 249, 2154, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (905, N'Essen/Mülheim', N'München', CAST(N'2018-08-20T02:10:37.920' AS DateTime), 0, 250, 130, 2003, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (906, N'Mailand', N'Rom', CAST(N'2018-04-21T12:10:37.933' AS DateTime), 0, 250, 10, 2045, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (907, N'Seattle', N'Hamburg', CAST(N'2018-08-31T03:27:37.947' AS DateTime), 0, 250, 141, 2192, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (908, N'Essen/Mülheim', N'New York', CAST(N'2018-05-03T13:34:37.977' AS DateTime), 0, 250, 22, 2001, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (909, N'Kapstadt', N'New York', CAST(N'2018-09-11T04:44:37.993' AS DateTime), 0, 250, 152, 2064, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (910, N'Frankfurt', N'Essen/Mülheim', CAST(N'2018-05-14T14:51:38.007' AS DateTime), 0, 250, 33, 2032, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (911, N'Essen/Mülheim', N'Seattle', CAST(N'2018-09-22T06:01:38.023' AS DateTime), 0, 250, 163, 2069, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (912, N'München', N'Madrid', CAST(N'2018-05-25T16:08:38.037' AS DateTime), 0, 250, 44, 2065, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (913, N'Paris', N'Prag', CAST(N'2018-10-04T07:25:38.050' AS DateTime), 0, 250, 175, 2138, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (914, N'Seattle', N'Prag', CAST(N'2018-06-05T17:25:38.063' AS DateTime), 0, 250, 55, 2188, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (915, N'Mailand', N'Kapstadt', CAST(N'2018-10-15T08:42:38.077' AS DateTime), 0, 250, 186, 2038, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (916, N'Seattle', N'Essen/Mülheim', CAST(N'2018-06-16T18:42:38.093' AS DateTime), 0, 250, 66, 2138, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (917, N'Moskau', N'Berlin', CAST(N'2018-10-26T09:59:38.123' AS DateTime), 0, 250, 197, 2074, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (918, N'London', N'Kapstadt', CAST(N'2018-06-28T20:06:38.137' AS DateTime), 0, 250, 78, 2079, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (919, N'Rom', N'Seattle', CAST(N'2018-11-06T11:16:38.150' AS DateTime), 0, 250, 204, 2086, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (920, N'Köln/Bonn', N'Seattle', CAST(N'2018-07-09T21:23:38.167' AS DateTime), 0, 250, 89, 2162, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (921, N'Paris', N'Berlin', CAST(N'2018-11-17T12:33:38.180' AS DateTime), 0, 250, 219, 2034, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (922, N'Moskau', N'Paris', CAST(N'2018-07-20T22:40:38.193' AS DateTime), 0, 250, 100, 2118, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (923, N'Rom', N'Seattle', CAST(N'2018-11-29T13:57:38.207' AS DateTime), 0, 250, 227, 2018, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (924, N'Kapstadt', N'Prag', CAST(N'2018-07-31T23:57:38.220' AS DateTime), 0, 250, 111, 2093, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (925, N'Berlin', N'Köln/Bonn', CAST(N'2018-12-10T15:14:38.247' AS DateTime), 0, 250, 242, 2041, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (926, N'Seattle', N'Prag', CAST(N'2018-08-13T01:21:38.270' AS DateTime), 0, 250, 123, 2002, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (927, N'Mailand', N'New York', CAST(N'2018-04-14T11:21:38.293' AS DateTime), 0, 250, 3, 2066, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (928, N'Berlin', N'Moskau', CAST(N'2018-08-24T02:38:38.310' AS DateTime), 0, 250, 134, 2143, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (929, N'London', N'Dallas', CAST(N'2018-04-25T12:38:38.330' AS DateTime), 0, 250, 14, 2071, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (930, N'Mailand', N'Berlin', CAST(N'2018-09-04T03:55:38.353' AS DateTime), 0, 250, 145, 2143, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (931, N'Frankfurt', N'Mailand', CAST(N'2018-05-07T14:02:38.373' AS DateTime), 0, 250, 26, 2103, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (932, N'London', N'Rom', CAST(N'2018-09-15T05:12:38.410' AS DateTime), 0, 250, 156, 2094, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (933, N'Essen/Mülheim', N'Madrid', CAST(N'2018-05-18T15:19:38.427' AS DateTime), 0, 250, 37, 2071, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (934, N'Moskau', N'Paris', CAST(N'2018-09-26T06:29:38.443' AS DateTime), 0, 250, 167, 2009, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (935, N'Moskau', N'Kapstadt', CAST(N'2018-05-29T16:36:38.467' AS DateTime), 0, 250, 48, 2097, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (936, N'Oslo', N'London', CAST(N'2018-10-08T07:53:38.487' AS DateTime), 0, 250, 179, 2108, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (937, N'Hamburg', N'New York', CAST(N'2018-06-09T17:53:38.507' AS DateTime), 0, 250, 59, 2033, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (938, N'Paris', N'Essen/Mülheim', CAST(N'2018-10-19T09:10:38.527' AS DateTime), 0, 250, 190, 2014, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (939, N'Mailand', N'London', CAST(N'2018-06-20T19:10:38.550' AS DateTime), 0, 250, 70, 2099, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (940, N'Mailand', N'Köln/Bonn', CAST(N'2018-10-30T10:27:38.570' AS DateTime), 0, 250, 201, 2087, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (941, N'Köln/Bonn', N'Kapstadt', CAST(N'2018-07-02T20:34:38.613' AS DateTime), 0, 250, 82, 2133, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (942, N'London', N'Seattle', CAST(N'2018-11-10T11:44:38.637' AS DateTime), 0, 250, 212, 2015, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (943, N'Dallas', N'New York', CAST(N'2018-07-13T21:51:38.657' AS DateTime), 0, 250, 93, 2193, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (944, N'Essen/Mülheim', N'Oslo', CAST(N'2018-11-21T13:01:38.680' AS DateTime), 0, 250, 223, 2129, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (945, N'New York', N'Madrid', CAST(N'2018-07-24T23:08:38.703' AS DateTime), 0, 250, 104, 2047, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (946, N'Rom', N'Paris', CAST(N'2018-12-03T14:25:38.727' AS DateTime), 0, 250, 231, 2151, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (947, N'Köln/Bonn', N'Paris', CAST(N'2018-08-05T00:25:38.747' AS DateTime), 0, 250, 115, 2128, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (948, N'Kapstadt', N'Köln/Bonn', CAST(N'2018-12-14T15:42:38.767' AS DateTime), 0, 250, 246, 2081, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (949, N'Prag', N'New York', CAST(N'2018-08-16T01:42:38.797' AS DateTime), 0, 250, 126, 2139, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (950, N'Paris', N'Madrid', CAST(N'2018-04-18T11:49:38.817' AS DateTime), 0, 250, 7, 2190, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (951, N'Dallas', N'Rom', CAST(N'2018-08-28T03:06:38.847' AS DateTime), 0, 250, 138, 2123, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (952, N'Oslo', N'London', CAST(N'2018-04-29T13:06:38.870' AS DateTime), 0, 250, 18, 2115, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (953, N'London', N'Köln/Bonn', CAST(N'2018-09-08T04:23:38.890' AS DateTime), 0, 250, 149, 2017, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (954, N'Paris', N'Dallas', CAST(N'2018-05-10T14:23:38.913' AS DateTime), 0, 250, 29, 2143, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (955, N'Moskau', N'Mailand', CAST(N'2018-09-19T05:40:38.937' AS DateTime), 0, 250, 160, 2140, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (956, N'Prag', N'Essen/Mülheim', CAST(N'2018-05-22T15:47:38.957' AS DateTime), 0, 250, 41, 2179, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (957, N'Madrid', N'Hamburg', CAST(N'2018-09-30T06:57:38.987' AS DateTime), 0, 250, 171, 2182, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (958, N'Essen/Mülheim', N'Köln/Bonn', CAST(N'2018-06-02T17:04:39.030' AS DateTime), 0, 250, 52, 2163, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (959, N'Kapstadt', N'Paris', CAST(N'2018-10-12T08:21:39.063' AS DateTime), 0, 250, 183, 2111, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (960, N'Köln/Bonn', N'Kapstadt', CAST(N'2018-06-13T18:21:39.087' AS DateTime), 0, 250, 63, 2013, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (961, N'London', N'Prag', CAST(N'2018-10-23T09:38:39.107' AS DateTime), 0, 250, 194, 2149, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (962, N'Berlin', N'Essen/Mülheim', CAST(N'2018-06-24T19:38:39.130' AS DateTime), 0, 250, 74, 2120, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (963, N'Berlin', N'Essen/Mülheim', CAST(N'2018-11-03T10:55:39.153' AS DateTime), 0, 250, 205, 2101, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (964, N'New York', N'Oslo', CAST(N'2018-07-06T21:02:39.177' AS DateTime), 0, 250, 86, 2041, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (965, N'Seattle', N'Kapstadt', CAST(N'2018-11-14T12:12:39.220' AS DateTime), 0, 250, 216, 2098, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (966, N'Oslo', N'Köln/Bonn', CAST(N'2018-07-17T22:19:39.240' AS DateTime), 0, 250, 97, 2162, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (967, N'Seattle', N'Berlin', CAST(N'2018-11-25T13:29:39.257' AS DateTime), 0, 250, 227, 2178, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (968, N'Kapstadt', N'Moskau', CAST(N'2018-07-28T23:36:39.273' AS DateTime), 0, 250, 108, 2138, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (969, N'Berlin', N'Köln/Bonn', CAST(N'2018-12-07T14:53:39.287' AS DateTime), 0, 250, 239, 2019, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (970, N'Kapstadt', N'München', CAST(N'2018-08-09T00:53:39.300' AS DateTime), 0, 250, 119, 2187, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (971, N'Berlin', N'München', CAST(N'2018-04-11T11:00:39.317' AS DateTime), 0, 250, 0, 2084, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (972, N'Mailand', N'Dallas', CAST(N'2018-08-20T02:10:39.330' AS DateTime), 0, 250, 130, 2113, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (973, N'Seattle', N'Frankfurt', CAST(N'2018-04-22T12:17:39.363' AS DateTime), 0, 250, 11, 2097, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (974, N'Berlin', N'Paris', CAST(N'2018-09-01T03:34:39.377' AS DateTime), 0, 250, 142, 2037, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (975, N'Rom', N'Seattle', CAST(N'2018-05-03T13:34:39.390' AS DateTime), 0, 250, 18, 2014, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (976, N'Paris', N'Rom', CAST(N'2018-09-12T04:51:39.403' AS DateTime), 0, 250, 153, 2173, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (977, N'Hamburg', N'Essen/Mülheim', CAST(N'2018-05-14T14:51:39.420' AS DateTime), 0, 250, 33, 2111, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (978, N'Kapstadt', N'Hamburg', CAST(N'2018-09-23T06:08:39.433' AS DateTime), 0, 250, 164, 2116, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (979, N'Oslo', N'Frankfurt', CAST(N'2018-05-26T16:15:39.447' AS DateTime), 0, 250, 45, 2193, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (980, N'Köln/Bonn', N'Moskau', CAST(N'2018-10-04T07:25:39.463' AS DateTime), 0, 250, 175, 2113, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (981, N'New York', N'Kapstadt', CAST(N'2018-06-06T17:32:39.477' AS DateTime), 0, 250, 56, 2157, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (982, N'New York', N'Kapstadt', CAST(N'2018-10-15T08:42:39.507' AS DateTime), 0, 250, 186, 2008, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (983, N'Dallas', N'Seattle', CAST(N'2018-06-17T18:49:39.520' AS DateTime), 0, 250, 67, 2023, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (984, N'Moskau', N'Prag', CAST(N'2018-10-27T10:06:39.537' AS DateTime), 0, 250, 198, 2172, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (985, N'Paris', N'London', CAST(N'2018-06-28T20:06:39.553' AS DateTime), 0, 250, 78, 2034, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (986, N'Seattle', N'Mailand', CAST(N'2018-11-07T11:23:39.577' AS DateTime), 0, 250, 209, 2052, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (987, N'Essen/Mülheim', N'Rom', CAST(N'2018-07-10T21:30:39.600' AS DateTime), 0, 250, 90, 2112, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (988, N'New York', N'Madrid', CAST(N'2018-11-18T12:40:39.620' AS DateTime), 0, 250, 220, 2090, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (989, N'Prag', N'Oslo', CAST(N'2018-07-21T22:47:39.643' AS DateTime), 0, 250, 101, 2120, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (990, N'Hamburg', N'Moskau', CAST(N'2018-11-29T13:57:39.667' AS DateTime), 0, 250, 231, 2051, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (991, N'Paris', N'Kapstadt', CAST(N'2018-08-02T00:04:39.703' AS DateTime), 0, 250, 112, 2111, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (992, N'Mailand', N'Oslo', CAST(N'2018-12-11T15:21:39.723' AS DateTime), 0, 250, 243, 2082, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (993, N'New York', N'Rom', CAST(N'2018-08-13T01:21:39.737' AS DateTime), 0, 250, 123, 2181, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (994, N'Prag', N'New York', CAST(N'2018-04-15T11:28:39.750' AS DateTime), 0, 250, 4, 2189, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (995, N'Köln/Bonn', N'Rom', CAST(N'2018-08-24T02:38:39.763' AS DateTime), 0, 250, 134, 2036, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (996, N'Mailand', N'New York', CAST(N'2018-04-26T12:45:39.777' AS DateTime), 0, 250, 15, 2126, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (997, N'London', N'Kapstadt', CAST(N'2018-09-05T04:02:39.790' AS DateTime), 0, 250, 146, 2153, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (998, N'London', N'Kapstadt', CAST(N'2018-05-07T14:02:39.817' AS DateTime), 0, 250, 26, 2070, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (999, N'Köln/Bonn', N'München', CAST(N'2018-09-16T05:19:39.830' AS DateTime), 0, 250, 157, 2160, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1000, N'Rom', N'Mailand', CAST(N'2018-05-18T15:19:39.847' AS DateTime), 0, 250, 33, 2010, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1001, N'Frankfurt', N'Oslo', CAST(N'2018-09-27T06:36:39.870' AS DateTime), 0, 250, 168, 2002, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1002, N'Rom', N'Paris', CAST(N'2018-05-30T16:43:39.893' AS DateTime), 0, 250, 45, 2115, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1003, N'Madrid', N'Oslo', CAST(N'2018-10-08T07:53:39.913' AS DateTime), 0, 250, 179, 2083, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1004, N'Essen/Mülheim', N'Frankfurt', CAST(N'2018-06-10T18:00:39.937' AS DateTime), 0, 250, 60, 2036, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1005, N'London', N'Köln/Bonn', CAST(N'2018-10-19T09:10:39.957' AS DateTime), 0, 250, 190, 2130, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1006, N'Moskau', N'Paris', CAST(N'2018-06-21T19:17:39.997' AS DateTime), 0, 250, 71, 2109, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1007, N'Köln/Bonn', N'Frankfurt', CAST(N'2018-10-31T10:34:40.013' AS DateTime), 0, 250, 202, 2052, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1008, N'Dallas', N'Kapstadt', CAST(N'2018-07-02T20:34:40.027' AS DateTime), 0, 250, 82, 2157, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1009, N'Mailand', N'Frankfurt', CAST(N'2018-11-11T11:51:40.037' AS DateTime), 0, 250, 213, 2002, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1010, N'Hamburg', N'Köln/Bonn', CAST(N'2018-07-13T21:51:40.053' AS DateTime), 0, 250, 93, 2155, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1011, N'Moskau', N'Rom', CAST(N'2018-11-22T13:08:40.077' AS DateTime), 0, 250, 224, 2161, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1012, N'Madrid', N'Mailand', CAST(N'2018-07-25T23:15:40.097' AS DateTime), 0, 250, 105, 2140, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1013, N'Madrid', N'Moskau', CAST(N'2018-12-03T14:25:40.120' AS DateTime), 0, 250, 235, 2121, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1014, N'Essen/Mülheim', N'Hamburg', CAST(N'2018-08-06T00:32:40.143' AS DateTime), 0, 250, 116, 2118, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1015, N'Essen/Mülheim', N'Moskau', CAST(N'2018-12-14T15:42:40.183' AS DateTime), 0, 250, 246, 2198, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1016, N'Moskau', N'Seattle', CAST(N'2018-08-17T01:49:40.197' AS DateTime), 0, 250, 127, 2126, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1017, N'Essen/Mülheim', N'Köln/Bonn', CAST(N'2018-04-19T11:56:40.213' AS DateTime), 0, 250, 8, 2013, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1018, N'Paris', N'Kapstadt', CAST(N'2018-08-28T03:06:40.227' AS DateTime), 0, 250, 138, 2021, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1019, N'Frankfurt', N'Köln/Bonn', CAST(N'2018-04-30T13:13:40.243' AS DateTime), 0, 250, 19, 2161, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1020, N'London', N'Moskau', CAST(N'2018-09-09T04:30:40.257' AS DateTime), 0, 250, 150, 2133, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1021, N'Seattle', N'New York', CAST(N'2018-05-11T14:30:40.270' AS DateTime), 0, 250, 30, 2030, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1022, N'Kapstadt', N'London', CAST(N'2018-09-20T05:47:40.283' AS DateTime), 0, 250, 161, 2098, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1023, N'Essen/Mülheim', N'Dallas', CAST(N'2018-05-22T15:47:40.300' AS DateTime), 0, 250, 41, 2134, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1024, N'Mailand', N'Seattle', CAST(N'2018-10-01T07:04:40.327' AS DateTime), 0, 250, 172, 2133, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1025, N'Mailand', N'Prag', CAST(N'2018-06-03T17:11:40.350' AS DateTime), 0, 250, 53, 2149, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1026, N'Köln/Bonn', N'Berlin', CAST(N'2018-10-12T08:21:40.363' AS DateTime), 0, 250, 183, 2180, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1027, N'Frankfurt', N'Paris', CAST(N'2018-06-14T18:28:40.377' AS DateTime), 0, 250, 64, 2102, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1028, N'New York', N'Berlin', CAST(N'2018-10-23T09:38:40.393' AS DateTime), 0, 250, 194, 2071, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1029, N'Köln/Bonn', N'Paris', CAST(N'2018-06-25T19:45:40.407' AS DateTime), 0, 250, 75, 2016, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1030, N'London', N'Moskau', CAST(N'2018-11-04T11:02:40.433' AS DateTime), 0, 250, 206, 2143, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1031, N'München', N'Prag', CAST(N'2018-07-06T21:02:40.447' AS DateTime), 0, 250, 86, 2009, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1032, N'Oslo', N'Frankfurt', CAST(N'2018-11-15T12:19:40.463' AS DateTime), 0, 250, 217, 2117, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1033, N'Paris', N'Dallas', CAST(N'2018-07-17T22:19:40.477' AS DateTime), 0, 250, 97, 2043, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1034, N'Prag', N'Kapstadt', CAST(N'2018-11-26T13:36:40.490' AS DateTime), 0, 250, 228, 2149, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1035, N'Dallas', N'Köln/Bonn', CAST(N'2018-07-29T23:43:40.507' AS DateTime), 0, 250, 109, 2116, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1036, N'Paris', N'Oslo', CAST(N'2018-12-07T14:53:40.520' AS DateTime), 0, 250, 239, 2053, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1037, N'London', N'Madrid', CAST(N'2018-08-10T01:00:40.537' AS DateTime), 0, 250, 120, 2037, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1038, N'Oslo', N'Köln/Bonn', CAST(N'2018-04-11T11:00:40.547' AS DateTime), 0, 250, 0, 2030, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1039, N'München', N'Frankfurt', CAST(N'2018-08-21T02:17:40.577' AS DateTime), 0, 250, 131, 2119, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1040, N'Kapstadt', N'Prag', CAST(N'2018-04-23T12:24:40.593' AS DateTime), 0, 250, 12, 2193, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1041, N'London', N'Dallas', CAST(N'2018-09-01T03:34:40.607' AS DateTime), 0, 250, 142, 2070, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1042, N'München', N'New York', CAST(N'2018-05-04T13:41:40.620' AS DateTime), 0, 250, 23, 2107, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1043, N'Mailand', N'München', CAST(N'2018-09-12T04:51:40.637' AS DateTime), 0, 250, 153, 2159, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1044, N'Frankfurt', N'Seattle', CAST(N'2018-05-15T14:58:40.650' AS DateTime), 0, 250, 34, 2117, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1045, N'Moskau', N'Essen/Mülheim', CAST(N'2018-09-24T06:15:40.667' AS DateTime), 0, 250, 165, 2130, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1046, N'Kapstadt', N'Essen/Mülheim', CAST(N'2018-05-26T16:15:40.680' AS DateTime), 0, 250, 45, 2165, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1047, N'Mailand', N'Kapstadt', CAST(N'2018-10-05T07:32:40.703' AS DateTime), 0, 250, 176, 2197, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1048, N'Essen/Mülheim', N'Prag', CAST(N'2018-06-06T17:32:40.750' AS DateTime), 0, 250, 56, 2044, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1049, N'Köln/Bonn', N'Oslo', CAST(N'2018-10-16T08:49:40.767' AS DateTime), 0, 250, 187, 2156, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1050, N'New York', N'Paris', CAST(N'2018-06-18T18:56:40.783' AS DateTime), 0, 250, 68, 2050, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1051, N'Frankfurt', N'Paris', CAST(N'2018-10-27T10:06:40.797' AS DateTime), 0, 250, 198, 2078, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1052, N'Berlin', N'Oslo', CAST(N'2018-06-29T20:13:40.813' AS DateTime), 0, 250, 79, 2086, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1053, N'Kapstadt', N'Paris', CAST(N'2018-11-08T11:30:40.827' AS DateTime), 0, 250, 210, 2159, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1054, N'Hamburg', N'Frankfurt', CAST(N'2018-07-10T21:30:40.843' AS DateTime), 0, 250, 90, 2022, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1055, N'Köln/Bonn', N'Seattle', CAST(N'2018-11-19T12:47:40.857' AS DateTime), 0, 250, 221, 2109, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1056, N'Kapstadt', N'Berlin', CAST(N'2018-07-21T22:47:40.873' AS DateTime), 0, 250, 101, 2146, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1057, N'Mailand', N'Moskau', CAST(N'2018-11-30T14:04:40.907' AS DateTime), 0, 250, 232, 2088, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1058, N'New York', N'Paris', CAST(N'2018-08-03T00:11:40.930' AS DateTime), 0, 250, 113, 2027, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1059, N'Madrid', N'Essen/Mülheim', CAST(N'2018-12-11T15:21:40.937' AS DateTime), 0, 250, 243, 2150, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1060, N'Mailand', N'Hamburg', CAST(N'2018-08-14T01:28:40.947' AS DateTime), 0, 250, 124, 2031, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1061, N'New York', N'Paris', CAST(N'2018-04-15T11:28:40.960' AS DateTime), 0, 250, 4, 2098, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1062, N'Hamburg', N'London', CAST(N'2018-08-25T02:45:40.970' AS DateTime), 0, 250, 135, 2129, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1063, N'Madrid', N'London', CAST(N'2018-04-27T12:52:40.990' AS DateTime), 0, 250, 16, 2010, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1064, N'Frankfurt', N'Berlin', CAST(N'2018-09-05T04:02:41.000' AS DateTime), 0, 250, 146, 2158, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1065, N'Seattle', N'Paris', CAST(N'2018-05-08T14:09:41.010' AS DateTime), 0, 250, 27, 2198, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1066, N'Moskau', N'London', CAST(N'2018-09-16T05:19:41.020' AS DateTime), 0, 250, 157, 2078, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1067, N'Moskau', N'Hamburg', CAST(N'2018-05-19T15:26:41.030' AS DateTime), 0, 250, 38, 2123, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1068, N'Seattle', N'Essen/Mülheim', CAST(N'2018-09-28T06:43:41.043' AS DateTime), 0, 250, 169, 2099, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1069, N'Dallas', N'Essen/Mülheim', CAST(N'2018-05-30T16:43:41.053' AS DateTime), 0, 250, 49, 2117, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1070, N'Kapstadt', N'Prag', CAST(N'2018-10-09T08:00:41.063' AS DateTime), 0, 250, 180, 2011, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1071, N'New York', N'Rom', CAST(N'2018-06-10T18:00:41.073' AS DateTime), 0, 250, 60, 2006, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1072, N'Oslo', N'Paris', CAST(N'2018-10-20T09:17:41.097' AS DateTime), 0, 250, 191, 2157, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1073, N'Hamburg', N'London', CAST(N'2018-06-22T19:24:41.107' AS DateTime), 0, 250, 72, 2005, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1074, N'Essen/Mülheim', N'Dallas', CAST(N'2018-10-31T10:34:41.117' AS DateTime), 0, 250, 202, 2137, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1075, N'Seattle', N'Paris', CAST(N'2018-07-03T20:41:41.127' AS DateTime), 0, 250, 83, 2117, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1076, N'New York', N'Dallas', CAST(N'2018-11-11T11:51:41.137' AS DateTime), 0, 250, 213, 2198, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1077, N'München', N'Rom', CAST(N'2018-07-14T21:58:41.143' AS DateTime), 0, 250, 94, 2075, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1078, N'London', N'Oslo', CAST(N'2018-11-23T13:15:41.153' AS DateTime), 0, 250, 225, 2199, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1079, N'Prag', N'Dallas', CAST(N'2018-07-25T23:15:41.163' AS DateTime), 0, 250, 105, 2136, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1080, N'Dallas', N'Köln/Bonn', CAST(N'2018-12-04T14:32:41.173' AS DateTime), 0, 250, 236, 2121, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1081, N'Kapstadt', N'Dallas', CAST(N'2018-08-07T00:39:41.190' AS DateTime), 0, 250, 117, 2088, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1082, N'Seattle', N'Essen/Mülheim', CAST(N'2018-12-15T15:49:41.200' AS DateTime), 0, 250, 247, 2152, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1083, N'Dallas', N'Hamburg', CAST(N'2018-08-18T01:56:41.207' AS DateTime), 0, 250, 128, 2081, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1084, N'Berlin', N'London', CAST(N'2018-04-19T11:56:41.217' AS DateTime), 0, 250, 8, 2163, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1085, N'Hamburg', N'Oslo', CAST(N'2018-08-29T03:13:41.227' AS DateTime), 0, 250, 139, 2199, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1086, N'London', N'Oslo', CAST(N'2018-05-01T13:20:41.233' AS DateTime), 0, 250, 20, 2061, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1087, N'Kapstadt', N'Moskau', CAST(N'2018-09-09T04:30:41.243' AS DateTime), 0, 250, 150, 2129, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1088, N'Köln/Bonn', N'Seattle', CAST(N'2018-05-12T14:37:41.253' AS DateTime), 0, 250, 31, 2055, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1089, N'Paris', N'Berlin', CAST(N'2018-09-20T05:47:41.260' AS DateTime), 0, 250, 161, 2074, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1090, N'Mailand', N'Frankfurt', CAST(N'2018-05-23T15:54:41.280' AS DateTime), 0, 250, 42, 2037, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1091, N'Frankfurt', N'Paris', CAST(N'2018-10-02T07:11:41.290' AS DateTime), 0, 250, 173, 2141, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1092, N'Seattle', N'Dallas', CAST(N'2018-06-03T17:11:41.300' AS DateTime), 0, 250, 53, 2178, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1093, N'Madrid', N'Hamburg', CAST(N'2018-10-13T08:28:41.307' AS DateTime), 0, 250, 184, 2002, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1094, N'London', N'Dallas', CAST(N'2018-06-14T18:28:41.317' AS DateTime), 0, 250, 64, 2016, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1095, N'Essen/Mülheim', N'Moskau', CAST(N'2018-10-24T09:45:41.327' AS DateTime), 0, 250, 195, 2197, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1096, N'London', N'Frankfurt', CAST(N'2018-06-26T19:52:41.340' AS DateTime), 0, 250, 76, 2191, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1097, N'Kapstadt', N'Mailand', CAST(N'2018-11-04T11:02:41.350' AS DateTime), 0, 250, 206, 2088, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1098, N'Prag', N'Rom', CAST(N'2018-07-07T21:09:41.360' AS DateTime), 0, 250, 87, 2033, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1099, N'Köln/Bonn', N'Essen/Mülheim', CAST(N'2018-11-15T12:19:41.370' AS DateTime), 0, 250, 217, 2078, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1100, N'Prag', N'Frankfurt', CAST(N'2018-07-18T22:26:41.380' AS DateTime), 0, 250, 98, 2044, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1101, N'Oslo', N'Dallas', CAST(N'2018-11-27T13:43:41.393' AS DateTime), 0, 250, 229, 2023, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1102, N'London', N'Berlin', CAST(N'2018-07-29T23:43:41.400' AS DateTime), 0, 250, 109, 2062, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1103, N'London', N'Berlin', CAST(N'2018-12-08T15:00:41.410' AS DateTime), 0, 250, 240, 2085, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1104, N'New York', N'Moskau', CAST(N'2018-08-10T01:00:41.420' AS DateTime), 0, 250, 120, 2142, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1105, N'London', N'Rom', CAST(N'2018-04-12T11:07:41.440' AS DateTime), 0, 250, 1, 2056, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1106, N'London', N'Köln/Bonn', CAST(N'2018-08-22T02:24:41.447' AS DateTime), 0, 250, 132, 2153, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1107, N'Mailand', N'Essen/Mülheim', CAST(N'2018-04-23T12:24:41.457' AS DateTime), 0, 250, 12, 2019, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1108, N'München', N'New York', CAST(N'2018-09-02T03:41:41.467' AS DateTime), 0, 250, 143, 2047, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1109, N'Paris', N'Rom', CAST(N'2018-05-04T13:41:41.477' AS DateTime), 0, 250, 23, 2076, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1110, N'Kapstadt', N'New York', CAST(N'2018-09-13T04:58:41.483' AS DateTime), 0, 250, 154, 2029, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1111, N'Kapstadt', N'Mailand', CAST(N'2018-05-16T15:05:41.493' AS DateTime), 0, 250, 35, 2165, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1112, N'Seattle', N'Paris', CAST(N'2018-09-24T06:15:41.503' AS DateTime), 0, 250, 165, 2009, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1113, N'Dallas', N'Paris', CAST(N'2018-05-27T16:22:41.510' AS DateTime), 0, 250, 46, 2112, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1114, N'Seattle', N'Dallas', CAST(N'2018-10-06T07:39:41.540' AS DateTime), 0, 250, 177, 2015, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1115, N'Prag', N'München', CAST(N'2018-06-07T17:39:41.563' AS DateTime), 0, 250, 57, 2176, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1116, N'Essen/Mülheim', N'Hamburg', CAST(N'2018-10-17T08:56:41.577' AS DateTime), 0, 250, 188, 2196, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1117, N'Madrid', N'Oslo', CAST(N'2018-06-18T18:56:41.597' AS DateTime), 0, 250, 68, 2097, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1118, N'New York', N'Frankfurt', CAST(N'2018-10-28T10:13:41.620' AS DateTime), 0, 250, 199, 2069, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1119, N'München', N'Kapstadt', CAST(N'2018-06-30T20:20:41.643' AS DateTime), 0, 250, 80, 2065, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1120, N'Madrid', N'Oslo', CAST(N'2018-11-08T11:30:41.667' AS DateTime), 0, 250, 210, 2142, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1121, N'Oslo', N'Moskau', CAST(N'2018-07-11T21:37:41.713' AS DateTime), 0, 250, 91, 2078, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1122, N'Rom', N'Kapstadt', CAST(N'2018-11-19T12:47:41.737' AS DateTime), 0, 250, 217, 2022, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1123, N'Madrid', N'Seattle', CAST(N'2018-07-22T22:54:41.760' AS DateTime), 0, 250, 102, 2182, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1124, N'Köln/Bonn', N'London', CAST(N'2018-12-01T14:11:41.783' AS DateTime), 0, 250, 233, 2165, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1125, N'Hamburg', N'Kapstadt', CAST(N'2018-08-03T00:11:41.807' AS DateTime), 0, 250, 113, 2157, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1126, N'Berlin', N'Moskau', CAST(N'2018-12-12T15:28:41.827' AS DateTime), 0, 250, 244, 2093, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1127, N'London', N'Seattle', CAST(N'2018-08-14T01:28:41.850' AS DateTime), 0, 250, 124, 2026, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1128, N'Paris', N'Oslo', CAST(N'2018-04-16T11:35:41.873' AS DateTime), 0, 250, 5, 2141, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1129, N'New York', N'Hamburg', CAST(N'2018-08-26T02:52:41.920' AS DateTime), 0, 250, 136, 2084, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1130, N'Mailand', N'Prag', CAST(N'2018-04-27T12:52:41.933' AS DateTime), 0, 250, 16, 2118, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1131, N'Seattle', N'Frankfurt', CAST(N'2018-09-06T04:09:41.950' AS DateTime), 0, 250, 147, 2100, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1132, N'Madrid', N'Essen/Mülheim', CAST(N'2018-05-08T14:09:41.963' AS DateTime), 0, 250, 27, 2083, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1133, N'Seattle', N'Köln/Bonn', CAST(N'2018-09-17T05:26:41.980' AS DateTime), 0, 250, 158, 2068, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1134, N'Essen/Mülheim', N'Madrid', CAST(N'2018-05-20T15:33:42.000' AS DateTime), 0, 250, 39, 2107, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1135, N'Frankfurt', N'New York', CAST(N'2018-09-28T06:43:42.023' AS DateTime), 0, 250, 169, 2108, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1136, N'New York', N'Paris', CAST(N'2018-05-31T16:50:42.043' AS DateTime), 0, 250, 50, 2053, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1137, N'Moskau', N'Frankfurt', CAST(N'2018-10-09T08:00:42.067' AS DateTime), 0, 250, 180, 2048, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1138, N'Madrid', N'Prag', CAST(N'2018-06-11T18:07:42.110' AS DateTime), 0, 250, 61, 2044, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1139, N'Moskau', N'Prag', CAST(N'2018-10-21T09:24:42.123' AS DateTime), 0, 250, 192, 2128, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1140, N'Seattle', N'New York', CAST(N'2018-06-22T19:24:42.137' AS DateTime), 0, 250, 72, 2129, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1141, N'Seattle', N'Paris', CAST(N'2018-11-01T10:41:42.183' AS DateTime), 0, 250, 203, 2025, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1142, N'Rom', N'Prag', CAST(N'2018-07-03T20:41:42.220' AS DateTime), 0, 250, 79, 2057, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1143, N'Rom', N'London', CAST(N'2018-11-12T11:58:42.230' AS DateTime), 0, 250, 210, 2011, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1144, N'London', N'München', CAST(N'2018-07-15T22:05:42.240' AS DateTime), 0, 250, 95, 2115, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1145, N'Madrid', N'Moskau', CAST(N'2018-11-23T13:15:42.250' AS DateTime), 0, 250, 225, 2065, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1146, N'Köln/Bonn', N'München', CAST(N'2018-07-26T23:22:42.260' AS DateTime), 0, 250, 106, 2198, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1147, N'Essen/Mülheim', N'München', CAST(N'2018-12-05T14:39:42.287' AS DateTime), 0, 250, 237, 2185, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1148, N'Paris', N'London', CAST(N'2018-08-07T00:39:42.300' AS DateTime), 0, 250, 117, 2171, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1149, N'Moskau', N'Rom', CAST(N'2018-12-16T15:56:42.310' AS DateTime), 0, 250, 248, 2053, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1150, N'Hamburg', N'Essen/Mülheim', CAST(N'2018-08-18T01:56:42.320' AS DateTime), 0, 250, 128, 2199, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1151, N'New York', N'Seattle', CAST(N'2018-04-20T12:03:42.330' AS DateTime), 0, 250, 9, 2018, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1152, N'Essen/Mülheim', N'München', CAST(N'2018-08-30T03:20:42.353' AS DateTime), 0, 250, 140, 2051, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1153, N'Rom', N'Frankfurt', CAST(N'2018-05-01T13:20:42.383' AS DateTime), 0, 250, 16, 2042, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1154, N'Hamburg', N'Essen/Mülheim', CAST(N'2018-09-10T04:37:42.400' AS DateTime), 0, 250, 151, 2180, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1155, N'Essen/Mülheim', N'Dallas', CAST(N'2018-05-12T14:37:42.410' AS DateTime), 0, 250, 31, 2070, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1156, N'Dallas', N'Hamburg', CAST(N'2018-09-21T05:54:42.417' AS DateTime), 0, 250, 162, 2074, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1157, N'Prag', N'New York', CAST(N'2018-05-24T16:01:42.427' AS DateTime), 0, 250, 43, 2177, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1158, N'Prag', N'Mailand', CAST(N'2018-10-02T07:11:42.437' AS DateTime), 0, 250, 173, 2137, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1159, N'Dallas', N'New York', CAST(N'2018-06-04T17:18:42.447' AS DateTime), 0, 250, 54, 2143, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1160, N'Berlin', N'Frankfurt', CAST(N'2018-10-13T08:28:42.460' AS DateTime), 0, 250, 184, 2169, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1161, N'Moskau', N'London', CAST(N'2018-06-15T18:35:42.480' AS DateTime), 0, 250, 65, 2143, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1162, N'Paris', N'Mailand', CAST(N'2018-10-25T09:52:42.520' AS DateTime), 0, 250, 196, 2085, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1163, N'Hamburg', N'Moskau', CAST(N'2018-06-26T19:52:42.533' AS DateTime), 0, 250, 76, 2028, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1164, N'Oslo', N'New York', CAST(N'2018-11-05T11:09:42.547' AS DateTime), 0, 250, 207, 2138, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1165, N'Dallas', N'Essen/Mülheim', CAST(N'2018-07-07T21:09:42.567' AS DateTime), 0, 250, 87, 2133, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1166, N'Mailand', N'München', CAST(N'2018-11-16T12:26:42.587' AS DateTime), 0, 250, 218, 2123, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1167, N'Oslo', N'Köln/Bonn', CAST(N'2018-07-19T22:33:42.607' AS DateTime), 0, 250, 99, 2198, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1168, N'Paris', N'Mailand', CAST(N'2018-11-27T13:43:42.623' AS DateTime), 0, 250, 229, 2197, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1169, N'Kapstadt', N'Moskau', CAST(N'2018-07-30T23:50:42.643' AS DateTime), 0, 250, 110, 2194, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1170, N'Seattle', N'Essen/Mülheim', CAST(N'2018-12-08T15:00:42.667' AS DateTime), 0, 250, 240, 2094, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1171, N'Prag', N'Rom', CAST(N'2018-08-11T01:07:42.713' AS DateTime), 0, 250, 121, 2195, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1172, N'London', N'Moskau', CAST(N'2018-04-13T11:14:42.737' AS DateTime), 0, 250, 2, 2087, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1173, N'Hamburg', N'Rom', CAST(N'2018-08-22T02:24:42.750' AS DateTime), 0, 250, 132, 2093, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1174, N'Oslo', N'Kapstadt', CAST(N'2018-04-24T12:31:42.763' AS DateTime), 0, 250, 13, 2128, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1175, N'Köln/Bonn', N'Moskau', CAST(N'2018-09-02T03:41:42.777' AS DateTime), 0, 250, 143, 2194, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1176, N'Hamburg', N'Moskau', CAST(N'2018-05-05T13:48:42.800' AS DateTime), 0, 250, 24, 2146, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1177, N'Berlin', N'Prag', CAST(N'2018-09-14T05:05:42.823' AS DateTime), 0, 250, 155, 2109, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1178, N'Kapstadt', N'Madrid', CAST(N'2018-05-16T15:05:42.833' AS DateTime), 0, 250, 35, 2038, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1179, N'Madrid', N'Essen/Mülheim', CAST(N'2018-09-25T06:22:42.843' AS DateTime), 0, 250, 166, 2123, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1180, N'Oslo', N'Mailand', CAST(N'2018-05-28T16:29:42.853' AS DateTime), 0, 250, 47, 2093, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1181, N'Kapstadt', N'New York', CAST(N'2018-10-06T07:39:42.863' AS DateTime), 0, 250, 177, 2075, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1182, N'London', N'Seattle', CAST(N'2018-06-08T17:46:42.870' AS DateTime), 0, 250, 58, 2116, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1183, N'München', N'Köln/Bonn', CAST(N'2018-10-17T08:56:42.883' AS DateTime), 0, 250, 188, 2052, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1184, N'Kapstadt', N'München', CAST(N'2018-06-19T19:03:42.897' AS DateTime), 0, 250, 69, 2002, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1185, N'Mailand', N'London', CAST(N'2018-10-29T10:20:42.913' AS DateTime), 0, 250, 200, 2035, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1186, N'Madrid', N'Berlin', CAST(N'2018-06-30T20:20:42.947' AS DateTime), 0, 250, 80, 2123, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1187, N'Dallas', N'Köln/Bonn', CAST(N'2018-11-09T11:37:42.963' AS DateTime), 0, 250, 211, 2141, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1188, N'Köln/Bonn', N'Oslo', CAST(N'2018-07-11T21:37:42.980' AS DateTime), 0, 250, 91, 2088, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1189, N'Hamburg', N'München', CAST(N'2018-11-20T12:54:42.997' AS DateTime), 0, 250, 222, 2103, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1190, N'Paris', N'Moskau', CAST(N'2018-07-23T23:01:43.020' AS DateTime), 0, 250, 103, 2093, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1191, N'Seattle', N'Prag', CAST(N'2018-12-01T14:11:43.040' AS DateTime), 0, 250, 233, 2095, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1192, N'London', N'Madrid', CAST(N'2018-08-04T00:18:43.060' AS DateTime), 0, 250, 114, 2114, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1193, N'Köln/Bonn', N'Moskau', CAST(N'2018-12-12T15:28:43.080' AS DateTime), 0, 250, 244, 2096, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1194, N'Berlin', N'Moskau', CAST(N'2018-08-15T01:35:43.103' AS DateTime), 0, 250, 125, 2157, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1195, N'Köln/Bonn', N'Essen/Mülheim', CAST(N'2018-04-17T11:42:43.147' AS DateTime), 0, 250, 6, 2189, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1196, N'Frankfurt', N'London', CAST(N'2018-08-26T02:52:43.167' AS DateTime), 0, 250, 136, 2100, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1197, N'Berlin', N'Dallas', CAST(N'2018-04-28T12:59:43.187' AS DateTime), 0, 250, 17, 2142, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1198, N'Hamburg', N'Essen/Mülheim', CAST(N'2018-09-06T04:09:43.210' AS DateTime), 0, 250, 147, 2112, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1199, N'Essen/Mülheim', N'Oslo', CAST(N'2018-05-09T14:16:43.230' AS DateTime), 0, 250, 28, 2038, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1200, N'Prag', N'Frankfurt', CAST(N'2018-09-18T05:33:43.257' AS DateTime), 0, 250, 159, 2147, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1201, N'New York', N'Kapstadt', CAST(N'2018-05-20T15:33:43.280' AS DateTime), 0, 250, 39, 2022, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1202, N'New York', N'Prag', CAST(N'2018-09-29T06:50:43.303' AS DateTime), 0, 250, 170, 2024, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1203, N'Prag', N'Moskau', CAST(N'2018-05-31T16:50:43.327' AS DateTime), 0, 250, 50, 2128, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1204, N'Paris', N'München', CAST(N'2018-10-10T08:07:43.377' AS DateTime), 0, 250, 181, 2193, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1205, N'New York', N'Oslo', CAST(N'2018-06-12T18:14:43.403' AS DateTime), 0, 250, 62, 2193, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1206, N'Hamburg', N'Mailand', CAST(N'2018-10-21T09:24:43.423' AS DateTime), 0, 250, 192, 2017, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1207, N'Kapstadt', N'Berlin', CAST(N'2018-06-23T19:31:43.443' AS DateTime), 0, 250, 73, 2079, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1208, N'Moskau', N'Essen/Mülheim', CAST(N'2018-11-02T10:48:43.463' AS DateTime), 0, 250, 204, 2140, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1209, N'Moskau', N'Köln/Bonn', CAST(N'2018-07-04T20:48:43.483' AS DateTime), 0, 250, 84, 2117, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1210, N'Köln/Bonn', N'Kapstadt', CAST(N'2018-11-13T12:05:43.520' AS DateTime), 0, 250, 215, 2060, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1211, N'Paris', N'Oslo', CAST(N'2018-07-15T22:05:43.543' AS DateTime), 0, 250, 95, 2187, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1212, N'Madrid', N'München', CAST(N'2018-11-24T13:22:43.563' AS DateTime), 0, 250, 226, 2096, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1213, N'New York', N'Rom', CAST(N'2018-07-27T23:29:43.583' AS DateTime), 0, 250, 107, 2114, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1214, N'Köln/Bonn', N'Dallas', CAST(N'2018-12-05T14:39:43.607' AS DateTime), 0, 250, 237, 2082, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1215, N'London', N'Rom', CAST(N'2018-08-08T00:46:43.630' AS DateTime), 0, 250, 118, 2172, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1216, N'Dallas', N'Moskau', CAST(N'2018-12-16T15:56:43.650' AS DateTime), 0, 250, 248, 2168, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1217, N'Moskau', N'Prag', CAST(N'2018-08-19T02:03:43.673' AS DateTime), 0, 250, 129, 2089, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1218, N'Frankfurt', N'Essen/Mülheim', CAST(N'2018-04-21T12:10:43.693' AS DateTime), 0, 250, 10, 2012, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1219, N'London', N'Frankfurt', CAST(N'2018-08-30T03:20:43.740' AS DateTime), 0, 250, 140, 2009, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1220, N'Paris', N'Berlin', CAST(N'2018-05-02T13:27:43.760' AS DateTime), 0, 250, 21, 2055, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1221, N'Prag', N'Köln/Bonn', CAST(N'2018-09-10T04:37:43.780' AS DateTime), 0, 250, 151, 2154, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1222, N'London', N'Berlin', CAST(N'2018-05-13T14:44:43.800' AS DateTime), 0, 250, 32, 2042, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1223, N'Berlin', N'Kapstadt', CAST(N'2018-09-22T06:01:43.820' AS DateTime), 0, 250, 163, 2158, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1224, N'Mailand', N'Moskau', CAST(N'2018-05-24T16:01:43.843' AS DateTime), 0, 250, 43, 2031, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1225, N'Prag', N'Moskau', CAST(N'2018-10-03T07:18:43.863' AS DateTime), 0, 250, 174, 2005, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1226, N'Dallas', N'Köln/Bonn', CAST(N'2018-06-04T17:18:43.883' AS DateTime), 0, 250, 54, 2092, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1227, N'Madrid', N'Moskau', CAST(N'2018-10-14T08:35:43.907' AS DateTime), 0, 250, 185, 2140, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1228, N'Essen/Mülheim', N'Seattle', CAST(N'2018-06-16T18:42:43.950' AS DateTime), 0, 250, 66, 2058, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1229, N'Madrid', N'Rom', CAST(N'2018-10-25T09:52:43.973' AS DateTime), 0, 250, 196, 2038, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1230, N'Madrid', N'Prag', CAST(N'2018-06-27T19:59:43.993' AS DateTime), 0, 250, 77, 2014, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1231, N'Paris', N'Köln/Bonn', CAST(N'2018-11-05T11:09:44.017' AS DateTime), 0, 250, 207, 2058, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1232, N'Rom', N'Seattle', CAST(N'2018-07-08T21:16:44.037' AS DateTime), 0, 250, 84, 2150, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1233, N'New York', N'Berlin', CAST(N'2018-11-17T12:33:44.057' AS DateTime), 0, 250, 219, 2058, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1234, N'New York', N'Dallas', CAST(N'2018-07-19T22:33:44.080' AS DateTime), 0, 250, 99, 2150, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1235, N'Berlin', N'Frankfurt', CAST(N'2018-11-28T13:50:44.100' AS DateTime), 0, 250, 230, 2196, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1236, N'Rom', N'Moskau', CAST(N'2018-07-30T23:50:44.140' AS DateTime), 0, 250, 106, 2034, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1237, N'Berlin', N'London', CAST(N'2018-12-09T15:07:44.160' AS DateTime), 0, 250, 241, 2162, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1238, N'Mailand', N'Moskau', CAST(N'2018-08-12T01:14:44.180' AS DateTime), 0, 250, 122, 2157, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1239, N'Prag', N'Mailand', CAST(N'2018-04-13T11:14:44.200' AS DateTime), 0, 250, 2, 2097, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1240, N'Seattle', N'Berlin', CAST(N'2018-08-23T02:31:44.220' AS DateTime), 0, 250, 133, 2029, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1241, N'Rom', N'Essen/Mülheim', CAST(N'2018-04-25T12:38:44.243' AS DateTime), 0, 250, 10, 2011, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1242, N'London', N'Madrid', CAST(N'2018-09-03T03:48:44.263' AS DateTime), 0, 250, 144, 2044, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1243, N'Madrid', N'Köln/Bonn', CAST(N'2018-05-06T13:55:44.307' AS DateTime), 0, 250, 25, 2071, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1244, N'Köln/Bonn', N'Hamburg', CAST(N'2018-09-14T05:05:44.327' AS DateTime), 0, 250, 155, 2038, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1245, N'New York', N'Dallas', CAST(N'2018-05-17T15:12:44.347' AS DateTime), 0, 250, 36, 2139, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1246, N'Moskau', N'Rom', CAST(N'2018-09-26T06:29:44.367' AS DateTime), 0, 250, 167, 2112, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1247, N'Seattle', N'Berlin', CAST(N'2018-05-28T16:29:44.387' AS DateTime), 0, 250, 47, 2170, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1248, N'München', N'Köln/Bonn', CAST(N'2018-10-07T07:46:44.407' AS DateTime), 0, 250, 178, 2171, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1249, N'New York', N'Kapstadt', CAST(N'2018-06-08T17:46:44.427' AS DateTime), 0, 250, 58, 2144, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1250, N'Oslo', N'Hamburg', CAST(N'2018-10-18T09:03:44.447' AS DateTime), 0, 250, 189, 2030, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1251, N'Prag', N'Moskau', CAST(N'2018-06-20T19:10:44.467' AS DateTime), 0, 250, 70, 2127, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1252, N'Kapstadt', N'Mailand', CAST(N'2018-10-29T10:20:44.507' AS DateTime), 0, 250, 200, 2066, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1253, N'Berlin', N'New York', CAST(N'2018-07-01T20:27:44.527' AS DateTime), 0, 250, 81, 2085, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1254, N'London', N'Rom', CAST(N'2018-11-09T11:37:44.543' AS DateTime), 0, 250, 211, 2152, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1255, N'Dallas', N'Moskau', CAST(N'2018-07-12T21:44:44.563' AS DateTime), 0, 250, 92, 2083, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1256, N'London', N'Madrid', CAST(N'2018-11-21T13:01:44.583' AS DateTime), 0, 250, 223, 2126, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1257, N'Frankfurt', N'Dallas', CAST(N'2018-07-23T23:01:44.603' AS DateTime), 0, 250, 103, 2035, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1258, N'Oslo', N'Dallas', CAST(N'2018-12-02T14:18:44.620' AS DateTime), 0, 250, 234, 2001, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1259, N'Rom', N'München', CAST(N'2018-08-04T00:18:44.643' AS DateTime), 0, 250, 110, 2094, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1260, N'Hamburg', N'Seattle', CAST(N'2018-12-13T15:35:44.687' AS DateTime), 0, 250, 245, 2007, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1261, N'Mailand', N'Dallas', CAST(N'2018-08-16T01:42:44.700' AS DateTime), 0, 250, 126, 2015, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1262, N'Hamburg', N'Essen/Mülheim', CAST(N'2018-04-17T11:42:44.713' AS DateTime), 0, 250, 6, 2117, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1263, N'Moskau', N'Kapstadt', CAST(N'2018-08-27T02:59:44.727' AS DateTime), 0, 250, 137, 2098, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1264, N'London', N'Prag', CAST(N'2018-04-28T12:59:44.743' AS DateTime), 0, 250, 17, 2133, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1265, N'München', N'Rom', CAST(N'2018-09-07T04:16:44.763' AS DateTime), 0, 250, 148, 2144, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1266, N'Frankfurt', N'München', CAST(N'2018-05-10T14:23:44.783' AS DateTime), 0, 250, 29, 2138, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1267, N'Paris', N'Rom', CAST(N'2018-09-18T05:33:44.800' AS DateTime), 0, 250, 159, 2197, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1268, N'Frankfurt', N'Kapstadt', CAST(N'2018-05-21T15:40:44.820' AS DateTime), 0, 250, 40, 2044, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1269, N'Dallas', N'Moskau', CAST(N'2018-09-29T06:50:44.857' AS DateTime), 0, 250, 170, 2117, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1270, N'New York', N'Prag', CAST(N'2018-06-01T16:57:44.887' AS DateTime), 0, 250, 51, 2063, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1271, N'Dallas', N'Paris', CAST(N'2018-10-11T08:14:44.907' AS DateTime), 0, 250, 182, 2176, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1272, N'Rom', N'Seattle', CAST(N'2018-06-12T18:14:44.923' AS DateTime), 0, 250, 58, 2159, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1273, N'Madrid', N'Kapstadt', CAST(N'2018-10-22T09:31:44.943' AS DateTime), 0, 250, 193, 2163, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1274, N'Berlin', N'München', CAST(N'2018-06-24T19:38:44.963' AS DateTime), 0, 250, 74, 2145, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1275, N'Mailand', N'Prag', CAST(N'2018-11-02T10:48:44.980' AS DateTime), 0, 250, 204, 2158, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1276, N'Seattle', N'Rom', CAST(N'2018-07-05T20:55:45.010' AS DateTime), 0, 250, 85, 2041, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1277, N'Dallas', N'Kapstadt', CAST(N'2018-11-13T12:05:45.023' AS DateTime), 0, 250, 215, 2151, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1278, N'London', N'Berlin', CAST(N'2018-07-16T22:12:45.037' AS DateTime), 0, 250, 96, 2082, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1279, N'München', N'Madrid', CAST(N'2018-11-25T13:29:45.053' AS DateTime), 0, 250, 227, 2046, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1280, N'München', N'Dallas', CAST(N'2018-07-27T23:29:45.067' AS DateTime), 0, 250, 107, 2185, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1281, N'Köln/Bonn', N'Hamburg', CAST(N'2018-12-06T14:46:45.083' AS DateTime), 0, 250, 238, 2101, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1282, N'Essen/Mülheim', N'Paris', CAST(N'2018-08-08T00:46:45.097' AS DateTime), 0, 250, 118, 2079, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1283, N'Paris', N'London', CAST(N'2018-12-17T16:03:45.113' AS DateTime), 0, 250, 249, 2170, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1284, N'New York', N'Mailand', CAST(N'2018-08-20T02:10:45.150' AS DateTime), 0, 250, 130, 2186, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1285, N'Dallas', N'Frankfurt', CAST(N'2018-04-21T12:10:45.173' AS DateTime), 0, 250, 10, 2154, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1286, N'Mailand', N'Kapstadt', CAST(N'2018-08-31T03:27:45.193' AS DateTime), 0, 250, 141, 2183, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1287, N'London', N'Rom', CAST(N'2018-05-02T13:27:45.213' AS DateTime), 0, 250, 21, 2067, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1288, N'Moskau', N'London', CAST(N'2018-09-11T04:44:45.227' AS DateTime), 0, 250, 152, 2095, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1289, N'Hamburg', N'Kapstadt', CAST(N'2018-05-14T14:51:45.240' AS DateTime), 0, 250, 33, 2113, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1290, N'Seattle', N'Kapstadt', CAST(N'2018-09-22T06:01:45.253' AS DateTime), 0, 250, 163, 2178, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1291, N'Kapstadt', N'Dallas', CAST(N'2018-05-25T16:08:45.267' AS DateTime), 0, 250, 44, 2045, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1292, N'Berlin', N'Köln/Bonn', CAST(N'2018-10-03T07:18:45.277' AS DateTime), 0, 250, 174, 2177, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1293, N'Kapstadt', N'New York', CAST(N'2018-06-05T17:25:45.297' AS DateTime), 0, 250, 55, 2185, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1294, N'München', N'Oslo', CAST(N'2018-10-15T08:42:45.307' AS DateTime), 0, 250, 186, 2023, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1295, N'Mailand', N'Berlin', CAST(N'2018-06-16T18:42:45.317' AS DateTime), 0, 250, 66, 2017, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1296, N'Essen/Mülheim', N'London', CAST(N'2018-10-26T09:59:45.330' AS DateTime), 0, 250, 197, 2017, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1297, N'Moskau', N'Oslo', CAST(N'2018-06-27T19:59:45.340' AS DateTime), 0, 250, 77, 2169, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1298, N'Paris', N'Moskau', CAST(N'2018-11-06T11:16:45.350' AS DateTime), 0, 250, 208, 2024, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1299, N'Paris', N'Dallas', CAST(N'2018-07-09T21:23:45.360' AS DateTime), 0, 250, 89, 2041, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1300, N'Moskau', N'Kapstadt', CAST(N'2018-11-17T12:33:45.367' AS DateTime), 0, 250, 219, 2031, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1301, N'Kapstadt', N'Moskau', CAST(N'2018-07-20T22:40:45.377' AS DateTime), 0, 250, 100, 2027, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1302, N'Dallas', N'Madrid', CAST(N'2018-11-29T13:57:45.397' AS DateTime), 0, 250, 231, 2198, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1303, N'New York', N'Essen/Mülheim', CAST(N'2018-07-31T23:57:45.407' AS DateTime), 0, 250, 111, 2137, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1304, N'Mailand', N'Prag', CAST(N'2018-12-10T15:14:45.420' AS DateTime), 0, 250, 242, 2143, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1305, N'München', N'Dallas', CAST(N'2018-08-12T01:14:45.427' AS DateTime), 0, 250, 122, 2135, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1306, N'Köln/Bonn', N'Berlin', CAST(N'2018-04-14T11:21:45.437' AS DateTime), 0, 250, 3, 2028, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1307, N'Essen/Mülheim', N'Kapstadt', CAST(N'2018-08-24T02:38:45.447' AS DateTime), 0, 250, 134, 2072, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1308, N'Essen/Mülheim', N'Rom', CAST(N'2018-04-25T12:38:45.453' AS DateTime), 0, 250, 14, 2174, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1309, N'München', N'Kapstadt', CAST(N'2018-09-04T03:55:45.470' AS DateTime), 0, 250, 145, 2043, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1310, N'Seattle', N'New York', CAST(N'2018-05-06T13:55:45.480' AS DateTime), 0, 250, 25, 2054, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1311, N'Seattle', N'Köln/Bonn', CAST(N'2018-09-15T05:12:45.487' AS DateTime), 0, 250, 156, 2163, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1312, N'Essen/Mülheim', N'London', CAST(N'2018-05-18T15:19:45.497' AS DateTime), 0, 250, 37, 2064, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1313, N'Dallas', N'Mailand', CAST(N'2018-09-26T06:29:45.507' AS DateTime), 0, 250, 167, 2036, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1314, N'Moskau', N'Paris', CAST(N'2018-05-29T16:36:45.513' AS DateTime), 0, 250, 48, 2022, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1315, N'Paris', N'München', CAST(N'2018-10-07T07:46:45.523' AS DateTime), 0, 250, 178, 2054, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1316, N'Moskau', N'Mailand', CAST(N'2018-06-09T17:53:45.533' AS DateTime), 0, 250, 59, 2032, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1317, N'Dallas', N'Frankfurt', CAST(N'2018-10-19T09:10:45.557' AS DateTime), 0, 250, 190, 2164, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1318, N'Dallas', N'Kapstadt', CAST(N'2018-06-20T19:10:45.567' AS DateTime), 0, 250, 70, 2009, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1319, N'Madrid', N'Frankfurt', CAST(N'2018-10-30T10:27:45.577' AS DateTime), 0, 250, 201, 2155, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1320, N'Dallas', N'Frankfurt', CAST(N'2018-07-01T20:27:45.587' AS DateTime), 0, 250, 81, 2083, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1321, N'Kapstadt', N'Rom', CAST(N'2018-11-10T11:44:45.593' AS DateTime), 0, 250, 212, 2180, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1322, N'London', N'New York', CAST(N'2018-07-13T21:51:45.607' AS DateTime), 0, 250, 93, 2071, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1323, N'Köln/Bonn', N'Prag', CAST(N'2018-11-21T13:01:45.613' AS DateTime), 0, 250, 223, 2191, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1324, N'New York', N'Seattle', CAST(N'2018-07-24T23:08:45.627' AS DateTime), 0, 250, 104, 2154, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1325, N'London', N'Hamburg', CAST(N'2018-12-02T14:18:45.637' AS DateTime), 0, 250, 234, 2096, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1326, N'Dallas', N'Prag', CAST(N'2018-08-05T00:25:45.657' AS DateTime), 0, 250, 115, 2122, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1327, N'Köln/Bonn', N'Prag', CAST(N'2018-12-14T15:42:45.667' AS DateTime), 0, 250, 246, 2064, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1328, N'New York', N'Paris', CAST(N'2018-08-16T01:42:45.677' AS DateTime), 0, 250, 126, 2164, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1329, N'Dallas', N'Rom', CAST(N'2018-04-18T11:49:45.687' AS DateTime), 0, 250, 7, 2010, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1330, N'Seattle', N'Moskau', CAST(N'2018-08-27T02:59:45.693' AS DateTime), 0, 250, 137, 2022, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1331, N'Rom', N'München', CAST(N'2018-04-29T13:06:45.703' AS DateTime), 0, 250, 14, 2100, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1332, N'Dallas', N'Rom', CAST(N'2018-09-08T04:23:45.713' AS DateTime), 0, 250, 149, 2018, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1333, N'Köln/Bonn', N'Madrid', CAST(N'2018-05-10T14:23:45.720' AS DateTime), 0, 250, 29, 2198, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1334, N'Frankfurt', N'Oslo', CAST(N'2018-09-19T05:40:45.730' AS DateTime), 0, 250, 160, 2079, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1335, N'Frankfurt', N'München', CAST(N'2018-05-22T15:47:45.753' AS DateTime), 0, 250, 41, 2059, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1336, N'Berlin', N'Seattle', CAST(N'2018-09-30T06:57:45.767' AS DateTime), 0, 250, 171, 2014, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1337, N'Kapstadt', N'Madrid', CAST(N'2018-06-02T17:04:45.777' AS DateTime), 0, 250, 52, 2108, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1338, N'Hamburg', N'Essen/Mülheim', CAST(N'2018-10-11T08:14:45.787' AS DateTime), 0, 250, 182, 2117, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1339, N'Frankfurt', N'München', CAST(N'2018-06-13T18:21:45.797' AS DateTime), 0, 250, 63, 2178, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1340, N'Frankfurt', N'Paris', CAST(N'2018-10-23T09:38:45.807' AS DateTime), 0, 250, 194, 2061, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1341, N'Rom', N'Prag', CAST(N'2018-06-24T19:38:45.823' AS DateTime), 0, 250, 70, 2190, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1342, N'Madrid', N'London', CAST(N'2018-11-03T10:55:45.833' AS DateTime), 0, 250, 205, 2115, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1343, N'Köln/Bonn', N'London', CAST(N'2018-07-05T20:55:45.843' AS DateTime), 0, 250, 85, 2175, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1344, N'Paris', N'Essen/Mülheim', CAST(N'2018-11-14T12:12:45.853' AS DateTime), 0, 250, 216, 2129, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1345, N'New York', N'München', CAST(N'2018-07-17T22:19:45.863' AS DateTime), 0, 250, 97, 2120, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1346, N'Oslo', N'Prag', CAST(N'2018-11-25T13:29:45.870' AS DateTime), 0, 250, 227, 2049, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1347, N'Prag', N'Dallas', CAST(N'2018-07-28T23:36:45.880' AS DateTime), 0, 250, 108, 2123, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1348, N'Dallas', N'Oslo', CAST(N'2018-12-06T14:46:45.890' AS DateTime), 0, 250, 238, 2142, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1349, N'Moskau', N'München', CAST(N'2018-08-09T00:53:45.900' AS DateTime), 0, 250, 119, 2079, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1350, N'Oslo', N'Madrid', CAST(N'2018-04-11T11:00:45.920' AS DateTime), 0, 250, 0, 2034, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1351, N'Hamburg', N'München', CAST(N'2018-08-20T02:10:45.930' AS DateTime), 0, 250, 130, 2099, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1352, N'Seattle', N'Kapstadt', CAST(N'2018-04-22T12:17:45.940' AS DateTime), 0, 250, 11, 2074, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1353, N'Paris', N'Köln/Bonn', CAST(N'2018-08-31T03:27:45.950' AS DateTime), 0, 250, 141, 2163, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1354, N'Seattle', N'Essen/Mülheim', CAST(N'2018-05-03T13:34:45.957' AS DateTime), 0, 250, 22, 2067, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1355, N'Hamburg', N'Paris', CAST(N'2018-09-12T04:51:45.970' AS DateTime), 0, 250, 153, 2026, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1356, N'Oslo', N'Prag', CAST(N'2018-05-14T14:51:45.980' AS DateTime), 0, 250, 33, 2117, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1357, N'Dallas', N'Hamburg', CAST(N'2018-09-23T06:08:45.987' AS DateTime), 0, 250, 164, 2131, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1358, N'New York', N'Prag', CAST(N'2018-05-25T16:08:45.997' AS DateTime), 0, 250, 44, 2086, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1359, N'Seattle', N'Rom', CAST(N'2018-10-04T07:25:46.017' AS DateTime), 0, 250, 175, 2119, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1360, N'London', N'Mailand', CAST(N'2018-06-06T17:32:46.027' AS DateTime), 0, 250, 56, 2141, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1361, N'Hamburg', N'Moskau', CAST(N'2018-10-15T08:42:46.033' AS DateTime), 0, 250, 186, 2031, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1362, N'Oslo', N'London', CAST(N'2018-06-17T18:49:46.043' AS DateTime), 0, 250, 67, 2046, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1363, N'Mailand', N'Köln/Bonn', CAST(N'2018-10-26T09:59:46.053' AS DateTime), 0, 250, 197, 2086, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1364, N'Kapstadt', N'Hamburg', CAST(N'2018-06-28T20:06:46.063' AS DateTime), 0, 250, 78, 2056, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1365, N'Kapstadt', N'Prag', CAST(N'2018-11-07T11:23:46.070' AS DateTime), 0, 250, 209, 2116, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1366, N'Seattle', N'Moskau', CAST(N'2018-07-09T21:23:46.080' AS DateTime), 0, 250, 89, 2161, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1367, N'Oslo', N'Seattle', CAST(N'2018-11-18T12:40:46.087' AS DateTime), 0, 250, 220, 2103, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1368, N'Prag', N'Moskau', CAST(N'2018-07-21T22:47:46.107' AS DateTime), 0, 250, 101, 2013, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1369, N'Dallas', N'Mailand', CAST(N'2018-11-29T13:57:46.117' AS DateTime), 0, 250, 231, 2154, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1370, N'Hamburg', N'Dallas', CAST(N'2018-08-02T00:04:46.127' AS DateTime), 0, 250, 112, 2124, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1371, N'Prag', N'Paris', CAST(N'2018-12-10T15:14:46.133' AS DateTime), 0, 250, 242, 2171, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1372, N'Mailand', N'Hamburg', CAST(N'2018-08-13T01:21:46.143' AS DateTime), 0, 250, 123, 2104, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1373, N'Essen/Mülheim', N'New York', CAST(N'2018-04-15T11:28:46.150' AS DateTime), 0, 250, 4, 2045, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1374, N'Essen/Mülheim', N'Seattle', CAST(N'2018-08-24T02:38:46.167' AS DateTime), 0, 250, 134, 2082, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1375, N'Hamburg', N'Essen/Mülheim', CAST(N'2018-04-26T12:45:46.177' AS DateTime), 0, 250, 15, 2043, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1376, N'Paris', N'Prag', CAST(N'2018-09-04T03:55:46.187' AS DateTime), 0, 250, 145, 2009, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1377, N'New York', N'Moskau', CAST(N'2018-05-07T14:02:46.193' AS DateTime), 0, 250, 26, 2119, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1378, N'London', N'Paris', CAST(N'2018-09-16T05:19:46.203' AS DateTime), 0, 250, 157, 2151, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1379, N'Hamburg', N'New York', CAST(N'2018-05-18T15:19:46.213' AS DateTime), 0, 250, 37, 2003, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1380, N'Frankfurt', N'Oslo', CAST(N'2018-09-27T06:36:46.220' AS DateTime), 0, 250, 168, 2179, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1381, N'Mailand', N'Rom', CAST(N'2018-05-29T16:36:46.230' AS DateTime), 0, 250, 48, 2052, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1382, N'Kapstadt', N'Köln/Bonn', CAST(N'2018-10-08T07:53:46.240' AS DateTime), 0, 250, 179, 2164, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1383, N'Paris', N'Rom', CAST(N'2018-06-10T18:00:46.260' AS DateTime), 0, 250, 60, 2071, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1384, N'Frankfurt', N'Oslo', CAST(N'2018-10-19T09:10:46.270' AS DateTime), 0, 250, 190, 2197, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1385, N'Moskau', N'München', CAST(N'2018-06-21T19:17:46.280' AS DateTime), 0, 250, 71, 2006, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1386, N'Frankfurt', N'Rom', CAST(N'2018-10-30T10:27:46.290' AS DateTime), 0, 250, 201, 2169, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1387, N'Madrid', N'Moskau', CAST(N'2018-07-02T20:34:46.303' AS DateTime), 0, 250, 82, 2187, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1388, N'Essen/Mülheim', N'Prag', CAST(N'2018-11-11T11:51:46.310' AS DateTime), 0, 250, 213, 2078, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1389, N'Berlin', N'München', CAST(N'2018-07-13T21:51:46.320' AS DateTime), 0, 250, 93, 2192, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1390, N'Frankfurt', N'Rom', CAST(N'2018-11-22T13:08:46.330' AS DateTime), 0, 250, 224, 2110, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1391, N'Prag', N'New York', CAST(N'2018-07-24T23:08:46.340' AS DateTime), 0, 250, 104, 2136, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1392, N'Paris', N'München', CAST(N'2018-12-03T14:25:46.357' AS DateTime), 0, 250, 235, 2083, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1393, N'Mailand', N'Paris', CAST(N'2018-08-06T00:32:46.367' AS DateTime), 0, 250, 116, 2197, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1394, N'Hamburg', N'Seattle', CAST(N'2018-12-14T15:42:46.377' AS DateTime), 0, 250, 246, 2120, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1395, N'New York', N'Moskau', CAST(N'2018-08-17T01:49:46.383' AS DateTime), 0, 250, 127, 2159, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1396, N'Köln/Bonn', N'Essen/Mülheim', CAST(N'2018-04-18T11:49:46.393' AS DateTime), 0, 250, 7, 2018, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1397, N'Rom', N'München', CAST(N'2018-08-28T03:06:46.400' AS DateTime), 0, 250, 134, 2048, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1398, N'London', N'Dallas', CAST(N'2018-04-30T13:13:46.410' AS DateTime), 0, 250, 19, 2146, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1399, N'Essen/Mülheim', N'Madrid', CAST(N'2018-09-08T04:23:46.420' AS DateTime), 0, 250, 149, 2157, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1400, N'Frankfurt', N'Madrid', CAST(N'2018-05-11T14:30:46.430' AS DateTime), 0, 250, 30, 2064, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1401, N'Berlin', N'Kapstadt', CAST(N'2018-09-20T05:47:46.453' AS DateTime), 0, 250, 161, 2110, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1402, N'Köln/Bonn', N'Madrid', CAST(N'2018-05-22T15:47:46.460' AS DateTime), 0, 250, 41, 2124, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1403, N'Dallas', N'Oslo', CAST(N'2018-10-01T07:04:46.470' AS DateTime), 0, 250, 172, 2073, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1404, N'Mailand', N'Moskau', CAST(N'2018-06-02T17:04:46.487' AS DateTime), 0, 250, 52, 2144, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1405, N'Berlin', N'Oslo', CAST(N'2018-10-12T08:21:46.507' AS DateTime), 0, 250, 183, 2145, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1406, N'Paris', N'London', CAST(N'2018-06-14T18:28:46.527' AS DateTime), 0, 250, 64, 2139, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1407, N'London', N'Hamburg', CAST(N'2018-10-23T09:38:46.567' AS DateTime), 0, 250, 194, 2047, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1408, N'London', N'Paris', CAST(N'2018-06-25T19:45:46.580' AS DateTime), 0, 250, 75, 2067, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1409, N'London', N'Moskau', CAST(N'2018-11-03T10:55:46.597' AS DateTime), 0, 250, 205, 2134, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1410, N'Rom', N'New York', CAST(N'2018-07-06T21:02:46.610' AS DateTime), 0, 250, 82, 2076, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1411, N'Prag', N'Seattle', CAST(N'2018-11-15T12:19:46.623' AS DateTime), 0, 250, 217, 2039, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1412, N'Madrid', N'Berlin', CAST(N'2018-07-17T22:19:46.637' AS DateTime), 0, 250, 97, 2077, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1413, N'Rom', N'Prag', CAST(N'2018-11-26T13:36:46.650' AS DateTime), 0, 250, 224, 2081, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1414, N'Frankfurt', N'München', CAST(N'2018-07-28T23:36:46.663' AS DateTime), 0, 250, 108, 2080, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1415, N'Essen/Mülheim', N'Köln/Bonn', CAST(N'2018-12-07T14:53:46.677' AS DateTime), 0, 250, 239, 2137, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1416, N'Kapstadt', N'München', CAST(N'2018-08-10T01:00:46.707' AS DateTime), 0, 250, 120, 2075, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1417, N'Essen/Mülheim', N'München', CAST(N'2018-04-11T11:00:46.727' AS DateTime), 0, 250, 0, 2189, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1418, N'Kapstadt', N'Moskau', CAST(N'2018-08-21T02:17:46.747' AS DateTime), 0, 250, 131, 2041, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1419, N'Madrid', N'Dallas', CAST(N'2018-04-22T12:17:46.767' AS DateTime), 0, 250, 11, 2176, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1420, N'Rom', N'Dallas', CAST(N'2018-09-01T03:34:46.787' AS DateTime), 0, 250, 138, 2134, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1421, N'Rom', N'Dallas', CAST(N'2018-05-04T13:41:46.807' AS DateTime), 0, 250, 19, 2183, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1422, N'Oslo', N'Prag', CAST(N'2018-09-12T04:51:46.830' AS DateTime), 0, 250, 153, 2032, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1423, N'Madrid', N'London', CAST(N'2018-05-15T14:58:46.850' AS DateTime), 0, 250, 34, 2022, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1424, N'Kapstadt', N'Rom', CAST(N'2018-09-23T06:08:46.870' AS DateTime), 0, 250, 164, 2053, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1425, N'Frankfurt', N'Kapstadt', CAST(N'2018-05-26T16:15:46.917' AS DateTime), 0, 250, 45, 2108, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1426, N'New York', N'Moskau', CAST(N'2018-10-05T07:32:46.940' AS DateTime), 0, 250, 176, 2026, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1427, N'München', N'Köln/Bonn', CAST(N'2018-06-06T17:32:46.967' AS DateTime), 0, 250, 56, 2129, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1428, N'London', N'Seattle', CAST(N'2018-10-16T08:49:46.987' AS DateTime), 0, 250, 187, 2075, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1429, N'Rom', N'Madrid', CAST(N'2018-06-18T18:56:47.010' AS DateTime), 0, 250, 64, 2103, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1430, N'Rom', N'New York', CAST(N'2018-10-27T10:06:47.033' AS DateTime), 0, 250, 194, 2023, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1431, N'München', N'Mailand', CAST(N'2018-06-29T20:13:47.057' AS DateTime), 0, 250, 79, 2023, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1432, N'Kapstadt', N'Madrid', CAST(N'2018-11-07T11:23:47.080' AS DateTime), 0, 250, 209, 2161, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1433, N'Seattle', N'Prag', CAST(N'2018-07-10T21:30:47.123' AS DateTime), 0, 250, 90, 2182, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1434, N'Kapstadt', N'Köln/Bonn', CAST(N'2018-11-19T12:47:47.153' AS DateTime), 0, 250, 221, 2181, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1435, N'Madrid', N'Seattle', CAST(N'2018-07-21T22:47:47.177' AS DateTime), 0, 250, 101, 2151, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1436, N'Essen/Mülheim', N'New York', CAST(N'2018-11-30T14:04:47.197' AS DateTime), 0, 250, 232, 2048, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1437, N'London', N'Essen/Mülheim', CAST(N'2018-08-02T00:04:47.217' AS DateTime), 0, 250, 112, 2081, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1438, N'Frankfurt', N'Prag', CAST(N'2018-12-11T15:21:47.237' AS DateTime), 0, 250, 243, 2007, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1439, N'London', N'Prag', CAST(N'2018-08-14T01:28:47.260' AS DateTime), 0, 250, 124, 2043, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1440, N'München', N'Madrid', CAST(N'2018-04-15T11:28:47.300' AS DateTime), 0, 250, 4, 2009, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1441, N'Kapstadt', N'Essen/Mülheim', CAST(N'2018-08-25T02:45:47.323' AS DateTime), 0, 250, 135, 2034, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1442, N'Hamburg', N'Frankfurt', CAST(N'2018-04-26T12:45:47.343' AS DateTime), 0, 250, 15, 2120, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1443, N'Essen/Mülheim', N'Kapstadt', CAST(N'2018-09-05T04:02:47.367' AS DateTime), 0, 250, 146, 2082, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1444, N'London', N'Dallas', CAST(N'2018-05-08T14:09:47.387' AS DateTime), 0, 250, 27, 2068, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1445, N'Dallas', N'Essen/Mülheim', CAST(N'2018-09-16T05:19:47.407' AS DateTime), 0, 250, 157, 2103, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1446, N'Berlin', N'New York', CAST(N'2018-05-19T15:26:47.427' AS DateTime), 0, 250, 38, 2113, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1447, N'Hamburg', N'Rom', CAST(N'2018-09-27T06:36:47.447' AS DateTime), 0, 250, 168, 2191, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1448, N'Oslo', N'Seattle', CAST(N'2018-05-30T16:43:47.467' AS DateTime), 0, 250, 49, 2017, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1449, N'Oslo', N'Frankfurt', CAST(N'2018-10-09T08:00:47.500' AS DateTime), 0, 250, 180, 2097, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1450, N'London', N'Moskau', CAST(N'2018-06-10T18:00:47.517' AS DateTime), 0, 250, 60, 2113, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1451, N'Seattle', N'Madrid', CAST(N'2018-10-20T09:17:47.530' AS DateTime), 0, 250, 191, 2194, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1452, N'Mailand', N'Essen/Mülheim', CAST(N'2018-06-21T19:17:47.547' AS DateTime), 0, 250, 71, 2136, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1453, N'Moskau', N'München', CAST(N'2018-10-31T10:34:47.560' AS DateTime), 0, 250, 202, 2005, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1454, N'Oslo', N'Mailand', CAST(N'2018-07-03T20:41:47.577' AS DateTime), 0, 250, 83, 2118, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1455, N'London', N'Berlin', CAST(N'2018-11-11T11:51:47.590' AS DateTime), 0, 250, 213, 2024, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1456, N'Hamburg', N'Berlin', CAST(N'2018-07-14T21:58:47.607' AS DateTime), 0, 250, 94, 2119, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1457, N'Berlin', N'Hamburg', CAST(N'2018-11-22T13:08:47.640' AS DateTime), 0, 250, 224, 2107, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1458, N'Rom', N'Madrid', CAST(N'2018-07-25T23:15:47.650' AS DateTime), 0, 250, 101, 2109, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1459, N'Kapstadt', N'Köln/Bonn', CAST(N'2018-12-04T14:32:47.660' AS DateTime), 0, 250, 236, 2095, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1460, N'Berlin', N'Seattle', CAST(N'2018-08-06T00:32:47.670' AS DateTime), 0, 250, 116, 2128, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1461, N'Köln/Bonn', N'Paris', CAST(N'2018-12-15T15:49:47.680' AS DateTime), 0, 250, 247, 2040, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1462, N'Madrid', N'Seattle', CAST(N'2018-08-18T01:56:47.690' AS DateTime), 0, 250, 128, 2018, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1463, N'London', N'Prag', CAST(N'2018-04-19T11:56:47.700' AS DateTime), 0, 250, 8, 2001, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1464, N'Madrid', N'Mailand', CAST(N'2018-08-29T03:13:47.710' AS DateTime), 0, 250, 139, 2092, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1465, N'Prag', N'Köln/Bonn', CAST(N'2018-04-30T13:13:47.720' AS DateTime), 0, 250, 19, 2159, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1466, N'London', N'Moskau', CAST(N'2018-09-09T04:30:47.740' AS DateTime), 0, 250, 150, 2131, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1467, N'Dallas', N'Essen/Mülheim', CAST(N'2018-05-12T14:37:47.757' AS DateTime), 0, 250, 31, 2007, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1468, N'Madrid', N'Rom', CAST(N'2018-09-20T05:47:47.767' AS DateTime), 0, 250, 161, 2084, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1469, N'Berlin', N'Paris', CAST(N'2018-05-23T15:54:47.777' AS DateTime), 0, 250, 42, 2003, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1470, N'Paris', N'Seattle', CAST(N'2018-10-01T07:04:47.787' AS DateTime), 0, 250, 172, 2096, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1471, N'Hamburg', N'Moskau', CAST(N'2018-06-03T17:11:47.797' AS DateTime), 0, 250, 53, 2097, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1472, N'London', N'Seattle', CAST(N'2018-10-13T08:28:47.807' AS DateTime), 0, 250, 184, 2012, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1473, N'Paris', N'Mailand', CAST(N'2018-06-14T18:28:47.827' AS DateTime), 0, 250, 64, 2076, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1474, N'Berlin', N'Kapstadt', CAST(N'2018-10-24T09:45:47.837' AS DateTime), 0, 250, 195, 2109, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1475, N'Moskau', N'Hamburg', CAST(N'2018-06-25T19:45:47.847' AS DateTime), 0, 250, 75, 2142, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1476, N'Frankfurt', N'Essen/Mülheim', CAST(N'2018-11-04T11:02:47.857' AS DateTime), 0, 250, 206, 2124, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1477, N'Essen/Mülheim', N'Mailand', CAST(N'2018-07-07T21:09:47.867' AS DateTime), 0, 250, 87, 2139, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1478, N'Kapstadt', N'Frankfurt', CAST(N'2018-11-15T12:19:47.877' AS DateTime), 0, 250, 217, 2186, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1479, N'Moskau', N'London', CAST(N'2018-07-18T22:26:47.887' AS DateTime), 0, 250, 98, 2021, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1480, N'Essen/Mülheim', N'Kapstadt', CAST(N'2018-11-26T13:36:47.897' AS DateTime), 0, 250, 228, 2054, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1481, N'Frankfurt', N'Oslo', CAST(N'2018-07-29T23:43:47.917' AS DateTime), 0, 250, 109, 2166, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1482, N'Prag', N'New York', CAST(N'2018-12-08T15:00:47.930' AS DateTime), 0, 250, 240, 2181, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1483, N'Dallas', N'München', CAST(N'2018-08-10T01:00:47.940' AS DateTime), 0, 250, 120, 2107, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1484, N'Essen/Mülheim', N'Dallas', CAST(N'2018-04-12T11:07:47.950' AS DateTime), 0, 250, 1, 2014, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1485, N'Köln/Bonn', N'Oslo', CAST(N'2018-08-21T02:17:47.960' AS DateTime), 0, 250, 131, 2181, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1486, N'Mailand', N'Rom', CAST(N'2018-04-23T12:24:47.970' AS DateTime), 0, 250, 12, 2027, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1487, N'Seattle', N'Dallas', CAST(N'2018-09-02T03:41:47.980' AS DateTime), 0, 250, 143, 2133, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1488, N'Paris', N'Seattle', CAST(N'2018-05-04T13:41:47.990' AS DateTime), 0, 250, 23, 2043, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1489, N'Kapstadt', N'London', CAST(N'2018-09-13T04:58:48.000' AS DateTime), 0, 250, 154, 2100, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1490, N'Prag', N'Essen/Mülheim', CAST(N'2018-05-15T14:58:48.023' AS DateTime), 0, 250, 34, 2071, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1491, N'Dallas', N'New York', CAST(N'2018-09-24T06:15:48.033' AS DateTime), 0, 250, 165, 2137, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1492, N'Frankfurt', N'Dallas', CAST(N'2018-05-27T16:22:48.043' AS DateTime), 0, 250, 46, 2178, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1493, N'Seattle', N'Frankfurt', CAST(N'2018-10-05T07:32:48.053' AS DateTime), 0, 250, 176, 2111, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1494, N'Kapstadt', N'Frankfurt', CAST(N'2018-06-07T17:39:48.063' AS DateTime), 0, 250, 57, 2114, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1495, N'Frankfurt', N'Berlin', CAST(N'2018-10-17T08:56:48.073' AS DateTime), 0, 250, 188, 2096, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1496, N'New York', N'Prag', CAST(N'2018-06-18T18:56:48.083' AS DateTime), 0, 250, 68, 2025, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1497, N'Berlin', N'München', CAST(N'2018-10-28T10:13:48.097' AS DateTime), 0, 250, 199, 2012, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1498, N'Dallas', N'Frankfurt', CAST(N'2018-06-29T20:13:48.107' AS DateTime), 0, 250, 79, 2170, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1499, N'Moskau', N'Seattle', CAST(N'2018-11-08T11:30:48.123' AS DateTime), 0, 250, 210, 2051, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1500, N'New York', N'Essen/Mülheim', CAST(N'2018-07-11T21:37:48.137' AS DateTime), 0, 250, 91, 2049, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1501, N'Paris', N'Hamburg', CAST(N'2018-11-19T12:47:48.150' AS DateTime), 0, 250, 221, 2157, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1502, N'München', N'Dallas', CAST(N'2018-07-22T22:54:48.160' AS DateTime), 0, 250, 102, 2004, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1503, N'Essen/Mülheim', N'Köln/Bonn', CAST(N'2018-11-30T14:04:48.170' AS DateTime), 0, 250, 232, 2116, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1504, N'Oslo', N'Madrid', CAST(N'2018-08-03T00:11:48.180' AS DateTime), 0, 250, 113, 2019, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1505, N'Rom', N'Seattle', CAST(N'2018-12-12T15:28:48.190' AS DateTime), 0, 250, 237, 2147, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1506, N'München', N'Madrid', CAST(N'2018-08-14T01:28:48.210' AS DateTime), 0, 250, 124, 2075, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1507, N'Prag', N'New York', CAST(N'2018-04-16T11:35:48.220' AS DateTime), 0, 250, 5, 2059, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1508, N'Dallas', N'Prag', CAST(N'2018-08-25T02:45:48.230' AS DateTime), 0, 250, 135, 2167, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1509, N'Prag', N'Köln/Bonn', CAST(N'2018-04-27T12:52:48.240' AS DateTime), 0, 250, 16, 2127, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1510, N'Frankfurt', N'Rom', CAST(N'2018-09-06T04:09:48.253' AS DateTime), 0, 250, 147, 2062, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1511, N'Paris', N'Seattle', CAST(N'2018-05-08T14:09:48.263' AS DateTime), 0, 250, 27, 2036, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1512, N'Oslo', N'Hamburg', CAST(N'2018-09-17T05:26:48.273' AS DateTime), 0, 250, 158, 2024, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1513, N'Köln/Bonn', N'London', CAST(N'2018-05-19T15:26:48.283' AS DateTime), 0, 250, 38, 2030, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1514, N'Berlin', N'London', CAST(N'2018-09-28T06:43:48.303' AS DateTime), 0, 250, 169, 2167, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1515, N'Paris', N'München', CAST(N'2018-05-31T16:50:48.313' AS DateTime), 0, 250, 50, 2199, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1516, N'Prag', N'London', CAST(N'2018-10-09T08:00:48.323' AS DateTime), 0, 250, 180, 2116, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1517, N'Madrid', N'Moskau', CAST(N'2018-06-11T18:07:48.333' AS DateTime), 0, 250, 61, 2081, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1518, N'Berlin', N'Oslo', CAST(N'2018-10-20T09:17:48.343' AS DateTime), 0, 250, 191, 2148, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1519, N'Madrid', N'Kapstadt', CAST(N'2018-06-22T19:24:48.357' AS DateTime), 0, 250, 72, 2162, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1520, N'Prag', N'New York', CAST(N'2018-11-01T10:41:48.363' AS DateTime), 0, 250, 203, 2140, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1521, N'London', N'Seattle', CAST(N'2018-07-03T20:41:48.373' AS DateTime), 0, 250, 83, 2179, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1522, N'Köln/Bonn', N'Prag', CAST(N'2018-11-12T11:58:48.383' AS DateTime), 0, 250, 214, 2037, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1523, N'Oslo', N'Paris', CAST(N'2018-07-14T21:58:48.407' AS DateTime), 0, 250, 94, 2091, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1524, N'New York', N'Oslo', CAST(N'2018-11-23T13:15:48.417' AS DateTime), 0, 250, 225, 2091, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1525, N'Köln/Bonn', N'Prag', CAST(N'2018-07-26T23:22:48.427' AS DateTime), 0, 250, 106, 2062, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1526, N'Mailand', N'Moskau', CAST(N'2018-12-04T14:32:48.437' AS DateTime), 0, 250, 236, 2078, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1527, N'Madrid', N'Dallas', CAST(N'2018-08-07T00:39:48.447' AS DateTime), 0, 250, 117, 2180, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1528, N'Frankfurt', N'Hamburg', CAST(N'2018-12-16T15:56:48.457' AS DateTime), 0, 250, 248, 2146, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1529, N'Oslo', N'London', CAST(N'2018-08-18T01:56:48.467' AS DateTime), 0, 250, 128, 2154, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1530, N'Paris', N'Berlin', CAST(N'2018-04-20T12:03:48.477' AS DateTime), 0, 250, 9, 2084, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1531, N'Rom', N'Seattle', CAST(N'2018-08-29T03:13:48.487' AS DateTime), 0, 250, 135, 2144, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1532, N'Mailand', N'New York', CAST(N'2018-05-01T13:20:48.507' AS DateTime), 0, 250, 20, 2133, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1533, N'Oslo', N'München', CAST(N'2018-09-10T04:37:48.523' AS DateTime), 0, 250, 151, 2128, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1534, N'Kapstadt', N'Moskau', CAST(N'2018-05-12T14:37:48.533' AS DateTime), 0, 250, 31, 2195, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1535, N'München', N'Köln/Bonn', CAST(N'2018-09-21T05:54:48.543' AS DateTime), 0, 250, 162, 2139, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1536, N'Dallas', N'Kapstadt', CAST(N'2018-05-23T15:54:48.560' AS DateTime), 0, 250, 42, 2077, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1537, N'Hamburg', N'Paris', CAST(N'2018-10-02T07:11:48.580' AS DateTime), 0, 250, 173, 2141, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1538, N'Seattle', N'Kapstadt', CAST(N'2018-06-04T17:18:48.617' AS DateTime), 0, 250, 54, 2065, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1539, N'Mailand', N'Hamburg', CAST(N'2018-10-13T08:28:48.630' AS DateTime), 0, 250, 184, 2073, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1540, N'München', N'Paris', CAST(N'2018-06-15T18:35:48.643' AS DateTime), 0, 250, 65, 2095, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1541, N'London', N'Berlin', CAST(N'2018-10-24T09:45:48.657' AS DateTime), 0, 250, 195, 2062, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1542, N'Hamburg', N'Essen/Mülheim', CAST(N'2018-06-26T19:52:48.670' AS DateTime), 0, 250, 76, 2155, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1543, N'Madrid', N'New York', CAST(N'2018-11-05T11:09:48.687' AS DateTime), 0, 250, 207, 2105, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1544, N'Mailand', N'Essen/Mülheim', CAST(N'2018-07-07T21:09:48.700' AS DateTime), 0, 250, 87, 2005, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1545, N'Paris', N'Oslo', CAST(N'2018-11-16T12:26:48.713' AS DateTime), 0, 250, 218, 2186, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1546, N'Dallas', N'Berlin', CAST(N'2018-07-18T22:26:48.727' AS DateTime), 0, 250, 98, 2190, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1547, N'Prag', N'London', CAST(N'2018-11-27T13:43:48.757' AS DateTime), 0, 250, 229, 2002, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1548, N'Moskau', N'Hamburg', CAST(N'2018-07-30T23:50:48.770' AS DateTime), 0, 250, 110, 2177, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1549, N'New York', N'Rom', CAST(N'2018-12-08T15:00:48.783' AS DateTime), 0, 250, 240, 2040, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1550, N'Mailand', N'Paris', CAST(N'2018-08-11T01:07:48.797' AS DateTime), 0, 250, 121, 2025, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1551, N'Moskau', N'Frankfurt', CAST(N'2018-04-12T11:07:48.813' AS DateTime), 0, 250, 1, 2191, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1552, N'Prag', N'Hamburg', CAST(N'2018-08-22T02:24:48.827' AS DateTime), 0, 250, 132, 2006, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1553, N'Mailand', N'Kapstadt', CAST(N'2018-04-24T12:31:48.840' AS DateTime), 0, 250, 13, 2181, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1554, N'Essen/Mülheim', N'Seattle', CAST(N'2018-09-02T03:41:48.853' AS DateTime), 0, 250, 143, 2136, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1555, N'Rom', N'Madrid', CAST(N'2018-05-05T13:48:48.867' AS DateTime), 0, 250, 20, 2078, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1556, N'Prag', N'München', CAST(N'2018-09-14T05:05:48.897' AS DateTime), 0, 250, 155, 2083, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1557, N'Moskau', N'Berlin', CAST(N'2018-05-16T15:05:48.907' AS DateTime), 0, 250, 35, 2094, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1558, N'Paris', N'Hamburg', CAST(N'2018-09-25T06:22:48.923' AS DateTime), 0, 250, 166, 2136, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1559, N'München', N'Moskau', CAST(N'2018-05-27T16:22:48.937' AS DateTime), 0, 250, 46, 2089, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1560, N'Essen/Mülheim', N'Seattle', CAST(N'2018-10-06T07:39:48.950' AS DateTime), 0, 250, 177, 2053, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1561, N'New York', N'Köln/Bonn', CAST(N'2018-06-08T17:46:48.967' AS DateTime), 0, 250, 58, 2067, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1562, N'Madrid', N'Dallas', CAST(N'2018-10-17T08:56:48.987' AS DateTime), 0, 250, 188, 2104, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1563, N'Essen/Mülheim', N'Prag', CAST(N'2018-06-19T19:03:49.007' AS DateTime), 0, 250, 69, 2177, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1564, N'Hamburg', N'Seattle', CAST(N'2018-10-28T10:13:49.030' AS DateTime), 0, 250, 199, 2093, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1565, N'Hamburg', N'Rom', CAST(N'2018-06-30T20:20:49.077' AS DateTime), 0, 250, 80, 2154, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1566, N'Kapstadt', N'Oslo', CAST(N'2018-11-09T11:37:49.100' AS DateTime), 0, 250, 211, 2138, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1567, N'New York', N'London', CAST(N'2018-07-11T21:37:49.123' AS DateTime), 0, 250, 91, 2175, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1568, N'London', N'New York', CAST(N'2018-11-20T12:54:49.143' AS DateTime), 0, 250, 222, 2161, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1569, N'Köln/Bonn', N'Prag', CAST(N'2018-07-22T22:54:49.167' AS DateTime), 0, 250, 102, 2067, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1570, N'Prag', N'Oslo', CAST(N'2018-12-01T14:11:49.190' AS DateTime), 0, 250, 233, 2183, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1571, N'London', N'München', CAST(N'2018-08-04T00:18:49.220' AS DateTime), 0, 250, 114, 2008, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1572, N'Paris', N'Frankfurt', CAST(N'2018-12-12T15:28:49.233' AS DateTime), 0, 250, 244, 2003, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1573, N'Prag', N'New York', CAST(N'2018-08-15T01:35:49.247' AS DateTime), 0, 250, 125, 2136, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1574, N'Frankfurt', N'München', CAST(N'2018-04-16T11:35:49.260' AS DateTime), 0, 250, 5, 2051, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1575, N'Frankfurt', N'London', CAST(N'2018-08-26T02:52:49.273' AS DateTime), 0, 250, 136, 2043, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1576, N'Madrid', N'Oslo', CAST(N'2018-04-28T12:59:49.287' AS DateTime), 0, 250, 17, 2069, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1577, N'Seattle', N'Essen/Mülheim', CAST(N'2018-09-06T04:09:49.300' AS DateTime), 0, 250, 147, 2025, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1578, N'Köln/Bonn', N'New York', CAST(N'2018-05-09T14:16:49.313' AS DateTime), 0, 250, 28, 2105, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1579, N'Moskau', N'Mailand', CAST(N'2018-09-17T05:26:49.327' AS DateTime), 0, 250, 158, 2038, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1580, N'Hamburg', N'New York', CAST(N'2018-05-20T15:33:49.370' AS DateTime), 0, 250, 39, 2194, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1581, N'Madrid', N'Prag', CAST(N'2018-09-29T06:50:49.393' AS DateTime), 0, 250, 170, 2086, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1582, N'Kapstadt', N'Köln/Bonn', CAST(N'2018-05-31T16:50:49.413' AS DateTime), 0, 250, 50, 2151, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1583, N'Köln/Bonn', N'London', CAST(N'2018-10-10T08:07:49.437' AS DateTime), 0, 250, 181, 2035, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1584, N'Berlin', N'New York', CAST(N'2018-06-11T18:07:49.457' AS DateTime), 0, 250, 61, 2159, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1585, N'Köln/Bonn', N'Paris', CAST(N'2018-10-21T09:24:49.480' AS DateTime), 0, 250, 192, 2140, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1586, N'Oslo', N'Rom', CAST(N'2018-06-23T19:31:49.503' AS DateTime), 0, 250, 73, 2096, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1587, N'New York', N'Moskau', CAST(N'2018-11-01T10:41:49.523' AS DateTime), 0, 250, 203, 2050, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1588, N'Moskau', N'Berlin', CAST(N'2018-07-04T20:48:49.543' AS DateTime), 0, 250, 84, 2135, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1589, N'Berlin', N'Kapstadt', CAST(N'2018-11-13T12:05:49.590' AS DateTime), 0, 250, 215, 2080, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1590, N'Berlin', N'Dallas', CAST(N'2018-07-15T22:05:49.613' AS DateTime), 0, 250, 95, 2011, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1591, N'Paris', N'Mailand', CAST(N'2018-11-24T13:22:49.633' AS DateTime), 0, 250, 226, 2092, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1592, N'Hamburg', N'London', CAST(N'2018-07-26T23:22:49.653' AS DateTime), 0, 250, 106, 2113, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1593, N'Oslo', N'Paris', CAST(N'2018-12-05T14:39:49.677' AS DateTime), 0, 250, 237, 2117, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1594, N'München', N'Frankfurt', CAST(N'2018-08-08T00:46:49.697' AS DateTime), 0, 250, 118, 2061, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1595, N'Moskau', N'Frankfurt', CAST(N'2018-12-16T15:56:49.717' AS DateTime), 0, 250, 248, 2139, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1596, N'Moskau', N'Berlin', CAST(N'2018-08-19T02:03:49.737' AS DateTime), 0, 250, 129, 2042, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1597, N'Kapstadt', N'Seattle', CAST(N'2018-04-20T12:03:49.787' AS DateTime), 0, 250, 9, 2029, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1598, N'Seattle', N'Moskau', CAST(N'2018-08-30T03:20:49.823' AS DateTime), 0, 250, 140, 2014, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1599, N'Essen/Mülheim', N'Köln/Bonn', CAST(N'2018-05-02T13:27:49.847' AS DateTime), 0, 250, 21, 2102, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1600, N'Mailand', N'London', CAST(N'2018-09-10T04:37:49.877' AS DateTime), 0, 250, 151, 2047, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1601, N'London', N'München', CAST(N'2018-05-13T14:44:49.900' AS DateTime), 0, 250, 32, 2118, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1602, N'Hamburg', N'London', CAST(N'2018-09-21T05:54:49.923' AS DateTime), 0, 250, 162, 2014, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1603, N'Berlin', N'München', CAST(N'2018-05-24T16:01:49.943' AS DateTime), 0, 250, 43, 2194, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1604, N'Dallas', N'Berlin', CAST(N'2018-10-03T07:18:49.983' AS DateTime), 0, 250, 174, 2183, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1605, N'Dallas', N'Paris', CAST(N'2018-06-04T17:18:50.007' AS DateTime), 0, 250, 54, 2159, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1606, N'Rom', N'Oslo', CAST(N'2018-10-14T08:35:50.030' AS DateTime), 0, 250, 181, 2143, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1607, N'Oslo', N'Paris', CAST(N'2018-06-15T18:35:50.053' AS DateTime), 0, 250, 65, 2089, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1608, N'Frankfurt', N'Berlin', CAST(N'2018-10-25T09:52:50.077' AS DateTime), 0, 250, 196, 2036, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1609, N'New York', N'München', CAST(N'2018-06-27T19:59:50.097' AS DateTime), 0, 250, 77, 2159, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1610, N'Madrid', N'Oslo', CAST(N'2018-11-05T11:09:50.123' AS DateTime), 0, 250, 207, 2092, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1611, N'Köln/Bonn', N'Oslo', CAST(N'2018-07-08T21:16:50.147' AS DateTime), 0, 250, 88, 2039, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1612, N'Köln/Bonn', N'Kapstadt', CAST(N'2018-11-16T12:26:50.170' AS DateTime), 0, 250, 218, 2019, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1613, N'Moskau', N'Kapstadt', CAST(N'2018-07-19T22:33:50.220' AS DateTime), 0, 250, 99, 2053, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1614, N'Moskau', N'Essen/Mülheim', CAST(N'2018-11-28T13:50:50.243' AS DateTime), 0, 250, 230, 2065, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1615, N'New York', N'München', CAST(N'2018-07-30T23:50:50.263' AS DateTime), 0, 250, 110, 2010, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1616, N'Frankfurt', N'Hamburg', CAST(N'2018-12-09T15:07:50.287' AS DateTime), 0, 250, 241, 2175, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1617, N'Köln/Bonn', N'Oslo', CAST(N'2018-08-11T01:07:50.307' AS DateTime), 0, 250, 121, 2125, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1618, N'Oslo', N'Frankfurt', CAST(N'2018-04-13T11:14:50.330' AS DateTime), 0, 250, 2, 2159, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1619, N'Köln/Bonn', N'Essen/Mülheim', CAST(N'2018-08-23T02:31:50.350' AS DateTime), 0, 250, 133, 2135, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1620, N'Moskau', N'Berlin', CAST(N'2018-04-24T12:31:50.377' AS DateTime), 0, 250, 13, 2111, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1621, N'Paris', N'Mailand', CAST(N'2018-09-03T03:48:50.423' AS DateTime), 0, 250, 144, 2038, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1622, N'Madrid', N'Dallas', CAST(N'2018-05-06T13:55:50.443' AS DateTime), 0, 250, 25, 2100, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1623, N'New York', N'Seattle', CAST(N'2018-09-14T05:05:50.467' AS DateTime), 0, 250, 155, 2179, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1624, N'New York', N'Madrid', CAST(N'2018-05-17T15:12:50.487' AS DateTime), 0, 250, 36, 2093, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1625, N'Paris', N'Rom', CAST(N'2018-09-25T06:22:50.507' AS DateTime), 0, 250, 166, 2093, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1626, N'New York', N'Kapstadt', CAST(N'2018-05-28T16:29:50.530' AS DateTime), 0, 250, 47, 2169, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1627, N'Köln/Bonn', N'New York', CAST(N'2018-10-07T07:46:50.553' AS DateTime), 0, 250, 178, 2054, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1628, N'Rom', N'Moskau', CAST(N'2018-06-08T17:46:50.573' AS DateTime), 0, 250, 54, 2179, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1629, N'Dallas', N'Berlin', CAST(N'2018-10-18T09:03:50.597' AS DateTime), 0, 250, 189, 2083, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1630, N'Berlin', N'Essen/Mülheim', CAST(N'2018-06-19T19:03:50.650' AS DateTime), 0, 250, 69, 2141, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1631, N'Hamburg', N'Rom', CAST(N'2018-10-29T10:20:50.690' AS DateTime), 0, 250, 200, 2027, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1632, N'Kapstadt', N'Hamburg', CAST(N'2018-07-01T20:27:50.710' AS DateTime), 0, 250, 81, 2110, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1633, N'Mailand', N'Prag', CAST(N'2018-11-09T11:37:50.727' AS DateTime), 0, 250, 211, 2195, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1634, N'Paris', N'München', CAST(N'2018-07-12T21:44:50.740' AS DateTime), 0, 250, 92, 2192, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1635, N'Frankfurt', N'New York', CAST(N'2018-11-20T12:54:50.750' AS DateTime), 0, 250, 222, 2079, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1636, N'Oslo', N'Rom', CAST(N'2018-07-23T23:01:50.760' AS DateTime), 0, 250, 103, 2010, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1637, N'Essen/Mülheim', N'Hamburg', CAST(N'2018-12-02T14:18:50.780' AS DateTime), 0, 250, 234, 2062, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1638, N'Essen/Mülheim', N'Hamburg', CAST(N'2018-08-04T00:18:50.790' AS DateTime), 0, 250, 114, 2175, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1639, N'Prag', N'Seattle', CAST(N'2018-12-13T15:35:50.800' AS DateTime), 0, 250, 245, 2178, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1640, N'Madrid', N'Paris', CAST(N'2018-08-15T01:35:50.810' AS DateTime), 0, 250, 125, 2153, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1641, N'Oslo', N'München', CAST(N'2018-04-17T11:42:50.817' AS DateTime), 0, 250, 6, 2055, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1642, N'Frankfurt', N'Hamburg', CAST(N'2018-08-27T02:59:50.827' AS DateTime), 0, 250, 137, 2130, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1643, N'Mailand', N'Köln/Bonn', CAST(N'2018-04-28T12:59:50.837' AS DateTime), 0, 250, 17, 2078, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1644, N'Seattle', N'New York', CAST(N'2018-09-07T04:16:50.847' AS DateTime), 0, 250, 148, 2169, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1645, N'München', N'London', CAST(N'2018-05-09T14:16:50.853' AS DateTime), 0, 250, 28, 2044, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1646, N'Dallas', N'Prag', CAST(N'2018-09-18T05:33:50.870' AS DateTime), 0, 250, 159, 2015, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1647, N'Essen/Mülheim', N'London', CAST(N'2018-05-21T15:40:50.880' AS DateTime), 0, 250, 40, 2049, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1648, N'Moskau', N'Paris', CAST(N'2018-09-29T06:50:50.897' AS DateTime), 0, 250, 170, 2084, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1649, N'München', N'Köln/Bonn', CAST(N'2018-06-01T16:57:50.913' AS DateTime), 0, 250, 51, 2056, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1650, N'Mailand', N'New York', CAST(N'2018-10-11T08:14:50.923' AS DateTime), 0, 250, 182, 2147, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1651, N'Madrid', N'München', CAST(N'2018-06-12T18:14:50.933' AS DateTime), 0, 250, 62, 2001, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1652, N'London', N'Berlin', CAST(N'2018-10-22T09:31:50.943' AS DateTime), 0, 250, 193, 2186, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1653, N'London', N'Rom', CAST(N'2018-06-23T19:31:50.957' AS DateTime), 0, 250, 73, 2143, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1654, N'New York', N'Moskau', CAST(N'2018-11-02T10:48:50.977' AS DateTime), 0, 250, 204, 2102, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1655, N'Kapstadt', N'Moskau', CAST(N'2018-07-05T20:55:50.987' AS DateTime), 0, 250, 85, 2023, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1656, N'London', N'Seattle', CAST(N'2018-11-13T12:05:50.997' AS DateTime), 0, 250, 215, 2035, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1657, N'Mailand', N'Oslo', CAST(N'2018-07-16T22:12:51.003' AS DateTime), 0, 250, 96, 2044, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1658, N'Moskau', N'Frankfurt', CAST(N'2018-11-24T13:22:51.013' AS DateTime), 0, 250, 226, 2011, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1659, N'Prag', N'London', CAST(N'2018-07-27T23:29:51.023' AS DateTime), 0, 250, 107, 2147, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1660, N'Madrid', N'Dallas', CAST(N'2018-12-06T14:46:51.030' AS DateTime), 0, 250, 238, 2188, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1661, N'London', N'Berlin', CAST(N'2018-08-08T00:46:51.047' AS DateTime), 0, 250, 118, 2121, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1662, N'New York', N'Madrid', CAST(N'2018-12-17T16:03:51.063' AS DateTime), 0, 250, 249, 2105, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1663, N'Madrid', N'Essen/Mülheim', CAST(N'2018-08-19T02:03:51.093' AS DateTime), 0, 250, 129, 2062, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1664, N'Rom', N'New York', CAST(N'2018-04-21T12:10:51.110' AS DateTime), 0, 250, 6, 2039, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1665, N'London', N'Frankfurt', CAST(N'2018-08-31T03:27:51.120' AS DateTime), 0, 250, 141, 2155, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1666, N'Kapstadt', N'Rom', CAST(N'2018-05-02T13:27:51.130' AS DateTime), 0, 250, 21, 2157, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1667, N'Prag', N'Frankfurt', CAST(N'2018-09-11T04:44:51.140' AS DateTime), 0, 250, 152, 2192, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1668, N'Essen/Mülheim', N'Prag', CAST(N'2018-05-13T14:44:51.147' AS DateTime), 0, 250, 32, 2049, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1669, N'Berlin', N'Dallas', CAST(N'2018-09-22T06:01:51.157' AS DateTime), 0, 250, 163, 2172, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1670, N'Seattle', N'Hamburg', CAST(N'2018-05-25T16:08:51.190' AS DateTime), 0, 250, 44, 2097, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1671, N'London', N'Essen/Mülheim', CAST(N'2018-10-03T07:18:51.200' AS DateTime), 0, 250, 174, 2056, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1672, N'Moskau', N'Oslo', CAST(N'2018-06-05T17:25:51.210' AS DateTime), 0, 250, 55, 2028, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1673, N'Essen/Mülheim', N'Moskau', CAST(N'2018-10-14T08:35:51.220' AS DateTime), 0, 250, 185, 2100, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1674, N'Dallas', N'Madrid', CAST(N'2018-06-16T18:42:51.230' AS DateTime), 0, 250, 66, 2042, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1675, N'Köln/Bonn', N'Berlin', CAST(N'2018-10-26T09:59:51.243' AS DateTime), 0, 250, 197, 2051, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1676, N'Berlin', N'Köln/Bonn', CAST(N'2018-06-27T19:59:51.253' AS DateTime), 0, 250, 77, 2158, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1677, N'Moskau', N'Oslo', CAST(N'2018-11-06T11:16:51.260' AS DateTime), 0, 250, 208, 2110, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1678, N'Hamburg', N'Paris', CAST(N'2018-07-08T21:16:51.277' AS DateTime), 0, 250, 88, 2055, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1679, N'Berlin', N'Madrid', CAST(N'2018-11-17T12:33:51.287' AS DateTime), 0, 250, 219, 2027, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1680, N'Moskau', N'Mailand', CAST(N'2018-07-20T22:40:51.293' AS DateTime), 0, 250, 100, 2177, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1681, N'Oslo', N'Moskau', CAST(N'2018-11-28T13:50:51.303' AS DateTime), 0, 250, 230, 2019, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1682, N'München', N'Madrid', CAST(N'2018-07-31T23:57:51.313' AS DateTime), 0, 250, 111, 2116, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1683, N'Kapstadt', N'Hamburg', CAST(N'2018-12-10T15:14:51.320' AS DateTime), 0, 250, 242, 2167, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1684, N'New York', N'Berlin', CAST(N'2018-08-12T01:14:51.330' AS DateTime), 0, 250, 122, 2144, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1685, N'Rom', N'Moskau', CAST(N'2018-04-14T11:21:51.337' AS DateTime), 0, 250, -1, 2047, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1686, N'Essen/Mülheim', N'Prag', CAST(N'2018-08-23T02:31:51.347' AS DateTime), 0, 250, 133, 2099, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1687, N'Dallas', N'Berlin', CAST(N'2018-04-25T12:38:51.367' AS DateTime), 0, 250, 14, 2136, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1688, N'Frankfurt', N'München', CAST(N'2018-09-04T03:55:51.373' AS DateTime), 0, 250, 145, 2051, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1689, N'Oslo', N'Hamburg', CAST(N'2018-05-06T13:55:51.383' AS DateTime), 0, 250, 25, 2073, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1690, N'Berlin', N'Prag', CAST(N'2018-09-15T05:12:51.390' AS DateTime), 0, 250, 156, 2010, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1691, N'Berlin', N'München', CAST(N'2018-05-17T15:12:51.400' AS DateTime), 0, 250, 36, 2019, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1692, N'New York', N'Berlin', CAST(N'2018-09-26T06:29:51.407' AS DateTime), 0, 250, 167, 2052, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1693, N'München', N'Frankfurt', CAST(N'2018-05-29T16:36:51.417' AS DateTime), 0, 250, 48, 2038, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1694, N'Seattle', N'Hamburg', CAST(N'2018-10-07T07:46:51.427' AS DateTime), 0, 250, 178, 2016, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1695, N'Dallas', N'Oslo', CAST(N'2018-06-09T17:53:51.437' AS DateTime), 0, 250, 59, 2178, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1696, N'Kapstadt', N'Madrid', CAST(N'2018-10-18T09:03:51.453' AS DateTime), 0, 250, 189, 2165, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1697, N'Berlin', N'Rom', CAST(N'2018-06-20T19:10:51.467' AS DateTime), 0, 250, 70, 2070, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1698, N'Mailand', N'Hamburg', CAST(N'2018-10-30T10:27:51.473' AS DateTime), 0, 250, 201, 2166, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1699, N'Mailand', N'Madrid', CAST(N'2018-07-01T20:27:51.483' AS DateTime), 0, 250, 81, 2045, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1700, N'New York', N'Hamburg', CAST(N'2018-11-10T11:44:51.493' AS DateTime), 0, 250, 212, 2161, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1701, N'New York', N'Kapstadt', CAST(N'2018-07-12T21:44:51.503' AS DateTime), 0, 250, 92, 2125, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1702, N'Oslo', N'New York', CAST(N'2018-11-21T13:01:51.513' AS DateTime), 0, 250, 223, 2134, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1703, N'Prag', N'Dallas', CAST(N'2018-07-24T23:08:51.533' AS DateTime), 0, 250, 104, 2127, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1704, N'Paris', N'Rom', CAST(N'2018-12-02T14:18:51.547' AS DateTime), 0, 250, 234, 2063, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1705, N'Kapstadt', N'Moskau', CAST(N'2018-08-05T00:25:51.557' AS DateTime), 0, 250, 115, 2024, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1706, N'Hamburg', N'London', CAST(N'2018-12-13T15:35:51.563' AS DateTime), 0, 250, 245, 2021, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1707, N'Rom', N'Prag', CAST(N'2018-08-16T01:42:51.573' AS DateTime), 0, 250, 122, 2194, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1708, N'Köln/Bonn', N'Seattle', CAST(N'2018-04-18T11:49:51.583' AS DateTime), 0, 250, 7, 2074, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1709, N'Prag', N'New York', CAST(N'2018-08-27T02:59:51.593' AS DateTime), 0, 250, 137, 2081, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1710, N'Hamburg', N'Kapstadt', CAST(N'2018-04-29T13:06:51.603' AS DateTime), 0, 250, 18, 2055, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1711, N'Madrid', N'Prag', CAST(N'2018-09-07T04:16:51.620' AS DateTime), 0, 250, 148, 2092, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1712, N'London', N'Paris', CAST(N'2018-05-10T14:23:51.630' AS DateTime), 0, 250, 29, 2035, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1713, N'Rom', N'Dallas', CAST(N'2018-09-19T05:40:51.637' AS DateTime), 0, 250, 156, 2041, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1714, N'Hamburg', N'Rom', CAST(N'2018-05-21T15:40:51.647' AS DateTime), 0, 250, 40, 2012, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1715, N'New York', N'Dallas', CAST(N'2018-09-30T06:57:51.657' AS DateTime), 0, 250, 171, 2066, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1716, N'Rom', N'New York', CAST(N'2018-06-02T17:04:51.667' AS DateTime), 0, 250, 48, 2121, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1717, N'Seattle', N'Köln/Bonn', CAST(N'2018-10-11T08:14:51.680' AS DateTime), 0, 250, 182, 2095, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1718, N'München', N'London', CAST(N'2018-06-13T18:21:51.693' AS DateTime), 0, 250, 63, 2135, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1719, N'Madrid', N'Paris', CAST(N'2018-10-22T09:31:51.707' AS DateTime), 0, 250, 193, 2017, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1720, N'Köln/Bonn', N'London', CAST(N'2018-06-24T19:38:51.740' AS DateTime), 0, 250, 74, 2002, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1721, N'Köln/Bonn', N'Rom', CAST(N'2018-11-03T10:55:51.753' AS DateTime), 0, 250, 205, 2038, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1722, N'London', N'Prag', CAST(N'2018-07-05T20:55:51.763' AS DateTime), 0, 250, 85, 2154, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1723, N'Madrid', N'Paris', CAST(N'2018-11-14T12:12:51.770' AS DateTime), 0, 250, 216, 2036, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1724, N'Dallas', N'Oslo', CAST(N'2018-07-16T22:12:51.780' AS DateTime), 0, 250, 96, 2075, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1725, N'Oslo', N'Frankfurt', CAST(N'2018-11-25T13:29:51.790' AS DateTime), 0, 250, 227, 2050, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1726, N'Oslo', N'Moskau', CAST(N'2018-07-28T23:36:51.800' AS DateTime), 0, 250, 108, 2151, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1727, N'Berlin', N'Köln/Bonn', CAST(N'2018-12-06T14:46:51.810' AS DateTime), 0, 250, 238, 2195, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1728, N'Kapstadt', N'Mailand', CAST(N'2018-08-09T00:53:51.817' AS DateTime), 0, 250, 119, 2104, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1729, N'Kapstadt', N'Essen/Mülheim', CAST(N'2018-12-17T16:03:51.837' AS DateTime), 0, 250, 249, 2038, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1730, N'Kapstadt', N'Prag', CAST(N'2018-08-20T02:10:51.850' AS DateTime), 0, 250, 130, 2003, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1731, N'Frankfurt', N'Berlin', CAST(N'2018-04-22T12:17:51.857' AS DateTime), 0, 250, 11, 2122, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1732, N'Hamburg', N'Oslo', CAST(N'2018-08-31T03:27:51.867' AS DateTime), 0, 250, 141, 2193, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1733, N'Madrid', N'Rom', CAST(N'2018-05-03T13:34:51.877' AS DateTime), 0, 250, 22, 2083, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1734, N'Moskau', N'Mailand', CAST(N'2018-09-11T04:44:51.887' AS DateTime), 0, 250, 152, 2040, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1735, N'Paris', N'Essen/Mülheim', CAST(N'2018-05-14T14:51:51.900' AS DateTime), 0, 250, 33, 2074, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1736, N'Frankfurt', N'Köln/Bonn', CAST(N'2018-09-23T06:08:51.910' AS DateTime), 0, 250, 164, 2052, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1737, N'Paris', N'Oslo', CAST(N'2018-05-25T16:08:51.920' AS DateTime), 0, 250, 44, 2164, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1738, N'Rom', N'Hamburg', CAST(N'2018-10-04T07:25:51.927' AS DateTime), 0, 250, 171, 2031, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1739, N'Berlin', N'Mailand', CAST(N'2018-06-05T17:25:51.937' AS DateTime), 0, 250, 55, 2165, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1740, N'Seattle', N'Moskau', CAST(N'2018-10-15T08:42:51.947' AS DateTime), 0, 250, 186, 2157, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1741, N'Moskau', N'Frankfurt', CAST(N'2018-06-17T18:49:51.953' AS DateTime), 0, 250, 67, 2179, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1742, N'Hamburg', N'Madrid', CAST(N'2018-10-26T09:59:51.963' AS DateTime), 0, 250, 197, 2170, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1743, N'Essen/Mülheim', N'Seattle', CAST(N'2018-06-28T20:06:51.973' AS DateTime), 0, 250, 78, 2030, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1744, N'Rom', N'Berlin', CAST(N'2018-11-06T11:16:51.990' AS DateTime), 0, 250, 204, 2060, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1745, N'London', N'Mailand', CAST(N'2018-07-09T21:23:52.007' AS DateTime), 0, 250, 89, 2154, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1746, N'Essen/Mülheim', N'London', CAST(N'2018-11-18T12:40:52.020' AS DateTime), 0, 250, 220, 2145, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1747, N'München', N'Seattle', CAST(N'2018-07-20T22:40:52.037' AS DateTime), 0, 250, 100, 2105, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1748, N'Oslo', N'London', CAST(N'2018-11-29T13:57:52.050' AS DateTime), 0, 250, 231, 2124, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1749, N'Hamburg', N'Essen/Mülheim', CAST(N'2018-08-02T00:04:52.067' AS DateTime), 0, 250, 112, 2166, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1750, N'Mailand', N'München', CAST(N'2018-12-10T15:14:52.080' AS DateTime), 0, 250, 242, 2094, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1751, N'München', N'Hamburg', CAST(N'2018-08-13T01:21:52.103' AS DateTime), 0, 250, 123, 2145, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1752, N'New York', N'Dallas', CAST(N'2018-04-14T11:21:52.120' AS DateTime), 0, 250, 3, 2077, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1753, N'Rom', N'Köln/Bonn', CAST(N'2018-08-24T02:38:52.147' AS DateTime), 0, 250, 130, 2182, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1754, N'Prag', N'London', CAST(N'2018-04-26T12:45:52.157' AS DateTime), 0, 250, 15, 2104, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1755, N'Frankfurt', N'München', CAST(N'2018-09-04T03:55:52.167' AS DateTime), 0, 250, 145, 2177, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1756, N'Prag', N'Dallas', CAST(N'2018-05-07T14:02:52.177' AS DateTime), 0, 250, 26, 2146, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1757, N'London', N'Köln/Bonn', CAST(N'2018-09-15T05:12:52.183' AS DateTime), 0, 250, 156, 2021, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1758, N'Frankfurt', N'Prag', CAST(N'2018-05-18T15:19:52.190' AS DateTime), 0, 250, 37, 2173, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1759, N'Köln/Bonn', N'New York', CAST(N'2018-09-27T06:36:52.200' AS DateTime), 0, 250, 168, 2140, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1760, N'Köln/Bonn', N'Dallas', CAST(N'2018-05-29T16:36:52.210' AS DateTime), 0, 250, 48, 2021, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1761, N'Berlin', N'Rom', CAST(N'2018-10-08T07:53:52.217' AS DateTime), 0, 250, 179, 2109, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1762, N'Seattle', N'München', CAST(N'2018-06-09T17:53:52.237' AS DateTime), 0, 250, 59, 2168, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1763, N'Moskau', N'Seattle', CAST(N'2018-10-19T09:10:52.247' AS DateTime), 0, 250, 190, 2101, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1764, N'London', N'Mailand', CAST(N'2018-06-21T19:17:52.257' AS DateTime), 0, 250, 71, 2022, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1765, N'Kapstadt', N'New York', CAST(N'2018-10-30T10:27:52.263' AS DateTime), 0, 250, 201, 2073, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1766, N'Berlin', N'Kapstadt', CAST(N'2018-07-02T20:34:52.273' AS DateTime), 0, 250, 82, 2045, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1767, N'Essen/Mülheim', N'Seattle', CAST(N'2018-11-10T11:44:52.280' AS DateTime), 0, 250, 212, 2153, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1768, N'Oslo', N'London', CAST(N'2018-07-13T21:51:52.297' AS DateTime), 0, 250, 93, 2010, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1769, N'Seattle', N'Madrid', CAST(N'2018-11-22T13:08:52.307' AS DateTime), 0, 250, 224, 2073, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1770, N'Rom', N'Seattle', CAST(N'2018-07-24T23:08:52.313' AS DateTime), 0, 250, 100, 2007, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1771, N'Rom', N'Kapstadt', CAST(N'2018-12-03T14:25:52.323' AS DateTime), 0, 250, 231, 2101, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1772, N'Berlin', N'Dallas', CAST(N'2018-08-05T00:25:52.330' AS DateTime), 0, 250, 115, 2086, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1773, N'Dallas', N'Köln/Bonn', CAST(N'2018-12-14T15:42:52.340' AS DateTime), 0, 250, 246, 2045, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1774, N'Dallas', N'Kapstadt', CAST(N'2018-08-17T01:49:52.350' AS DateTime), 0, 250, 127, 2199, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1775, N'Rom', N'Oslo', CAST(N'2018-04-18T11:49:52.357' AS DateTime), 0, 250, 3, 2100, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1776, N'Köln/Bonn', N'Kapstadt', CAST(N'2018-08-28T03:06:52.367' AS DateTime), 0, 250, 138, 2096, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1777, N'Prag', N'Rom', CAST(N'2018-04-30T13:13:52.387' AS DateTime), 0, 250, 19, 2068, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1778, N'Oslo', N'Köln/Bonn', CAST(N'2018-09-08T04:23:52.393' AS DateTime), 0, 250, 149, 2128, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1779, N'Rom', N'Frankfurt', CAST(N'2018-05-11T14:30:52.403' AS DateTime), 0, 250, 26, 2032, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1780, N'Seattle', N'London', CAST(N'2018-09-19T05:40:52.410' AS DateTime), 0, 250, 160, 2035, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1781, N'Seattle', N'Paris', CAST(N'2018-05-22T15:47:52.420' AS DateTime), 0, 250, 41, 2164, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1782, N'Berlin', N'München', CAST(N'2018-10-01T07:04:52.427' AS DateTime), 0, 250, 172, 2068, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1783, N'Berlin', N'Paris', CAST(N'2018-06-02T17:04:52.437' AS DateTime), 0, 250, 52, 2044, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1784, N'Seattle', N'Essen/Mülheim', CAST(N'2018-10-12T08:21:52.443' AS DateTime), 0, 250, 183, 2098, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1785, N'Madrid', N'Frankfurt', CAST(N'2018-06-13T18:21:52.453' AS DateTime), 0, 250, 63, 2024, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1786, N'London', N'Essen/Mülheim', CAST(N'2018-10-23T09:38:52.470' AS DateTime), 0, 250, 194, 2158, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1787, N'London', N'Frankfurt', CAST(N'2018-06-25T19:45:52.480' AS DateTime), 0, 250, 75, 2103, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1788, N'Hamburg', N'Mailand', CAST(N'2018-11-03T10:55:52.487' AS DateTime), 0, 250, 205, 2197, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1789, N'Mailand', N'Moskau', CAST(N'2018-07-06T21:02:52.497' AS DateTime), 0, 250, 86, 2159, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1790, N'Rom', N'München', CAST(N'2018-11-14T12:12:52.507' AS DateTime), 0, 250, 212, 2181, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1791, N'Madrid', N'Köln/Bonn', CAST(N'2018-07-17T22:19:52.513' AS DateTime), 0, 250, 97, 2186, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1792, N'Berlin', N'Rom', CAST(N'2018-11-26T13:36:52.520' AS DateTime), 0, 250, 228, 2070, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1793, N'Hamburg', N'Rom', CAST(N'2018-07-28T23:36:52.530' AS DateTime), 0, 250, 108, 2153, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1794, N'München', N'Köln/Bonn', CAST(N'2018-12-07T14:53:52.540' AS DateTime), 0, 250, 239, 2084, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1795, N'Köln/Bonn', N'Madrid', CAST(N'2018-08-09T00:53:52.573' AS DateTime), 0, 250, 119, 2115, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1796, N'Madrid', N'Berlin', CAST(N'2018-04-11T11:00:52.583' AS DateTime), 0, 250, 0, 2029, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1797, N'Prag', N'Oslo', CAST(N'2018-08-21T02:17:52.593' AS DateTime), 0, 250, 131, 2067, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1798, N'Köln/Bonn', N'New York', CAST(N'2018-04-22T12:17:52.603' AS DateTime), 0, 250, 11, 2099, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1799, N'Oslo', N'Madrid', CAST(N'2018-09-01T03:34:52.613' AS DateTime), 0, 250, 142, 2107, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1800, N'Seattle', N'Rom', CAST(N'2018-05-03T13:34:52.627' AS DateTime), 0, 250, 22, 2062, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1801, N'Kapstadt', N'Mailand', CAST(N'2018-09-12T04:51:52.647' AS DateTime), 0, 250, 153, 2111, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1802, N'Essen/Mülheim', N'Hamburg', CAST(N'2018-05-15T14:58:52.657' AS DateTime), 0, 250, 34, 2096, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1803, N'Berlin', N'Hamburg', CAST(N'2018-09-23T06:08:52.663' AS DateTime), 0, 250, 164, 2177, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1804, N'Frankfurt', N'Dallas', CAST(N'2018-05-26T16:15:52.673' AS DateTime), 0, 250, 45, 2131, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1805, N'Paris', N'New York', CAST(N'2018-10-04T07:25:52.683' AS DateTime), 0, 250, 175, 2108, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1806, N'New York', N'Kapstadt', CAST(N'2018-06-06T17:32:52.690' AS DateTime), 0, 250, 56, 2034, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1807, N'Moskau', N'Prag', CAST(N'2018-10-16T08:49:52.700' AS DateTime), 0, 250, 187, 2177, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1808, N'Seattle', N'Paris', CAST(N'2018-06-17T18:49:52.707' AS DateTime), 0, 250, 67, 2159, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1809, N'Paris', N'London', CAST(N'2018-10-27T10:06:52.717' AS DateTime), 0, 250, 198, 2149, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1810, N'Köln/Bonn', N'New York', CAST(N'2018-06-29T20:13:52.737' AS DateTime), 0, 250, 79, 2104, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1811, N'München', N'Dallas', CAST(N'2018-11-07T11:23:52.743' AS DateTime), 0, 250, 209, 2008, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1812, N'Frankfurt', N'Rom', CAST(N'2018-07-10T21:30:52.753' AS DateTime), 0, 250, 90, 2045, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1813, N'London', N'Essen/Mülheim', CAST(N'2018-11-18T12:40:52.760' AS DateTime), 0, 250, 220, 2149, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1814, N'Madrid', N'London', CAST(N'2018-07-21T22:47:52.770' AS DateTime), 0, 250, 101, 2031, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1815, N'London', N'Moskau', CAST(N'2018-11-30T14:04:52.780' AS DateTime), 0, 250, 232, 2109, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1816, N'Rom', N'Paris', CAST(N'2018-08-02T00:04:52.787' AS DateTime), 0, 250, 108, 2182, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1817, N'Berlin', N'Madrid', CAST(N'2018-12-11T15:21:52.797' AS DateTime), 0, 250, 243, 2178, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1818, N'München', N'Essen/Mülheim', CAST(N'2018-08-13T01:21:52.807' AS DateTime), 0, 250, 123, 2057, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1819, N'Moskau', N'Madrid', CAST(N'2018-04-15T11:28:52.823' AS DateTime), 0, 250, 4, 2086, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1820, N'Dallas', N'London', CAST(N'2018-08-25T02:45:52.833' AS DateTime), 0, 250, 135, 2171, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1821, N'Essen/Mülheim', N'Kapstadt', CAST(N'2018-04-26T12:45:52.840' AS DateTime), 0, 250, 15, 2115, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1822, N'London', N'Dallas', CAST(N'2018-09-05T04:02:52.850' AS DateTime), 0, 250, 146, 2001, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1823, N'New York', N'Rom', CAST(N'2018-05-07T14:02:52.857' AS DateTime), 0, 250, 26, 2066, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1824, N'Frankfurt', N'Paris', CAST(N'2018-09-16T05:19:52.867' AS DateTime), 0, 250, 157, 2144, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1825, N'Hamburg', N'Essen/Mülheim', CAST(N'2018-05-19T15:26:52.883' AS DateTime), 0, 250, 38, 2069, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1826, N'Kapstadt', N'Köln/Bonn', CAST(N'2018-09-27T06:36:52.897' AS DateTime), 0, 250, 168, 2026, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1827, N'Oslo', N'Madrid', CAST(N'2018-05-30T16:43:52.917' AS DateTime), 0, 250, 49, 2044, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1828, N'Essen/Mülheim', N'New York', CAST(N'2018-10-08T07:53:52.930' AS DateTime), 0, 250, 179, 2006, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1829, N'Hamburg', N'Essen/Mülheim', CAST(N'2018-06-10T18:00:52.940' AS DateTime), 0, 250, 60, 2098, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1830, N'Paris', N'Kapstadt', CAST(N'2018-10-20T09:17:52.950' AS DateTime), 0, 250, 191, 2071, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1831, N'Paris', N'Oslo', CAST(N'2018-06-21T19:17:52.957' AS DateTime), 0, 250, 71, 2025, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1832, N'Prag', N'Moskau', CAST(N'2018-10-31T10:34:52.967' AS DateTime), 0, 250, 202, 2197, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1833, N'New York', N'Prag', CAST(N'2018-07-02T20:34:52.977' AS DateTime), 0, 250, 82, 2133, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1834, N'Frankfurt', N'Moskau', CAST(N'2018-11-11T11:51:52.990' AS DateTime), 0, 250, 213, 2138, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1835, N'Moskau', N'Madrid', CAST(N'2018-07-14T21:58:53.000' AS DateTime), 0, 250, 94, 2138, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1836, N'Berlin', N'Frankfurt', CAST(N'2018-11-22T13:08:53.010' AS DateTime), 0, 250, 224, 2173, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1837, N'Prag', N'New York', CAST(N'2018-07-25T23:15:53.017' AS DateTime), 0, 250, 105, 2149, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1838, N'Köln/Bonn', N'Dallas', CAST(N'2018-12-03T14:25:53.027' AS DateTime), 0, 250, 235, 2179, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1839, N'Moskau', N'Madrid', CAST(N'2018-08-06T00:32:53.037' AS DateTime), 0, 250, 116, 2147, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1840, N'Oslo', N'Kapstadt', CAST(N'2018-12-15T15:49:53.047' AS DateTime), 0, 250, 247, 2172, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1841, N'Kapstadt', N'Oslo', CAST(N'2018-08-17T01:49:53.053' AS DateTime), 0, 250, 127, 2104, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1842, N'Dallas', N'Seattle', CAST(N'2018-04-19T11:56:53.063' AS DateTime), 0, 250, 8, 2106, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1843, N'Moskau', N'New York', CAST(N'2018-08-29T03:13:53.080' AS DateTime), 0, 250, 139, 2031, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1844, N'London', N'Hamburg', CAST(N'2018-04-30T13:13:53.087' AS DateTime), 0, 250, 19, 2141, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1845, N'Mailand', N'Kapstadt', CAST(N'2018-09-09T04:30:53.097' AS DateTime), 0, 250, 150, 2050, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1846, N'Prag', N'München', CAST(N'2018-05-11T14:30:53.107' AS DateTime), 0, 250, 30, 2159, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1847, N'London', N'Hamburg', CAST(N'2018-09-20T05:47:53.113' AS DateTime), 0, 250, 161, 2130, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1848, N'New York', N'Oslo', CAST(N'2018-05-23T15:54:53.123' AS DateTime), 0, 250, 42, 2036, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1849, N'Moskau', N'München', CAST(N'2018-10-01T07:04:53.133' AS DateTime), 0, 250, 172, 2189, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1850, N'Köln/Bonn', N'Dallas', CAST(N'2018-06-03T17:11:53.147' AS DateTime), 0, 250, 53, 2149, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1851, N'Köln/Bonn', N'Seattle', CAST(N'2018-10-12T08:21:53.180' AS DateTime), 0, 250, 183, 2152, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1852, N'Kapstadt', N'Köln/Bonn', CAST(N'2018-06-14T18:28:53.197' AS DateTime), 0, 250, 64, 2137, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1853, N'Hamburg', N'New York', CAST(N'2018-10-24T09:45:53.213' AS DateTime), 0, 250, 195, 2034, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1854, N'München', N'Paris', CAST(N'2018-06-25T19:45:53.227' AS DateTime), 0, 250, 75, 2094, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1855, N'Seattle', N'München', CAST(N'2018-11-04T11:02:53.237' AS DateTime), 0, 250, 206, 2082, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1856, N'Berlin', N'Essen/Mülheim', CAST(N'2018-07-06T21:02:53.250' AS DateTime), 0, 250, 86, 2028, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1857, N'New York', N'Berlin', CAST(N'2018-11-15T12:19:53.260' AS DateTime), 0, 250, 217, 2134, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1858, N'Oslo', N'Moskau', CAST(N'2018-07-18T22:26:53.270' AS DateTime), 0, 250, 98, 2118, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1859, N'Dallas', N'London', CAST(N'2018-11-26T13:36:53.280' AS DateTime), 0, 250, 228, 2069, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1860, N'Prag', N'Moskau', CAST(N'2018-07-29T23:43:53.310' AS DateTime), 0, 250, 109, 2075, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1861, N'Seattle', N'Paris', CAST(N'2018-12-07T14:53:53.320' AS DateTime), 0, 250, 239, 2021, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1862, N'Prag', N'Dallas', CAST(N'2018-08-10T01:00:53.333' AS DateTime), 0, 250, 120, 2130, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1863, N'Prag', N'Moskau', CAST(N'2018-04-12T11:07:53.343' AS DateTime), 0, 250, 1, 2073, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1864, N'Prag', N'New York', CAST(N'2018-08-21T02:17:53.357' AS DateTime), 0, 250, 131, 2036, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1865, N'Kapstadt', N'Hamburg', CAST(N'2018-04-23T12:24:53.367' AS DateTime), 0, 250, 12, 2181, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1866, N'Moskau', N'London', CAST(N'2018-09-01T03:34:53.390' AS DateTime), 0, 250, 142, 2161, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1867, N'Moskau', N'Oslo', CAST(N'2018-05-04T13:41:53.407' AS DateTime), 0, 250, 23, 2015, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1868, N'Rom', N'Frankfurt', CAST(N'2018-09-13T04:58:53.420' AS DateTime), 0, 250, 150, 2034, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1869, N'Moskau', N'Frankfurt', CAST(N'2018-05-15T14:58:53.437' AS DateTime), 0, 250, 34, 2138, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1870, N'Kapstadt', N'Rom', CAST(N'2018-09-24T06:15:53.447' AS DateTime), 0, 250, 165, 2131, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1871, N'Moskau', N'Berlin', CAST(N'2018-05-27T16:22:53.457' AS DateTime), 0, 250, 46, 2160, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1872, N'Rom', N'Frankfurt', CAST(N'2018-10-05T07:32:53.467' AS DateTime), 0, 250, 172, 2180, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1873, N'Frankfurt', N'München', CAST(N'2018-06-07T17:39:53.473' AS DateTime), 0, 250, 57, 2121, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1874, N'Frankfurt', N'Seattle', CAST(N'2018-10-16T08:49:53.483' AS DateTime), 0, 250, 187, 2026, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1875, N'Rom', N'Paris', CAST(N'2018-06-18T18:56:53.500' AS DateTime), 0, 250, 64, 2161, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1876, N'Berlin', N'Rom', CAST(N'2018-10-28T10:13:53.510' AS DateTime), 0, 250, 199, 2051, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1877, N'Moskau', N'Essen/Mülheim', CAST(N'2018-06-29T20:13:53.517' AS DateTime), 0, 250, 79, 2027, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1878, N'Essen/Mülheim', N'Kapstadt', CAST(N'2018-11-08T11:30:53.527' AS DateTime), 0, 250, 210, 2151, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1879, N'Rom', N'Kapstadt', CAST(N'2018-07-10T21:30:53.537' AS DateTime), 0, 250, 86, 2082, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1880, N'Essen/Mülheim', N'Berlin', CAST(N'2018-11-19T12:47:53.543' AS DateTime), 0, 250, 221, 2093, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1881, N'Madrid', N'Prag', CAST(N'2018-07-22T22:54:53.553' AS DateTime), 0, 250, 102, 2052, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1882, N'Dallas', N'Moskau', CAST(N'2018-11-30T14:04:53.563' AS DateTime), 0, 250, 232, 2148, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1883, N'London', N'Moskau', CAST(N'2018-08-03T00:11:53.570' AS DateTime), 0, 250, 113, 2136, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1884, N'Madrid', N'Mailand', CAST(N'2018-12-11T15:21:53.590' AS DateTime), 0, 250, 243, 2051, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1885, N'Hamburg', N'Mailand', CAST(N'2018-08-14T01:28:53.600' AS DateTime), 0, 250, 124, 2045, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1886, N'Dallas', N'Berlin', CAST(N'2018-04-16T11:35:53.607' AS DateTime), 0, 250, 5, 2137, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1887, N'London', N'Moskau', CAST(N'2018-08-25T02:45:53.617' AS DateTime), 0, 250, 135, 2152, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1888, N'Paris', N'Köln/Bonn', CAST(N'2018-04-27T12:52:53.627' AS DateTime), 0, 250, 16, 2102, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1889, N'Prag', N'Kapstadt', CAST(N'2018-09-05T04:02:53.633' AS DateTime), 0, 250, 146, 2049, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1890, N'Berlin', N'Dallas', CAST(N'2018-05-08T14:09:53.643' AS DateTime), 0, 250, 27, 2054, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1891, N'Mailand', N'Rom', CAST(N'2018-09-17T05:26:53.653' AS DateTime), 0, 250, 158, 2015, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1892, N'München', N'Hamburg', CAST(N'2018-05-19T15:26:53.663' AS DateTime), 0, 250, 38, 2031, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1893, N'Madrid', N'London', CAST(N'2018-09-28T06:43:53.683' AS DateTime), 0, 250, 169, 2162, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1894, N'Frankfurt', N'New York', CAST(N'2018-05-30T16:43:53.697' AS DateTime), 0, 250, 49, 2141, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1895, N'Moskau', N'Seattle', CAST(N'2018-10-09T08:00:53.707' AS DateTime), 0, 250, 180, 2060, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1896, N'Madrid', N'Moskau', CAST(N'2018-06-11T18:07:53.717' AS DateTime), 0, 250, 61, 2060, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1897, N'Prag', N'London', CAST(N'2018-10-20T09:17:53.723' AS DateTime), 0, 250, 191, 2158, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1898, N'Seattle', N'Paris', CAST(N'2018-06-22T19:24:53.733' AS DateTime), 0, 250, 72, 2097, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1899, N'Seattle', N'Paris', CAST(N'2018-10-31T10:34:53.753' AS DateTime), 0, 250, 202, 2057, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1900, N'Essen/Mülheim', N'Mailand', CAST(N'2018-07-03T20:41:53.760' AS DateTime), 0, 250, 83, 2160, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1901, N'Mailand', N'London', CAST(N'2018-11-12T11:58:53.770' AS DateTime), 0, 250, 214, 2125, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1902, N'Paris', N'London', CAST(N'2018-07-14T21:58:53.780' AS DateTime), 0, 250, 94, 2031, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1903, N'Hamburg', N'Frankfurt', CAST(N'2018-11-23T13:15:53.790' AS DateTime), 0, 250, 225, 2059, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1904, N'New York', N'Madrid', CAST(N'2018-07-26T23:22:53.800' AS DateTime), 0, 250, 106, 2059, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1905, N'Oslo', N'Berlin', CAST(N'2018-12-04T14:32:53.807' AS DateTime), 0, 250, 236, 2172, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1906, N'Prag', N'Hamburg', CAST(N'2018-08-07T00:39:53.817' AS DateTime), 0, 250, 117, 2127, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1907, N'Köln/Bonn', N'Dallas', CAST(N'2018-12-15T15:49:53.827' AS DateTime), 0, 250, 247, 2102, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1908, N'Moskau', N'Mailand', CAST(N'2018-08-18T01:56:53.843' AS DateTime), 0, 250, 128, 2155, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1909, N'Oslo', N'Moskau', CAST(N'2018-04-20T12:03:53.853' AS DateTime), 0, 250, 9, 2088, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1910, N'Essen/Mülheim', N'Madrid', CAST(N'2018-08-29T03:13:53.863' AS DateTime), 0, 250, 139, 2024, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1911, N'Madrid', N'Berlin', CAST(N'2018-05-01T13:20:53.873' AS DateTime), 0, 250, 20, 2114, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1912, N'Rom', N'Frankfurt', CAST(N'2018-09-09T04:30:53.880' AS DateTime), 0, 250, 146, 2032, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1913, N'London', N'München', CAST(N'2018-05-12T14:37:53.890' AS DateTime), 0, 250, 31, 2140, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1914, N'Prag', N'Berlin', CAST(N'2018-09-21T05:54:53.897' AS DateTime), 0, 250, 162, 2092, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1915, N'Rom', N'München', CAST(N'2018-05-23T15:54:53.907' AS DateTime), 0, 250, 38, 2168, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1916, N'München', N'Moskau', CAST(N'2018-10-02T07:11:53.917' AS DateTime), 0, 250, 173, 2130, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1917, N'Moskau', N'Essen/Mülheim', CAST(N'2018-06-03T17:11:53.937' AS DateTime), 0, 250, 53, 2108, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1918, N'Kapstadt', N'Moskau', CAST(N'2018-10-13T08:28:53.947' AS DateTime), 0, 250, 184, 2110, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1919, N'Kapstadt', N'Berlin', CAST(N'2018-06-15T18:35:53.960' AS DateTime), 0, 250, 65, 2186, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1920, N'Moskau', N'Köln/Bonn', CAST(N'2018-10-24T09:45:53.977' AS DateTime), 0, 250, 195, 2119, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1921, N'New York', N'Prag', CAST(N'2018-06-26T19:52:53.990' AS DateTime), 0, 250, 76, 2041, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1922, N'Dallas', N'Essen/Mülheim', CAST(N'2018-11-04T11:02:54.007' AS DateTime), 0, 250, 206, 2172, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1923, N'Seattle', N'Moskau', CAST(N'2018-07-07T21:09:54.023' AS DateTime), 0, 250, 87, 2193, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1924, N'Seattle', N'Hamburg', CAST(N'2018-11-16T12:26:54.037' AS DateTime), 0, 250, 218, 2014, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1925, N'Oslo', N'Seattle', CAST(N'2018-07-18T22:26:54.067' AS DateTime), 0, 250, 98, 2188, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1926, N'Berlin', N'Köln/Bonn', CAST(N'2018-11-27T13:43:54.083' AS DateTime), 0, 250, 229, 2071, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1927, N'Oslo', N'Essen/Mülheim', CAST(N'2018-07-29T23:43:54.093' AS DateTime), 0, 250, 109, 2004, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1928, N'Kapstadt', N'Hamburg', CAST(N'2018-12-08T15:00:54.103' AS DateTime), 0, 250, 240, 2028, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1929, N'Moskau', N'Frankfurt', CAST(N'2018-08-11T01:07:54.113' AS DateTime), 0, 250, 121, 2088, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1930, N'Berlin', N'Mailand', CAST(N'2018-04-12T11:07:54.123' AS DateTime), 0, 250, 1, 2010, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1931, N'Köln/Bonn', N'Essen/Mülheim', CAST(N'2018-08-22T02:24:54.137' AS DateTime), 0, 250, 132, 2177, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1932, N'Frankfurt', N'Oslo', CAST(N'2018-04-23T12:24:54.153' AS DateTime), 0, 250, 12, 2095, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1933, N'Köln/Bonn', N'London', CAST(N'2018-09-02T03:41:54.163' AS DateTime), 0, 250, 143, 2070, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1934, N'Dallas', N'Paris', CAST(N'2018-05-05T13:48:54.173' AS DateTime), 0, 250, 24, 2192, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1935, N'Seattle', N'Madrid', CAST(N'2018-09-13T04:58:54.183' AS DateTime), 0, 250, 154, 2104, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1936, N'Mailand', N'Madrid', CAST(N'2018-05-16T15:05:54.193' AS DateTime), 0, 250, 35, 2173, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1937, N'Moskau', N'Essen/Mülheim', CAST(N'2018-09-25T06:22:54.203' AS DateTime), 0, 250, 166, 2152, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1938, N'Moskau', N'New York', CAST(N'2018-05-27T16:22:54.210' AS DateTime), 0, 250, 46, 2095, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1939, N'Moskau', N'Madrid', CAST(N'2018-10-06T07:39:54.220' AS DateTime), 0, 250, 177, 2069, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1940, N'Frankfurt', N'London', CAST(N'2018-06-07T17:39:54.230' AS DateTime), 0, 250, 57, 2141, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1941, N'Paris', N'Seattle', CAST(N'2018-10-17T08:56:54.247' AS DateTime), 0, 250, 188, 2024, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1942, N'Oslo', N'Mailand', CAST(N'2018-06-19T19:03:54.257' AS DateTime), 0, 250, 69, 2095, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1943, N'Hamburg', N'Kapstadt', CAST(N'2018-10-28T10:13:54.267' AS DateTime), 0, 250, 199, 2162, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1944, N'Mailand', N'Kapstadt', CAST(N'2018-06-30T20:20:54.277' AS DateTime), 0, 250, 80, 2184, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1945, N'Berlin', N'Dallas', CAST(N'2018-11-08T11:30:54.287' AS DateTime), 0, 250, 210, 2075, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1946, N'Berlin', N'Frankfurt', CAST(N'2018-07-11T21:37:54.293' AS DateTime), 0, 250, 91, 2063, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1947, N'New York', N'Frankfurt', CAST(N'2018-11-20T12:54:54.303' AS DateTime), 0, 250, 222, 2038, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1948, N'Moskau', N'Paris', CAST(N'2018-07-22T22:54:54.313' AS DateTime), 0, 250, 102, 2142, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1949, N'Rom', N'New York', CAST(N'2018-12-01T14:11:54.323' AS DateTime), 0, 250, 229, 2016, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1950, N'Paris', N'Prag', CAST(N'2018-08-03T00:11:54.343' AS DateTime), 0, 250, 113, 2013, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1951, N'München', N'Hamburg', CAST(N'2018-12-12T15:28:54.350' AS DateTime), 0, 250, 244, 2194, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1952, N'New York', N'Prag', CAST(N'2018-08-15T01:35:54.360' AS DateTime), 0, 250, 125, 2142, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1953, N'Madrid', N'Essen/Mülheim', CAST(N'2018-04-16T11:35:54.370' AS DateTime), 0, 250, 5, 2079, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1954, N'Berlin', N'Rom', CAST(N'2018-08-26T02:52:54.380' AS DateTime), 0, 250, 136, 2012, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1955, N'Frankfurt', N'München', CAST(N'2018-04-27T12:52:54.390' AS DateTime), 0, 250, 16, 2195, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1956, N'Madrid', N'Moskau', CAST(N'2018-09-06T04:09:54.403' AS DateTime), 0, 250, 147, 2142, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1957, N'Frankfurt', N'Prag', CAST(N'2018-05-09T14:16:54.417' AS DateTime), 0, 250, 28, 2146, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1958, N'Berlin', N'Mailand', CAST(N'2018-09-17T05:26:54.447' AS DateTime), 0, 250, 158, 2056, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1959, N'Prag', N'Madrid', CAST(N'2018-05-20T15:33:54.463' AS DateTime), 0, 250, 39, 2055, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1960, N'Paris', N'New York', CAST(N'2018-09-28T06:43:54.473' AS DateTime), 0, 250, 169, 2166, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1961, N'Paris', N'Essen/Mülheim', CAST(N'2018-05-31T16:50:54.483' AS DateTime), 0, 250, 50, 2058, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1962, N'Essen/Mülheim', N'London', CAST(N'2018-10-10T08:07:54.490' AS DateTime), 0, 250, 181, 2123, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1963, N'Dallas', N'London', CAST(N'2018-06-11T18:07:54.500' AS DateTime), 0, 250, 61, 2079, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1964, N'New York', N'Hamburg', CAST(N'2018-10-21T09:24:54.507' AS DateTime), 0, 250, 192, 2068, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1965, N'Oslo', N'Moskau', CAST(N'2018-06-22T19:24:54.533' AS DateTime), 0, 250, 72, 2162, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1966, N'München', N'Prag', CAST(N'2018-11-01T10:41:54.547' AS DateTime), 0, 250, 203, 2057, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1967, N'Essen/Mülheim', N'Mailand', CAST(N'2018-07-04T20:48:54.557' AS DateTime), 0, 250, 84, 2014, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1968, N'London', N'Rom', CAST(N'2018-11-12T11:58:54.563' AS DateTime), 0, 250, 214, 2004, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1969, N'Rom', N'Frankfurt', CAST(N'2018-07-15T22:05:54.573' AS DateTime), 0, 250, 91, 2146, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1970, N'Seattle', N'München', CAST(N'2018-11-24T13:22:54.583' AS DateTime), 0, 250, 226, 2140, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1971, N'München', N'Moskau', CAST(N'2018-07-26T23:22:54.593' AS DateTime), 0, 250, 106, 2131, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1972, N'Prag', N'Essen/Mülheim', CAST(N'2018-12-05T14:39:54.603' AS DateTime), 0, 250, 237, 2063, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1973, N'Kapstadt', N'London', CAST(N'2018-08-07T00:39:54.610' AS DateTime), 0, 250, 117, 2176, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1974, N'Hamburg', N'Rom', CAST(N'2018-12-16T15:56:54.627' AS DateTime), 0, 250, 248, 2088, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1975, N'Rom', N'Paris', CAST(N'2018-08-19T02:03:54.637' AS DateTime), 0, 250, 125, 2023, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1976, N'Madrid', N'Mailand', CAST(N'2018-04-20T12:03:54.647' AS DateTime), 0, 250, 9, 2079, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1977, N'London', N'Dallas', CAST(N'2018-08-30T03:20:54.657' AS DateTime), 0, 250, 140, 2135, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1978, N'Hamburg', N'Essen/Mülheim', CAST(N'2018-05-01T13:20:54.667' AS DateTime), 0, 250, 20, 2006, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1979, N'Mailand', N'Köln/Bonn', CAST(N'2018-09-10T04:37:54.677' AS DateTime), 0, 250, 151, 2083, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1980, N'Köln/Bonn', N'Madrid', CAST(N'2018-05-13T14:44:54.683' AS DateTime), 0, 250, 32, 2053, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1981, N'Köln/Bonn', N'Seattle', CAST(N'2018-09-21T05:54:54.693' AS DateTime), 0, 250, 162, 2046, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1982, N'Essen/Mülheim', N'Hamburg', CAST(N'2018-05-24T16:01:54.710' AS DateTime), 0, 250, 43, 2071, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1983, N'Oslo', N'Rom', CAST(N'2018-10-02T07:11:54.717' AS DateTime), 0, 250, 173, 2072, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1984, N'Hamburg', N'Mailand', CAST(N'2018-06-04T17:18:54.727' AS DateTime), 0, 250, 54, 2074, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1985, N'Moskau', N'Madrid', CAST(N'2018-10-14T08:35:54.737' AS DateTime), 0, 250, 185, 2011, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1986, N'Madrid', N'Seattle', CAST(N'2018-06-15T18:35:54.747' AS DateTime), 0, 250, 65, 2188, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1987, N'Dallas', N'Madrid', CAST(N'2018-10-25T09:52:54.757' AS DateTime), 0, 250, 196, 2046, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1988, N'Essen/Mülheim', N'London', CAST(N'2018-06-26T19:52:54.767' AS DateTime), 0, 250, 76, 2088, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1989, N'Essen/Mülheim', N'Oslo', CAST(N'2018-11-05T11:09:54.777' AS DateTime), 0, 250, 207, 2160, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1990, N'New York', N'Frankfurt', CAST(N'2018-07-08T21:16:54.787' AS DateTime), 0, 250, 88, 2099, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1991, N'Oslo', N'Prag', CAST(N'2018-11-16T12:26:54.803' AS DateTime), 0, 250, 218, 2096, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1992, N'New York', N'Dallas', CAST(N'2018-07-19T22:33:54.820' AS DateTime), 0, 250, 99, 2123, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1993, N'Hamburg', N'Prag', CAST(N'2018-11-27T13:43:54.830' AS DateTime), 0, 250, 229, 2035, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1994, N'Essen/Mülheim', N'Dallas', CAST(N'2018-07-30T23:50:54.837' AS DateTime), 0, 250, 110, 2036, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1995, N'Berlin', N'München', CAST(N'2018-12-09T15:07:54.847' AS DateTime), 0, 250, 241, 2101, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1996, N'Rom', N'New York', CAST(N'2018-08-11T01:07:54.857' AS DateTime), 0, 250, 117, 2181, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1997, N'Dallas', N'Moskau', CAST(N'2018-04-13T11:14:54.867' AS DateTime), 0, 250, 2, 2114, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1998, N'Mailand', N'Köln/Bonn', CAST(N'2018-08-23T02:31:54.883' AS DateTime), 0, 250, 133, 2009, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (1999, N'Berlin', N'Prag', CAST(N'2018-04-24T12:31:54.890' AS DateTime), 0, 250, 13, 2068, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2000, N'Kapstadt', N'Berlin', CAST(N'2018-09-03T03:48:54.900' AS DateTime), 0, 250, 144, 2055, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2001, N'Prag', N'Rom', CAST(N'2018-05-05T13:48:54.913' AS DateTime), 0, 250, 24, 2044, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2002, N'Madrid', N'Rom', CAST(N'2018-09-14T05:05:54.923' AS DateTime), 0, 250, 155, 2188, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2003, N'Oslo', N'Dallas', CAST(N'2018-05-17T15:12:54.937' AS DateTime), 0, 250, 36, 2178, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2004, N'Paris', N'New York', CAST(N'2018-09-25T06:22:54.943' AS DateTime), 0, 250, 166, 2032, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2005, N'Essen/Mülheim', N'Hamburg', CAST(N'2018-05-28T16:29:54.953' AS DateTime), 0, 250, 47, 2172, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2006, N'Berlin', N'Seattle', CAST(N'2018-10-06T07:39:54.973' AS DateTime), 0, 250, 177, 2043, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2007, N'Oslo', N'Mailand', CAST(N'2018-06-08T17:46:54.980' AS DateTime), 0, 250, 58, 2065, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2008, N'Oslo', N'New York', CAST(N'2018-10-18T09:03:54.990' AS DateTime), 0, 250, 189, 2095, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2009, N'Oslo', N'Paris', CAST(N'2018-06-19T19:03:55.000' AS DateTime), 0, 250, 69, 2057, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2010, N'Paris', N'Moskau', CAST(N'2018-10-29T10:20:55.007' AS DateTime), 0, 250, 200, 2089, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2011, N'Köln/Bonn', N'Paris', CAST(N'2018-06-30T20:20:55.017' AS DateTime), 0, 250, 80, 2108, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2012, N'Oslo', N'Hamburg', CAST(N'2018-11-09T11:37:55.027' AS DateTime), 0, 250, 211, 2139, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2013, N'Dallas', N'Hamburg', CAST(N'2018-07-12T21:44:55.037' AS DateTime), 0, 250, 92, 2168, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2014, N'Moskau', N'Paris', CAST(N'2018-11-20T12:54:55.043' AS DateTime), 0, 250, 222, 2134, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2015, N'Berlin', N'Prag', CAST(N'2018-07-23T23:01:55.063' AS DateTime), 0, 250, 103, 2186, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2016, N'Paris', N'Seattle', CAST(N'2018-12-01T14:11:55.070' AS DateTime), 0, 250, 233, 2009, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2017, N'Hamburg', N'Dallas', CAST(N'2018-08-04T00:18:55.080' AS DateTime), 0, 250, 114, 2166, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2018, N'München', N'Madrid', CAST(N'2018-12-13T15:35:55.090' AS DateTime), 0, 250, 245, 2109, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2019, N'Dallas', N'New York', CAST(N'2018-08-15T01:35:55.100' AS DateTime), 0, 250, 125, 2125, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2020, N'Essen/Mülheim', N'Oslo', CAST(N'2018-04-17T11:42:55.110' AS DateTime), 0, 250, 6, 2174, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2021, N'New York', N'Mailand', CAST(N'2018-08-26T02:52:55.117' AS DateTime), 0, 250, 136, 2072, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2022, N'Mailand', N'München', CAST(N'2018-04-28T12:59:55.127' AS DateTime), 0, 250, 17, 2048, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2023, N'New York', N'Madrid', CAST(N'2018-09-07T04:16:55.133' AS DateTime), 0, 250, 148, 2004, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2024, N'Hamburg', N'Frankfurt', CAST(N'2018-05-09T14:16:55.150' AS DateTime), 0, 250, 28, 2105, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2025, N'Berlin', N'New York', CAST(N'2018-09-18T05:33:55.167' AS DateTime), 0, 250, 159, 2175, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2026, N'München', N'Prag', CAST(N'2018-05-20T15:33:55.177' AS DateTime), 0, 250, 39, 2102, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2027, N'Essen/Mülheim', N'Köln/Bonn', CAST(N'2018-09-29T06:50:55.183' AS DateTime), 0, 250, 170, 2052, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2028, N'Moskau', N'New York', CAST(N'2018-06-01T16:57:55.193' AS DateTime), 0, 250, 51, 2030, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2029, N'Moskau', N'Dallas', CAST(N'2018-10-10T08:07:55.200' AS DateTime), 0, 250, 181, 2189, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2030, N'Prag', N'Frankfurt', CAST(N'2018-06-12T18:14:55.210' AS DateTime), 0, 250, 62, 2044, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2031, N'Köln/Bonn', N'Dallas', CAST(N'2018-10-22T09:31:55.227' AS DateTime), 0, 250, 193, 2181, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2032, N'Dallas', N'Rom', CAST(N'2018-06-23T19:31:55.237' AS DateTime), 0, 250, 73, 2114, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2033, N'London', N'Seattle', CAST(N'2018-11-02T10:48:55.243' AS DateTime), 0, 250, 204, 2158, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2034, N'Madrid', N'Berlin', CAST(N'2018-07-04T20:48:55.253' AS DateTime), 0, 250, 84, 2003, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2035, N'Oslo', N'Rom', CAST(N'2018-11-13T12:05:55.260' AS DateTime), 0, 250, 215, 2151, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2036, N'Mailand', N'Prag', CAST(N'2018-07-16T22:12:55.270' AS DateTime), 0, 250, 96, 2061, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2037, N'Kapstadt', N'Prag', CAST(N'2018-11-24T13:22:55.277' AS DateTime), 0, 250, 226, 2040, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2038, N'Paris', N'München', CAST(N'2018-07-27T23:29:55.287' AS DateTime), 0, 250, 107, 2084, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2039, N'Hamburg', N'Essen/Mülheim', CAST(N'2018-12-05T14:39:55.303' AS DateTime), 0, 250, 237, 2166, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2040, N'Berlin', N'New York', CAST(N'2018-08-08T00:46:55.313' AS DateTime), 0, 250, 118, 2125, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2041, N'Oslo', N'Mailand', CAST(N'2018-12-17T16:03:55.323' AS DateTime), 0, 250, 249, 2021, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2042, N'Madrid', N'Rom', CAST(N'2018-08-19T02:03:55.330' AS DateTime), 0, 250, 129, 2080, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2043, N'Mailand', N'Frankfurt', CAST(N'2018-04-21T12:10:55.340' AS DateTime), 0, 250, 10, 2067, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2044, N'Rom', N'Essen/Mülheim', CAST(N'2018-08-30T03:20:55.350' AS DateTime), 0, 250, 136, 2169, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2045, N'Seattle', N'Oslo', CAST(N'2018-05-02T13:27:55.357' AS DateTime), 0, 250, 21, 2042, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2046, N'Köln/Bonn', N'Seattle', CAST(N'2018-09-11T04:44:55.367' AS DateTime), 0, 250, 152, 2062, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2047, N'Paris', N'Frankfurt', CAST(N'2018-05-13T14:44:55.377' AS DateTime), 0, 250, 32, 2098, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2048, N'New York', N'Essen/Mülheim', CAST(N'2018-09-22T06:01:55.393' AS DateTime), 0, 250, 163, 2112, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2049, N'Berlin', N'Kapstadt', CAST(N'2018-05-24T16:01:55.403' AS DateTime), 0, 250, 43, 2165, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2050, N'Mailand', N'Essen/Mülheim', CAST(N'2018-10-03T07:18:55.413' AS DateTime), 0, 250, 174, 2111, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2051, N'Essen/Mülheim', N'London', CAST(N'2018-06-05T17:25:55.420' AS DateTime), 0, 250, 55, 2007, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2052, N'Hamburg', N'Oslo', CAST(N'2018-10-14T08:35:55.430' AS DateTime), 0, 250, 185, 2111, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2053, N'Oslo', N'Berlin', CAST(N'2018-06-16T18:42:55.440' AS DateTime), 0, 250, 66, 2002, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2054, N'London', N'Berlin', CAST(N'2018-10-25T09:52:55.447' AS DateTime), 0, 250, 196, 2086, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2055, N'Dallas', N'Mailand', CAST(N'2018-06-27T19:59:55.457' AS DateTime), 0, 250, 77, 2151, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2056, N'London', N'Seattle', CAST(N'2018-11-06T11:16:55.463' AS DateTime), 0, 250, 208, 2051, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2057, N'Hamburg', N'Dallas', CAST(N'2018-07-08T21:16:55.483' AS DateTime), 0, 250, 88, 2012, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2058, N'Prag', N'New York', CAST(N'2018-11-17T12:33:55.493' AS DateTime), 0, 250, 219, 2114, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2059, N'München', N'Köln/Bonn', CAST(N'2018-07-19T22:33:55.503' AS DateTime), 0, 250, 99, 2143, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2060, N'Prag', N'Madrid', CAST(N'2018-11-28T13:50:55.513' AS DateTime), 0, 250, 230, 2101, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2061, N'Moskau', N'Dallas', CAST(N'2018-07-31T23:57:55.523' AS DateTime), 0, 250, 111, 2061, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2062, N'Kapstadt', N'Moskau', CAST(N'2018-12-09T15:07:55.530' AS DateTime), 0, 250, 241, 2077, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2063, N'Kapstadt', N'Prag', CAST(N'2018-08-12T01:14:55.547' AS DateTime), 0, 250, 122, 2195, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2064, N'New York', N'London', CAST(N'2018-04-14T11:21:55.557' AS DateTime), 0, 250, 3, 2134, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2065, N'Rom', N'Berlin', CAST(N'2018-08-23T02:31:55.567' AS DateTime), 0, 250, 129, 2018, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2066, N'Frankfurt', N'Seattle', CAST(N'2018-04-25T12:38:55.577' AS DateTime), 0, 250, 14, 2056, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2067, N'Kapstadt', N'Seattle', CAST(N'2018-09-03T03:48:55.583' AS DateTime), 0, 250, 144, 2016, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2068, N'Moskau', N'Rom', CAST(N'2018-05-06T13:55:55.593' AS DateTime), 0, 250, 25, 2164, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2069, N'Mailand', N'Hamburg', CAST(N'2018-09-15T05:12:55.600' AS DateTime), 0, 250, 156, 2149, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2070, N'Mailand', N'Berlin', CAST(N'2018-05-17T15:12:55.610' AS DateTime), 0, 250, 36, 2128, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2071, N'Madrid', N'London', CAST(N'2018-09-26T06:29:55.617' AS DateTime), 0, 250, 167, 2036, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2072, N'Mailand', N'Kapstadt', CAST(N'2018-05-28T16:29:55.637' AS DateTime), 0, 250, 47, 2006, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2073, N'München', N'Hamburg', CAST(N'2018-10-07T07:46:55.647' AS DateTime), 0, 250, 178, 2181, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2074, N'London', N'Prag', CAST(N'2018-06-09T17:53:55.653' AS DateTime), 0, 250, 59, 2034, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2075, N'Köln/Bonn', N'Prag', CAST(N'2018-10-18T09:03:55.663' AS DateTime), 0, 250, 189, 2122, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2076, N'London', N'Köln/Bonn', CAST(N'2018-06-20T19:10:55.673' AS DateTime), 0, 250, 70, 2116, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2077, N'Mailand', N'Frankfurt', CAST(N'2018-10-29T10:20:55.680' AS DateTime), 0, 250, 200, 2120, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2078, N'Paris', N'Essen/Mülheim', CAST(N'2018-07-01T20:27:55.690' AS DateTime), 0, 250, 81, 2036, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2079, N'Paris', N'Dallas', CAST(N'2018-11-10T11:44:55.700' AS DateTime), 0, 250, 212, 2139, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2080, N'Mailand', N'Rom', CAST(N'2018-07-12T21:44:55.710' AS DateTime), 0, 250, 92, 2072, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2081, N'New York', N'London', CAST(N'2018-11-21T13:01:55.727' AS DateTime), 0, 250, 223, 2103, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2082, N'London', N'Kapstadt', CAST(N'2018-07-23T23:01:55.737' AS DateTime), 0, 250, 103, 2193, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2083, N'Mailand', N'Kapstadt', CAST(N'2018-12-02T14:18:55.743' AS DateTime), 0, 250, 234, 2051, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2084, N'Frankfurt', N'Oslo', CAST(N'2018-08-05T00:25:55.753' AS DateTime), 0, 250, 115, 2098, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2085, N'London', N'Paris', CAST(N'2018-12-13T15:35:55.760' AS DateTime), 0, 250, 245, 2029, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2086, N'Oslo', N'Rom', CAST(N'2018-08-16T01:42:55.770' AS DateTime), 0, 250, 126, 2146, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2087, N'Hamburg', N'Frankfurt', CAST(N'2018-04-17T11:42:55.780' AS DateTime), 0, 250, 6, 2197, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2088, N'Hamburg', N'Dallas', CAST(N'2018-08-27T02:59:55.787' AS DateTime), 0, 250, 137, 2190, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2089, N'Berlin', N'Paris', CAST(N'2018-04-29T13:06:55.797' AS DateTime), 0, 250, 18, 2127, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2090, N'Dallas', N'Frankfurt', CAST(N'2018-09-07T04:16:55.813' AS DateTime), 0, 250, 148, 2156, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2091, N'Rom', N'New York', CAST(N'2018-05-10T14:23:55.827' AS DateTime), 0, 250, 25, 2180, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2092, N'Prag', N'Essen/Mülheim', CAST(N'2018-09-19T05:40:55.833' AS DateTime), 0, 250, 160, 2035, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2093, N'New York', N'Oslo', CAST(N'2018-05-21T15:40:55.840' AS DateTime), 0, 250, 40, 2148, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2094, N'New York', N'Oslo', CAST(N'2018-09-30T06:57:55.850' AS DateTime), 0, 250, 171, 2085, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2095, N'Rom', N'Paris', CAST(N'2018-06-01T16:57:55.860' AS DateTime), 0, 250, 47, 2030, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2096, N'München', N'Frankfurt', CAST(N'2018-10-11T08:14:55.867' AS DateTime), 0, 250, 182, 2062, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2097, N'Berlin', N'Prag', CAST(N'2018-06-13T18:21:55.887' AS DateTime), 0, 250, 63, 2139, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2098, N'Dallas', N'Köln/Bonn', CAST(N'2018-10-22T09:31:55.897' AS DateTime), 0, 250, 193, 2036, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2099, N'London', N'Mailand', CAST(N'2018-06-24T19:38:55.903' AS DateTime), 0, 250, 74, 2075, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2100, N'Moskau', N'Rom', CAST(N'2018-11-02T10:48:55.913' AS DateTime), 0, 250, 204, 2081, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2101, N'Rom', N'Mailand', CAST(N'2018-07-05T20:55:55.923' AS DateTime), 0, 250, 81, 2146, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2102, N'Mailand', N'Essen/Mülheim', CAST(N'2018-11-14T12:12:55.933' AS DateTime), 0, 250, 216, 2058, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2103, N'Moskau', N'Kapstadt', CAST(N'2018-07-16T22:12:55.943' AS DateTime), 0, 250, 96, 2137, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2104, N'Dallas', N'Köln/Bonn', CAST(N'2018-11-25T13:29:55.950' AS DateTime), 0, 250, 227, 2074, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2105, N'Dallas', N'Moskau', CAST(N'2018-07-27T23:29:55.970' AS DateTime), 0, 250, 107, 2043, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2106, N'Moskau', N'Madrid', CAST(N'2018-12-06T14:46:55.980' AS DateTime), 0, 250, 238, 2113, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2107, N'Kapstadt', N'Oslo', CAST(N'2018-08-09T00:53:55.990' AS DateTime), 0, 250, 119, 2070, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2108, N'Rom', N'Dallas', CAST(N'2018-12-17T16:03:56.000' AS DateTime), 0, 250, 237, 2111, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2109, N'Frankfurt', N'London', CAST(N'2018-08-20T02:10:56.010' AS DateTime), 0, 250, 130, 2074, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2110, N'Essen/Mülheim', N'Hamburg', CAST(N'2018-04-21T12:10:56.017' AS DateTime), 0, 250, 10, 2055, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2111, N'Kapstadt', N'Frankfurt', CAST(N'2018-08-31T03:27:56.027' AS DateTime), 0, 250, 141, 2126, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2112, N'Paris', N'Seattle', CAST(N'2018-05-03T13:34:56.037' AS DateTime), 0, 250, 22, 2170, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2113, N'Seattle', N'Madrid', CAST(N'2018-09-11T04:44:56.043' AS DateTime), 0, 250, 152, 2105, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2114, N'Köln/Bonn', N'New York', CAST(N'2018-05-14T14:51:56.067' AS DateTime), 0, 250, 33, 2014, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2115, N'Köln/Bonn', N'Rom', CAST(N'2018-09-22T06:01:56.077' AS DateTime), 0, 250, 163, 2195, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2116, N'Seattle', N'Dallas', CAST(N'2018-05-25T16:08:56.083' AS DateTime), 0, 250, 44, 2162, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2117, N'New York', N'Kapstadt', CAST(N'2018-10-04T07:25:56.093' AS DateTime), 0, 250, 175, 2151, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2118, N'London', N'Frankfurt', CAST(N'2018-06-05T17:25:56.103' AS DateTime), 0, 250, 55, 2199, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2119, N'Prag', N'Hamburg', CAST(N'2018-10-15T08:42:56.110' AS DateTime), 0, 250, 186, 2077, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2120, N'London', N'Oslo', CAST(N'2018-06-16T18:42:56.120' AS DateTime), 0, 250, 66, 2172, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2121, N'New York', N'Paris', CAST(N'2018-10-26T09:59:56.130' AS DateTime), 0, 250, 197, 2035, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2122, N'Hamburg', N'Essen/Mülheim', CAST(N'2018-06-28T20:06:56.137' AS DateTime), 0, 250, 78, 2131, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2123, N'Köln/Bonn', N'Kapstadt', CAST(N'2018-11-06T11:16:56.157' AS DateTime), 0, 250, 208, 2173, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2124, N'Dallas', N'Madrid', CAST(N'2018-07-09T21:23:56.170' AS DateTime), 0, 250, 89, 2188, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2125, N'Paris', N'München', CAST(N'2018-11-18T12:40:56.180' AS DateTime), 0, 250, 220, 2142, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2126, N'Oslo', N'Rom', CAST(N'2018-07-20T22:40:56.193' AS DateTime), 0, 250, 100, 2151, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2127, N'London', N'New York', CAST(N'2018-11-29T13:57:56.203' AS DateTime), 0, 250, 231, 2152, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2128, N'London', N'New York', CAST(N'2018-07-31T23:57:56.210' AS DateTime), 0, 250, 111, 2197, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2129, N'Rom', N'Köln/Bonn', CAST(N'2018-12-10T15:14:56.230' AS DateTime), 0, 250, 237, 2055, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2130, N'Rom', N'Madrid', CAST(N'2018-08-13T01:21:56.240' AS DateTime), 0, 250, 119, 2104, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2131, N'Mailand', N'Rom', CAST(N'2018-04-14T11:21:56.250' AS DateTime), 0, 250, 3, 2189, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2132, N'New York', N'Moskau', CAST(N'2018-08-24T02:38:56.260' AS DateTime), 0, 250, 134, 2042, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2133, N'Oslo', N'Frankfurt', CAST(N'2018-04-25T12:38:56.267' AS DateTime), 0, 250, 14, 2118, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2134, N'Rom', N'Mailand', CAST(N'2018-09-04T03:55:56.277' AS DateTime), 0, 250, 141, 2029, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2135, N'Dallas', N'New York', CAST(N'2018-05-07T14:02:56.287' AS DateTime), 0, 250, 26, 2184, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2136, N'Kapstadt', N'Dallas', CAST(N'2018-09-15T05:12:56.297' AS DateTime), 0, 250, 156, 2188, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2137, N'Rom', N'New York', CAST(N'2018-05-18T15:19:56.307' AS DateTime), 0, 250, 33, 2176, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2138, N'New York', N'Dallas', CAST(N'2018-09-26T06:29:56.323' AS DateTime), 0, 250, 167, 2052, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2139, N'Frankfurt', N'Rom', CAST(N'2018-05-29T16:36:56.330' AS DateTime), 0, 250, 48, 2152, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2140, N'Hamburg', N'Madrid', CAST(N'2018-10-08T07:53:56.340' AS DateTime), 0, 250, 179, 2096, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2141, N'London', N'Oslo', CAST(N'2018-06-09T17:53:56.347' AS DateTime), 0, 250, 59, 2191, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2142, N'London', N'Prag', CAST(N'2018-10-19T09:10:56.357' AS DateTime), 0, 250, 190, 2117, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2143, N'Dallas', N'Essen/Mülheim', CAST(N'2018-06-20T19:10:56.367' AS DateTime), 0, 250, 70, 2108, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2144, N'Prag', N'Dallas', CAST(N'2018-10-30T10:27:56.373' AS DateTime), 0, 250, 201, 2043, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2145, N'München', N'Frankfurt', CAST(N'2018-07-02T20:34:56.383' AS DateTime), 0, 250, 82, 2040, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2146, N'New York', N'Paris', CAST(N'2018-11-10T11:44:56.393' AS DateTime), 0, 250, 212, 2004, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2147, N'Frankfurt', N'Prag', CAST(N'2018-07-13T21:51:56.417' AS DateTime), 0, 250, 93, 2057, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2148, N'London', N'Berlin', CAST(N'2018-11-21T13:01:56.423' AS DateTime), 0, 250, 223, 2044, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2149, N'New York', N'Madrid', CAST(N'2018-07-24T23:08:56.433' AS DateTime), 0, 250, 104, 2061, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2150, N'Seattle', N'Moskau', CAST(N'2018-12-03T14:25:56.440' AS DateTime), 0, 250, 235, 2057, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2151, N'Mailand', N'Seattle', CAST(N'2018-08-05T00:25:56.450' AS DateTime), 0, 250, 115, 2050, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2152, N'Frankfurt', N'Oslo', CAST(N'2018-12-14T15:42:56.460' AS DateTime), 0, 250, 246, 2106, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2153, N'Hamburg', N'Moskau', CAST(N'2018-08-16T01:42:56.467' AS DateTime), 0, 250, 126, 2022, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2154, N'London', N'Kapstadt', CAST(N'2018-04-18T11:49:56.477' AS DateTime), 0, 250, 7, 2046, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2155, N'Paris', N'Kapstadt', CAST(N'2018-08-28T03:06:56.487' AS DateTime), 0, 250, 138, 2130, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2156, N'Seattle', N'Mailand', CAST(N'2018-04-29T13:06:56.510' AS DateTime), 0, 250, 18, 2187, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2157, N'Frankfurt', N'Mailand', CAST(N'2018-09-08T04:23:56.520' AS DateTime), 0, 250, 149, 2176, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2158, N'Essen/Mülheim', N'München', CAST(N'2018-05-11T14:30:56.533' AS DateTime), 0, 250, 30, 2064, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2159, N'Hamburg', N'Berlin', CAST(N'2018-09-19T05:40:56.543' AS DateTime), 0, 250, 160, 2181, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2160, N'Essen/Mülheim', N'Seattle', CAST(N'2018-05-22T15:47:56.553' AS DateTime), 0, 250, 41, 2137, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2161, N'Hamburg', N'Köln/Bonn', CAST(N'2018-09-30T06:57:56.563' AS DateTime), 0, 250, 171, 2011, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2162, N'Köln/Bonn', N'Dallas', CAST(N'2018-06-02T17:04:56.583' AS DateTime), 0, 250, 52, 2012, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2163, N'München', N'New York', CAST(N'2018-10-12T08:21:56.590' AS DateTime), 0, 250, 183, 2086, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2164, N'Kapstadt', N'Oslo', CAST(N'2018-06-13T18:21:56.600' AS DateTime), 0, 250, 63, 2146, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2165, N'Seattle', N'Berlin', CAST(N'2018-10-23T09:38:56.607' AS DateTime), 0, 250, 194, 2187, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2166, N'Köln/Bonn', N'Moskau', CAST(N'2018-06-24T19:38:56.617' AS DateTime), 0, 250, 74, 2194, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2167, N'New York', N'Frankfurt', CAST(N'2018-11-03T10:55:56.627' AS DateTime), 0, 250, 205, 2080, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2168, N'Seattle', N'Moskau', CAST(N'2018-07-06T21:02:56.637' AS DateTime), 0, 250, 86, 2185, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2169, N'Oslo', N'Madrid', CAST(N'2018-11-14T12:12:56.647' AS DateTime), 0, 250, 216, 2125, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2170, N'Mailand', N'Oslo', CAST(N'2018-07-17T22:19:56.657' AS DateTime), 0, 250, 97, 2085, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2171, N'Frankfurt', N'Prag', CAST(N'2018-11-25T13:29:56.677' AS DateTime), 0, 250, 227, 2010, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2172, N'München', N'Essen/Mülheim', CAST(N'2018-07-28T23:36:56.687' AS DateTime), 0, 250, 108, 2076, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2173, N'Seattle', N'Paris', CAST(N'2018-12-07T14:53:56.697' AS DateTime), 0, 250, 239, 2163, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2174, N'Paris', N'Berlin', CAST(N'2018-08-09T00:53:56.703' AS DateTime), 0, 250, 119, 2014, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2175, N'Kapstadt', N'London', CAST(N'2018-04-11T11:00:56.713' AS DateTime), 0, 250, 0, 2125, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2176, N'Seattle', N'Hamburg', CAST(N'2018-08-20T02:10:56.723' AS DateTime), 0, 250, 130, 2147, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2177, N'Rom', N'Oslo', CAST(N'2018-04-22T12:17:56.733' AS DateTime), 0, 250, 7, 2136, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2178, N'Frankfurt', N'Madrid', CAST(N'2018-09-01T03:34:56.740' AS DateTime), 0, 250, 142, 2070, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2179, N'Seattle', N'Berlin', CAST(N'2018-05-03T13:34:56.750' AS DateTime), 0, 250, 22, 2030, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2180, N'Köln/Bonn', N'Berlin', CAST(N'2018-09-12T04:51:56.770' AS DateTime), 0, 250, 153, 2195, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2181, N'Oslo', N'Mailand', CAST(N'2018-05-14T14:51:56.777' AS DateTime), 0, 250, 33, 2134, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2182, N'Hamburg', N'Berlin', CAST(N'2018-09-23T06:08:56.787' AS DateTime), 0, 250, 164, 2160, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2183, N'Prag', N'Hamburg', CAST(N'2018-05-26T16:15:56.797' AS DateTime), 0, 250, 45, 2053, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2184, N'Dallas', N'Prag', CAST(N'2018-10-04T07:25:56.810' AS DateTime), 0, 250, 175, 2047, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2185, N'Berlin', N'Rom', CAST(N'2018-06-06T17:32:56.820' AS DateTime), 0, 250, 56, 2174, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2186, N'Hamburg', N'Rom', CAST(N'2018-10-15T08:42:56.830' AS DateTime), 0, 250, 186, 2154, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2187, N'Essen/Mülheim', N'Dallas', CAST(N'2018-06-17T18:49:56.837' AS DateTime), 0, 250, 67, 2056, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2188, N'München', N'Kapstadt', CAST(N'2018-10-27T10:06:56.857' AS DateTime), 0, 250, 198, 2189, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2189, N'Rom', N'London', CAST(N'2018-06-28T20:06:56.870' AS DateTime), 0, 250, 74, 2140, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2190, N'New York', N'Köln/Bonn', CAST(N'2018-11-07T11:23:56.877' AS DateTime), 0, 250, 209, 2116, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2191, N'London', N'Frankfurt', CAST(N'2018-07-10T21:30:56.887' AS DateTime), 0, 250, 90, 2030, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2192, N'London', N'Seattle', CAST(N'2018-11-18T12:40:56.897' AS DateTime), 0, 250, 220, 2089, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2193, N'München', N'Rom', CAST(N'2018-07-21T22:47:56.907' AS DateTime), 0, 250, 101, 2034, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2194, N'Dallas', N'Mailand', CAST(N'2018-11-29T13:57:56.917' AS DateTime), 0, 250, 231, 2069, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2195, N'London', N'Mailand', CAST(N'2018-08-02T00:04:56.933' AS DateTime), 0, 250, 112, 2015, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2196, N'Prag', N'Mailand', CAST(N'2018-12-11T15:21:56.943' AS DateTime), 0, 250, 243, 2093, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2197, N'Essen/Mülheim', N'London', CAST(N'2018-08-13T01:21:56.950' AS DateTime), 0, 250, 123, 2092, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2198, N'Frankfurt', N'Seattle', CAST(N'2018-04-15T11:28:56.960' AS DateTime), 0, 250, 4, 2153, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2199, N'London', N'Prag', CAST(N'2018-08-24T02:38:56.970' AS DateTime), 0, 250, 134, 2070, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2200, N'Frankfurt', N'Prag', CAST(N'2018-04-26T12:45:56.977' AS DateTime), 0, 250, 15, 2024, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2201, N'Mailand', N'Moskau', CAST(N'2018-09-05T04:02:56.987' AS DateTime), 0, 250, 146, 2141, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2202, N'Dallas', N'Madrid', CAST(N'2018-05-07T14:02:56.997' AS DateTime), 0, 250, 26, 2190, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2203, N'Hamburg', N'Prag', CAST(N'2018-09-16T05:19:57.007' AS DateTime), 0, 250, 157, 2099, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2204, N'Madrid', N'New York', CAST(N'2018-05-18T15:19:57.027' AS DateTime), 0, 250, 37, 2092, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2205, N'Kapstadt', N'Rom', CAST(N'2018-09-27T06:36:57.037' AS DateTime), 0, 250, 168, 2136, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2206, N'London', N'Madrid', CAST(N'2018-05-30T16:43:57.047' AS DateTime), 0, 250, 49, 2150, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2207, N'Oslo', N'Köln/Bonn', CAST(N'2018-10-08T07:53:57.053' AS DateTime), 0, 250, 179, 2185, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2208, N'Madrid', N'München', CAST(N'2018-06-10T18:00:57.063' AS DateTime), 0, 250, 60, 2055, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2209, N'Dallas', N'Hamburg', CAST(N'2018-10-19T09:10:57.073' AS DateTime), 0, 250, 190, 2019, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2210, N'Frankfurt', N'Kapstadt', CAST(N'2018-06-21T19:17:57.080' AS DateTime), 0, 250, 71, 2011, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2211, N'Mailand', N'Madrid', CAST(N'2018-10-31T10:34:57.090' AS DateTime), 0, 250, 202, 2127, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2212, N'Paris', N'Moskau', CAST(N'2018-07-02T20:34:57.107' AS DateTime), 0, 250, 82, 2024, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2213, N'London', N'Dallas', CAST(N'2018-11-11T11:51:57.117' AS DateTime), 0, 250, 213, 2193, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2214, N'Madrid', N'Essen/Mülheim', CAST(N'2018-07-13T21:51:57.123' AS DateTime), 0, 250, 93, 2001, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2215, N'Rom', N'Paris', CAST(N'2018-11-22T13:08:57.133' AS DateTime), 0, 250, 220, 2018, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2216, N'Moskau', N'Essen/Mülheim', CAST(N'2018-07-25T23:15:57.140' AS DateTime), 0, 250, 105, 2193, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2217, N'Hamburg', N'Essen/Mülheim', CAST(N'2018-12-03T14:25:57.150' AS DateTime), 0, 250, 235, 2042, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2218, N'Köln/Bonn', N'Seattle', CAST(N'2018-08-06T00:32:57.157' AS DateTime), 0, 250, 116, 2165, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2219, N'Madrid', N'Moskau', CAST(N'2018-12-15T15:49:57.167' AS DateTime), 0, 250, 247, 2115, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2220, N'Kapstadt', N'Moskau', CAST(N'2018-08-17T01:49:57.177' AS DateTime), 0, 250, 127, 2062, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2221, N'Essen/Mülheim', N'Moskau', CAST(N'2018-04-19T11:56:57.193' AS DateTime), 0, 250, 8, 2133, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2222, N'Essen/Mülheim', N'Kapstadt', CAST(N'2018-08-28T03:06:57.203' AS DateTime), 0, 250, 138, 2161, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2223, N'München', N'London', CAST(N'2018-04-30T13:13:57.213' AS DateTime), 0, 250, 19, 2162, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2224, N'Essen/Mülheim', N'Paris', CAST(N'2018-09-09T04:30:57.220' AS DateTime), 0, 250, 150, 2192, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2225, N'Köln/Bonn', N'Berlin', CAST(N'2018-05-11T14:30:57.230' AS DateTime), 0, 250, 30, 2028, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2226, N'München', N'Dallas', CAST(N'2018-09-20T05:47:57.237' AS DateTime), 0, 250, 161, 2195, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2227, N'Rom', N'London', CAST(N'2018-05-22T15:47:57.247' AS DateTime), 0, 250, 37, 2085, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2228, N'München', N'Madrid', CAST(N'2018-10-01T07:04:57.263' AS DateTime), 0, 250, 172, 2006, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2229, N'Madrid', N'Köln/Bonn', CAST(N'2018-06-03T17:11:57.273' AS DateTime), 0, 250, 53, 2041, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2230, N'Kapstadt', N'Prag', CAST(N'2018-10-12T08:21:57.283' AS DateTime), 0, 250, 183, 2193, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2231, N'London', N'New York', CAST(N'2018-06-14T18:28:57.293' AS DateTime), 0, 250, 64, 2023, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2232, N'Hamburg', N'London', CAST(N'2018-10-23T09:38:57.300' AS DateTime), 0, 250, 194, 2111, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2233, N'Moskau', N'Rom', CAST(N'2018-06-25T19:45:57.310' AS DateTime), 0, 250, 75, 2096, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2234, N'London', N'München', CAST(N'2018-11-04T11:02:57.320' AS DateTime), 0, 250, 206, 2087, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2235, N'London', N'Köln/Bonn', CAST(N'2018-07-06T21:02:57.327' AS DateTime), 0, 250, 86, 2196, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2236, N'New York', N'Seattle', CAST(N'2018-11-15T12:19:57.347' AS DateTime), 0, 250, 217, 2146, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2237, N'New York', N'Moskau', CAST(N'2018-07-17T22:19:57.357' AS DateTime), 0, 250, 97, 2102, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2238, N'Hamburg', N'Madrid', CAST(N'2018-11-26T13:36:57.363' AS DateTime), 0, 250, 228, 2128, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2239, N'Seattle', N'New York', CAST(N'2018-07-29T23:43:57.373' AS DateTime), 0, 250, 109, 2178, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2240, N'Rom', N'Kapstadt', CAST(N'2018-12-07T14:53:57.380' AS DateTime), 0, 250, 235, 2169, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2241, N'Hamburg', N'Madrid', CAST(N'2018-08-10T01:00:57.390' AS DateTime), 0, 250, 120, 2116, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2242, N'Moskau', N'Oslo', CAST(N'2018-04-11T11:00:57.400' AS DateTime), 0, 250, 0, 2190, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2243, N'Kapstadt', N'Paris', CAST(N'2018-08-21T02:17:57.410' AS DateTime), 0, 250, 131, 2077, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2244, N'Berlin', N'Madrid', CAST(N'2018-04-23T12:24:57.417' AS DateTime), 0, 250, 12, 2009, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2245, N'Dallas', N'Mailand', CAST(N'2018-09-01T03:34:57.437' AS DateTime), 0, 250, 142, 2135, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2246, N'Moskau', N'Köln/Bonn', CAST(N'2018-05-04T13:41:57.443' AS DateTime), 0, 250, 23, 2117, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2247, N'München', N'Kapstadt', CAST(N'2018-09-12T04:51:57.453' AS DateTime), 0, 250, 153, 2068, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2248, N'Dallas', N'Berlin', CAST(N'2018-05-15T14:58:57.460' AS DateTime), 0, 250, 34, 2037, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2249, N'Essen/Mülheim', N'Mailand', CAST(N'2018-09-24T06:15:57.470' AS DateTime), 0, 250, 165, 2103, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2250, N'Seattle', N'New York', CAST(N'2018-05-26T16:15:57.480' AS DateTime), 0, 250, 45, 2009, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2251, N'Seattle', N'München', CAST(N'2018-10-05T07:32:57.490' AS DateTime), 0, 250, 176, 2113, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2252, N'Rom', N'Köln/Bonn', CAST(N'2018-06-07T17:39:57.497' AS DateTime), 0, 250, 53, 2095, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2253, N'New York', N'London', CAST(N'2018-10-16T08:49:57.507' AS DateTime), 0, 250, 187, 2136, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2254, N'Essen/Mülheim', N'Oslo', CAST(N'2018-06-18T18:56:57.527' AS DateTime), 0, 250, 68, 2041, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2255, N'Hamburg', N'Mailand', CAST(N'2018-10-27T10:06:57.537' AS DateTime), 0, 250, 198, 2064, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2256, N'Madrid', N'Seattle', CAST(N'2018-06-29T20:13:57.547' AS DateTime), 0, 250, 79, 2043, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2257, N'Dallas', N'Rom', CAST(N'2018-11-08T11:30:57.557' AS DateTime), 0, 250, 210, 2059, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2258, N'Berlin', N'Hamburg', CAST(N'2018-07-10T21:30:57.563' AS DateTime), 0, 250, 90, 2199, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2259, N'Prag', N'Köln/Bonn', CAST(N'2018-11-19T12:47:57.573' AS DateTime), 0, 250, 221, 2170, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2260, N'Paris', N'Madrid', CAST(N'2018-07-21T22:47:57.583' AS DateTime), 0, 250, 101, 2093, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2261, N'Paris', N'Frankfurt', CAST(N'2018-11-30T14:04:57.600' AS DateTime), 0, 250, 232, 2151, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2262, N'Essen/Mülheim', N'Mailand', CAST(N'2018-08-03T00:11:57.607' AS DateTime), 0, 250, 113, 2133, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2263, N'Köln/Bonn', N'Hamburg', CAST(N'2018-12-11T15:21:57.617' AS DateTime), 0, 250, 243, 2187, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2264, N'London', N'Madrid', CAST(N'2018-08-14T01:28:57.623' AS DateTime), 0, 250, 124, 2028, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2265, N'Essen/Mülheim', N'Prag', CAST(N'2018-04-15T11:28:57.633' AS DateTime), 0, 250, 4, 2172, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2266, N'Oslo', N'Kapstadt', CAST(N'2018-08-25T02:45:57.643' AS DateTime), 0, 250, 135, 2060, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2267, N'Essen/Mülheim', N'London', CAST(N'2018-04-27T12:52:57.653' AS DateTime), 0, 250, 16, 2149, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2268, N'New York', N'Dallas', CAST(N'2018-09-05T04:02:57.660' AS DateTime), 0, 250, 146, 2113, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2269, N'Kapstadt', N'Dallas', CAST(N'2018-05-08T14:09:57.677' AS DateTime), 0, 250, 27, 2125, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2270, N'Köln/Bonn', N'Prag', CAST(N'2018-09-16T05:19:57.687' AS DateTime), 0, 250, 157, 2044, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2271, N'Rom', N'Madrid', CAST(N'2018-05-19T15:26:57.697' AS DateTime), 0, 250, 34, 2089, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2272, N'Madrid', N'München', CAST(N'2018-09-28T06:43:57.707' AS DateTime), 0, 250, 169, 2119, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2273, N'London', N'Berlin', CAST(N'2018-05-30T16:43:57.713' AS DateTime), 0, 250, 49, 2197, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2274, N'Essen/Mülheim', N'London', CAST(N'2018-10-09T08:00:57.727' AS DateTime), 0, 250, 180, 2081, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2275, N'München', N'Kapstadt', CAST(N'2018-06-10T18:00:57.733' AS DateTime), 0, 250, 60, 2024, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2276, N'London', N'Prag', CAST(N'2018-10-20T09:17:57.743' AS DateTime), 0, 250, 191, 2064, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2277, N'Prag', N'Oslo', CAST(N'2018-06-22T19:24:57.750' AS DateTime), 0, 250, 72, 2132, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2278, N'München', N'London', CAST(N'2018-10-31T10:34:57.767' AS DateTime), 0, 250, 202, 2076, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2279, N'Moskau', N'Seattle', CAST(N'2018-07-03T20:41:57.777' AS DateTime), 0, 250, 83, 2153, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2280, N'Oslo', N'Madrid', CAST(N'2018-11-11T11:51:57.787' AS DateTime), 0, 250, 213, 2053, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2281, N'Moskau', N'Seattle', CAST(N'2018-07-14T21:58:57.800' AS DateTime), 0, 250, 94, 2070, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2282, N'Seattle', N'Frankfurt', CAST(N'2018-11-23T13:15:57.817' AS DateTime), 0, 250, 225, 2006, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2283, N'Seattle', N'Madrid', CAST(N'2018-07-25T23:15:57.827' AS DateTime), 0, 250, 105, 2076, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2284, N'Köln/Bonn', N'Moskau', CAST(N'2018-12-04T14:32:57.837' AS DateTime), 0, 250, 236, 2160, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2285, N'Rom', N'Dallas', CAST(N'2018-08-07T00:39:57.847' AS DateTime), 0, 250, 113, 2006, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2286, N'London', N'Prag', CAST(N'2018-12-15T15:49:57.857' AS DateTime), 0, 250, 247, 2029, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2287, N'Mailand', N'Paris', CAST(N'2018-08-18T01:56:57.873' AS DateTime), 0, 250, 128, 2087, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2288, N'Rom', N'Essen/Mülheim', CAST(N'2018-04-19T11:56:57.890' AS DateTime), 0, 250, 4, 2127, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2289, N'Moskau', N'Hamburg', CAST(N'2018-08-29T03:13:57.907' AS DateTime), 0, 250, 139, 2097, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2290, N'Frankfurt', N'Rom', CAST(N'2018-05-01T13:20:57.923' AS DateTime), 0, 250, 20, 2095, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2291, N'Kapstadt', N'Mailand', CAST(N'2018-09-09T04:30:57.940' AS DateTime), 0, 250, 150, 2027, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2292, N'Essen/Mülheim', N'Hamburg', CAST(N'2018-05-12T14:37:57.957' AS DateTime), 0, 250, 31, 2136, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2293, N'Berlin', N'Paris', CAST(N'2018-09-20T05:47:57.990' AS DateTime), 0, 250, 161, 2146, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2294, N'Frankfurt', N'Seattle', CAST(N'2018-05-23T15:54:58.007' AS DateTime), 0, 250, 42, 2134, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2295, N'Oslo', N'Köln/Bonn', CAST(N'2018-10-02T07:11:58.023' AS DateTime), 0, 250, 173, 2068, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2296, N'Madrid', N'Kapstadt', CAST(N'2018-06-03T17:11:58.040' AS DateTime), 0, 250, 53, 2082, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2297, N'London', N'Köln/Bonn', CAST(N'2018-10-13T08:28:58.057' AS DateTime), 0, 250, 184, 2028, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2298, N'New York', N'Mailand', CAST(N'2018-06-14T18:28:58.073' AS DateTime), 0, 250, 64, 2089, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2299, N'Kapstadt', N'Köln/Bonn', CAST(N'2018-10-24T09:45:58.087' AS DateTime), 0, 250, 195, 2186, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2300, N'Seattle', N'München', CAST(N'2018-06-26T19:52:58.107' AS DateTime), 0, 250, 76, 2182, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2301, N'Prag', N'New York', CAST(N'2018-11-04T11:02:58.123' AS DateTime), 0, 250, 206, 2116, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2302, N'Oslo', N'Paris', CAST(N'2018-07-07T21:09:58.157' AS DateTime), 0, 250, 87, 2022, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2303, N'New York', N'Moskau', CAST(N'2018-11-15T12:19:58.173' AS DateTime), 0, 250, 217, 2152, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2304, N'London', N'Rom', CAST(N'2018-07-18T22:26:58.190' AS DateTime), 0, 250, 98, 2022, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2305, N'Paris', N'London', CAST(N'2018-11-27T13:43:58.207' AS DateTime), 0, 250, 229, 2148, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2306, N'Essen/Mülheim', N'London', CAST(N'2018-07-29T23:43:58.223' AS DateTime), 0, 250, 109, 2093, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2307, N'Rom', N'Seattle', CAST(N'2018-12-08T15:00:58.237' AS DateTime), 0, 250, 236, 2070, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2308, N'Frankfurt', N'Seattle', CAST(N'2018-08-10T01:00:58.253' AS DateTime), 0, 250, 120, 2006, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2309, N'London', N'Hamburg', CAST(N'2018-04-12T11:07:58.270' AS DateTime), 0, 250, 1, 2198, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2310, N'Seattle', N'Oslo', CAST(N'2018-08-22T02:24:58.287' AS DateTime), 0, 250, 132, 2186, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2311, N'Essen/Mülheim', N'London', CAST(N'2018-04-23T12:24:58.323' AS DateTime), 0, 250, 12, 2063, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2312, N'Kapstadt', N'Prag', CAST(N'2018-09-02T03:41:58.340' AS DateTime), 0, 250, 143, 2012, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2313, N'Frankfurt', N'Berlin', CAST(N'2018-05-04T13:41:58.357' AS DateTime), 0, 250, 23, 2168, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2314, N'Köln/Bonn', N'Hamburg', CAST(N'2018-09-13T04:58:58.373' AS DateTime), 0, 250, 154, 2047, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2315, N'New York', N'Berlin', CAST(N'2018-05-16T15:05:58.390' AS DateTime), 0, 250, 35, 2191, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2316, N'Berlin', N'Hamburg', CAST(N'2018-09-24T06:15:58.407' AS DateTime), 0, 250, 165, 2021, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2317, N'Seattle', N'Frankfurt', CAST(N'2018-05-27T16:22:58.427' AS DateTime), 0, 250, 46, 2178, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2318, N'Mailand', N'Paris', CAST(N'2018-10-06T07:39:58.440' AS DateTime), 0, 250, 177, 2085, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2319, N'Moskau', N'Mailand', CAST(N'2018-06-07T17:39:58.457' AS DateTime), 0, 250, 57, 2182, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2320, N'Prag', N'Moskau', CAST(N'2018-10-17T08:56:58.493' AS DateTime), 0, 250, 188, 2044, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2321, N'München', N'Dallas', CAST(N'2018-06-18T18:56:58.513' AS DateTime), 0, 250, 68, 2137, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2322, N'Kapstadt', N'Moskau', CAST(N'2018-10-28T10:13:58.530' AS DateTime), 0, 250, 199, 2191, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2323, N'Kapstadt', N'Moskau', CAST(N'2018-06-30T20:20:58.547' AS DateTime), 0, 250, 80, 2163, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2324, N'London', N'New York', CAST(N'2018-11-08T11:30:58.560' AS DateTime), 0, 250, 210, 2013, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2325, N'Prag', N'München', CAST(N'2018-07-11T21:37:58.577' AS DateTime), 0, 250, 91, 2085, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2326, N'Seattle', N'Frankfurt', CAST(N'2018-11-19T12:47:58.603' AS DateTime), 0, 250, 221, 2061, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2327, N'Berlin', N'Oslo', CAST(N'2018-07-22T22:54:58.620' AS DateTime), 0, 250, 102, 2197, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2328, N'Madrid', N'Berlin', CAST(N'2018-12-01T14:11:58.637' AS DateTime), 0, 250, 233, 2055, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2329, N'Köln/Bonn', N'Frankfurt', CAST(N'2018-08-03T00:11:58.653' AS DateTime), 0, 250, 113, 2029, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2330, N'Prag', N'Mailand', CAST(N'2018-12-12T15:28:58.667' AS DateTime), 0, 250, 244, 2124, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2331, N'München', N'Hamburg', CAST(N'2018-08-14T01:28:58.680' AS DateTime), 0, 250, 124, 2110, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2332, N'Kapstadt', N'Paris', CAST(N'2018-04-16T11:35:58.693' AS DateTime), 0, 250, 5, 2199, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2333, N'Köln/Bonn', N'Moskau', CAST(N'2018-08-26T02:52:58.707' AS DateTime), 0, 250, 136, 2058, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2334, N'Berlin', N'London', CAST(N'2018-04-27T12:52:58.720' AS DateTime), 0, 250, 16, 2111, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2335, N'Madrid', N'London', CAST(N'2018-09-06T04:09:58.753' AS DateTime), 0, 250, 147, 2183, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2336, N'Mailand', N'Berlin', CAST(N'2018-05-08T14:09:58.767' AS DateTime), 0, 250, 27, 2042, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2337, N'Mailand', N'Köln/Bonn', CAST(N'2018-09-17T05:26:58.780' AS DateTime), 0, 250, 158, 2042, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2338, N'Köln/Bonn', N'Dallas', CAST(N'2018-05-20T15:33:58.793' AS DateTime), 0, 250, 39, 2170, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2339, N'Kapstadt', N'Rom', CAST(N'2018-09-28T06:43:58.807' AS DateTime), 0, 250, 169, 2010, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2340, N'Oslo', N'London', CAST(N'2018-05-31T16:50:58.820' AS DateTime), 0, 250, 50, 2147, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2341, N'Prag', N'München', CAST(N'2018-10-09T08:00:58.830' AS DateTime), 0, 250, 180, 2175, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2342, N'Berlin', N'Dallas', CAST(N'2018-06-11T18:07:58.843' AS DateTime), 0, 250, 61, 2058, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2343, N'Rom', N'Frankfurt', CAST(N'2018-10-21T09:24:58.857' AS DateTime), 0, 250, 188, 2013, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2344, N'Paris', N'Moskau', CAST(N'2018-06-22T19:24:58.880' AS DateTime), 0, 250, 72, 2193, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2345, N'Paris', N'Prag', CAST(N'2018-11-01T10:41:58.893' AS DateTime), 0, 250, 203, 2194, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2346, N'Kapstadt', N'Berlin', CAST(N'2018-07-04T20:48:58.907' AS DateTime), 0, 250, 84, 2186, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2347, N'Berlin', N'Hamburg', CAST(N'2018-11-12T11:58:58.920' AS DateTime), 0, 250, 214, 2083, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2348, N'Oslo', N'Köln/Bonn', CAST(N'2018-07-15T22:05:58.930' AS DateTime), 0, 250, 95, 2139, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2349, N'Berlin', N'Frankfurt', CAST(N'2018-11-23T13:15:58.943' AS DateTime), 0, 250, 225, 2189, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2350, N'London', N'Köln/Bonn', CAST(N'2018-07-26T23:22:58.957' AS DateTime), 0, 250, 106, 2110, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2351, N'Mailand', N'Köln/Bonn', CAST(N'2018-12-05T14:39:58.970' AS DateTime), 0, 250, 237, 2136, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2352, N'Madrid', N'Paris', CAST(N'2018-08-07T00:39:58.983' AS DateTime), 0, 250, 117, 2125, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2353, N'Madrid', N'Paris', CAST(N'2018-12-16T15:56:59.013' AS DateTime), 0, 250, 248, 2183, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2354, N'Paris', N'Hamburg', CAST(N'2018-08-18T01:56:59.033' AS DateTime), 0, 250, 128, 2160, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2355, N'New York', N'Berlin', CAST(N'2018-04-20T12:03:59.047' AS DateTime), 0, 250, 9, 2080, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2356, N'Rom', N'Oslo', CAST(N'2018-08-30T03:20:59.057' AS DateTime), 0, 250, 136, 2101, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2357, N'Oslo', N'Prag', CAST(N'2018-05-01T13:20:59.070' AS DateTime), 0, 250, 20, 2140, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2358, N'Moskau', N'Frankfurt', CAST(N'2018-09-10T04:37:59.083' AS DateTime), 0, 250, 151, 2135, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2359, N'Moskau', N'Berlin', CAST(N'2018-05-12T14:37:59.107' AS DateTime), 0, 250, 31, 2013, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2360, N'Madrid', N'Moskau', CAST(N'2018-09-21T05:54:59.117' AS DateTime), 0, 250, 162, 2042, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2361, N'München', N'Essen/Mülheim', CAST(N'2018-05-24T16:01:59.130' AS DateTime), 0, 250, 43, 2029, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2362, N'Frankfurt', N'Mailand', CAST(N'2018-10-02T07:11:59.143' AS DateTime), 0, 250, 173, 2042, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2363, N'Kapstadt', N'Moskau', CAST(N'2018-06-04T17:18:59.157' AS DateTime), 0, 250, 54, 2025, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2364, N'London', N'Oslo', CAST(N'2018-10-13T08:28:59.167' AS DateTime), 0, 250, 184, 2120, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2365, N'Berlin', N'New York', CAST(N'2018-06-15T18:35:59.180' AS DateTime), 0, 250, 65, 2199, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2366, N'New York', N'Köln/Bonn', CAST(N'2018-10-25T09:52:59.193' AS DateTime), 0, 250, 196, 2041, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2367, N'Rom', N'Essen/Mülheim', CAST(N'2018-06-26T19:52:59.203' AS DateTime), 0, 250, 72, 2039, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2368, N'Seattle', N'Madrid', CAST(N'2018-11-05T11:09:59.233' AS DateTime), 0, 250, 207, 2174, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2369, N'München', N'Berlin', CAST(N'2018-07-07T21:09:59.247' AS DateTime), 0, 250, 87, 2052, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2370, N'London', N'Moskau', CAST(N'2018-11-16T12:26:59.260' AS DateTime), 0, 250, 218, 2004, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2371, N'Madrid', N'Seattle', CAST(N'2018-07-19T22:33:59.273' AS DateTime), 0, 250, 99, 2055, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2372, N'Mailand', N'New York', CAST(N'2018-11-27T13:43:59.287' AS DateTime), 0, 250, 229, 2113, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2373, N'Prag', N'Hamburg', CAST(N'2018-07-30T23:50:59.300' AS DateTime), 0, 250, 110, 2101, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2374, N'Rom', N'London', CAST(N'2018-12-08T15:00:59.310' AS DateTime), 0, 250, 236, 2116, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2375, N'New York', N'Frankfurt', CAST(N'2018-08-11T01:07:59.323' AS DateTime), 0, 250, 121, 2118, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2376, N'Paris', N'Seattle', CAST(N'2018-04-13T11:14:59.337' AS DateTime), 0, 250, 2, 2195, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2377, N'Kapstadt', N'Madrid', CAST(N'2018-08-22T02:24:59.363' AS DateTime), 0, 250, 132, 2114, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2378, N'Madrid', N'Berlin', CAST(N'2018-04-24T12:31:59.377' AS DateTime), 0, 250, 13, 2138, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2379, N'Rom', N'Paris', CAST(N'2018-09-03T03:48:59.390' AS DateTime), 0, 250, 140, 2043, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2380, N'New York', N'Frankfurt', CAST(N'2018-05-05T13:48:59.403' AS DateTime), 0, 250, 24, 2159, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2381, N'Rom', N'Essen/Mülheim', CAST(N'2018-09-14T05:05:59.417' AS DateTime), 0, 250, 151, 2156, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2382, N'Oslo', N'Essen/Mülheim', CAST(N'2018-05-16T15:05:59.427' AS DateTime), 0, 250, 35, 2062, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2383, N'London', N'Prag', CAST(N'2018-09-25T06:22:59.440' AS DateTime), 0, 250, 166, 2190, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2384, N'Frankfurt', N'Hamburg', CAST(N'2018-05-28T16:29:59.453' AS DateTime), 0, 250, 47, 2177, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2385, N'Frankfurt', N'Kapstadt', CAST(N'2018-10-06T07:39:59.477' AS DateTime), 0, 250, 177, 2018, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2386, N'Essen/Mülheim', N'Rom', CAST(N'2018-06-08T17:46:59.497' AS DateTime), 0, 250, 58, 2143, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2387, N'Moskau', N'Seattle', CAST(N'2018-10-17T08:56:59.510' AS DateTime), 0, 250, 188, 2090, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2388, N'Berlin', N'Seattle', CAST(N'2018-06-19T19:03:59.537' AS DateTime), 0, 250, 69, 2116, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2389, N'München', N'Köln/Bonn', CAST(N'2018-10-29T10:20:59.553' AS DateTime), 0, 250, 200, 2070, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2390, N'Oslo', N'München', CAST(N'2018-06-30T20:20:59.567' AS DateTime), 0, 250, 80, 2142, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2391, N'Dallas', N'New York', CAST(N'2018-11-09T11:37:59.580' AS DateTime), 0, 250, 211, 2160, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2392, N'Essen/Mülheim', N'London', CAST(N'2018-07-11T21:37:59.603' AS DateTime), 0, 250, 91, 2056, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2393, N'Berlin', N'München', CAST(N'2018-11-20T12:54:59.620' AS DateTime), 0, 250, 222, 2005, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2394, N'Frankfurt', N'Hamburg', CAST(N'2018-07-23T23:01:59.633' AS DateTime), 0, 250, 103, 2092, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2395, N'New York', N'München', CAST(N'2018-12-01T14:11:59.650' AS DateTime), 0, 250, 233, 2126, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2396, N'Mailand', N'London', CAST(N'2018-08-04T00:18:59.667' AS DateTime), 0, 250, 114, 2095, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2397, N'Mailand', N'Berlin', CAST(N'2018-12-12T15:28:59.677' AS DateTime), 0, 250, 244, 2035, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2398, N'Frankfurt', N'Paris', CAST(N'2018-08-15T01:35:59.690' AS DateTime), 0, 250, 125, 2144, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2399, N'New York', N'Kapstadt', CAST(N'2018-04-17T11:42:59.700' AS DateTime), 0, 250, 6, 2075, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2400, N'Seattle', N'London', CAST(N'2018-08-26T02:52:59.710' AS DateTime), 0, 250, 136, 2153, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2401, N'Dallas', N'Prag', CAST(N'2018-04-28T12:59:59.730' AS DateTime), 0, 250, 17, 2181, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2402, N'Paris', N'Berlin', CAST(N'2018-09-06T04:09:59.740' AS DateTime), 0, 250, 147, 2070, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2403, N'London', N'Berlin', CAST(N'2018-05-09T14:16:59.750' AS DateTime), 0, 250, 28, 2132, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2404, N'Hamburg', N'Köln/Bonn', CAST(N'2018-09-18T05:33:59.763' AS DateTime), 0, 250, 159, 2102, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2405, N'Prag', N'Dallas', CAST(N'2018-05-20T15:33:59.773' AS DateTime), 0, 250, 39, 2076, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2406, N'Moskau', N'Dallas', CAST(N'2018-09-29T06:50:59.783' AS DateTime), 0, 250, 170, 2132, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2407, N'Oslo', N'Madrid', CAST(N'2018-05-31T16:50:59.793' AS DateTime), 0, 250, 50, 2114, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2408, N'Kapstadt', N'Köln/Bonn', CAST(N'2018-10-10T08:07:59.803' AS DateTime), 0, 250, 181, 2186, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2409, N'Mailand', N'Essen/Mülheim', CAST(N'2018-06-12T18:14:59.823' AS DateTime), 0, 250, 62, 2059, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2410, N'Köln/Bonn', N'Essen/Mülheim', CAST(N'2018-10-21T09:24:59.830' AS DateTime), 0, 250, 192, 2062, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2411, N'Seattle', N'Paris', CAST(N'2018-06-23T19:31:59.840' AS DateTime), 0, 250, 73, 2097, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2412, N'München', N'Hamburg', CAST(N'2018-11-02T10:48:59.850' AS DateTime), 0, 250, 204, 2040, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2413, N'Mailand', N'Dallas', CAST(N'2018-07-04T20:48:59.863' AS DateTime), 0, 250, 84, 2021, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2414, N'London', N'Seattle', CAST(N'2018-11-13T12:05:59.880' AS DateTime), 0, 250, 215, 2057, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2415, N'Kapstadt', N'New York', CAST(N'2018-07-15T22:05:59.897' AS DateTime), 0, 250, 95, 2109, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2416, N'Mailand', N'London', CAST(N'2018-11-24T13:22:59.917' AS DateTime), 0, 250, 226, 2010, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2417, N'Madrid', N'Seattle', CAST(N'2018-07-27T23:29:59.933' AS DateTime), 0, 250, 107, 2164, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2418, N'Mailand', N'Hamburg', CAST(N'2018-12-05T14:39:59.970' AS DateTime), 0, 250, 237, 2036, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2419, N'Köln/Bonn', N'Dallas', CAST(N'2018-08-08T00:46:59.990' AS DateTime), 0, 250, 118, 2197, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2420, N'Rom', N'Frankfurt', CAST(N'2018-12-16T15:57:00.000' AS DateTime), 0, 250, 237, 2144, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2421, N'London', N'Paris', CAST(N'2018-08-19T02:04:00.017' AS DateTime), 0, 250, 129, 2081, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2422, N'Dallas', N'Kapstadt', CAST(N'2018-04-21T12:11:00.030' AS DateTime), 0, 250, 10, 2022, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2423, N'Prag', N'Köln/Bonn', CAST(N'2018-08-30T03:21:00.040' AS DateTime), 0, 250, 140, 2071, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2424, N'Essen/Mülheim', N'Hamburg', CAST(N'2018-05-02T13:28:00.050' AS DateTime), 0, 250, 21, 2181, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2425, N'Essen/Mülheim', N'Köln/Bonn', CAST(N'2018-09-10T04:38:00.067' AS DateTime), 0, 250, 151, 2025, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2426, N'Dallas', N'München', CAST(N'2018-05-13T14:45:00.077' AS DateTime), 0, 250, 32, 2156, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2427, N'Hamburg', N'Madrid', CAST(N'2018-09-22T06:02:00.087' AS DateTime), 0, 250, 163, 2062, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2428, N'New York', N'Paris', CAST(N'2018-05-24T16:02:00.097' AS DateTime), 0, 250, 43, 2012, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2429, N'Mailand', N'Köln/Bonn', CAST(N'2018-10-03T07:19:00.107' AS DateTime), 0, 250, 174, 2045, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2430, N'Rom', N'Madrid', CAST(N'2018-06-04T17:19:00.117' AS DateTime), 0, 250, 50, 2049, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2431, N'Oslo', N'London', CAST(N'2018-10-14T08:36:00.127' AS DateTime), 0, 250, 185, 2199, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2432, N'Köln/Bonn', N'Madrid', CAST(N'2018-06-16T18:43:00.133' AS DateTime), 0, 250, 66, 2167, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2433, N'Madrid', N'Paris', CAST(N'2018-10-25T09:53:00.153' AS DateTime), 0, 250, 196, 2190, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2434, N'Frankfurt', N'Seattle', CAST(N'2018-06-27T20:00:00.163' AS DateTime), 0, 250, 77, 2019, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2435, N'Prag', N'Oslo', CAST(N'2018-11-05T11:10:00.173' AS DateTime), 0, 250, 207, 2140, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2436, N'Dallas', N'Frankfurt', CAST(N'2018-07-08T21:17:00.180' AS DateTime), 0, 250, 88, 2060, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2437, N'Kapstadt', N'Hamburg', CAST(N'2018-11-17T12:34:00.190' AS DateTime), 0, 250, 219, 2023, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2438, N'Hamburg', N'Paris', CAST(N'2018-07-19T22:34:00.200' AS DateTime), 0, 250, 99, 2146, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2439, N'Berlin', N'London', CAST(N'2018-11-28T13:51:00.207' AS DateTime), 0, 250, 230, 2093, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2440, N'Prag', N'Madrid', CAST(N'2018-07-31T23:58:00.217' AS DateTime), 0, 250, 111, 2039, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2441, N'London', N'München', CAST(N'2018-12-09T15:08:00.227' AS DateTime), 0, 250, 241, 2109, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2442, N'Berlin', N'Dallas', CAST(N'2018-08-12T01:15:00.247' AS DateTime), 0, 250, 122, 2078, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2443, N'Köln/Bonn', N'Madrid', CAST(N'2018-04-13T11:15:00.257' AS DateTime), 0, 250, 2, 2017, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2444, N'Rom', N'Oslo', CAST(N'2018-08-23T02:32:00.267' AS DateTime), 0, 250, 129, 2148, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2445, N'Oslo', N'Hamburg', CAST(N'2018-04-25T12:39:00.277' AS DateTime), 0, 250, 14, 2184, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2446, N'Rom', N'Prag', CAST(N'2018-09-03T03:49:00.283' AS DateTime), 0, 250, 140, 2113, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2447, N'Prag', N'Köln/Bonn', CAST(N'2018-05-06T13:56:00.293' AS DateTime), 0, 250, 25, 2051, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2448, N'Moskau', N'Paris', CAST(N'2018-09-14T05:06:00.303' AS DateTime), 0, 250, 155, 2002, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2449, N'Frankfurt', N'Seattle', CAST(N'2018-05-17T15:13:00.313' AS DateTime), 0, 250, 36, 2194, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2450, N'Prag', N'London', CAST(N'2018-09-26T06:30:00.323' AS DateTime), 0, 250, 167, 2065, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2451, N'Moskau', N'Essen/Mülheim', CAST(N'2018-05-28T16:30:00.343' AS DateTime), 0, 250, 47, 2141, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2452, N'Moskau', N'Prag', CAST(N'2018-10-07T07:47:00.360' AS DateTime), 0, 250, 178, 2100, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2453, N'Oslo', N'Rom', CAST(N'2018-06-08T17:47:00.377' AS DateTime), 0, 250, 58, 2146, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2454, N'Prag', N'Rom', CAST(N'2018-10-18T09:04:00.397' AS DateTime), 0, 250, 189, 2074, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2455, N'Rom', N'Hamburg', CAST(N'2018-06-20T19:11:00.413' AS DateTime), 0, 250, 66, 2161, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2456, N'Seattle', N'Kapstadt', CAST(N'2018-10-29T10:21:00.433' AS DateTime), 0, 250, 200, 2179, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2457, N'Berlin', N'New York', CAST(N'2018-07-01T20:28:00.453' AS DateTime), 0, 250, 81, 2188, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2458, N'Kapstadt', N'Seattle', CAST(N'2018-11-09T11:38:00.493' AS DateTime), 0, 250, 211, 2108, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2459, N'Dallas', N'Köln/Bonn', CAST(N'2018-07-12T21:45:00.513' AS DateTime), 0, 250, 92, 2083, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2460, N'Dallas', N'Moskau', CAST(N'2018-11-21T13:02:00.533' AS DateTime), 0, 250, 223, 2110, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2461, N'Oslo', N'Moskau', CAST(N'2018-07-23T23:02:00.550' AS DateTime), 0, 250, 103, 2037, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2462, N'München', N'Prag', CAST(N'2018-12-02T14:19:00.563' AS DateTime), 0, 250, 234, 2068, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2463, N'Essen/Mülheim', N'Berlin', CAST(N'2018-08-04T00:19:00.577' AS DateTime), 0, 250, 114, 2125, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2464, N'Köln/Bonn', N'Prag', CAST(N'2018-12-13T15:36:00.590' AS DateTime), 0, 250, 245, 2011, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2465, N'London', N'Oslo', CAST(N'2018-08-16T01:43:00.603' AS DateTime), 0, 250, 126, 2142, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2466, N'Seattle', N'London', CAST(N'2018-04-17T11:43:00.630' AS DateTime), 0, 250, 6, 2157, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2467, N'Mailand', N'Moskau', CAST(N'2018-08-27T03:00:00.643' AS DateTime), 0, 250, 137, 2144, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2468, N'Mailand', N'Rom', CAST(N'2018-04-28T13:00:00.657' AS DateTime), 0, 250, 17, 2185, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2469, N'Kapstadt', N'Oslo', CAST(N'2018-09-07T04:17:00.670' AS DateTime), 0, 250, 148, 2177, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2470, N'Berlin', N'Prag', CAST(N'2018-05-10T14:24:00.683' AS DateTime), 0, 250, 29, 2135, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2471, N'Oslo', N'Essen/Mülheim', CAST(N'2018-09-18T05:34:00.697' AS DateTime), 0, 250, 159, 2122, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2472, N'New York', N'Moskau', CAST(N'2018-05-21T15:41:00.713' AS DateTime), 0, 250, 40, 2141, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2473, N'Seattle', N'Mailand', CAST(N'2018-09-30T06:58:00.727' AS DateTime), 0, 250, 171, 2186, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2474, N'Essen/Mülheim', N'Köln/Bonn', CAST(N'2018-06-01T16:58:00.737' AS DateTime), 0, 250, 51, 2157, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2475, N'Frankfurt', N'Oslo', CAST(N'2018-10-11T08:15:00.763' AS DateTime), 0, 250, 182, 2091, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2476, N'Köln/Bonn', N'Madrid', CAST(N'2018-06-12T18:15:00.777' AS DateTime), 0, 250, 62, 2126, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2477, N'Prag', N'Berlin', CAST(N'2018-10-22T09:32:00.790' AS DateTime), 0, 250, 193, 2166, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2478, N'Mailand', N'Rom', CAST(N'2018-06-24T19:39:00.803' AS DateTime), 0, 250, 74, 2052, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2479, N'Rom', N'New York', CAST(N'2018-11-02T10:49:00.813' AS DateTime), 0, 250, 200, 2090, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2480, N'Essen/Mülheim', N'Mailand', CAST(N'2018-07-05T20:56:00.827' AS DateTime), 0, 250, 85, 2189, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2481, N'Rom', N'Essen/Mülheim', CAST(N'2018-11-13T12:06:00.840' AS DateTime), 0, 250, 211, 2088, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2482, N'Seattle', N'Rom', CAST(N'2018-07-16T22:13:00.853' AS DateTime), 0, 250, 96, 2002, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2483, N'Prag', N'Hamburg', CAST(N'2018-11-25T13:30:00.867' AS DateTime), 0, 250, 227, 2023, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2484, N'Dallas', N'New York', CAST(N'2018-07-27T23:30:00.900' AS DateTime), 0, 250, 107, 2189, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2485, N'Hamburg', N'Prag', CAST(N'2018-12-06T14:47:00.923' AS DateTime), 0, 250, 238, 2164, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2486, N'Oslo', N'Paris', CAST(N'2018-08-08T00:47:00.943' AS DateTime), 0, 250, 118, 2018, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2487, N'Hamburg', N'Köln/Bonn', CAST(N'2018-12-17T16:04:00.963' AS DateTime), 0, 250, 249, 2158, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2488, N'Moskau', N'Madrid', CAST(N'2018-08-20T02:11:00.983' AS DateTime), 0, 250, 130, 2020, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2489, N'Paris', N'Oslo', CAST(N'2018-04-21T12:11:01.000' AS DateTime), 0, 250, 10, 2175, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2490, N'Hamburg', N'Rom', CAST(N'2018-08-31T03:28:01.037' AS DateTime), 0, 250, 141, 2065, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2491, N'Mailand', N'London', CAST(N'2018-05-02T13:28:01.057' AS DateTime), 0, 250, 21, 2090, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2492, N'Essen/Mülheim', N'Mailand', CAST(N'2018-09-11T04:45:01.077' AS DateTime), 0, 250, 152, 2163, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2493, N'Essen/Mülheim', N'Seattle', CAST(N'2018-05-14T14:52:01.097' AS DateTime), 0, 250, 33, 2104, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2494, N'Prag', N'London', CAST(N'2018-09-22T06:02:01.117' AS DateTime), 0, 250, 163, 2177, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2495, N'Rom', N'Essen/Mülheim', CAST(N'2018-05-25T16:09:01.143' AS DateTime), 0, 250, 40, 2087, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2496, N'Paris', N'Hamburg', CAST(N'2018-10-03T07:19:01.167' AS DateTime), 0, 250, 174, 2073, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2497, N'Moskau', N'Hamburg', CAST(N'2018-06-05T17:26:01.187' AS DateTime), 0, 250, 55, 2032, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2498, N'Frankfurt', N'Prag', CAST(N'2018-10-15T08:43:01.207' AS DateTime), 0, 250, 186, 2169, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2499, N'Madrid', N'Köln/Bonn', CAST(N'2018-06-16T18:43:01.247' AS DateTime), 0, 250, 66, 2115, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2500, N'Moskau', N'Rom', CAST(N'2018-10-26T10:00:01.273' AS DateTime), 0, 250, 197, 2012, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2501, N'Dallas', N'Mailand', CAST(N'2018-06-27T20:00:01.293' AS DateTime), 0, 250, 77, 2133, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2502, N'Madrid', N'Frankfurt', CAST(N'2018-11-06T11:17:01.313' AS DateTime), 0, 250, 208, 2094, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2503, N'Mailand', N'Seattle', CAST(N'2018-07-09T21:24:01.333' AS DateTime), 0, 250, 89, 2123, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2504, N'London', N'Prag', CAST(N'2018-11-17T12:34:01.353' AS DateTime), 0, 250, 219, 2019, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2505, N'Hamburg', N'Dallas', CAST(N'2018-07-20T22:41:01.377' AS DateTime), 0, 250, 100, 2163, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2506, N'Seattle', N'Mailand', CAST(N'2018-11-29T13:58:01.397' AS DateTime), 0, 250, 231, 2097, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2507, N'Madrid', N'New York', CAST(N'2018-07-31T23:58:01.423' AS DateTime), 0, 250, 111, 2125, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2508, N'Frankfurt', N'München', CAST(N'2018-12-10T15:15:01.470' AS DateTime), 0, 250, 242, 2077, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2509, N'Madrid', N'Moskau', CAST(N'2018-08-12T01:15:01.490' AS DateTime), 0, 250, 122, 2183, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2510, N'Hamburg', N'Paris', CAST(N'2018-04-14T11:22:01.510' AS DateTime), 0, 250, 3, 2092, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2511, N'Prag', N'Oslo', CAST(N'2018-08-24T02:39:01.533' AS DateTime), 0, 250, 134, 2044, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2512, N'Paris', N'Seattle', CAST(N'2018-04-25T12:39:01.553' AS DateTime), 0, 250, 14, 2192, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2513, N'Oslo', N'Prag', CAST(N'2018-09-04T03:56:01.577' AS DateTime), 0, 250, 145, 2149, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2514, N'Hamburg', N'Seattle', CAST(N'2018-05-06T13:56:01.600' AS DateTime), 0, 250, 25, 2014, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2515, N'Rom', N'Essen/Mülheim', CAST(N'2018-09-15T05:13:01.620' AS DateTime), 0, 250, 152, 2127, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2516, N'Oslo', N'Paris', CAST(N'2018-05-18T15:20:01.640' AS DateTime), 0, 250, 37, 2181, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2517, N'Frankfurt', N'Kapstadt', CAST(N'2018-09-26T06:30:01.687' AS DateTime), 0, 250, 167, 2038, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2518, N'Rom', N'Kapstadt', CAST(N'2018-05-29T16:37:01.713' AS DateTime), 0, 250, 44, 2121, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2519, N'New York', N'Madrid', CAST(N'2018-10-07T07:47:01.733' AS DateTime), 0, 250, 178, 2150, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2520, N'London', N'München', CAST(N'2018-06-09T17:54:01.757' AS DateTime), 0, 250, 59, 2069, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2521, N'Seattle', N'Rom', CAST(N'2018-10-19T09:11:01.780' AS DateTime), 0, 250, 190, 2036, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2522, N'Rom', N'Essen/Mülheim', CAST(N'2018-06-20T19:11:01.803' AS DateTime), 0, 250, 66, 2082, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2523, N'Dallas', N'Prag', CAST(N'2018-10-30T10:28:01.847' AS DateTime), 0, 250, 201, 2112, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2524, N'London', N'Oslo', CAST(N'2018-07-01T20:28:01.867' AS DateTime), 0, 250, 81, 2087, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2525, N'London', N'Frankfurt', CAST(N'2018-11-10T11:45:01.887' AS DateTime), 0, 250, 212, 2013, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2526, N'Frankfurt', N'Dallas', CAST(N'2018-07-13T21:52:01.910' AS DateTime), 0, 250, 93, 2004, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2527, N'Kapstadt', N'London', CAST(N'2018-11-21T13:02:01.930' AS DateTime), 0, 250, 223, 2017, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2528, N'Moskau', N'Köln/Bonn', CAST(N'2018-07-24T23:09:01.953' AS DateTime), 0, 250, 104, 2049, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2529, N'Frankfurt', N'New York', CAST(N'2018-12-02T14:19:01.973' AS DateTime), 0, 250, 234, 2140, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2530, N'Berlin', N'London', CAST(N'2018-08-05T00:26:01.993' AS DateTime), 0, 250, 115, 2012, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2531, N'Essen/Mülheim', N'London', CAST(N'2018-12-14T15:43:02.017' AS DateTime), 0, 250, 246, 2013, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2532, N'Berlin', N'Moskau', CAST(N'2018-08-16T01:43:02.063' AS DateTime), 0, 250, 126, 2070, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2533, N'Hamburg', N'Berlin', CAST(N'2018-04-18T11:50:02.083' AS DateTime), 0, 250, 7, 2184, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2534, N'Moskau', N'Köln/Bonn', CAST(N'2018-08-27T03:00:02.103' AS DateTime), 0, 250, 137, 2168, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2535, N'Köln/Bonn', N'Moskau', CAST(N'2018-04-29T13:07:02.127' AS DateTime), 0, 250, 18, 2124, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2536, N'Prag', N'Oslo', CAST(N'2018-09-08T04:24:02.147' AS DateTime), 0, 250, 149, 2147, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2537, N'Prag', N'Kapstadt', CAST(N'2018-05-10T14:24:02.167' AS DateTime), 0, 250, 29, 2052, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2538, N'München', N'Berlin', CAST(N'2018-09-19T05:41:02.187' AS DateTime), 0, 250, 160, 2187, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2539, N'Hamburg', N'München', CAST(N'2018-05-22T15:48:02.207' AS DateTime), 0, 250, 41, 2141, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2540, N'Dallas', N'Hamburg', CAST(N'2018-09-30T06:58:02.230' AS DateTime), 0, 250, 171, 2101, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2541, N'Moskau', N'Prag', CAST(N'2018-06-02T17:05:02.273' AS DateTime), 0, 250, 52, 2075, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2542, N'Dallas', N'Essen/Mülheim', CAST(N'2018-10-11T08:15:02.297' AS DateTime), 0, 250, 182, 2004, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2543, N'Mailand', N'New York', CAST(N'2018-06-13T18:22:02.317' AS DateTime), 0, 250, 63, 2168, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2544, N'Kapstadt', N'Paris', CAST(N'2018-10-23T09:39:02.337' AS DateTime), 0, 250, 194, 2103, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2545, N'Rom', N'Paris', CAST(N'2018-06-24T19:39:02.357' AS DateTime), 0, 250, 70, 2167, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2546, N'Seattle', N'London', CAST(N'2018-11-03T10:56:02.377' AS DateTime), 0, 250, 205, 2019, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2547, N'London', N'Kapstadt', CAST(N'2018-07-05T20:56:02.397' AS DateTime), 0, 250, 85, 2032, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2548, N'Berlin', N'Kapstadt', CAST(N'2018-11-14T12:13:02.417' AS DateTime), 0, 250, 216, 2054, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2549, N'Frankfurt', N'Köln/Bonn', CAST(N'2018-07-17T22:20:02.437' AS DateTime), 0, 250, 97, 2006, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2550, N'New York', N'München', CAST(N'2018-11-25T13:30:02.483' AS DateTime), 0, 250, 227, 2012, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2551, N'Rom', N'Dallas', CAST(N'2018-07-28T23:37:02.510' AS DateTime), 0, 250, 104, 2076, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2552, N'Essen/Mülheim', N'Köln/Bonn', CAST(N'2018-12-06T14:47:02.530' AS DateTime), 0, 250, 238, 2173, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2553, N'Berlin', N'Köln/Bonn', CAST(N'2018-08-09T00:54:02.550' AS DateTime), 0, 250, 119, 2176, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2554, N'Moskau', N'Berlin', CAST(N'2018-04-11T11:01:02.570' AS DateTime), 0, 250, 0, 2055, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2555, N'Oslo', N'Essen/Mülheim', CAST(N'2018-08-20T02:11:02.587' AS DateTime), 0, 250, 130, 2076, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2556, N'Essen/Mülheim', N'Kapstadt', CAST(N'2018-04-22T12:18:02.630' AS DateTime), 0, 250, 11, 2117, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2557, N'Frankfurt', N'Mailand', CAST(N'2018-08-31T03:28:02.650' AS DateTime), 0, 250, 141, 2149, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2558, N'New York', N'Moskau', CAST(N'2018-05-03T13:35:02.670' AS DateTime), 0, 250, 22, 2079, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2559, N'London', N'Prag', CAST(N'2018-09-12T04:52:02.687' AS DateTime), 0, 250, 153, 2144, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2560, N'Frankfurt', N'Oslo', CAST(N'2018-05-14T14:52:02.707' AS DateTime), 0, 250, 33, 2095, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2561, N'Dallas', N'Madrid', CAST(N'2018-09-23T06:09:02.727' AS DateTime), 0, 250, 164, 2093, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2562, N'Kapstadt', N'Prag', CAST(N'2018-05-25T16:09:02.747' AS DateTime), 0, 250, 44, 2093, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2563, N'München', N'Prag', CAST(N'2018-10-04T07:26:02.767' AS DateTime), 0, 250, 175, 2035, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2564, N'Dallas', N'Seattle', CAST(N'2018-06-06T17:33:02.790' AS DateTime), 0, 250, 56, 2023, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2565, N'Hamburg', N'Kapstadt', CAST(N'2018-10-15T08:43:02.833' AS DateTime), 0, 250, 186, 2148, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2566, N'Madrid', N'München', CAST(N'2018-06-17T18:50:02.847' AS DateTime), 0, 250, 67, 2019, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2567, N'Oslo', N'London', CAST(N'2018-10-27T10:07:02.857' AS DateTime), 0, 250, 198, 2088, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2568, N'Mailand', N'Prag', CAST(N'2018-06-28T20:07:02.867' AS DateTime), 0, 250, 78, 2136, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2569, N'Rom', N'Seattle', CAST(N'2018-11-07T11:24:02.877' AS DateTime), 0, 250, 205, 2072, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2570, N'Dallas', N'Paris', CAST(N'2018-07-09T21:24:02.887' AS DateTime), 0, 250, 89, 2141, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2571, N'München', N'Oslo', CAST(N'2018-11-18T12:41:02.897' AS DateTime), 0, 250, 220, 2072, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2572, N'Paris', N'Moskau', CAST(N'2018-07-21T22:48:02.907' AS DateTime), 0, 250, 101, 2043, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2573, N'Kapstadt', N'Frankfurt', CAST(N'2018-11-29T13:58:02.917' AS DateTime), 0, 250, 231, 2040, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2574, N'Oslo', N'Moskau', CAST(N'2018-08-02T00:05:02.937' AS DateTime), 0, 250, 112, 2052, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2575, N'Paris', N'München', CAST(N'2018-12-10T15:15:02.947' AS DateTime), 0, 250, 242, 2157, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2576, N'New York', N'Paris', CAST(N'2018-08-13T01:22:02.957' AS DateTime), 0, 250, 123, 2160, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2577, N'New York', N'Mailand', CAST(N'2018-04-15T11:29:02.967' AS DateTime), 0, 250, 4, 2081, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2578, N'New York', N'Hamburg', CAST(N'2018-08-24T02:39:02.977' AS DateTime), 0, 250, 134, 2108, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2579, N'Berlin', N'Prag', CAST(N'2018-04-26T12:46:02.987' AS DateTime), 0, 250, 15, 2057, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2580, N'Kapstadt', N'Mailand', CAST(N'2018-09-04T03:56:03.007' AS DateTime), 0, 250, 145, 2169, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2581, N'Frankfurt', N'München', CAST(N'2018-05-07T14:03:03.017' AS DateTime), 0, 250, 26, 2027, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2582, N'Mailand', N'Kapstadt', CAST(N'2018-09-16T05:20:03.027' AS DateTime), 0, 250, 157, 2155, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2583, N'Essen/Mülheim', N'Kapstadt', CAST(N'2018-05-18T15:20:03.037' AS DateTime), 0, 250, 37, 2036, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2584, N'Prag', N'Frankfurt', CAST(N'2018-09-27T06:37:03.047' AS DateTime), 0, 250, 168, 2008, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2585, N'Oslo', N'Dallas', CAST(N'2018-05-29T16:37:03.053' AS DateTime), 0, 250, 48, 2149, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2586, N'Hamburg', N'Berlin', CAST(N'2018-10-08T07:54:03.063' AS DateTime), 0, 250, 179, 2085, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2587, N'Oslo', N'Seattle', CAST(N'2018-06-10T18:01:03.077' AS DateTime), 0, 250, 60, 2056, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2588, N'Moskau', N'Rom', CAST(N'2018-10-19T09:11:03.090' AS DateTime), 0, 250, 190, 2191, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2589, N'Rom', N'Prag', CAST(N'2018-06-21T19:18:03.127' AS DateTime), 0, 250, 67, 2141, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2590, N'Kapstadt', N'London', CAST(N'2018-10-30T10:28:03.143' AS DateTime), 0, 250, 201, 2013, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2591, N'Oslo', N'Berlin', CAST(N'2018-07-02T20:35:03.157' AS DateTime), 0, 250, 82, 2125, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2592, N'London', N'Kapstadt', CAST(N'2018-11-11T11:52:03.170' AS DateTime), 0, 250, 213, 2091, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2593, N'München', N'Dallas', CAST(N'2018-07-13T21:52:03.180' AS DateTime), 0, 250, 93, 2060, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2594, N'Berlin', N'Madrid', CAST(N'2018-11-22T13:09:03.193' AS DateTime), 0, 250, 224, 2119, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2595, N'New York', N'München', CAST(N'2018-07-24T23:09:03.203' AS DateTime), 0, 250, 104, 2076, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2596, N'London', N'Essen/Mülheim', CAST(N'2018-12-03T14:26:03.217' AS DateTime), 0, 250, 235, 2047, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2597, N'Kapstadt', N'Madrid', CAST(N'2018-08-06T00:33:03.227' AS DateTime), 0, 250, 116, 2102, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2598, N'Kapstadt', N'Moskau', CAST(N'2018-12-14T15:43:03.243' AS DateTime), 0, 250, 246, 2110, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2599, N'Kapstadt', N'Hamburg', CAST(N'2018-08-17T01:50:03.253' AS DateTime), 0, 250, 127, 2033, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2600, N'Rom', N'Frankfurt', CAST(N'2018-04-19T11:57:03.263' AS DateTime), 0, 250, 4, 2187, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2601, N'Paris', N'München', CAST(N'2018-08-28T03:07:03.273' AS DateTime), 0, 250, 138, 2119, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2602, N'Berlin', N'Paris', CAST(N'2018-04-30T13:14:03.283' AS DateTime), 0, 250, 19, 2107, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2603, N'Hamburg', N'Rom', CAST(N'2018-09-08T04:24:03.293' AS DateTime), 0, 250, 149, 2011, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2604, N'Frankfurt', N'München', CAST(N'2018-05-11T14:31:03.303' AS DateTime), 0, 250, 30, 2176, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2605, N'Kapstadt', N'Seattle', CAST(N'2018-09-20T05:48:03.313' AS DateTime), 0, 250, 161, 2186, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2606, N'Hamburg', N'Moskau', CAST(N'2018-05-22T15:48:03.323' AS DateTime), 0, 250, 41, 2186, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2607, N'Kapstadt', N'Mailand', CAST(N'2018-10-01T07:05:03.343' AS DateTime), 0, 250, 172, 2006, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2608, N'Frankfurt', N'München', CAST(N'2018-06-02T17:05:03.357' AS DateTime), 0, 250, 52, 2165, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2609, N'Kapstadt', N'Köln/Bonn', CAST(N'2018-10-12T08:22:03.367' AS DateTime), 0, 250, 183, 2127, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2610, N'Dallas', N'Kapstadt', CAST(N'2018-06-14T18:29:03.377' AS DateTime), 0, 250, 64, 2198, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2611, N'München', N'Prag', CAST(N'2018-10-23T09:39:03.387' AS DateTime), 0, 250, 194, 2106, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2612, N'Rom', N'Dallas', CAST(N'2018-06-25T19:46:03.397' AS DateTime), 0, 250, 71, 2041, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2613, N'Frankfurt', N'Mailand', CAST(N'2018-11-03T10:56:03.413' AS DateTime), 0, 250, 205, 2161, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2614, N'Paris', N'Essen/Mülheim', CAST(N'2018-07-06T21:03:03.423' AS DateTime), 0, 250, 86, 2001, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2615, N'Dallas', N'Madrid', CAST(N'2018-11-15T12:20:03.430' AS DateTime), 0, 250, 217, 2124, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2616, N'New York', N'Moskau', CAST(N'2018-07-17T22:20:03.440' AS DateTime), 0, 250, 97, 2046, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2617, N'Prag', N'Moskau', CAST(N'2018-11-26T13:37:03.450' AS DateTime), 0, 250, 228, 2182, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2618, N'Oslo', N'Moskau', CAST(N'2018-07-28T23:37:03.460' AS DateTime), 0, 250, 108, 2104, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2619, N'Oslo', N'Moskau', CAST(N'2018-12-07T14:54:03.470' AS DateTime), 0, 250, 239, 2149, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2620, N'Oslo', N'New York', CAST(N'2018-08-10T01:01:03.480' AS DateTime), 0, 250, 120, 2021, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2621, N'Rom', N'München', CAST(N'2018-04-11T11:01:03.487' AS DateTime), 0, 250, -4, 2188, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2622, N'Madrid', N'Prag', CAST(N'2018-08-21T02:18:03.507' AS DateTime), 0, 250, 131, 2084, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2623, N'Seattle', N'Köln/Bonn', CAST(N'2018-04-22T12:18:03.517' AS DateTime), 0, 250, 11, 2195, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2624, N'Moskau', N'Paris', CAST(N'2018-09-01T03:35:03.527' AS DateTime), 0, 250, 142, 2106, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2625, N'Seattle', N'München', CAST(N'2018-05-04T13:42:03.533' AS DateTime), 0, 250, 23, 2068, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2626, N'München', N'Kapstadt', CAST(N'2018-09-12T04:52:03.543' AS DateTime), 0, 250, 153, 2182, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2627, N'New York', N'Berlin', CAST(N'2018-05-15T14:59:03.553' AS DateTime), 0, 250, 34, 2072, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2628, N'Prag', N'Mailand', CAST(N'2018-09-23T06:09:03.563' AS DateTime), 0, 250, 164, 2069, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2629, N'Berlin', N'Köln/Bonn', CAST(N'2018-05-26T16:16:03.573' AS DateTime), 0, 250, 45, 2189, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2630, N'Berlin', N'Paris', CAST(N'2018-10-05T07:33:03.597' AS DateTime), 0, 250, 176, 2075, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2631, N'Mailand', N'München', CAST(N'2018-06-06T17:33:03.633' AS DateTime), 0, 250, 56, 2167, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2632, N'Seattle', N'München', CAST(N'2018-10-16T08:50:03.657' AS DateTime), 0, 250, 187, 2120, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2633, N'Frankfurt', N'München', CAST(N'2018-06-18T18:57:03.673' AS DateTime), 0, 250, 68, 2072, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2634, N'Hamburg', N'Oslo', CAST(N'2018-10-27T10:07:03.690' AS DateTime), 0, 250, 198, 2067, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2635, N'Köln/Bonn', N'Oslo', CAST(N'2018-06-29T20:14:03.710' AS DateTime), 0, 250, 79, 2037, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2636, N'London', N'Hamburg', CAST(N'2018-11-07T11:24:03.727' AS DateTime), 0, 250, 209, 2087, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2637, N'Hamburg', N'Essen/Mülheim', CAST(N'2018-07-10T21:31:03.757' AS DateTime), 0, 250, 90, 2151, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2638, N'Kapstadt', N'Rom', CAST(N'2018-11-19T12:48:03.777' AS DateTime), 0, 250, 221, 2128, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2639, N'New York', N'Moskau', CAST(N'2018-07-21T22:48:03.800' AS DateTime), 0, 250, 101, 2166, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2640, N'Rom', N'Mailand', CAST(N'2018-11-30T14:05:03.823' AS DateTime), 0, 250, 228, 2132, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2641, N'Madrid', N'Moskau', CAST(N'2018-08-02T00:05:03.847' AS DateTime), 0, 250, 112, 2025, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2642, N'Köln/Bonn', N'Seattle', CAST(N'2018-12-11T15:22:03.867' AS DateTime), 0, 250, 243, 2002, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2643, N'Berlin', N'Essen/Mülheim', CAST(N'2018-08-14T01:29:03.890' AS DateTime), 0, 250, 124, 2017, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2644, N'Seattle', N'Prag', CAST(N'2018-04-15T11:29:03.910' AS DateTime), 0, 250, 4, 2087, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2645, N'Frankfurt', N'Berlin', CAST(N'2018-08-25T02:46:03.933' AS DateTime), 0, 250, 135, 2060, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2646, N'Prag', N'München', CAST(N'2018-04-26T12:46:03.973' AS DateTime), 0, 250, 15, 2129, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2647, N'Berlin', N'Prag', CAST(N'2018-09-05T04:03:03.987' AS DateTime), 0, 250, 146, 2165, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2648, N'New York', N'Madrid', CAST(N'2018-05-08T14:10:04.003' AS DateTime), 0, 250, 27, 2040, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2649, N'Dallas', N'London', CAST(N'2018-09-16T05:20:04.017' AS DateTime), 0, 250, 157, 2188, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2650, N'Mailand', N'Rom', CAST(N'2018-05-19T15:27:04.033' AS DateTime), 0, 250, 38, 2016, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2651, N'Essen/Mülheim', N'Rom', CAST(N'2018-09-27T06:37:04.057' AS DateTime), 0, 250, 168, 2099, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2652, N'New York', N'Kapstadt', CAST(N'2018-05-30T16:44:04.077' AS DateTime), 0, 250, 49, 2182, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2653, N'Seattle', N'Hamburg', CAST(N'2018-10-09T08:01:04.097' AS DateTime), 0, 250, 180, 2084, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2654, N'Paris', N'Seattle', CAST(N'2018-06-10T18:01:04.120' AS DateTime), 0, 250, 60, 2013, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2655, N'Rom', N'Madrid', CAST(N'2018-10-20T09:18:04.163' AS DateTime), 0, 250, 187, 2113, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2656, N'Seattle', N'Mailand', CAST(N'2018-06-21T19:18:04.193' AS DateTime), 0, 250, 71, 2027, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2657, N'Paris', N'Hamburg', CAST(N'2018-10-31T10:35:04.213' AS DateTime), 0, 250, 202, 2050, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2658, N'Dallas', N'Madrid', CAST(N'2018-07-03T20:42:04.233' AS DateTime), 0, 250, 83, 2040, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2659, N'Dallas', N'Mailand', CAST(N'2018-11-11T11:52:04.253' AS DateTime), 0, 250, 213, 2084, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2660, N'Mailand', N'Berlin', CAST(N'2018-07-14T21:59:04.273' AS DateTime), 0, 250, 94, 2130, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2661, N'Kapstadt', N'New York', CAST(N'2018-11-23T13:16:04.317' AS DateTime), 0, 250, 225, 2077, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2662, N'Mailand', N'Seattle', CAST(N'2018-07-25T23:16:04.337' AS DateTime), 0, 250, 105, 2159, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2663, N'Prag', N'New York', CAST(N'2018-12-04T14:33:04.357' AS DateTime), 0, 250, 236, 2142, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2664, N'Köln/Bonn', N'Dallas', CAST(N'2018-08-06T00:33:04.377' AS DateTime), 0, 250, 116, 2166, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2665, N'Frankfurt', N'London', CAST(N'2018-12-15T15:50:04.400' AS DateTime), 0, 250, 247, 2190, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2666, N'Prag', N'London', CAST(N'2018-08-18T01:57:04.420' AS DateTime), 0, 250, 128, 2002, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2667, N'New York', N'Köln/Bonn', CAST(N'2018-04-19T11:57:04.440' AS DateTime), 0, 250, 8, 2181, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2668, N'Kapstadt', N'Berlin', CAST(N'2018-08-29T03:14:04.460' AS DateTime), 0, 250, 139, 2023, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2669, N'Kapstadt', N'Essen/Mülheim', CAST(N'2018-04-30T13:14:04.480' AS DateTime), 0, 250, 19, 2089, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2670, N'Rom', N'New York', CAST(N'2018-09-09T04:31:04.523' AS DateTime), 0, 250, 146, 2064, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2671, N'Mailand', N'Hamburg', CAST(N'2018-05-12T14:38:04.540' AS DateTime), 0, 250, 31, 2032, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2672, N'Essen/Mülheim', N'New York', CAST(N'2018-09-20T05:48:04.553' AS DateTime), 0, 250, 161, 2014, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2673, N'Seattle', N'Kapstadt', CAST(N'2018-05-23T15:55:04.567' AS DateTime), 0, 250, 42, 2028, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2674, N'Essen/Mülheim', N'Hamburg', CAST(N'2018-10-01T07:05:04.580' AS DateTime), 0, 250, 172, 2160, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2675, N'Paris', N'Hamburg', CAST(N'2018-06-03T17:12:04.593' AS DateTime), 0, 250, 53, 2048, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2676, N'Paris', N'Madrid', CAST(N'2018-10-13T08:29:04.607' AS DateTime), 0, 250, 184, 2090, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2677, N'Köln/Bonn', N'Paris', CAST(N'2018-06-14T18:29:04.617' AS DateTime), 0, 250, 64, 2031, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2678, N'Paris', N'Madrid', CAST(N'2018-10-24T09:46:04.630' AS DateTime), 0, 250, 195, 2160, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2679, N'Essen/Mülheim', N'Dallas', CAST(N'2018-06-25T19:46:04.663' AS DateTime), 0, 250, 75, 2121, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2680, N'Köln/Bonn', N'New York', CAST(N'2018-11-04T11:03:04.680' AS DateTime), 0, 250, 206, 2189, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2681, N'London', N'Köln/Bonn', CAST(N'2018-07-07T21:10:04.700' AS DateTime), 0, 250, 87, 2198, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2682, N'Paris', N'Essen/Mülheim', CAST(N'2018-11-15T12:20:04.717' AS DateTime), 0, 250, 217, 2150, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2683, N'Seattle', N'Rom', CAST(N'2018-07-18T22:27:04.737' AS DateTime), 0, 250, 98, 2148, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2684, N'Prag', N'Madrid', CAST(N'2018-11-26T13:37:04.753' AS DateTime), 0, 250, 228, 2173, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2685, N'Berlin', N'Frankfurt', CAST(N'2018-07-29T23:44:04.773' AS DateTime), 0, 250, 109, 2078, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2686, N'Kapstadt', N'Madrid', CAST(N'2018-12-08T15:01:04.797' AS DateTime), 0, 250, 240, 2083, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2687, N'Oslo', N'Dallas', CAST(N'2018-08-10T01:01:04.817' AS DateTime), 0, 250, 120, 2009, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2688, N'Köln/Bonn', N'München', CAST(N'2018-04-12T11:08:04.863' AS DateTime), 0, 250, 1, 2017, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2689, N'Berlin', N'New York', CAST(N'2018-08-21T02:18:04.893' AS DateTime), 0, 250, 131, 2092, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2690, N'Paris', N'München', CAST(N'2018-04-23T12:25:04.907' AS DateTime), 0, 250, 12, 2039, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2691, N'Paris', N'Dallas', CAST(N'2018-09-02T03:42:04.923' AS DateTime), 0, 250, 143, 2161, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2692, N'Berlin', N'Mailand', CAST(N'2018-05-04T13:42:04.933' AS DateTime), 0, 250, 23, 2097, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2693, N'Essen/Mülheim', N'Prag', CAST(N'2018-09-13T04:59:04.940' AS DateTime), 0, 250, 154, 2141, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2694, N'London', N'Moskau', CAST(N'2018-05-16T15:06:04.960' AS DateTime), 0, 250, 35, 2122, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2695, N'Prag', N'Dallas', CAST(N'2018-09-24T06:16:04.970' AS DateTime), 0, 250, 165, 2150, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2696, N'New York', N'Moskau', CAST(N'2018-05-27T16:23:04.980' AS DateTime), 0, 250, 46, 2158, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2697, N'Paris', N'Köln/Bonn', CAST(N'2018-10-05T07:33:04.990' AS DateTime), 0, 250, 176, 2008, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2698, N'London', N'Hamburg', CAST(N'2018-06-07T17:40:05.000' AS DateTime), 0, 250, 57, 2154, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2699, N'Köln/Bonn', N'New York', CAST(N'2018-10-17T08:57:05.010' AS DateTime), 0, 250, 188, 2082, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2700, N'Frankfurt', N'Paris', CAST(N'2018-06-18T18:57:05.027' AS DateTime), 0, 250, 68, 2094, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2701, N'London', N'Seattle', CAST(N'2018-10-28T10:14:05.040' AS DateTime), 0, 250, 199, 2090, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2702, N'Frankfurt', N'Rom', CAST(N'2018-06-29T20:14:05.060' AS DateTime), 0, 250, 79, 2073, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2703, N'London', N'Paris', CAST(N'2018-11-08T11:31:05.080' AS DateTime), 0, 250, 210, 2133, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2704, N'London', N'Rom', CAST(N'2018-07-11T21:38:05.093' AS DateTime), 0, 250, 91, 2135, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2705, N'Seattle', N'Moskau', CAST(N'2018-11-19T12:48:05.107' AS DateTime), 0, 250, 221, 2108, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2706, N'London', N'Moskau', CAST(N'2018-07-22T22:55:05.113' AS DateTime), 0, 250, 102, 2076, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2707, N'Frankfurt', N'Seattle', CAST(N'2018-11-30T14:05:05.123' AS DateTime), 0, 250, 232, 2004, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2708, N'Oslo', N'München', CAST(N'2018-08-03T00:12:05.133' AS DateTime), 0, 250, 113, 2012, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2709, N'Essen/Mülheim', N'Berlin', CAST(N'2018-12-12T15:29:05.143' AS DateTime), 0, 250, 244, 2160, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2710, N'Kapstadt', N'Frankfurt', CAST(N'2018-08-14T01:29:05.150' AS DateTime), 0, 250, 124, 2086, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2711, N'Köln/Bonn', N'New York', CAST(N'2018-04-16T11:36:05.160' AS DateTime), 0, 250, 5, 2189, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2712, N'Frankfurt', N'Hamburg', CAST(N'2018-08-25T02:46:05.177' AS DateTime), 0, 250, 135, 2173, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2713, N'Prag', N'New York', CAST(N'2018-04-27T12:53:05.187' AS DateTime), 0, 250, 16, 2070, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2714, N'Köln/Bonn', N'Paris', CAST(N'2018-09-06T04:10:05.193' AS DateTime), 0, 250, 147, 2001, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2715, N'Moskau', N'Seattle', CAST(N'2018-05-08T14:10:05.203' AS DateTime), 0, 250, 27, 2013, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2716, N'Prag', N'Frankfurt', CAST(N'2018-09-17T05:27:05.210' AS DateTime), 0, 250, 158, 2134, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2717, N'München', N'Frankfurt', CAST(N'2018-05-19T15:27:05.220' AS DateTime), 0, 250, 38, 2142, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2718, N'Oslo', N'Berlin', CAST(N'2018-09-28T06:44:05.227' AS DateTime), 0, 250, 169, 2149, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2719, N'Prag', N'Paris', CAST(N'2018-05-31T16:51:05.237' AS DateTime), 0, 250, 50, 2068, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2720, N'Köln/Bonn', N'Moskau', CAST(N'2018-10-09T08:01:05.247' AS DateTime), 0, 250, 180, 2117, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2721, N'Rom', N'Köln/Bonn', CAST(N'2018-06-11T18:08:05.263' AS DateTime), 0, 250, 57, 2030, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2722, N'Seattle', N'Essen/Mülheim', CAST(N'2018-10-20T09:18:05.277' AS DateTime), 0, 250, 191, 2115, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2723, N'London', N'Seattle', CAST(N'2018-06-22T19:25:05.283' AS DateTime), 0, 250, 72, 2161, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2724, N'Dallas', N'Berlin', CAST(N'2018-11-01T10:42:05.293' AS DateTime), 0, 250, 203, 2164, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2725, N'Köln/Bonn', N'Berlin', CAST(N'2018-07-03T20:42:05.300' AS DateTime), 0, 250, 83, 2072, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2726, N'Mailand', N'Dallas', CAST(N'2018-11-12T11:59:05.310' AS DateTime), 0, 250, 214, 2048, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2727, N'Oslo', N'München', CAST(N'2018-07-15T22:06:05.327' AS DateTime), 0, 250, 95, 2131, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2728, N'Berlin', N'Seattle', CAST(N'2018-11-23T13:16:05.337' AS DateTime), 0, 250, 225, 2059, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2729, N'Moskau', N'Hamburg', CAST(N'2018-07-26T23:23:05.347' AS DateTime), 0, 250, 106, 2128, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2730, N'Essen/Mülheim', N'London', CAST(N'2018-12-04T14:33:05.357' AS DateTime), 0, 250, 236, 2030, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2731, N'Rom', N'Frankfurt', CAST(N'2018-08-07T00:40:05.367' AS DateTime), 0, 250, 113, 2135, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2732, N'Kapstadt', N'Seattle', CAST(N'2018-12-16T15:57:05.377' AS DateTime), 0, 250, 248, 2066, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2733, N'Prag', N'Paris', CAST(N'2018-08-18T01:57:05.387' AS DateTime), 0, 250, 128, 2158, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2734, N'Prag', N'London', CAST(N'2018-04-20T12:04:05.397' AS DateTime), 0, 250, 9, 2091, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2735, N'Köln/Bonn', N'Essen/Mülheim', CAST(N'2018-08-29T03:14:05.407' AS DateTime), 0, 250, 139, 2180, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2736, N'Hamburg', N'Mailand', CAST(N'2018-05-01T13:21:05.427' AS DateTime), 0, 250, 20, 2088, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2737, N'Frankfurt', N'Berlin', CAST(N'2018-09-10T04:38:05.433' AS DateTime), 0, 250, 151, 2080, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2738, N'Frankfurt', N'Rom', CAST(N'2018-05-12T14:38:05.443' AS DateTime), 0, 250, 31, 2087, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2739, N'Oslo', N'Rom', CAST(N'2018-09-21T05:55:05.453' AS DateTime), 0, 250, 162, 2103, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2740, N'Madrid', N'Frankfurt', CAST(N'2018-05-23T15:55:05.463' AS DateTime), 0, 250, 42, 2106, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2741, N'Oslo', N'Moskau', CAST(N'2018-10-02T07:12:05.473' AS DateTime), 0, 250, 173, 2065, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2742, N'Oslo', N'München', CAST(N'2018-06-04T17:19:05.483' AS DateTime), 0, 250, 54, 2084, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2743, N'Rom', N'Berlin', CAST(N'2018-10-13T08:29:05.490' AS DateTime), 0, 250, 180, 2193, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2744, N'Moskau', N'Mailand', CAST(N'2018-06-15T18:36:05.500' AS DateTime), 0, 250, 65, 2082, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2745, N'Kapstadt', N'Hamburg', CAST(N'2018-10-24T09:46:05.527' AS DateTime), 0, 250, 195, 2153, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2746, N'Dallas', N'Paris', CAST(N'2018-06-26T19:53:05.537' AS DateTime), 0, 250, 76, 2075, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2747, N'Seattle', N'Hamburg', CAST(N'2018-11-05T11:10:05.543' AS DateTime), 0, 250, 207, 2132, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2748, N'Rom', N'Essen/Mülheim', CAST(N'2018-07-07T21:10:05.553' AS DateTime), 0, 250, 83, 2045, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2749, N'Essen/Mülheim', N'Köln/Bonn', CAST(N'2018-11-16T12:27:05.560' AS DateTime), 0, 250, 218, 2180, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2750, N'Paris', N'Kapstadt', CAST(N'2018-07-18T22:27:05.570' AS DateTime), 0, 250, 98, 2134, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2751, N'Rom', N'Köln/Bonn', CAST(N'2018-11-27T13:44:05.593' AS DateTime), 0, 250, 225, 2118, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2752, N'Essen/Mülheim', N'München', CAST(N'2018-07-30T23:51:05.603' AS DateTime), 0, 250, 110, 2118, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2753, N'München', N'Dallas', CAST(N'2018-12-08T15:01:05.617' AS DateTime), 0, 250, 240, 2013, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2754, N'Frankfurt', N'München', CAST(N'2018-08-11T01:08:05.627' AS DateTime), 0, 250, 121, 2015, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2755, N'Frankfurt', N'Kapstadt', CAST(N'2018-04-12T11:08:05.637' AS DateTime), 0, 250, 1, 2129, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2756, N'Oslo', N'New York', CAST(N'2018-08-22T02:25:05.650' AS DateTime), 0, 250, 132, 2145, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2757, N'Prag', N'Moskau', CAST(N'2018-04-24T12:32:05.663' AS DateTime), 0, 250, 13, 2091, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2758, N'Seattle', N'Kapstadt', CAST(N'2018-09-02T03:42:05.677' AS DateTime), 0, 250, 143, 2147, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2759, N'Oslo', N'Berlin', CAST(N'2018-05-05T13:49:05.687' AS DateTime), 0, 250, 24, 2182, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2760, N'Paris', N'München', CAST(N'2018-09-14T05:06:05.710' AS DateTime), 0, 250, 155, 2181, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2761, N'Prag', N'Oslo', CAST(N'2018-05-16T15:06:05.720' AS DateTime), 0, 250, 35, 2043, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2762, N'Hamburg', N'Kapstadt', CAST(N'2018-09-25T06:23:05.727' AS DateTime), 0, 250, 166, 2006, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2763, N'Frankfurt', N'Hamburg', CAST(N'2018-05-27T16:23:05.737' AS DateTime), 0, 250, 46, 2162, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2764, N'Paris', N'Rom', CAST(N'2018-10-06T07:40:05.747' AS DateTime), 0, 250, 177, 2127, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2765, N'Frankfurt', N'Moskau', CAST(N'2018-06-08T17:47:05.757' AS DateTime), 0, 250, 58, 2049, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2766, N'Dallas', N'Moskau', CAST(N'2018-10-17T08:57:05.767' AS DateTime), 0, 250, 188, 2172, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2767, N'Moskau', N'Hamburg', CAST(N'2018-06-19T19:04:05.777' AS DateTime), 0, 250, 69, 2173, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2768, N'Köln/Bonn', N'Hamburg', CAST(N'2018-10-28T10:14:05.787' AS DateTime), 0, 250, 199, 2118, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2769, N'Paris', N'Madrid', CAST(N'2018-06-30T20:21:05.810' AS DateTime), 0, 250, 80, 2170, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2770, N'München', N'Seattle', CAST(N'2018-11-09T11:38:05.823' AS DateTime), 0, 250, 211, 2147, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2771, N'Kapstadt', N'München', CAST(N'2018-07-11T21:38:05.833' AS DateTime), 0, 250, 91, 2111, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2772, N'Hamburg', N'Madrid', CAST(N'2018-11-20T12:55:05.840' AS DateTime), 0, 250, 222, 2154, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2773, N'Frankfurt', N'New York', CAST(N'2018-07-22T22:55:05.850' AS DateTime), 0, 250, 102, 2129, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2774, N'London', N'Essen/Mülheim', CAST(N'2018-12-01T14:12:05.860' AS DateTime), 0, 250, 233, 2005, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2775, N'Paris', N'Hamburg', CAST(N'2018-08-04T00:19:05.880' AS DateTime), 0, 250, 114, 2130, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2776, N'Rom', N'Essen/Mülheim', CAST(N'2018-12-12T15:29:05.893' AS DateTime), 0, 250, 237, 2193, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2777, N'Kapstadt', N'Rom', CAST(N'2018-08-15T01:36:05.903' AS DateTime), 0, 250, 125, 2062, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2778, N'London', N'Frankfurt', CAST(N'2018-04-16T11:36:05.917' AS DateTime), 0, 250, 5, 2192, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2779, N'Frankfurt', N'Seattle', CAST(N'2018-08-26T02:53:05.927' AS DateTime), 0, 250, 136, 2150, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2780, N'Dallas', N'Hamburg', CAST(N'2018-04-28T13:00:05.937' AS DateTime), 0, 250, 17, 2193, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2781, N'Prag', N'Frankfurt', CAST(N'2018-09-06T04:10:05.950' AS DateTime), 0, 250, 147, 2127, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2782, N'München', N'Frankfurt', CAST(N'2018-05-09T14:17:05.960' AS DateTime), 0, 250, 28, 2181, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2783, N'Essen/Mülheim', N'Mailand', CAST(N'2018-09-17T05:27:05.973' AS DateTime), 0, 250, 158, 2090, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2784, N'München', N'Essen/Mülheim', CAST(N'2018-05-20T15:34:05.993' AS DateTime), 0, 250, 39, 2196, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2785, N'Prag', N'Hamburg', CAST(N'2018-09-29T06:51:06.003' AS DateTime), 0, 250, 170, 2037, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2786, N'Köln/Bonn', N'Hamburg', CAST(N'2018-05-31T16:51:06.013' AS DateTime), 0, 250, 50, 2105, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2787, N'London', N'Seattle', CAST(N'2018-10-10T08:08:06.023' AS DateTime), 0, 250, 181, 2181, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2788, N'Mailand', N'Madrid', CAST(N'2018-06-12T18:15:06.033' AS DateTime), 0, 250, 62, 2043, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2789, N'Frankfurt', N'Oslo', CAST(N'2018-10-21T09:25:06.040' AS DateTime), 0, 250, 192, 2138, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2790, N'Kapstadt', N'Seattle', CAST(N'2018-06-23T19:32:06.053' AS DateTime), 0, 250, 73, 2024, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2791, N'Paris', N'Seattle', CAST(N'2018-11-01T10:42:06.063' AS DateTime), 0, 250, 203, 2168, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2792, N'Seattle', N'London', CAST(N'2018-07-04T20:49:06.073' AS DateTime), 0, 250, 84, 2050, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2793, N'Frankfurt', N'Essen/Mülheim', CAST(N'2018-11-13T12:06:06.097' AS DateTime), 0, 250, 215, 2119, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2794, N'Rom', N'Prag', CAST(N'2018-07-15T22:06:06.107' AS DateTime), 0, 250, 91, 2142, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2795, N'Prag', N'Rom', CAST(N'2018-11-24T13:23:06.120' AS DateTime), 0, 250, 226, 2161, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2796, N'Prag', N'Mailand', CAST(N'2018-07-26T23:23:06.127' AS DateTime), 0, 250, 106, 2176, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2797, N'Essen/Mülheim', N'New York', CAST(N'2018-12-05T14:40:06.137' AS DateTime), 0, 250, 237, 2125, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2798, N'Kapstadt', N'Hamburg', CAST(N'2018-08-08T00:47:06.147' AS DateTime), 0, 250, 118, 2028, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2799, N'Rom', N'Madrid', CAST(N'2018-12-16T15:57:06.157' AS DateTime), 0, 250, 237, 2159, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2800, N'Madrid', N'Essen/Mülheim', CAST(N'2018-08-19T02:04:06.167' AS DateTime), 0, 250, 129, 2133, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2801, N'Paris', N'New York', CAST(N'2018-04-20T12:04:06.177' AS DateTime), 0, 250, 9, 2108, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2802, N'Madrid', N'Seattle', CAST(N'2018-08-30T03:21:06.197' AS DateTime), 0, 250, 140, 2165, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2803, N'Kapstadt', N'Oslo', CAST(N'2018-05-02T13:28:06.210' AS DateTime), 0, 250, 21, 2029, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2804, N'Mailand', N'Oslo', CAST(N'2018-09-10T04:38:06.223' AS DateTime), 0, 250, 151, 2009, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2805, N'Dallas', N'Prag', CAST(N'2018-05-13T14:45:06.233' AS DateTime), 0, 250, 32, 2082, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2806, N'Moskau', N'Paris', CAST(N'2018-09-21T05:55:06.243' AS DateTime), 0, 250, 162, 2161, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2807, N'Köln/Bonn', N'Hamburg', CAST(N'2018-05-24T16:02:06.253' AS DateTime), 0, 250, 43, 2070, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2808, N'Kapstadt', N'Berlin', CAST(N'2018-10-03T07:19:06.273' AS DateTime), 0, 250, 174, 2009, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2809, N'Prag', N'Köln/Bonn', CAST(N'2018-06-04T17:19:06.287' AS DateTime), 0, 250, 54, 2188, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2810, N'Köln/Bonn', N'Oslo', CAST(N'2018-10-14T08:36:06.297' AS DateTime), 0, 250, 185, 2152, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2811, N'Prag', N'Madrid', CAST(N'2018-06-15T18:36:06.307' AS DateTime), 0, 250, 65, 2060, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2812, N'Madrid', N'Kapstadt', CAST(N'2018-10-25T09:53:06.317' AS DateTime), 0, 250, 196, 2189, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2813, N'Madrid', N'New York', CAST(N'2018-06-27T20:00:06.330' AS DateTime), 0, 250, 77, 2015, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2814, N'Moskau', N'London', CAST(N'2018-11-05T11:10:06.340' AS DateTime), 0, 250, 207, 2062, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2815, N'Seattle', N'Moskau', CAST(N'2018-07-08T21:17:06.350' AS DateTime), 0, 250, 88, 2120, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2816, N'Dallas', N'München', CAST(N'2018-11-16T12:27:06.357' AS DateTime), 0, 250, 218, 2158, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2817, N'Mailand', N'Köln/Bonn', CAST(N'2018-07-19T22:34:06.377' AS DateTime), 0, 250, 99, 2079, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2818, N'Dallas', N'Paris', CAST(N'2018-11-28T13:51:06.387' AS DateTime), 0, 250, 230, 2041, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2819, N'Rom', N'Essen/Mülheim', CAST(N'2018-07-30T23:51:06.397' AS DateTime), 0, 250, 106, 2160, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2820, N'New York', N'Rom', CAST(N'2018-12-09T15:08:06.407' AS DateTime), 0, 250, 241, 2112, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2821, N'Dallas', N'Oslo', CAST(N'2018-08-12T01:15:06.417' AS DateTime), 0, 250, 122, 2104, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2822, N'Hamburg', N'Prag', CAST(N'2018-04-13T11:15:06.427' AS DateTime), 0, 250, 2, 2070, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2823, N'Oslo', N'München', CAST(N'2018-08-23T02:32:06.440' AS DateTime), 0, 250, 133, 2145, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2824, N'Mailand', N'Seattle', CAST(N'2018-04-24T12:32:06.450' AS DateTime), 0, 250, 13, 2161, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2825, N'Essen/Mülheim', N'Seattle', CAST(N'2018-09-03T03:49:06.460' AS DateTime), 0, 250, 144, 2169, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2826, N'Berlin', N'Frankfurt', CAST(N'2018-05-06T13:56:06.483' AS DateTime), 0, 250, 25, 2094, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2827, N'Paris', N'Prag', CAST(N'2018-09-14T05:06:06.493' AS DateTime), 0, 250, 155, 2018, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2828, N'München', N'Kapstadt', CAST(N'2018-05-17T15:13:06.507' AS DateTime), 0, 250, 36, 2141, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2829, N'London', N'Prag', CAST(N'2018-09-25T06:23:06.517' AS DateTime), 0, 250, 166, 2088, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2830, N'Frankfurt', N'Prag', CAST(N'2018-05-28T16:30:06.527' AS DateTime), 0, 250, 47, 2008, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2831, N'München', N'Köln/Bonn', CAST(N'2018-10-07T07:47:06.537' AS DateTime), 0, 250, 178, 2061, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2832, N'Prag', N'Moskau', CAST(N'2018-06-08T17:47:06.547' AS DateTime), 0, 250, 58, 2093, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2833, N'Kapstadt', N'Prag', CAST(N'2018-10-18T09:04:06.557' AS DateTime), 0, 250, 189, 2014, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2834, N'Köln/Bonn', N'Frankfurt', CAST(N'2018-06-19T19:04:06.570' AS DateTime), 0, 250, 69, 2010, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2835, N'Frankfurt', N'Dallas', CAST(N'2018-10-29T10:21:06.617' AS DateTime), 0, 250, 200, 2110, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2836, N'Moskau', N'Köln/Bonn', CAST(N'2018-07-01T20:28:06.633' AS DateTime), 0, 250, 81, 2147, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2837, N'London', N'Köln/Bonn', CAST(N'2018-11-09T11:38:06.647' AS DateTime), 0, 250, 211, 2137, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2838, N'London', N'Hamburg', CAST(N'2018-07-12T21:45:06.657' AS DateTime), 0, 250, 92, 2160, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2839, N'Mailand', N'Madrid', CAST(N'2018-11-20T12:55:06.670' AS DateTime), 0, 250, 222, 2021, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2840, N'Dallas', N'Oslo', CAST(N'2018-07-23T23:02:06.680' AS DateTime), 0, 250, 103, 2159, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2841, N'Moskau', N'Seattle', CAST(N'2018-12-02T14:19:06.707' AS DateTime), 0, 250, 234, 2064, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2842, N'Paris', N'Prag', CAST(N'2018-08-04T00:19:06.720' AS DateTime), 0, 250, 114, 2044, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2843, N'Frankfurt', N'London', CAST(N'2018-12-13T15:36:06.730' AS DateTime), 0, 250, 245, 2051, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2844, N'Prag', N'Paris', CAST(N'2018-08-15T01:36:06.740' AS DateTime), 0, 250, 125, 2038, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2845, N'Paris', N'Berlin', CAST(N'2018-04-17T11:43:06.750' AS DateTime), 0, 250, 6, 2017, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2846, N'Kapstadt', N'München', CAST(N'2018-08-27T03:00:06.760' AS DateTime), 0, 250, 137, 2155, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2847, N'Rom', N'Seattle', CAST(N'2018-04-28T13:00:06.773' AS DateTime), 0, 250, 13, 2148, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2848, N'Köln/Bonn', N'London', CAST(N'2018-09-07T04:17:06.787' AS DateTime), 0, 250, 148, 2162, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2849, N'Berlin', N'Prag', CAST(N'2018-05-09T14:17:06.800' AS DateTime), 0, 250, 28, 2009, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2850, N'Essen/Mülheim', N'London', CAST(N'2018-09-18T05:34:06.833' AS DateTime), 0, 250, 159, 2194, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2851, N'Essen/Mülheim', N'Frankfurt', CAST(N'2018-05-21T15:41:06.850' AS DateTime), 0, 250, 40, 2070, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2852, N'Rom', N'Mailand', CAST(N'2018-09-29T06:51:06.863' AS DateTime), 0, 250, 166, 2075, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2853, N'Seattle', N'Frankfurt', CAST(N'2018-06-01T16:58:06.877' AS DateTime), 0, 250, 51, 2017, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2854, N'Berlin', N'New York', CAST(N'2018-10-11T08:15:06.893' AS DateTime), 0, 250, 182, 2194, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2855, N'Berlin', N'Hamburg', CAST(N'2018-06-12T18:15:06.907' AS DateTime), 0, 250, 62, 2186, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2856, N'Berlin', N'London', CAST(N'2018-10-22T09:32:06.923' AS DateTime), 0, 250, 193, 2086, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2857, N'Essen/Mülheim', N'Rom', CAST(N'2018-06-23T19:32:06.940' AS DateTime), 0, 250, 73, 2133, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2858, N'Berlin', N'New York', CAST(N'2018-11-02T10:49:06.957' AS DateTime), 0, 250, 204, 2040, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2859, N'Berlin', N'Rom', CAST(N'2018-07-05T20:56:06.990' AS DateTime), 0, 250, 85, 2068, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2860, N'Prag', N'Paris', CAST(N'2018-11-13T12:06:07.003' AS DateTime), 0, 250, 215, 2001, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2861, N'Hamburg', N'London', CAST(N'2018-07-16T22:13:07.020' AS DateTime), 0, 250, 96, 2005, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2862, N'Rom', N'Essen/Mülheim', CAST(N'2018-11-24T13:23:07.033' AS DateTime), 0, 250, 222, 2059, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2863, N'Madrid', N'München', CAST(N'2018-07-27T23:30:07.047' AS DateTime), 0, 250, 107, 2113, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2864, N'Seattle', N'München', CAST(N'2018-12-06T14:47:07.063' AS DateTime), 0, 250, 238, 2009, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2865, N'Seattle', N'Rom', CAST(N'2018-08-08T00:47:07.080' AS DateTime), 0, 250, 118, 2010, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2866, N'Essen/Mülheim', N'Köln/Bonn', CAST(N'2018-12-17T16:04:07.090' AS DateTime), 0, 250, 249, 2037, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2867, N'Madrid', N'Berlin', CAST(N'2018-08-19T02:04:07.117' AS DateTime), 0, 250, 129, 2028, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2868, N'New York', N'Dallas', CAST(N'2018-04-21T12:11:07.133' AS DateTime), 0, 250, 10, 2014, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2869, N'Rom', N'Seattle', CAST(N'2018-08-31T03:28:07.147' AS DateTime), 0, 250, 137, 2093, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2870, N'München', N'Köln/Bonn', CAST(N'2018-05-02T13:28:07.157' AS DateTime), 0, 250, 21, 2037, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2871, N'Berlin', N'München', CAST(N'2018-09-11T04:45:07.170' AS DateTime), 0, 250, 152, 2144, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2872, N'Frankfurt', N'Madrid', CAST(N'2018-05-13T14:45:07.187' AS DateTime), 0, 250, 32, 2065, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2873, N'Dallas', N'Essen/Mülheim', CAST(N'2018-09-22T06:02:07.207' AS DateTime), 0, 250, 163, 2079, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2874, N'New York', N'München', CAST(N'2018-05-25T16:09:07.237' AS DateTime), 0, 250, 44, 2044, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2875, N'Madrid', N'Berlin', CAST(N'2018-10-03T07:19:07.253' AS DateTime), 0, 250, 174, 2033, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2876, N'New York', N'London', CAST(N'2018-06-05T17:26:07.270' AS DateTime), 0, 250, 55, 2067, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2877, N'München', N'Rom', CAST(N'2018-10-14T08:36:07.290' AS DateTime), 0, 250, 185, 2010, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2878, N'München', N'New York', CAST(N'2018-06-16T18:43:07.307' AS DateTime), 0, 250, 66, 2068, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2879, N'Madrid', N'Moskau', CAST(N'2018-10-26T10:00:07.323' AS DateTime), 0, 250, 197, 2071, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2880, N'Berlin', N'Kapstadt', CAST(N'2018-06-27T20:00:07.337' AS DateTime), 0, 250, 77, 2137, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2881, N'Oslo', N'London', CAST(N'2018-11-06T11:17:07.353' AS DateTime), 0, 250, 208, 2135, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2882, N'Dallas', N'Rom', CAST(N'2018-07-08T21:17:07.367' AS DateTime), 0, 250, 88, 2123, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2883, N'Mailand', N'Seattle', CAST(N'2018-11-17T12:34:07.397' AS DateTime), 0, 250, 219, 2162, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2884, N'Prag', N'Kapstadt', CAST(N'2018-07-20T22:41:07.407' AS DateTime), 0, 250, 100, 2048, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2885, N'Madrid', N'Oslo', CAST(N'2018-11-28T13:51:07.427' AS DateTime), 0, 250, 230, 2150, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2886, N'Seattle', N'London', CAST(N'2018-07-31T23:58:07.447' AS DateTime), 0, 250, 111, 2027, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2887, N'München', N'Madrid', CAST(N'2018-12-10T15:15:07.460' AS DateTime), 0, 250, 242, 2107, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2888, N'London', N'Hamburg', CAST(N'2018-08-12T01:15:07.473' AS DateTime), 0, 250, 122, 2056, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2889, N'Essen/Mülheim', N'London', CAST(N'2018-04-14T11:22:07.487' AS DateTime), 0, 250, 3, 2162, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2890, N'Mailand', N'Rom', CAST(N'2018-08-23T02:32:07.500' AS DateTime), 0, 250, 133, 2097, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2891, N'London', N'Hamburg', CAST(N'2018-04-25T12:39:07.523' AS DateTime), 0, 250, 14, 2060, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2892, N'Seattle', N'Madrid', CAST(N'2018-09-04T03:56:07.537' AS DateTime), 0, 250, 145, 2087, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2893, N'Mailand', N'Prag', CAST(N'2018-05-06T13:56:07.557' AS DateTime), 0, 250, 25, 2073, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2894, N'Paris', N'Mailand', CAST(N'2018-09-15T05:13:07.577' AS DateTime), 0, 250, 156, 2188, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2895, N'Kapstadt', N'Paris', CAST(N'2018-05-17T15:13:07.593' AS DateTime), 0, 250, 36, 2011, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2896, N'Rom', N'Seattle', CAST(N'2018-09-26T06:30:07.613' AS DateTime), 0, 250, 163, 2139, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2897, N'Seattle', N'Dallas', CAST(N'2018-05-29T16:37:07.633' AS DateTime), 0, 250, 48, 2049, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2898, N'Kapstadt', N'Paris', CAST(N'2018-10-07T07:47:07.653' AS DateTime), 0, 250, 178, 2188, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2899, N'Paris', N'Hamburg', CAST(N'2018-06-09T17:54:07.670' AS DateTime), 0, 250, 59, 2150, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2900, N'Kapstadt', N'Essen/Mülheim', CAST(N'2018-10-18T09:04:07.710' AS DateTime), 0, 250, 189, 2089, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2901, N'New York', N'Köln/Bonn', CAST(N'2018-06-20T19:11:07.743' AS DateTime), 0, 250, 70, 2110, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2902, N'Seattle', N'London', CAST(N'2018-10-30T10:28:07.767' AS DateTime), 0, 250, 201, 2133, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2903, N'Köln/Bonn', N'Moskau', CAST(N'2018-07-01T20:28:07.787' AS DateTime), 0, 250, 81, 2094, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2904, N'Moskau', N'Prag', CAST(N'2018-11-10T11:45:07.810' AS DateTime), 0, 250, 212, 2029, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2905, N'Oslo', N'Köln/Bonn', CAST(N'2018-07-12T21:45:07.837' AS DateTime), 0, 250, 92, 2095, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2906, N'Prag', N'Dallas', CAST(N'2018-11-21T13:02:07.857' AS DateTime), 0, 250, 223, 2095, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2907, N'Seattle', N'München', CAST(N'2018-07-24T23:09:07.880' AS DateTime), 0, 250, 104, 2156, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2908, N'London', N'Köln/Bonn', CAST(N'2018-12-02T14:19:07.893' AS DateTime), 0, 250, 234, 2117, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2909, N'Essen/Mülheim', N'London', CAST(N'2018-08-05T00:26:07.903' AS DateTime), 0, 250, 115, 2064, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2910, N'New York', N'Kapstadt', CAST(N'2018-12-13T15:36:07.910' AS DateTime), 0, 250, 245, 2184, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2911, N'Dallas', N'Berlin', CAST(N'2018-08-16T01:43:07.920' AS DateTime), 0, 250, 126, 2066, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2912, N'Prag', N'Madrid', CAST(N'2018-04-18T11:50:07.927' AS DateTime), 0, 250, 7, 2069, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2913, N'Oslo', N'Berlin', CAST(N'2018-08-27T03:00:07.937' AS DateTime), 0, 250, 137, 2086, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2914, N'München', N'Mailand', CAST(N'2018-04-29T13:07:07.943' AS DateTime), 0, 250, 18, 2128, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2915, N'Köln/Bonn', N'Rom', CAST(N'2018-09-08T04:24:07.973' AS DateTime), 0, 250, 149, 2003, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2916, N'München', N'Seattle', CAST(N'2018-05-10T14:24:07.987' AS DateTime), 0, 250, 29, 2040, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2917, N'Madrid', N'Köln/Bonn', CAST(N'2018-09-19T05:41:08.000' AS DateTime), 0, 250, 160, 2153, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2918, N'Rom', N'New York', CAST(N'2018-05-21T15:41:08.017' AS DateTime), 0, 250, 36, 2055, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2919, N'Berlin', N'Dallas', CAST(N'2018-09-30T06:58:08.030' AS DateTime), 0, 250, 171, 2188, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2920, N'Berlin', N'London', CAST(N'2018-06-02T17:05:08.043' AS DateTime), 0, 250, 52, 2118, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2921, N'Madrid', N'Kapstadt', CAST(N'2018-10-11T08:15:08.057' AS DateTime), 0, 250, 182, 2162, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2922, N'Moskau', N'Hamburg', CAST(N'2018-06-13T18:22:08.073' AS DateTime), 0, 250, 63, 2176, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2923, N'Seattle', N'Moskau', CAST(N'2018-10-22T09:32:08.087' AS DateTime), 0, 250, 193, 2113, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2924, N'New York', N'Madrid', CAST(N'2018-06-24T19:39:08.117' AS DateTime), 0, 250, 74, 2119, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2925, N'Rom', N'Mailand', CAST(N'2018-11-03T10:56:08.133' AS DateTime), 0, 250, 201, 2069, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2926, N'Hamburg', N'Dallas', CAST(N'2018-07-05T20:56:08.147' AS DateTime), 0, 250, 85, 2097, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2927, N'Kapstadt', N'Prag', CAST(N'2018-11-14T12:13:08.163' AS DateTime), 0, 250, 216, 2031, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2928, N'New York', N'Paris', CAST(N'2018-07-16T22:13:08.177' AS DateTime), 0, 250, 96, 2012, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2929, N'Prag', N'Oslo', CAST(N'2018-11-25T13:30:08.193' AS DateTime), 0, 250, 227, 2081, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2930, N'Madrid', N'New York', CAST(N'2018-07-28T23:37:08.207' AS DateTime), 0, 250, 108, 2168, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2931, N'Köln/Bonn', N'Seattle', CAST(N'2018-12-06T14:47:08.223' AS DateTime), 0, 250, 238, 2166, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2932, N'Seattle', N'Frankfurt', CAST(N'2018-08-09T00:54:08.237' AS DateTime), 0, 250, 119, 2027, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2933, N'Hamburg', N'Essen/Mülheim', CAST(N'2018-12-17T16:04:08.263' AS DateTime), 0, 250, 249, 2104, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2934, N'Köln/Bonn', N'Seattle', CAST(N'2018-08-20T02:11:08.277' AS DateTime), 0, 250, 130, 2019, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2935, N'New York', N'Dallas', CAST(N'2018-04-22T12:18:08.293' AS DateTime), 0, 250, 11, 2084, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2936, N'Paris', N'New York', CAST(N'2018-08-31T03:28:08.303' AS DateTime), 0, 250, 141, 2093, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2937, N'Seattle', N'München', CAST(N'2018-05-03T13:35:08.317' AS DateTime), 0, 250, 22, 2125, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2938, N'Paris', N'Berlin', CAST(N'2018-09-11T04:45:08.330' AS DateTime), 0, 250, 152, 2058, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2939, N'Mailand', N'Prag', CAST(N'2018-05-14T14:52:08.343' AS DateTime), 0, 250, 33, 2093, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2940, N'Madrid', N'Paris', CAST(N'2018-09-23T06:09:08.370' AS DateTime), 0, 250, 164, 2154, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2941, N'Hamburg', N'Seattle', CAST(N'2018-05-25T16:09:08.380' AS DateTime), 0, 250, 44, 2005, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2942, N'Madrid', N'Paris', CAST(N'2018-10-04T07:26:08.390' AS DateTime), 0, 250, 175, 2035, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2943, N'Essen/Mülheim', N'New York', CAST(N'2018-06-05T17:26:08.403' AS DateTime), 0, 250, 55, 2073, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2944, N'Hamburg', N'Dallas', CAST(N'2018-10-15T08:43:08.413' AS DateTime), 0, 250, 186, 2038, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2945, N'Dallas', N'Prag', CAST(N'2018-06-17T18:50:08.423' AS DateTime), 0, 250, 67, 2162, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2946, N'Frankfurt', N'Berlin', CAST(N'2018-10-26T10:00:08.433' AS DateTime), 0, 250, 197, 2089, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2947, N'New York', N'Frankfurt', CAST(N'2018-06-28T20:07:08.443' AS DateTime), 0, 250, 78, 2052, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2948, N'Oslo', N'Hamburg', CAST(N'2018-11-07T11:24:08.470' AS DateTime), 0, 250, 209, 2098, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2949, N'Hamburg', N'Madrid', CAST(N'2018-07-09T21:24:08.483' AS DateTime), 0, 250, 89, 2134, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2950, N'Prag', N'Hamburg', CAST(N'2018-11-18T12:41:08.493' AS DateTime), 0, 250, 220, 2117, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2951, N'New York', N'Rom', CAST(N'2018-07-20T22:41:08.503' AS DateTime), 0, 250, 100, 2068, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2952, N'Essen/Mülheim', N'Frankfurt', CAST(N'2018-11-29T13:58:08.513' AS DateTime), 0, 250, 231, 2005, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2953, N'Frankfurt', N'Kapstadt', CAST(N'2018-08-02T00:05:08.527' AS DateTime), 0, 250, 112, 2115, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2954, N'Köln/Bonn', N'Seattle', CAST(N'2018-12-10T15:15:08.537' AS DateTime), 0, 250, 242, 2001, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2955, N'Frankfurt', N'Mailand', CAST(N'2018-08-13T01:22:08.547' AS DateTime), 0, 250, 123, 2034, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2956, N'Paris', N'Mailand', CAST(N'2018-04-14T11:22:08.557' AS DateTime), 0, 250, 3, 2005, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2957, N'Köln/Bonn', N'London', CAST(N'2018-08-24T02:39:08.580' AS DateTime), 0, 250, 134, 2103, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2958, N'Köln/Bonn', N'Mailand', CAST(N'2018-04-26T12:46:08.590' AS DateTime), 0, 250, 15, 2107, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2959, N'New York', N'Prag', CAST(N'2018-09-04T03:56:08.597' AS DateTime), 0, 250, 145, 2101, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2960, N'Köln/Bonn', N'Paris', CAST(N'2018-05-07T14:03:08.610' AS DateTime), 0, 250, 26, 2156, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2961, N'Prag', N'Seattle', CAST(N'2018-09-15T05:13:08.620' AS DateTime), 0, 250, 156, 2170, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2962, N'Hamburg', N'Mailand', CAST(N'2018-05-18T15:20:08.630' AS DateTime), 0, 250, 37, 2158, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2963, N'Dallas', N'Köln/Bonn', CAST(N'2018-09-27T06:37:08.643' AS DateTime), 0, 250, 168, 2174, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2964, N'London', N'Paris', CAST(N'2018-05-29T16:37:08.653' AS DateTime), 0, 250, 48, 2051, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2965, N'Madrid', N'Essen/Mülheim', CAST(N'2018-10-08T07:54:08.660' AS DateTime), 0, 250, 179, 2064, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2966, N'Kapstadt', N'Paris', CAST(N'2018-06-09T17:54:08.683' AS DateTime), 0, 250, 59, 2038, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2967, N'Frankfurt', N'Kapstadt', CAST(N'2018-10-19T09:11:08.700' AS DateTime), 0, 250, 190, 2018, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2968, N'New York', N'Berlin', CAST(N'2018-06-21T19:18:08.713' AS DateTime), 0, 250, 71, 2195, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2969, N'Köln/Bonn', N'Kapstadt', CAST(N'2018-10-30T10:28:08.727' AS DateTime), 0, 250, 201, 2107, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2970, N'Prag', N'Hamburg', CAST(N'2018-07-02T20:35:08.737' AS DateTime), 0, 250, 82, 2007, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2971, N'Essen/Mülheim', N'Mailand', CAST(N'2018-11-10T11:45:08.747' AS DateTime), 0, 250, 212, 2116, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2972, N'Rom', N'Oslo', CAST(N'2018-07-13T21:52:08.757' AS DateTime), 0, 250, 89, 2095, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2973, N'Moskau', N'Hamburg', CAST(N'2018-11-22T13:09:08.780' AS DateTime), 0, 250, 224, 2003, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2974, N'Seattle', N'Paris', CAST(N'2018-07-24T23:09:08.797' AS DateTime), 0, 250, 104, 2053, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2975, N'München', N'Madrid', CAST(N'2018-12-03T14:26:08.807' AS DateTime), 0, 250, 235, 2191, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2976, N'Köln/Bonn', N'Paris', CAST(N'2018-08-05T00:26:08.817' AS DateTime), 0, 250, 115, 2152, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2977, N'Hamburg', N'Madrid', CAST(N'2018-12-14T15:43:08.827' AS DateTime), 0, 250, 246, 2024, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2978, N'Rom', N'München', CAST(N'2018-08-17T01:50:08.837' AS DateTime), 0, 250, 123, 2118, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2979, N'Seattle', N'Oslo', CAST(N'2018-04-18T11:50:08.850' AS DateTime), 0, 250, 7, 2128, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2980, N'Madrid', N'Dallas', CAST(N'2018-08-28T03:07:08.860' AS DateTime), 0, 250, 138, 2132, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2981, N'Köln/Bonn', N'Mailand', CAST(N'2018-04-30T13:14:08.883' AS DateTime), 0, 250, 19, 2014, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2982, N'Madrid', N'New York', CAST(N'2018-09-08T04:24:08.893' AS DateTime), 0, 250, 149, 2191, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2983, N'Seattle', N'Prag', CAST(N'2018-05-11T14:31:08.907' AS DateTime), 0, 250, 30, 2160, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2984, N'Madrid', N'Hamburg', CAST(N'2018-09-19T05:41:08.920' AS DateTime), 0, 250, 160, 2041, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2985, N'Hamburg', N'London', CAST(N'2018-05-22T15:48:08.927' AS DateTime), 0, 250, 41, 2087, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2986, N'Kapstadt', N'Mailand', CAST(N'2018-10-01T07:05:08.937' AS DateTime), 0, 250, 172, 2038, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2987, N'Berlin', N'Dallas', CAST(N'2018-06-02T17:05:08.947' AS DateTime), 0, 250, 52, 2076, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2988, N'Essen/Mülheim', N'Rom', CAST(N'2018-10-12T08:22:08.957' AS DateTime), 0, 250, 183, 2066, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2989, N'Oslo', N'Paris', CAST(N'2018-06-13T18:22:08.970' AS DateTime), 0, 250, 63, 2058, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2990, N'Dallas', N'New York', CAST(N'2018-10-23T09:39:08.997' AS DateTime), 0, 250, 194, 2005, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2991, N'Kapstadt', N'Seattle', CAST(N'2018-06-25T19:46:09.007' AS DateTime), 0, 250, 75, 2050, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2992, N'London', N'Paris', CAST(N'2018-11-03T10:56:09.017' AS DateTime), 0, 250, 205, 2189, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2993, N'Hamburg', N'Rom', CAST(N'2018-07-06T21:03:09.030' AS DateTime), 0, 250, 86, 2045, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2994, N'Berlin', N'Moskau', CAST(N'2018-11-14T12:13:09.043' AS DateTime), 0, 250, 216, 2181, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2995, N'Dallas', N'London', CAST(N'2018-07-17T22:20:09.057' AS DateTime), 0, 250, 97, 2128, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2996, N'Oslo', N'München', CAST(N'2018-11-26T13:37:09.070' AS DateTime), 0, 250, 228, 2155, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2997, N'München', N'Madrid', CAST(N'2018-07-28T23:37:09.083' AS DateTime), 0, 250, 108, 2081, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2998, N'Mailand', N'Madrid', CAST(N'2018-12-07T14:54:09.097' AS DateTime), 0, 250, 239, 2198, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (2999, N'Rom', N'Mailand', CAST(N'2018-08-09T00:54:09.123' AS DateTime), 0, 250, 115, 2027, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (3000, N'Essen/Mülheim', N'Oslo', CAST(N'2018-04-11T11:01:09.140' AS DateTime), 0, 250, 0, 2043, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (3001, N'Oslo', N'Kapstadt', CAST(N'2018-08-21T02:18:09.153' AS DateTime), 0, 250, 131, 2003, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (3002, N'Mailand', N'Dallas', CAST(N'2018-04-22T12:18:09.163' AS DateTime), 0, 250, 11, 2164, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (3003, N'Dallas', N'Mailand', CAST(N'2018-09-01T03:35:09.177' AS DateTime), 0, 250, 142, 2126, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (3004, N'Hamburg', N'Dallas', CAST(N'2018-05-03T13:35:09.187' AS DateTime), 0, 250, 22, 2004, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (3005, N'Paris', N'Mailand', CAST(N'2018-09-12T04:52:09.213' AS DateTime), 0, 250, 153, 2163, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (3006, N'Dallas', N'Seattle', CAST(N'2018-05-15T14:59:09.227' AS DateTime), 0, 250, 34, 2199, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (3007, N'Rom', N'Prag', CAST(N'2018-09-23T06:09:09.243' AS DateTime), 0, 250, 160, 2166, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (3008, N'Essen/Mülheim', N'New York', CAST(N'2018-05-26T16:16:09.257' AS DateTime), 0, 250, 45, 2076, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (3009, N'Madrid', N'Köln/Bonn', CAST(N'2018-10-05T07:33:09.267' AS DateTime), 0, 250, 176, 2014, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (3010, N'Oslo', N'Kapstadt', CAST(N'2018-06-06T17:33:09.280' AS DateTime), 0, 250, 56, 2091, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (3011, N'London', N'Berlin', CAST(N'2018-10-16T08:50:09.293' AS DateTime), 0, 250, 187, 2067, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (3012, N'Oslo', N'Berlin', CAST(N'2018-06-17T18:50:09.303' AS DateTime), 0, 250, 67, 2036, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (3013, N'London', N'München', CAST(N'2018-10-27T10:07:09.320' AS DateTime), 0, 250, 198, 2192, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (3014, N'Rom', N'Kapstadt', CAST(N'2018-06-29T20:14:09.347' AS DateTime), 0, 250, 75, 2134, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (3015, N'Köln/Bonn', N'Hamburg', CAST(N'2018-11-07T11:24:09.360' AS DateTime), 0, 250, 209, 2097, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (3016, N'Kapstadt', N'Moskau', CAST(N'2018-07-10T21:31:09.373' AS DateTime), 0, 250, 90, 2163, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (3017, N'Seattle', N'Hamburg', CAST(N'2018-11-18T12:41:09.383' AS DateTime), 0, 250, 220, 2011, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (3018, N'München', N'Madrid', CAST(N'2018-07-21T22:48:09.393' AS DateTime), 0, 250, 101, 2027, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (3019, N'München', N'New York', CAST(N'2018-11-30T14:05:09.403' AS DateTime), 0, 250, 232, 2124, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (3020, N'Seattle', N'Essen/Mülheim', CAST(N'2018-08-02T00:05:09.417' AS DateTime), 0, 250, 112, 2003, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (3021, N'Seattle', N'Hamburg', CAST(N'2018-12-11T15:22:09.430' AS DateTime), 0, 250, 243, 2162, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (3022, N'Dallas', N'Seattle', CAST(N'2018-08-13T01:22:09.440' AS DateTime), 0, 250, 123, 2102, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (3023, N'Mailand', N'New York', CAST(N'2018-04-15T11:29:09.463' AS DateTime), 0, 250, 4, 2121, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (3024, N'Prag', N'Berlin', CAST(N'2018-08-25T02:46:09.477' AS DateTime), 0, 250, 135, 2194, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (3025, N'Seattle', N'München', CAST(N'2018-04-26T12:46:09.490' AS DateTime), 0, 250, 15, 2104, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (3026, N'Paris', N'Oslo', CAST(N'2018-09-05T04:03:09.500' AS DateTime), 0, 250, 146, 2007, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (3027, N'New York', N'Köln/Bonn', CAST(N'2018-05-07T14:03:09.517' AS DateTime), 0, 250, 26, 2055, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (3028, N'New York', N'Paris', CAST(N'2018-09-16T05:20:09.530' AS DateTime), 0, 250, 157, 2089, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (3029, N'Frankfurt', N'Hamburg', CAST(N'2018-05-19T15:27:09.540' AS DateTime), 0, 250, 38, 2006, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (3030, N'Madrid', N'Berlin', CAST(N'2018-09-27T06:37:09.553' AS DateTime), 0, 250, 168, 2143, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (3031, N'Prag', N'Köln/Bonn', CAST(N'2018-05-30T16:44:09.567' AS DateTime), 0, 250, 49, 2113, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (3032, N'Kapstadt', N'Dallas', CAST(N'2018-10-08T07:54:09.597' AS DateTime), 0, 250, 179, 2012, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (3033, N'Paris', N'Prag', CAST(N'2018-06-10T18:01:09.613' AS DateTime), 0, 250, 60, 2031, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (3034, N'Frankfurt', N'London', CAST(N'2018-10-20T09:18:09.627' AS DateTime), 0, 250, 191, 2008, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (3035, N'Moskau', N'Prag', CAST(N'2018-06-21T19:18:09.640' AS DateTime), 0, 250, 71, 2179, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (3036, N'Dallas', N'Mailand', CAST(N'2018-10-31T10:35:09.653' AS DateTime), 0, 250, 202, 2140, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (3037, N'Moskau', N'Essen/Mülheim', CAST(N'2018-07-02T20:35:09.663' AS DateTime), 0, 250, 82, 2147, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (3038, N'Moskau', N'Berlin', CAST(N'2018-11-11T11:52:09.683' AS DateTime), 0, 250, 213, 2100, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (3039, N'Essen/Mülheim', N'Berlin', CAST(N'2018-07-14T21:59:09.697' AS DateTime), 0, 250, 94, 2155, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (3040, N'London', N'Madrid', CAST(N'2018-11-22T13:09:09.710' AS DateTime), 0, 250, 224, 2100, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (3041, N'Mailand', N'Moskau', CAST(N'2018-07-25T23:16:09.720' AS DateTime), 0, 250, 105, 2123, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (3042, N'Madrid', N'Berlin', CAST(N'2018-12-04T14:33:09.733' AS DateTime), 0, 250, 236, 2154, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (3043, N'Paris', N'Madrid', CAST(N'2018-08-06T00:33:09.743' AS DateTime), 0, 250, 116, 2034, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (3044, N'Mailand', N'Berlin', CAST(N'2018-12-15T15:50:09.757' AS DateTime), 0, 250, 247, 2075, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (3045, N'Madrid', N'Moskau', CAST(N'2018-08-17T01:50:09.767' AS DateTime), 0, 250, 127, 2177, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (3046, N'Köln/Bonn', N'Frankfurt', CAST(N'2018-04-19T11:57:09.780' AS DateTime), 0, 250, 8, 2177, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (3047, N'Prag', N'München', CAST(N'2018-08-29T03:14:09.810' AS DateTime), 0, 250, 139, 2143, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (3048, N'Rom', N'Köln/Bonn', CAST(N'2018-04-30T13:14:09.820' AS DateTime), 0, 250, 15, 2053, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (3049, N'Köln/Bonn', N'Frankfurt', CAST(N'2018-09-09T04:31:09.833' AS DateTime), 0, 250, 150, 2015, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (3050, N'Dallas', N'Rom', CAST(N'2018-05-11T14:31:09.843' AS DateTime), 0, 250, 30, 2007, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (3051, N'Moskau', N'Kapstadt', CAST(N'2018-09-20T05:48:09.857' AS DateTime), 0, 250, 161, 2085, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (3052, N'Seattle', N'Prag', CAST(N'2018-05-23T15:55:09.867' AS DateTime), 0, 250, 42, 2026, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (3053, N'Prag', N'Moskau', CAST(N'2018-10-01T07:05:09.880' AS DateTime), 0, 250, 172, 2106, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (3054, N'München', N'Essen/Mülheim', CAST(N'2018-06-03T17:12:09.893' AS DateTime), 0, 250, 53, 2073, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (3055, N'Seattle', N'Paris', CAST(N'2018-10-12T08:22:09.907' AS DateTime), 0, 250, 183, 2122, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (3056, N'Prag', N'Dallas', CAST(N'2018-06-14T18:29:09.927' AS DateTime), 0, 250, 64, 2177, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (3057, N'Kapstadt', N'Essen/Mülheim', CAST(N'2018-10-24T09:46:09.940' AS DateTime), 0, 250, 195, 2156, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (3058, N'München', N'Rom', CAST(N'2018-06-25T19:46:09.953' AS DateTime), 0, 250, 75, 2070, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (3059, N'Oslo', N'Frankfurt', CAST(N'2018-11-04T11:03:09.963' AS DateTime), 0, 250, 206, 2107, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (3060, N'London', N'Kapstadt', CAST(N'2018-07-06T21:03:09.973' AS DateTime), 0, 250, 86, 2043, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (3061, N'Hamburg', N'Dallas', CAST(N'2018-11-15T12:20:09.983' AS DateTime), 0, 250, 217, 2143, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (3062, N'Köln/Bonn', N'Dallas', CAST(N'2018-07-18T22:27:09.993' AS DateTime), 0, 250, 98, 2018, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (3063, N'Kapstadt', N'London', CAST(N'2018-11-26T13:37:10.003' AS DateTime), 0, 250, 228, 2075, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (3064, N'Paris', N'Moskau', CAST(N'2018-07-29T23:44:10.017' AS DateTime), 0, 250, 109, 2027, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (3065, N'Kapstadt', N'München', CAST(N'2018-12-07T14:54:10.047' AS DateTime), 0, 250, 239, 2101, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (3066, N'New York', N'Köln/Bonn', CAST(N'2018-08-10T01:01:10.060' AS DateTime), 0, 250, 120, 2158, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (3067, N'Mailand', N'Moskau', CAST(N'2018-04-12T11:08:10.070' AS DateTime), 0, 250, 1, 2197, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (3068, N'Paris', N'Hamburg', CAST(N'2018-08-21T02:18:10.087' AS DateTime), 0, 250, 131, 2184, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (3069, N'Madrid', N'Mailand', CAST(N'2018-04-23T12:25:10.100' AS DateTime), 0, 250, 12, 2103, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (3070, N'Frankfurt', N'Essen/Mülheim', CAST(N'2018-09-01T03:35:10.110' AS DateTime), 0, 250, 142, 2091, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (3071, N'Moskau', N'Hamburg', CAST(N'2018-05-04T13:42:10.137' AS DateTime), 0, 250, 23, 2155, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (3072, N'Rom', N'Dallas', CAST(N'2018-09-13T04:59:10.150' AS DateTime), 0, 250, 150, 2157, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (3073, N'New York', N'Mailand', CAST(N'2018-05-15T14:59:10.160' AS DateTime), 0, 250, 34, 2091, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (3074, N'Prag', N'Seattle', CAST(N'2018-09-24T06:16:10.173' AS DateTime), 0, 250, 165, 2116, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (3075, N'Prag', N'Paris', CAST(N'2018-05-27T16:23:10.183' AS DateTime), 0, 250, 46, 2029, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (3076, N'New York', N'London', CAST(N'2018-10-05T07:33:10.193' AS DateTime), 0, 250, 176, 2032, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (3077, N'Madrid', N'Rom', CAST(N'2018-06-07T17:40:10.207' AS DateTime), 0, 250, 57, 2164, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (3078, N'Essen/Mülheim', N'Oslo', CAST(N'2018-10-16T08:50:10.220' AS DateTime), 0, 250, 187, 2049, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (3079, N'Köln/Bonn', N'Kapstadt', CAST(N'2018-06-18T18:57:10.233' AS DateTime), 0, 250, 68, 2150, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (3080, N'Kapstadt', N'London', CAST(N'2018-10-28T10:14:10.257' AS DateTime), 0, 250, 199, 2108, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (3081, N'Moskau', N'Essen/Mülheim', CAST(N'2018-06-29T20:14:10.270' AS DateTime), 0, 250, 79, 2122, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (3082, N'Oslo', N'Madrid', CAST(N'2018-11-08T11:31:10.287' AS DateTime), 0, 250, 210, 2078, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (3083, N'London', N'Mailand', CAST(N'2018-07-10T21:31:10.297' AS DateTime), 0, 250, 90, 2032, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (3084, N'Seattle', N'Dallas', CAST(N'2018-11-19T12:48:10.307' AS DateTime), 0, 250, 221, 2150, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (3085, N'London', N'Oslo', CAST(N'2018-07-22T22:55:10.317' AS DateTime), 0, 250, 102, 2175, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [Betrieb].[Flug] ([FlugNr], [Abflugort], [Zielort], [Datum], [NichtRaucherFlug], [Plaetze], [FreiePlaetze], [Pilot_PersonID], [Ankunft], [Memo], [Bestreikt], [Auslastung], [aliensErlaubt]) VALUES (3086, N'Paris', N